/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.comp;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.UUID;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.comp.FieldComparator;
import org.apache.solr.client.solrj.io.comp.StreamComparator;
import org.apache.solr.client.solrj.io.stream.expr.Explanation;
import org.apache.solr.client.solrj.io.stream.expr.Expressible;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionValue;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class MultipleFieldComparator
implements StreamComparator {
    private static final long serialVersionUID = 1L;
    private UUID comparatorNodeId = UUID.randomUUID();
    private StreamComparator[] comps;

    public MultipleFieldComparator(StreamComparator ... comps) {
        this.comps = comps;
    }

    public StreamComparator[] getComps() {
        return this.comps;
    }

    @Override
    public int compare(Tuple t1, Tuple t2) {
        for (StreamComparator comp : this.comps) {
            int i = comp.compare(t1, t2);
            if (i == 0) continue;
            return i;
        }
        return 0;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MultipleFieldComparator that = (MultipleFieldComparator)o;
        return Arrays.equals(this.comps, that.comps);
    }

    public int hashCode() {
        return Arrays.hashCode(this.comps);
    }

    @Override
    public StreamExpressionParameter toExpression(StreamFactory factory) throws IOException {
        StringBuilder sb = new StringBuilder();
        for (StreamComparator comp : this.comps) {
            if (comp instanceof Expressible) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
            } else {
                throw new IOException("This MultiComp contains a non-expressible comparator - it cannot be converted to an expression");
            }
            sb.append(comp.toExpression(factory));
        }
        return new StreamExpressionValue(sb.toString());
    }

    @Override
    public boolean isDerivedFrom(StreamComparator base) {
        if (null == base) {
            return false;
        }
        if (base instanceof MultipleFieldComparator) {
            MultipleFieldComparator baseComp = (MultipleFieldComparator)base;
            if (baseComp.comps.length >= this.comps.length) {
                for (int idx = 0; idx < this.comps.length; ++idx) {
                    if (this.comps[idx].isDerivedFrom(baseComp.comps[idx])) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public Explanation toExplanation(StreamFactory factory) throws IOException {
        return new Explanation(this.comparatorNodeId.toString()).withExpressionType("sorter").withImplementingClass(this.getClass().getName()).withExpression(this.toExpression(factory).toString());
    }

    @Override
    public MultipleFieldComparator copyAliased(Map<String, String> aliases) {
        StreamComparator[] aliasedComps = new StreamComparator[this.comps.length];
        for (int idx = 0; idx < this.comps.length; ++idx) {
            aliasedComps[idx] = this.comps[idx].copyAliased(aliases);
        }
        return new MultipleFieldComparator(aliasedComps);
    }

    @Override
    public StreamComparator append(StreamComparator other) {
        ArrayList<StreamComparator> newComps = new ArrayList<StreamComparator>();
        for (StreamComparator comp : this.comps) {
            newComps.add(comp);
        }
        if (other instanceof FieldComparator) {
            newComps.add(other);
        } else if (other instanceof MultipleFieldComparator) {
            for (StreamComparator comp : ((MultipleFieldComparator)other).comps) {
                newComps.add(comp);
            }
        }
        return new MultipleFieldComparator(newComps.toArray(new StreamComparator[newComps.size()]));
    }
}

