/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.planNodes;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.shacl.ast.Shape;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNodeHelper;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationExecutionLogger;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationTuple;

public class SingleCloseablePlanNode
implements PlanNode {
    private final PlanNode parent;
    private final Shape shape;
    boolean receivedLogger = false;

    public SingleCloseablePlanNode(PlanNode parent, Shape shape) {
        this.parent = PlanNodeHelper.handleSorting(this, parent);
        this.shape = shape;
    }

    @Override
    public CloseableIteration<? extends ValidationTuple, SailException> iterator() {
        assert (this.receivedLogger);
        return new SingleCloseableIteration(this.parent);
    }

    @Override
    public int depth() {
        throw new IllegalStateException();
    }

    @Override
    public void getPlanAsGraphvizDot(StringBuilder stringBuilder) {
        this.parent.getPlanAsGraphvizDot(stringBuilder);
    }

    public String toString() {
        return "SingleCloseablePlanNode{parent=" + this.parent + "}";
    }

    @Override
    public String getId() {
        return "" + System.identityHashCode(this);
    }

    @Override
    public void receiveLogger(ValidationExecutionLogger validationExecutionLogger) {
        this.receivedLogger = true;
        this.parent.receiveLogger(validationExecutionLogger);
    }

    @Override
    public boolean producesSorted() {
        return this.parent.producesSorted();
    }

    @Override
    public boolean requiresSorted() {
        return false;
    }

    public Shape getShape() {
        return this.shape;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SingleCloseablePlanNode that = (SingleCloseablePlanNode)o;
        return this.parent.equals(that.parent);
    }

    public int hashCode() {
        return Objects.hash(this.parent);
    }

    private static class SingleCloseableIteration
    implements CloseableIteration<ValidationTuple, SailException> {
        final CloseableIteration<? extends ValidationTuple, SailException> parentIterator;
        final AtomicBoolean closed = new AtomicBoolean(false);

        public SingleCloseableIteration(PlanNode parent) {
            this.parentIterator = parent.iterator();
        }

        @Override
        public void close() throws SailException {
            if (this.closed.compareAndSet(false, true)) {
                this.parentIterator.close();
            }
        }

        @Override
        public boolean hasNext() throws SailException {
            return this.parentIterator.hasNext();
        }

        @Override
        public ValidationTuple next() throws SailException {
            return (ValidationTuple)this.parentIterator.next();
        }

        @Override
        public void remove() throws SailException {
            this.parentIterator.remove();
        }
    }
}

