/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.http.server.repository.handler;

import java.io.IOException;
import java.io.InputStream;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.rdf4j.common.exception.RDF4JException;
import org.eclipse.rdf4j.common.webapp.views.EmptySuccessView;
import org.eclipse.rdf4j.http.protocol.error.ErrorInfo;
import org.eclipse.rdf4j.http.protocol.error.ErrorType;
import org.eclipse.rdf4j.http.server.ClientHTTPException;
import org.eclipse.rdf4j.http.server.HTTPException;
import org.eclipse.rdf4j.http.server.ServerHTTPException;
import org.eclipse.rdf4j.http.server.repository.handler.RepositoryRequestHandler;
import org.eclipse.rdf4j.http.server.repository.resolver.RepositoryResolver;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.repository.config.RepositoryConfig;
import org.eclipse.rdf4j.repository.config.RepositoryConfigException;
import org.eclipse.rdf4j.rio.Rio;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;

public class DefaultRepositoryRequestHandler
implements RepositoryRequestHandler {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final RepositoryResolver repositoryResolver;

    public DefaultRepositoryRequestHandler(RepositoryResolver repositoryResolver) {
        this.repositoryResolver = repositoryResolver;
    }

    @Override
    public ModelAndView handleDeleteRepositoryRequest(HttpServletRequest request) throws HTTPException {
        String repId = this.repositoryResolver.getRepositoryID(request);
        this.logger.info("DELETE request invoked for repository '" + repId + "'");
        if (request.getParameter("query") != null) {
            this.logger.warn("query supplied on repository delete request, aborting delete");
            throw new HTTPException(400, "Repository delete error: query supplied with request");
        }
        try {
            boolean success = this.repositoryResolver.getRepositoryManager().removeRepository(repId);
            if (success) {
                this.logger.info("DELETE request successfully completed");
                return new ModelAndView((View)EmptySuccessView.getInstance());
            }
            this.logger.error("error while attempting to delete repository '" + repId + "'");
            throw new HTTPException(400, "could not locate repository configuration for repository '" + repId + "'.");
        }
        catch (RDF4JException e) {
            this.logger.error("error while attempting to delete repository '" + repId + "'", (Throwable)e);
            throw new ServerHTTPException("Repository delete error: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public ModelAndView handleCreateOrUpdateRepositoryRequest(HttpServletRequest request) throws IOException, HTTPException {
        String repId = this.repositoryResolver.getRepositoryID(request);
        this.logger.info("PUT request invoked for repository '" + repId + "'");
        try {
            if (this.repositoryResolver.getRepositoryManager().hasRepositoryConfig(repId)) {
                ErrorInfo errorInfo = new ErrorInfo(ErrorType.REPOSITORY_EXISTS, "repository already exists: " + repId);
                throw new ClientHTTPException(409, errorInfo.toString());
            }
            Model model = Rio.parse((InputStream)request.getInputStream(), "", Rio.getParserFormatForMIMEType(request.getContentType()).orElseThrow(() -> new HTTPException(400, "unrecognized content type " + request.getContentType())), new Resource[0]);
            RepositoryConfig config = this.repositoryResolver.getRepositoryConfig(repId, model);
            if (config == null) {
                throw new RepositoryConfigException("could not read repository config from supplied data");
            }
            this.repositoryResolver.getRepositoryManager().addRepositoryConfig(config);
            return new ModelAndView((View)EmptySuccessView.getInstance());
        }
        catch (RepositoryConfigException e) {
            ErrorInfo errorInfo = new ErrorInfo(ErrorType.MALFORMED_DATA, "Supplied repository configuration is invalid: " + e.getMessage());
            throw new ClientHTTPException(400, errorInfo.toString());
        }
        catch (RDF4JException e) {
            this.logger.error("error while attempting to create/configure repository '" + repId + "'", (Throwable)e);
            throw new ServerHTTPException("Repository create error: " + e.getMessage(), (Throwable)e);
        }
    }
}

