/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ua.ui.editor.toc;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.CharBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TocHTMLTitleUtil {
    private static final String whitespace = "[ \\t\\n\\r\\f\\v]*";
    private static final String titleTag = "[Tt][Ii][Tt][Ll][Ee]";
    private static Pattern titlePattern = null;

    private static void initPattern() {
        StringBuilder buf = new StringBuilder();
        buf.append('<');
        buf.append(whitespace);
        buf.append(titleTag);
        buf.append('>');
        buf.append("(.*?)");
        buf.append('<');
        buf.append(whitespace);
        buf.append('/');
        buf.append(whitespace);
        buf.append(titleTag);
        buf.append('>');
        titlePattern = Pattern.compile(buf.toString());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String findTitle(File f) {
        if (titlePattern == null) {
            TocHTMLTitleUtil.initPattern();
        }
        String title = null;
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try {
                FileInputStream inputStream = new FileInputStream(f);
                try {
                    try (FileChannel fc = inputStream.getChannel();){
                        MappedByteBuffer bb = fc.map(FileChannel.MapMode.READ_ONLY, 0L, fc.size());
                        CharBuffer cb = Charset.forName("8859_1").newDecoder().decode(bb);
                        Matcher m = titlePattern.matcher(cb);
                        if (m.find()) {
                            title = m.group(1);
                        }
                    }
                    if (inputStream == null) return title;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (inputStream == null) throw throwable;
                    inputStream.close();
                    throw throwable;
                }
                inputStream.close();
                return title;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            return null;
        }
    }
}

