/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.filediff;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.egit.ui.internal.history.FileDiff;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;

public abstract class AbstractFileDiffHandler
extends AbstractHandler {
    protected IStructuredSelection getSelection(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection) {
            return (IStructuredSelection)selection;
        }
        return StructuredSelection.EMPTY;
    }

    protected FileDiff getDiff(IStructuredSelection selection) {
        if (selection.size() == 1) {
            return (FileDiff)Adapters.adapt((Object)selection.getFirstElement(), FileDiff.class);
        }
        return null;
    }

    protected List<FileDiff> getDiffs(IStructuredSelection selection, Predicate<FileDiff> filter) {
        ArrayList<FileDiff> result = new ArrayList<FileDiff>();
        Iterator items = selection.iterator();
        while (items.hasNext()) {
            FileDiff diff = (FileDiff)Adapters.adapt(items.next(), FileDiff.class);
            if (diff == null || !filter.test(diff)) continue;
            result.add(diff);
        }
        return result;
    }
}

