/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.internal.dialogs.about;

import java.util.Optional;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.e4.ui.internal.dialogs.about.ProductProperties;
import org.eclipse.e4.ui.internal.dialogs.about.UnavailableProduct;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Image;

public final class ProductInformation {
    private final IProduct product;
    private final String productName;

    public ProductInformation() {
        this(new UnavailableProduct());
    }

    public ProductInformation(IProduct product) {
        this.product = Optional.ofNullable(product).orElse(new UnavailableProduct());
        this.productName = Optional.ofNullable(product.getName()).orElse("");
    }

    public String getName() {
        return this.productName;
    }

    public ImageDescriptor getAboutImageDescriptor() {
        if (JFaceResources.getImage((String)this.productName) == null) {
            this.createAboutImage();
        }
        return JFaceResources.getImageRegistry().getDescriptor(this.productName);
    }

    private void createAboutImage() {
        Optional<ImageDescriptor> imageDescriptor = ProductProperties.aboutImage(Optional.of(this.product));
        if (imageDescriptor.isPresent()) {
            JFaceResources.getImageRegistry().put(this.productName, imageDescriptor.get());
        }
    }

    public String getAboutText() {
        return Optional.ofNullable(ProductProperties.getAboutText(this.product)).orElse("");
    }

    public Optional<Image> getAboutImage() {
        if (JFaceResources.getImage((String)this.productName) == null) {
            this.createAboutImage();
        }
        return Optional.ofNullable(JFaceResources.getImage((String)this.productName));
    }
}

