/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.launching;

import com.google.common.io.CharStreams;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.rcptt.core.ContextType;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.model.ITestCase;
import org.eclipse.rcptt.core.model.ModelException;
import org.eclipse.rcptt.core.model.search.Q7SearchCore;
import org.eclipse.rcptt.ecl.parser.ScriptErrorStatus;
import org.eclipse.rcptt.internal.core.model.Q7Context;
import org.eclipse.rcptt.internal.launching.EclStackTrace;
import org.eclipse.rcptt.internal.launching.ExecutionStatus;
import org.eclipse.rcptt.internal.launching.PrepareExecutionWrapper;
import org.eclipse.rcptt.internal.launching.Q7LaunchManager;
import org.eclipse.rcptt.internal.ui.Images;
import org.eclipse.rcptt.internal.ui.Messages;
import org.eclipse.rcptt.internal.ui.Q7UIPlugin;
import org.eclipse.rcptt.launching.IExecutable;
import org.eclipse.rcptt.launching.IExecutionSession;
import org.eclipse.rcptt.launching.Q7Launcher;
import org.eclipse.rcptt.reporting.core.SimpleSeverity;
import org.eclipse.rcptt.reporting.util.IndentedWriter;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.Report;
import org.eclipse.rcptt.tesla.core.info.AdvancedInformation;
import org.eclipse.rcptt.tesla.core.ui.StyleRangeEntry;
import org.eclipse.rcptt.ui.actions.CollapseAllAction;
import org.eclipse.rcptt.ui.actions.LockSelectionAction;
import org.eclipse.rcptt.ui.actions.Q7ExecutionViewAction;
import org.eclipse.rcptt.ui.actions.RunFailedAction;
import org.eclipse.rcptt.ui.actions.RunSelectedAction;
import org.eclipse.rcptt.ui.actions.StopAction;
import org.eclipse.rcptt.ui.actions.StopOnFirstFailAction;
import org.eclipse.rcptt.ui.editors.context.ContextEditor;
import org.eclipse.rcptt.ui.editors.ecl.EclEditor;
import org.eclipse.rcptt.ui.editors.verification.VerificationEditor;
import org.eclipse.rcptt.ui.editors.verification.VerificationEditorPage;
import org.eclipse.rcptt.ui.history.ViewHistory;
import org.eclipse.rcptt.ui.launching.DetailsDialog;
import org.eclipse.rcptt.ui.launching.ExecutionContentProvider;
import org.eclipse.rcptt.ui.launching.ExecutionLabelProvider;
import org.eclipse.rcptt.ui.launching.StatisticPanel;
import org.eclipse.rcptt.ui.report.ReportAction;
import org.eclipse.rcptt.ui.utils.Executables;
import org.eclipse.rcptt.ui.utils.RangeUtils;
import org.eclipse.rcptt.verifications.runtime.StyledMessage;
import org.eclipse.rcptt.verifications.runtime.VerificationReporter;
import org.eclipse.rcptt.verifications.runtime.VerificationStatus;
import org.eclipse.rcptt.verifications.status.VerificationStatusData;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.ResourceTransfer;
import org.eclipse.ui.part.ViewPart;

public class ExecutionView
extends ViewPart
implements IExecutionSession.IExecutionSessionListener {
    public static final String ID = "org.eclipse.rcptt.ui.views.execution";
    private static final String DETAILS_LABEL = Messages.ExecutionView_MessageLabel;
    private static final String ADVANCED_INFO_LABEL = Messages.ExecutionView_DetailsLabel;
    private TreeViewer viewer;
    private StyledText failureTrace;
    private final StopAction stopAction = new StopAction();
    private final StopOnFirstFailAction stopOnFirstFailAction = new StopOnFirstFailAction(false);
    private Q7ExecutionViewAction runSelectedAction;
    private final RunFailedAction runFailedAction = new RunFailedAction();
    private ReportAction reportAction;
    private StatisticPanel statisticPanel;
    private ExecutionViewHistory viewHistory;
    private IExecutionSession activeSession;
    private Composite evParent;
    private Report report;
    private Button advInfoButton;
    private boolean scrollState = false;
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static List<ExecutionView> views = new ArrayList<ExecutionView>();
    private final Listener mouseUp = new Listener(){

        public void handleEvent(Event event) {
            if (!(event.widget instanceof StyledText)) {
                return;
            }
            StyledText st = (StyledText)event.widget;
            int offset = st.getCaretOffset();
            Object data = null;
            StyleRange[] styleRangeArray = st.getStyleRanges();
            int n = styleRangeArray.length;
            int n2 = 0;
            while (n2 < n) {
                StyleRange range = styleRangeArray[n2];
                if (range.start <= offset && range.length + range.start > offset) {
                    data = range.data;
                    break;
                }
                ++n2;
            }
            if (data instanceof ScriptErrorStatus) {
                ScriptErrorStatus status = (ScriptErrorStatus)data;
                IQ7NamedElement element = Q7SearchCore.findById((String)status.getResource());
                ExecutionView.this.openElement(element, status.getLine(), status.getColumn(), status.getLength());
            } else if (data instanceof VerificationStatusData) {
                Object page;
                VerificationStatusData statusData = (VerificationStatusData)data;
                IQ7NamedElement element = Q7SearchCore.findById((String)statusData.getResourceId());
                if (element == null) {
                    return;
                }
                IFile resource = (IFile)element.getResource();
                if (resource == null) {
                    return;
                }
                IEditorPart editor = null;
                try {
                    editor = IDE.openEditor((IWorkbenchPage)ExecutionView.this.getSite().getPage(), (IFile)resource);
                }
                catch (PartInitException e) {
                    return;
                }
                if (editor instanceof VerificationEditor && (page = ((VerificationEditor)editor).getSelectedPage()) instanceof VerificationEditorPage) {
                    ((VerificationEditorPage)page).select(statusData);
                }
            }
        }
    };
    private final IResourceChangeListener workspaceListener = new IResourceChangeListener(){

        public void resourceChanged(IResourceChangeEvent event) {
            if (event.getType() == 1) {
                Q7UIPlugin.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!(this).ExecutionView.this.viewer.getControl().isDisposed()) {
                            (this).ExecutionView.this.viewer.refresh();
                        }
                    }
                });
            }
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecutionView() {
        List<ExecutionView> list = views;
        synchronized (list) {
            views.add(this);
        }
    }

    static boolean hasEclScipt(IQ7NamedElement element) {
        if (element instanceof ITestCase) {
            return true;
        }
        if (element instanceof Q7Context) {
            try {
                ContextType type = ((Q7Context)element).getType();
                if (type.getId().equals("org.eclipse.rcptt.core.ecl.context")) {
                    return true;
                }
            }
            catch (ModelException e) {
                return false;
            }
        }
        return false;
    }

    static void jump(EclEditor scenarioEditor, ExecutionStatus es) {
        if (es.hasLocation()) {
            scenarioEditor.setSelection(es.getLine(), es.getColumn(), es.getLength());
        } else {
            scenarioEditor.setSelection(1, 1, 1);
        }
    }

    public void createPartControl(Composite parent) {
        this.evParent = parent;
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        parent.setLayout((Layout)gridLayout);
        this.viewHistory = new ExecutionViewHistory();
        Composite spComposite = this.createStatisticPanel(parent);
        spComposite.setLayoutData((Object)new GridData(768));
        SashForm form = new SashForm(parent, 512);
        form.setLayoutData((Object)new GridData(1808));
        Tree tree = new Tree((Composite)form, 67586);
        this.viewer = new TreeViewer(tree);
        this.viewer.setLabelProvider((IBaseLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new ExecutionLabelProvider()));
        final ExecutionContentProvider cp = new ExecutionContentProvider();
        this.viewer.setContentProvider((IContentProvider)cp);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ExecutionView.this.runSelectedAction.updateEnablement(ExecutionView.this.activeSession);
                ExecutionView.this.failureTrace.setText("");
                Object element = ((IStructuredSelection)event.getSelection()).getFirstElement();
                if (element instanceof IExecutable) {
                    IExecutable exec = (IExecutable)element;
                    IStatus status = exec.getResultStatus();
                    if (ExecutionView.this.isConnectionTerminatedStatus(exec)) {
                        ExecutionView.this.failureTrace.setText(Messages.ExecutionView_NoConnectionEMsg);
                        ExecutionView.this.advInfoButton.setEnabled(false);
                    } else if (status != null && !status.isOK()) {
                        ExecutionView.this.setMessage(exec.getActualElement(), status, 0);
                        if (status instanceof ExecutionStatus) {
                            ExecutionStatus st = (ExecutionStatus)status;
                            AdvancedInformation info = st.getInfo();
                            if (info != null) {
                                ExecutionView.this.advInfoButton.setEnabled(true);
                            } else {
                                ExecutionView.this.advInfoButton.setEnabled(false);
                            }
                        }
                    } else {
                        ExecutionView.this.advInfoButton.setEnabled(false);
                    }
                    Object ee = element;
                    while (ee != null && !(ee instanceof PrepareExecutionWrapper)) {
                        ee = cp.getParent(ee);
                    }
                    if (ee instanceof PrepareExecutionWrapper) {
                        Report resultReport = ((PrepareExecutionWrapper)ee).getResultReport();
                        if (resultReport != null) {
                            ExecutionView.this.report = resultReport;
                            ExecutionView.this.advInfoButton.setEnabled(true);
                        } else {
                            ExecutionView.this.report = null;
                        }
                    }
                }
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                Object element = ((IStructuredSelection)event.getSelection()).getFirstElement();
                ExecutionView.this.openElement(element);
            }
        });
        IToolBarManager manager = this.getViewSite().getActionBars().getToolBarManager();
        this.runSelectedAction = new RunSelectedAction((ISelectionProvider)this.viewer);
        manager.add((IAction)new CollapseAllAction(this.viewer));
        manager.add((IAction)new LockSelectionAction(this));
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.runSelectedAction);
        manager.add((IAction)this.runFailedAction);
        manager.add((IAction)this.stopAction);
        manager.add((IAction)this.stopOnFirstFailAction);
        manager.add((IContributionItem)new Separator());
        this.reportAction = new ReportAction((IShellProvider)this.getSite());
        manager.add((IAction)this.reportAction);
        manager.add(this.viewHistory.createHistoryDropDownAction());
        this.runSelectedAction.updateEnablement(null);
        this.runFailedAction.updateEnablement(null);
        this.stopAction.updateEnablement(null);
        MenuManager mgr = new MenuManager();
        mgr.add((IAction)new Action("&Open"){

            public void run() {
                ISelection selection = ExecutionView.this.viewer.getSelection();
                if (!selection.isEmpty() && selection instanceof IStructuredSelection) {
                    ExecutionView.this.openElement(((IStructuredSelection)selection).getFirstElement());
                }
            }
        });
        mgr.add((IAction)this.runSelectedAction);
        mgr.add((IAction)this.stopAction);
        Menu menu = mgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.createFailTrace((Composite)form);
        form.setWeights(new int[]{50, 50});
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.workspaceListener);
        this.initializeDnD();
    }

    private void initializeDnD() {
        int ops = 3;
        Transfer[] transferTypes = new Transfer[]{ResourceTransfer.getInstance(), LocalSelectionTransfer.getTransfer()};
        this.viewer.addDragSupport(ops, transferTypes, (DragSourceListener)new ContentDragListener((StructuredViewer)this.viewer));
    }

    private boolean isConnectionTerminatedStatus(IExecutable exec) {
        IStatus status = exec.getResultStatus();
        if (Q7LaunchManager.isConnectionException((IStatus)status)) {
            if (Messages.ExecutionView_ConnectionResetMsg.equals(status.getMessage()) || Messages.ExecutionView_ConnectionRefusedMsg.equals(status.getMessage())) {
                return true;
            }
            IExecutable[] iExecutableArray = exec.getChildren();
            int n = iExecutableArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExecutable execChild = iExecutableArray[n2];
                if (this.isConnectionTerminatedStatus(execChild)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private IRegion append(StringBuilder sb, String text) {
        int begin = sb.length();
        sb.append(text);
        int end = sb.length();
        return new Region(begin, end - begin);
    }

    private static StyleRange bold(IRegion region) {
        return new StyleRange(region.getOffset(), region.getLength(), null, null, 1);
    }

    private static StyleRange link(IRegion region, Object data) {
        StyleRange result = new StyleRange(region.getOffset(), region.getLength(), JFaceColors.getHyperlinkText((Display)Display.getDefault()), null, 0);
        result.data = data;
        result.underline = true;
        result.underlineStyle = 4;
        return result;
    }

    private void setMessage(IQ7NamedElement namedElement, IStatus status, int level) {
        StringBuilder buffer = new StringBuilder();
        List<StyleRange> ranges = this.print(status, level, buffer);
        buffer.append(LINE_SEPARATOR);
        Throwable t = status.getException();
        if (t != null) {
            this.processThrowableMsg(level, buffer, t);
        }
        this.failureTrace.setText(buffer.toString());
        this.failureTrace.setStyleRanges(ranges.toArray(new StyleRange[ranges.size()]));
        this.failureTrace.removeListener(4, this.mouseUp);
        this.failureTrace.addListener(4, this.mouseUp);
    }

    /*
     * WARNING - void declaration
     */
    private List<StyleRange> print(IStatus status, int level, StringBuilder buffer) {
        String message = status.getMessage();
        if (message == null || message.length() == 0) {
            message = status.matches(8) ? "Execution is canceled." : (status.matches(4) ? Messages.ExecutionView_ExecutionFailedMsg : "Execution result is malformed.");
        }
        ArrayList<StyleRange> ranges = new ArrayList<StyleRange>();
        if (status instanceof ExecutionStatus) {
            IStatus[] iStatusArray = status.getChildren();
            int n = iStatusArray.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus child = iStatusArray[n2];
                ranges.addAll(this.print(child, level, buffer));
                ++n2;
            }
            return ranges;
        }
        ExecutionView.appendTabs(buffer, level);
        if (status instanceof ScriptErrorStatus) {
            void var8_11;
            EclStackTrace trace = EclStackTrace.fromScriptStatus((IStatus)status);
            this.append(buffer, trace.getDisplayMessage());
            if (trace.frames.length != 0) {
                this.append(buffer, LINE_SEPARATOR);
            }
            ScriptErrorStatus[] scriptErrorStatusArray = trace.frames;
            int n = trace.frames.length;
            boolean n3 = false;
            while (var8_11 < n) {
                ScriptErrorStatus frame = scriptErrorStatusArray[var8_11];
                this.append(buffer, "\tat ");
                ranges.add(ExecutionView.bold(this.append(buffer, frame.getMessage())));
                this.append(buffer, " (");
                ranges.add(ExecutionView.link(this.append(buffer, EclStackTrace.getLocation((ScriptErrorStatus)frame)), frame));
                this.append(buffer, ")\n");
                ++var8_11;
            }
            return ranges;
        }
        if (status instanceof VerificationStatus) {
            VerificationStatus verStatus = (VerificationStatus)status;
            StyledMessage styledMsg = VerificationReporter.getStyledMessage((VerificationStatus)verStatus);
            buffer.append(styledMsg.getMessage());
            for (Map.Entry n : styledMsg.getStyles().entrySet()) {
                ranges.add(this.makeMessageStyleRange((StyleRangeEntry)n.getKey(), n.getValue()));
            }
        } else {
            buffer.append(message);
            buffer.append(LINE_SEPARATOR);
        }
        IStatus[] iStatusArray = status.getChildren();
        int n = iStatusArray.length;
        int n3 = 0;
        while (n3 < n) {
            Object child = iStatusArray[n3];
            this.print((IStatus)child, level + 1, buffer);
            ++n3;
        }
        return ranges;
    }

    private StyleRange makeMessageStyleRange(StyleRangeEntry entry, Object data) {
        if (entry.getUnderline() != null && entry.getUnderline().equals("verification_link")) {
            StyleRange result = new StyleRange(entry.getStart(), entry.getLength(), JFaceColors.getHyperlinkText((Display)Display.getDefault()), null, 0);
            result.data = data;
            result.underline = true;
            result.underlineStyle = 4;
            return result;
        }
        StyleRange result = RangeUtils.fromEMF(entry, (Device)this.evParent.getDisplay());
        if (result.underlineStyle == 4) {
            result.underlineStyle = 0;
        }
        result.start = entry.getStart();
        result.length = entry.getLength();
        result.data = data;
        return result;
    }

    private void processThrowableMsg(final int level, StringBuilder buffer, Throwable t) {
        IndentedWriter printWriter = new IndentedWriter(CharStreams.asWriter((Appendable)buffer)){

            public void writeIndent() {
                ExecutionView.appendTabs(this, level + 1);
            }
        };
        t.printStackTrace((PrintWriter)printWriter);
        printWriter.close();
    }

    private static <T extends Appendable> T appendTabs(T stream, int tabs) {
        int i = 0;
        while (i < tabs) {
            try {
                stream.append("  ");
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            ++i;
        }
        return stream;
    }

    private Composite createStatisticPanel(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        this.statisticPanel = new StatisticPanel(composite);
        this.statisticPanel.setLayoutData(new GridData(768));
        return composite;
    }

    private void createFailTrace(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        Composite detailsHeader = new Composite(composite, 0);
        GridLayout detailsHeaderLayout = new GridLayout(2, false);
        detailsHeaderLayout.marginWidth = 5;
        detailsHeaderLayout.marginHeight = 0;
        detailsHeader.setLayout((Layout)detailsHeaderLayout);
        detailsHeader.setLayoutData((Object)new GridData(4, 128, true, false));
        Label label = new Label(detailsHeader, 16384);
        label.setText(DETAILS_LABEL);
        this.advInfoButton = new Button(detailsHeader, 8);
        this.advInfoButton.setLayoutData((Object)new GridData(640));
        this.advInfoButton.setText(ADVANCED_INFO_LABEL);
        this.advInfoButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DetailsDialog dialog = new DetailsDialog(ExecutionView.this.failureTrace.getShell(), ExecutionView.this.report);
                dialog.open();
            }
        });
        this.advInfoButton.setEnabled(false);
        this.failureTrace = new StyledText(composite, 2888);
        this.failureTrace.setLayoutData((Object)new GridData(4, 4, true, true));
    }

    public void update(IExecutable ... executables) {
        int i = 0;
        IExecutable[] iExecutableArray = executables;
        int n = executables.length;
        int n2 = 0;
        while (n2 < n) {
            IExecutable executable = iExecutableArray[n2];
            IExecutable.State state = executable.getStatus();
            IStatus result = executable.getResultStatus();
            boolean failed = result.matches(-2);
            if (!this.scrollState && ++i == executables.length && !result.matches(8)) {
                this.viewer.setSelection((ISelection)new StructuredSelection((Object)executable), true);
            }
            if (IExecutable.State.COMPLETED == state && !failed) {
                this.viewer.collapseToLevel((Object)executable, -1);
            } else if (IExecutable.State.RUNNING == state) {
                this.viewer.expandToLevel((Object)executable, 1);
            }
            if (failed && this.stopOnFirstFailAction.getValue()) {
                MultiStatus status = new MultiStatus("org.eclipse.rcptt.core", 0, new IStatus[]{result}, "Stopped after previous failure", null){
                    {
                        this.setSeverity(8);
                    }
                };
                Q7Launcher.getInstance().stop((IStatus)status);
            }
            this.viewer.refresh((Object)executable);
            ++n2;
        }
        if (this.activeSession != null) {
            this.statisticPanel.update(this.activeSession.getTotalCount(), this.activeSession.getFinishedCount(), this.activeSession.getFailedCount(), this.activeSession.getStoppedCount(), this.activeSession.getTotalTime());
        }
        this.runSelectedAction.updateEnablement(this.activeSession);
        this.runFailedAction.updateEnablement(this.activeSession);
    }

    public void executionFinished() {
        this.activeSession.removeListener((IExecutionSession.IExecutionSessionListener)this);
    }

    public void statisticsUpdate() {
        if (this.activeSession == null) {
            return;
        }
        if (this.statisticPanel != null && this.statisticPanel.isDisposed()) {
            return;
        }
        this.statisticPanel.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                ExecutionView.this.statisticPanel.update(ExecutionView.this.activeSession.getTotalCount(), ExecutionView.this.activeSession.getFinishedCount(), ExecutionView.this.activeSession.getFailedCount(), ExecutionView.this.activeSession.getStoppedCount(), ExecutionView.this.activeSession.getTotalTime());
            }
        });
    }

    public void setInput(IExecutionSession session) {
        this.activeSession = session;
        if (this.activeSession != null) {
            this.activeSession.addListener((IExecutionSession.IExecutionSessionListener)this);
        }
        this.statisticPanel.reset();
        IExecutable[] executables = new IExecutable[]{};
        if (session != null) {
            executables = session.getExecutables();
            this.statisticsUpdate();
        }
        Executables input = new Executables(executables);
        this.viewer.setSelection(null);
        this.viewer.setInput((Object)input);
        this.runSelectedAction.updateEnablement(session);
        this.runSelectedAction.inputChanged(input);
        this.stopAction.updateEnablement(session);
        this.runFailedAction.updateEnablement(session);
        this.reportAction.setSession(session);
    }

    public void finished() {
        this.statisticsUpdate();
        if (this.activeSession != null) {
            this.activeSession.removeListener((IExecutionSession.IExecutionSessionListener)this);
        }
        this.runSelectedAction.updateEnablement(this.activeSession);
        this.stopAction.updateEnablement(this.activeSession);
        this.runFailedAction.updateEnablement(this.activeSession);
    }

    public void setFocus() {
        this.viewer.getTree().setFocus();
    }

    public boolean getScrollState() {
        return this.scrollState;
    }

    public boolean updateScrollState() {
        this.scrollState = !this.scrollState;
        return this.scrollState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        List<ExecutionView> list = views;
        synchronized (list) {
            views.remove((Object)this);
        }
        super.dispose();
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.workspaceListener);
    }

    private void openElement(IQ7NamedElement element, int line, int column, int length) {
        if (element == null) {
            return;
        }
        IFile resource = (IFile)element.getResource();
        if (resource == null) {
            return;
        }
        IEditorPart editor = null;
        try {
            editor = IDE.openEditor((IWorkbenchPage)this.getSite().getPage(), (IFile)resource);
        }
        catch (PartInitException e) {
            return;
        }
        if (line == -1 || column == -1 || length == -1) {
            return;
        }
        if (editor instanceof ContextEditor) {
            editor = ((ContextEditor)editor).getEditor();
        }
        if (editor instanceof EclEditor) {
            ((EclEditor)editor).setSelection(line, column, length);
        }
    }

    private void openElement(Object element) {
        if (!(element instanceof IExecutable)) {
            return;
        }
        IExecutable exec = (IExecutable)element;
        int line = 1;
        int column = 1;
        int length = 0;
        if (exec.getResultStatus() instanceof ExecutionStatus) {
            ExecutionStatus st = (ExecutionStatus)exec.getResultStatus();
            line = st.getLine();
            column = st.getColumn();
            length = st.getLength();
        }
        this.openElement(exec.getActualElement(), line, column, length);
    }

    private class ClearAction
    extends Action {
        public ClearAction() {
            IExecutionSession[] sessions;
            this.setText(Messages.ExecutionView_ClearActionText);
            boolean enabled = false;
            IExecutionSession[] iExecutionSessionArray = sessions = Q7Launcher.getInstance().getExecutionSessions();
            int n = sessions.length;
            int n2 = 0;
            while (n2 < n) {
                IExecutionSession session = iExecutionSessionArray[n2];
                if (!session.isRunning()) {
                    enabled = true;
                    break;
                }
                ++n2;
            }
            this.setEnabled(enabled);
        }

        public void run() {
            List<IExecutionSession> runningSessions = this.getRunningSessions();
            IExecutionSession first = runningSessions.isEmpty() ? null : runningSessions.get(0);
            ExecutionView.this.viewHistory.setHistoryEntries(runningSessions, first);
        }

        private List<IExecutionSession> getRunningSessions() {
            IExecutionSession[] sessions = Q7Launcher.getInstance().getExecutionSessions();
            ArrayList<IExecutionSession> runningSessions = new ArrayList<IExecutionSession>();
            IExecutionSession[] iExecutionSessionArray = sessions;
            int n = sessions.length;
            int n2 = 0;
            while (n2 < n) {
                IExecutionSession session = iExecutionSessionArray[n2];
                if (session.isRunning()) {
                    runningSessions.add(session);
                }
                ++n2;
            }
            return runningSessions;
        }
    }

    private class ContentDragListener
    extends DragSourceAdapter {
        private final StructuredViewer structuredViewer;

        public ContentDragListener(StructuredViewer structuredViewer) {
            this.structuredViewer = structuredViewer;
        }

        public void dragStart(DragSourceEvent event) {
            IStructuredSelection selection = (IStructuredSelection)this.structuredViewer.getSelection();
            List list = this.getSelection(event, selection);
            boolean bl = event.doit = !list.isEmpty();
            if (!list.isEmpty()) {
                LocalSelectionTransfer.getTransfer().setSelection((ISelection)new StructuredSelection(list));
            }
        }

        public void dragSetData(DragSourceEvent event) {
            ISelection selection;
            if (ResourceTransfer.getInstance().isSupportedType(event.dataType) && (selection = LocalSelectionTransfer.getTransfer().getSelection()) instanceof IStructuredSelection) {
                List list = ((IStructuredSelection)selection).toList();
                event.data = list.toArray(new IResource[list.size()]);
            }
        }

        private List getSelection(DragSourceEvent event, IStructuredSelection selection) {
            ArrayList<IResource> selectedElements = new ArrayList<IResource>();
            List list = selection.toList();
            for (Object o : list) {
                IQ7NamedElement element;
                if (!(o instanceof PrepareExecutionWrapper) || !((element = ((PrepareExecutionWrapper)o).getActualElement()) instanceof ITestCase) || element.getResource() == null) continue;
                selectedElements.add(element.getResource());
            }
            return selectedElements;
        }
    }

    private class ExecutionViewHistory
    extends ViewHistory {
        private ExecutionViewHistory() {
        }

        @Override
        public void configureHistoryListAction(IAction action) {
            action.setText(Messages.ExecutionView_HistoryActionText);
        }

        @Override
        public void configureHistoryDropDownAction(IAction action) {
            action.setToolTipText(Messages.ExecutionView_ExecutionHistoryActionToolTip);
            action.setImageDescriptor(ImageDescriptor.createFromImage((Image)Images.getImage("icons/launching/history_list.gif")));
        }

        @Override
        public Action getClearAction() {
            return new ClearAction();
        }

        @Override
        public String getHistoryListDialogTitle() {
            return Messages.ExecutionView_HistoryListDialogTitle;
        }

        @Override
        public String getHistoryListDialogMessage() {
            return Messages.ExecutionView_HistoryListDialogMsg;
        }

        @Override
        public Shell getShell() {
            return ExecutionView.this.evParent.getShell();
        }

        public List<IExecutionSession> getHistoryEntries() {
            return Arrays.asList(Q7Launcher.getInstance().getExecutionSessions());
        }

        @Override
        public Object getCurrentEntry() {
            return ExecutionView.this.activeSession;
        }

        @Override
        public void setActiveEntry(Object entry) {
            ExecutionView.this.setInput((IExecutionSession)entry);
        }

        @Override
        public void setHistoryEntries(List<?> remainingEntries, Object activeEntry) {
            IExecutionSession[] sessions;
            ExecutionView.this.setInput((IExecutionSession)activeEntry);
            IExecutionSession[] iExecutionSessionArray = sessions = Q7Launcher.getInstance().getExecutionSessions();
            int n = sessions.length;
            int n2 = 0;
            while (n2 < n) {
                IExecutionSession session = iExecutionSessionArray[n2];
                if (!remainingEntries.contains(session)) {
                    Q7Launcher.getInstance().removeExecutionSession(session);
                }
                ++n2;
            }
        }

        @Override
        public ImageDescriptor getImageDescriptor(Object element) {
            IExecutionSession session = (IExecutionSession)element;
            if (session.isRunning()) {
                return ImageDescriptor.createFromImage((Image)Images.getImage("icons/launching/tsuiterun.gif"));
            }
            SimpleSeverity severity = SimpleSeverity.create((IStatus)session.getResultStatus());
            switch (severity) {
                case OK: {
                    return ImageDescriptor.createFromImage((Image)Images.getImage("icons/launching/tsuiteok.gif"));
                }
                case ERROR: {
                    return ImageDescriptor.createFromImage((Image)Images.getImage("icons/launching/tsuiteerror.gif"));
                }
                case CANCEL: {
                    return ImageDescriptor.createFromImage((Image)Images.getImage("icons/launching/tsuite.gif"));
                }
            }
            throw new IllegalStateException("Unknown SimpleSeverity: " + String.valueOf(severity));
        }

        @Override
        public String getText(Object element) {
            IExecutionSession session = (IExecutionSession)element;
            String startTime = DateFormat.getDateTimeInstance().format(session.getStartTime());
            return Messages.bind((String)"{0} ({1})", (Object)session.getName(), (Object)startTime);
        }

        @Override
        public void addMenuEntries(MenuManager manager) {
        }

        @Override
        public String getMaxEntriesMessage() {
            return Messages.ExecutionView_MaxEntriesMsg;
        }

        @Override
        public int getMaxEntries() {
            return Q7Launcher.getInstance().getMaxHistoryEntries();
        }

        @Override
        public void setMaxEntries(int maxEntries) {
            Q7Launcher.getInstance().setMaxHistoryEntries(maxEntries);
        }
    }
}

