/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.editors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.model.IQ7Project;
import org.eclipse.rcptt.core.model.ITestCase;
import org.eclipse.rcptt.core.model.ITestSuite;
import org.eclipse.rcptt.core.model.ModelException;
import org.eclipse.rcptt.core.model.search.AllProjectScope;
import org.eclipse.rcptt.core.model.search.ISearchScope;
import org.eclipse.rcptt.core.scenario.NamedElement;
import org.eclipse.rcptt.core.scenario.TestSuite;
import org.eclipse.rcptt.core.scenario.TestSuiteItem;
import org.eclipse.rcptt.internal.core.model.ReferencedProjectScope;
import org.eclipse.rcptt.internal.ui.Messages;
import org.eclipse.rcptt.internal.ui.Q7UIPlugin;
import org.eclipse.rcptt.ui.commons.TestSuiteTableViewer;
import org.eclipse.rcptt.ui.controls.SectionWithComposite;
import org.eclipse.rcptt.ui.controls.TestSuiteButtonsPanel;
import org.eclipse.rcptt.ui.editors.EditorHeader;
import org.eclipse.rcptt.ui.editors.NamedElementEditor;
import org.eclipse.rcptt.ui.editors.NamedElementEditorPage;
import org.eclipse.rcptt.ui.tags.SelectTagsFilterDialog;
import org.eclipse.rcptt.ui.utils.WorkbenchUtils;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class TestSuiteEditorPage
extends NamedElementEditorPage {
    private TestSuiteTableViewer testCasesviewer;
    private TestSuiteButtonsPanel suiteButtonsPanel;
    private boolean needCheckReferences = true;

    public TestSuiteEditorPage(NamedElementEditor editor) {
        super(editor, "test.suite", Messages.TestSuiteEditorPage_Name);
    }

    public ITestSuite getModel() {
        return (ITestSuite)super.getModel();
    }

    public TestSuite getElement() {
        return (TestSuite)super.getElement();
    }

    public TestSuiteTableViewer getTestCasesviewer() {
        return this.testCasesviewer;
    }

    @Override
    protected void createSpecificContent(Composite parent, FormToolkit toolkit, IManagedForm form) {
        Section testCasesSection = new SectionWithComposite("Test Cases", 322).numColumns(2).create(parent, toolkit);
        Composite testCasesComposite = (Composite)testCasesSection.getClient();
        this.createSuiteTable(testCasesComposite);
        this.suiteButtonsPanel = new TestSuiteButtonsPanel(testCasesComposite, true);
        this.addButtonsListeners();
        this.testCasesviewer.setInput(this.getElement().getItems());
        this.suiteButtonsPanel.updateButtons(this.testCasesviewer);
        this.suiteButtonsPanel.getResetOrderLink().setVisible(this.getElement().isManuallyOrdered());
    }

    private void createSuiteTable(Composite parent) {
        this.testCasesviewer = new TestSuiteTableViewer(parent, this.getModel(), this.getElement());
        this.testCasesviewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TestSuiteEditorPage.this.suiteButtonsPanel.updateButtons(TestSuiteEditorPage.this.testCasesviewer);
            }
        });
        this.testCasesviewer.getTestSuiteObservable().addChangeListener(new IChangeListener(){

            public void handleChange(ChangeEvent event) {
                if (TestSuiteEditorPage.this.needCheckReferences) {
                    TestSuiteEditorPage.this.getEditor().checkMissingReferences();
                }
                TestSuiteEditorPage.this.suiteButtonsPanel.updateButtons(TestSuiteEditorPage.this.testCasesviewer);
                TestSuiteEditorPage.this.suiteButtonsPanel.getResetOrderLink().setVisible(TestSuiteEditorPage.this.getElement().isManuallyOrdered());
            }
        });
        if (!this.getElement().isManuallyOrdered()) {
            this.testCasesviewer.setComparator(new TestSuiteComparator());
        }
    }

    private void addButtonsListeners() {
        this.suiteButtonsPanel.getAddTestCaseBtn().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TestSuiteEditorPage.this.addTestCase();
                TestSuiteEditorPage.this.refreshPage();
            }
        });
        this.suiteButtonsPanel.getAddFolderBtn().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TestSuiteEditorPage.this.addFolder();
                TestSuiteEditorPage.this.refreshPage();
            }
        });
        this.suiteButtonsPanel.getAddTaggedBtn().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TestSuiteEditorPage.this.addTagged();
                TestSuiteEditorPage.this.refreshPage();
            }
        });
        this.suiteButtonsPanel.getRemoveBtn().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TestSuiteEditorPage.this.testCasesviewer.handleRemove();
                TestSuiteEditorPage.this.refreshPage();
            }
        });
        this.suiteButtonsPanel.getRemoveAllBtn().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TestSuiteEditorPage.this.testCasesviewer.removeAll();
                TestSuiteEditorPage.this.refreshPage();
            }
        });
        this.suiteButtonsPanel.getMoveUpBtn().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!TestSuiteEditorPage.this.getElement().isManuallyOrdered()) {
                    TestSuiteEditorPage.this.getElement().setManuallyOrdered(true);
                    TestSuiteEditorPage.this.suiteButtonsPanel.getResetOrderLink().setVisible(true);
                }
                TestSuiteEditorPage.this.testCasesviewer.moveUp();
                TestSuiteEditorPage.this.suiteButtonsPanel.updateButtons(TestSuiteEditorPage.this.testCasesviewer);
            }
        });
        this.suiteButtonsPanel.getMoveDownBtn().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!TestSuiteEditorPage.this.getElement().isManuallyOrdered()) {
                    TestSuiteEditorPage.this.getElement().setManuallyOrdered(true);
                    TestSuiteEditorPage.this.suiteButtonsPanel.getResetOrderLink().setVisible(true);
                }
                TestSuiteEditorPage.this.testCasesviewer.moveDown();
                TestSuiteEditorPage.this.suiteButtonsPanel.updateButtons(TestSuiteEditorPage.this.testCasesviewer);
            }
        });
        this.suiteButtonsPanel.getResetOrderLink().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (TestSuiteEditorPage.this.getElement().isManuallyOrdered()) {
                    TestSuiteEditorPage.this.getElement().setManuallyOrdered(false);
                    TestSuiteEditorPage.this.suiteButtonsPanel.getResetOrderLink().setVisible(false);
                }
                TestSuiteEditorPage.this.testCasesviewer.setComparator(new TestSuiteComparator());
                TestSuiteEditorPage.this.suiteButtonsPanel.updateButtons(TestSuiteEditorPage.this.testCasesviewer);
            }
        });
    }

    private void addTestCase() {
        try {
            this.needCheckReferences = false;
            ArrayList<IQ7NamedElement> excluded = new ArrayList<IQ7NamedElement>();
            excluded.add((IQ7NamedElement)this.getModel());
            List<TestSuiteItem> testcases = this.testCasesviewer.getTestcases();
            for (TestSuiteItem testSuiteItem : testcases) {
                try {
                    IQ7NamedElement[] case1 = this.getModel().getQ7Project().findNamedElement(testSuiteItem.getNamedElementId());
                    if (case1 == null || case1.length <= 0) continue;
                    excluded.addAll(Arrays.asList(case1));
                }
                catch (ModelException e) {
                    Q7UIPlugin.log(e);
                }
            }
            IQ7NamedElement[] selected = TestSuiteButtonsPanel.selectTestCase(this.getSearchScope(), excluded, true);
            int i = 0;
            while (i < selected.length) {
                this.testCasesviewer.addItem(selected[i]);
                ++i;
            }
        }
        finally {
            this.needCheckReferences = true;
        }
    }

    private void addFolder() {
        try {
            this.needCheckReferences = false;
            IContainer container = TestSuiteButtonsPanel.selectFolder();
            if (container != null) {
                this.testCasesviewer.addFolder(container);
                this.getEditor().checkMissingReferences();
            }
        }
        finally {
            this.needCheckReferences = true;
        }
    }

    private void addTagged() {
        try {
            this.needCheckReferences = false;
            SelectTagsFilterDialog dialog = new SelectTagsFilterDialog(WorkbenchUtils.getShell());
            int result = dialog.open();
            if (result == 0) {
                this.testCasesviewer.addTags(dialog.getSelectedTags());
                this.testCasesviewer.addItems(dialog.getSelectedItems());
            }
        }
        finally {
            this.needCheckReferences = true;
        }
    }

    private ISearchScope getSearchScope() {
        IQ7Project testSuiteProject = this.getModel().getQ7Project();
        ReferencedProjectScope scope = testSuiteProject != null ? new ReferencedProjectScope(testSuiteProject) : new AllProjectScope();
        return scope;
    }

    public void refreshPage() {
        this.testCasesviewer.refresh();
        this.suiteButtonsPanel.updateButtons(this.testCasesviewer);
        this.suiteButtonsPanel.getResetOrderLink().setVisible(this.getElement().isManuallyOrdered());
    }

    @Override
    protected void record() {
    }

    public void updateContent() {
        this.testCasesviewer.updateItems();
    }

    @Override
    protected EditorHeader createHeader() {
        return new EditorHeader((IQ7NamedElement)this.getModel(), (NamedElement)this.getElement()){

            @Override
            protected Button createRecordButton(Composite composite, FormToolkit toolkit) {
                Button button = toolkit.createButton(composite, Messages.TestSuiteEditorPage_ExecuteButton, 8);
                button.setImage(DebugUITools.getImageDescriptor((String)"IMG_ACT_RUN").createImage());
                button.setBackground(null);
                GridDataFactory.fillDefaults().applyTo((Control)button);
                button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        if ((e.stateMask & 0x20000) != 0) {
                            this.multiReplay();
                        } else {
                            this.replay();
                        }
                    }
                });
                return button;
            }

            @Override
            protected Button createReplayButton(Composite composite, FormToolkit toolkit) {
                return null;
            }

            @Override
            protected void record() {
            }

            @Override
            protected int getTagsSpacing() {
                return 3;
            }
        };
    }

    private class TestSuiteComparator
    extends ViewerComparator {
        private TestSuiteComparator() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public int category(Object element) {
            if (!(element instanceof TestSuiteItem)) return super.category(element);
            String id = ((TestSuiteItem)element).getNamedElementId();
            try {
                IQ7NamedElement[] case1;
                IQ7NamedElement[] iQ7NamedElementArray = case1 = TestSuiteEditorPage.this.getModel().getQ7Project().findNamedElement(id);
                int n = case1.length;
                int n2 = 0;
                while (true) {
                    if (n2 >= n) {
                        return super.category(element);
                    }
                    IQ7NamedElement iq7NamedElement = iQ7NamedElementArray[n2];
                    if (iq7NamedElement instanceof ITestSuite) {
                        return 1;
                    }
                    if (iq7NamedElement instanceof ITestCase) {
                        return 0;
                    }
                    ++n2;
                }
            }
            catch (CoreException e) {
                Q7UIPlugin.log(e);
            }
            return super.category(element);
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            int cat2;
            int cat1 = this.category(e1);
            if (cat1 != (cat2 = this.category(e2))) {
                return cat1 - cat2;
            }
            if (e1 instanceof TestSuiteItem && e2 instanceof TestSuiteItem) {
                String id1 = ((TestSuiteItem)e1).getNamedElementId();
                String id2 = ((TestSuiteItem)e2).getNamedElementId();
                try {
                    IQ7NamedElement[] case1 = TestSuiteEditorPage.this.getModel().getQ7Project().findNamedElement(id1);
                    IQ7NamedElement[] case2 = TestSuiteEditorPage.this.getModel().getQ7Project().findNamedElement(id2);
                    if (case1 != null && case2 != null && case1.length > 0 && case2.length > 0) {
                        return case1[0].getElementName().compareTo(case2[0].getElementName());
                    }
                }
                catch (CoreException e) {
                    Q7UIPlugin.log(e);
                }
            }
            return super.compare(viewer, e1, e2);
        }
    }
}

