/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ecl.filesystem.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.rcptt.ecl.filesystem.EclFile;
import org.eclipse.rcptt.ecl.filesystem.EclFilesystemPlugin;

public class JavaFile
implements EclFile {
    private final File file;

    public JavaFile(File file) {
        if (file == null) {
            throw new NullPointerException();
        }
        this.file = file;
    }

    @Override
    public String getName() {
        return this.file.getName();
    }

    @Override
    public boolean exists() {
        return this.file.exists();
    }

    public Collection<JavaFile> getChildren() throws CoreException {
        File[] array = this.file.listFiles();
        if (array == null) {
            throw new CoreException((IStatus)this.err("%s is not a directory", null));
        }
        ArrayList<JavaFile> rv = new ArrayList<JavaFile>(array.length);
        File[] fileArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            rv.add(new JavaFile(f));
            ++n2;
        }
        return rv;
    }

    @Override
    public URI toURI() {
        return this.file.toURI();
    }

    @Override
    public boolean isDirectory() {
        return this.file.isDirectory();
    }

    private static void deleteRecursive(File path) throws IOException {
        if (!path.exists()) {
            throw new FileNotFoundException(path.getAbsolutePath());
        }
        if (path.isDirectory()) {
            File[] fileArray = path.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                JavaFile.deleteRecursive(f);
                ++n2;
            }
        }
        if (!path.delete()) {
            throw new IOException("Failed to delete " + String.valueOf(path));
        }
    }

    @Override
    public void delete() throws CoreException {
        try {
            JavaFile.deleteRecursive(this.file);
        }
        catch (FileNotFoundException e) {
            throw new CoreException((IStatus)this.err("Failed to delete %s", e));
        }
        catch (IOException e) {
            throw new CoreException((IStatus)this.err("Failed to delete %s", e));
        }
    }

    public static void copy(JavaFile src, JavaFile dst) throws CoreException, IOException {
        JavaFile.doCopyFile(src.file, dst.file);
    }

    private static void doCopyFile(File src, File dst) throws CoreException, IOException {
        if (!dst.exists()) {
            dst.createNewFile();
        }
        FileChannel source = null;
        AbstractInterruptibleChannel destination = null;
        try {
            source = new FileInputStream(src).getChannel();
            destination = new FileOutputStream(dst).getChannel();
            ((FileChannel)destination).transferFrom(source, 0L, source.size());
        }
        finally {
            if (source != null) {
                source.close();
            }
            if (destination != null) {
                destination.close();
            }
        }
        try {
            if (src.canExecute() && !dst.setExecutable(true, true)) {
                EclFilesystemPlugin.logWarning(String.format("Can't set executable permissions for %s", dst.getAbsolutePath()), null);
            }
        }
        catch (SecurityException e) {
            EclFilesystemPlugin.logWarning(String.format("Can't set executable permissions for %s", dst.getAbsolutePath()), e);
        }
    }

    private void copyStream(InputStream input, OutputStream output) throws CoreException, IOException {
        try {
            byte[] buffer = new byte[0x100000];
            while (true) {
                int count = input.read(buffer);
                assert (count != 0);
                if (count <= 0) break;
                output.write(buffer, 0, count);
            }
            return;
        }
        finally {
            input.close();
            output.close();
        }
    }

    @Override
    public void append(InputStream is) throws CoreException {
        this.mkdirs();
        try {
            FileOutputStream os = new FileOutputStream(this.file, true);
            this.copyStream(is, os);
        }
        catch (FileNotFoundException e) {
            throw new CoreException((IStatus)this.err("Failed to append %s", e));
        }
        catch (IOException e) {
            throw new CoreException((IStatus)this.err("Failed to append %s", e));
        }
    }

    @Override
    public void write(InputStream is) throws CoreException {
        this.mkdirs();
        try {
            FileOutputStream os = new FileOutputStream(this.file, false);
            this.copyStream(is, os);
        }
        catch (FileNotFoundException e) {
            throw new CoreException((IStatus)this.err("Failed to write %s", e));
        }
        catch (IOException e) {
            throw new CoreException((IStatus)this.err("Failed to write %s", e));
        }
    }

    private void mkdirs() throws CoreException {
        File parent = this.file.getParentFile();
        if (parent == null) {
            return;
        }
        parent.mkdirs();
    }

    @Override
    public InputStream read() throws CoreException {
        try {
            return new FileInputStream(this.file);
        }
        catch (FileNotFoundException e) {
            throw new CoreException((IStatus)this.err("Failed to read %s", e));
        }
    }

    private Status err(String message, Throwable e) {
        return new Status(4, "org.eclipse.rcptt.ecl.filesystem", String.format(message, this.toString()), e);
    }

    public String toString() {
        return this.file.toString();
    }

    @Override
    public File toFile() {
        return this.file;
    }
}

