/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ua.core.toc.text;

import org.eclipse.jface.text.IDocument;
import org.eclipse.pde.internal.core.text.IDocumentElementNode;
import org.eclipse.pde.internal.core.text.IDocumentNodeFactory;
import org.eclipse.pde.internal.core.text.NodeDocumentHandler;
import org.eclipse.pde.internal.ua.core.toc.text.TocMarkerManager;
import org.eclipse.pde.internal.ua.core.toc.text.TocModel;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class TocDocumentHandler
extends NodeDocumentHandler {
    private final TocModel fModel;

    public TocDocumentHandler(TocModel model, boolean reconciling) {
        super(reconciling, (IDocumentNodeFactory)model.getFactory());
        this.fModel = model;
    }

    protected IDocument getDocument() {
        return this.fModel.getDocument();
    }

    protected IDocumentElementNode getRootNode() {
        return this.fModel.getToc();
    }

    public void startDocument() throws SAXException {
        this.fModel.purgeErrors();
        super.startDocument();
    }

    public void endDocument() throws SAXException {
        super.endDocument();
        if (this.fModel.isMarkerRefreshNeeded()) {
            TocMarkerManager.refreshMarkers(this.fModel);
            this.fModel.setMarkerRefreshNeeded(false);
        }
    }

    public void error(SAXParseException e) throws SAXException {
        this.fModel.addError(e);
        super.error(e);
    }

    public void fatalError(SAXParseException e) throws SAXException {
        this.fModel.addError(e);
        super.fatalError(e);
        if (this.fModel.isMarkerRefreshNeeded()) {
            TocMarkerManager.refreshMarkers(this.fModel);
            this.fModel.setMarkerRefreshNeeded(false);
        }
    }
}

