/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.launching;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.rcptt.internal.launching.Q7LaunchingPlugin;
import org.eclipse.rcptt.launching.ILaunchExecutor;

public enum LaunchExecutor {
    INSTANCE;

    private Map<String, ILaunchExecutor> executors = LaunchExecutor.readExtensions();
    private static final String ATTR_CLASS = "class";
    private static final String ATTR_TYPE = "type";
    private static final String EXTPT_EXECUTORS = "org.eclipse.rcptt.launching.executors";

    public ILaunch launch(ILaunchConfiguration config, IProgressMonitor monitor) throws CoreException {
        return this.launch("run", config, monitor);
    }

    public ILaunch launch(String mode, ILaunchConfiguration config, IProgressMonitor monitor) throws CoreException {
        ILaunchExecutor executor = this.executors.get(config.getType().getIdentifier());
        if (executor != null) {
            return executor.launch(mode, config, monitor);
        }
        return config.launch(mode, monitor);
    }

    private static Map<String, ILaunchExecutor> readExtensions() {
        IConfigurationElement[] configs;
        HashMap<String, ILaunchExecutor> executors = new HashMap<String, ILaunchExecutor>();
        IConfigurationElement[] iConfigurationElementArray = configs = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTPT_EXECUTORS);
        int n = configs.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement config = iConfigurationElementArray[n2];
            try {
                ILaunchExecutor executor = (ILaunchExecutor)config.createExecutableExtension(ATTR_CLASS);
                String type = config.getAttribute(ATTR_TYPE);
                executors.put(type, executor);
            }
            catch (Exception e) {
                StringBuilder builder = new StringBuilder();
                builder.append("Problem while loading '");
                builder.append(EXTPT_EXECUTORS);
                builder.append("' extension");
                try {
                    String plugin = config.getNamespaceIdentifier();
                    builder.append(" from the '");
                    builder.append(plugin);
                    builder.append("' plugin");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                builder.append(": ");
                builder.append(e.getMessage());
                Q7LaunchingPlugin.log(builder.toString(), e);
            }
            ++n2;
        }
        return executors;
    }
}

