/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ecl.data.internal.commands;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.rcptt.ecl.core.Command;
import org.eclipse.rcptt.ecl.data.commands.ExcludeRows;
import org.eclipse.rcptt.ecl.data.commands.RowMatchMode;
import org.eclipse.rcptt.ecl.data.internal.EclDataPlugin;
import org.eclipse.rcptt.ecl.data.internal.commands.TableRowMatcher;
import org.eclipse.rcptt.ecl.data.objects.ObjectsFactory;
import org.eclipse.rcptt.ecl.data.objects.Row;
import org.eclipse.rcptt.ecl.data.objects.Table;
import org.eclipse.rcptt.ecl.runtime.ICommandService;
import org.eclipse.rcptt.ecl.runtime.IProcess;

public class ExcludeRowsService
extends TableRowMatcher
implements ICommandService {
    public IStatus service(Command command, IProcess context) throws InterruptedException, CoreException {
        if (!(command instanceof ExcludeRows)) {
            return Status.CANCEL_STATUS;
        }
        ExcludeRows ec = (ExcludeRows)command;
        Table source = ec.getTable();
        EList<String> srcColumns = source.getColumns();
        String filterColumn = ec.getColumn();
        if (filterColumn == null) {
            return EclDataPlugin.createErr("Failed to filter table. column argument is not specified.", new Object[0]);
        }
        int columnIndex = srcColumns.indexOf(filterColumn);
        RowMatchMode match = ec.getMatch();
        String value = ec.getValue();
        if (value == null) {
            return EclDataPlugin.createErr("Failed to filter table. Pattern value is not specified.", new Object[0]);
        }
        TableRowMatcher.IMatcher matcher = this.createMatcher(match, value);
        Table result = ObjectsFactory.eINSTANCE.createTable();
        result.getColumns().addAll(source.getColumns());
        if (columnIndex == -1) {
            context.getOutput().write((Object)result);
            return Status.OK_STATUS;
        }
        for (Row row : source.getRows()) {
            String columnValue = (String)row.getValues().get(columnIndex);
            if (matcher.match(columnValue)) continue;
            result.getRows().add((Object)((Row)EcoreUtil.copy((EObject)row)));
        }
        context.getOutput().write((Object)result);
        return Status.OK_STATUS;
    }
}

