/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.core.refactoring;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IModuleDescription;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.debug.core.JDIDebugPlugin;
import org.eclipse.jdt.internal.debug.core.refactoring.LaunchConfigurationProjectMainTypeChange;
import org.eclipse.jdt.internal.debug.core.refactoring.RefactoringMessages;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;

public class JDTDebugRefactoringUtil {
    public static Change createChangeFromList(List<Change> changes, String changeLabel) {
        int nbChanges = changes.size();
        switch (nbChanges) {
            case 0: {
                return null;
            }
            case 1: {
                return changes.get(0);
            }
        }
        return new CompositeChange(changeLabel, changes.toArray(new Change[changes.size()]));
    }

    protected static String computeNewContainerName(ILaunchConfiguration launchConfiguration) {
        IFile file = launchConfiguration.getFile();
        if (file != null) {
            return file.getParent().getProjectRelativePath().toString();
        }
        return null;
    }

    protected static Change createChangesForOuterTypeChange(ILaunchConfiguration config, IType type, String newfqname, String pname) throws CoreException {
        IType[] innerTypes = type.getTypes();
        if (innerTypes.length == 0) {
            return null;
        }
        Change change = null;
        String mtname = config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, null);
        int i = 0;
        while (i < innerTypes.length) {
            String newTypeName = newfqname + "$" + innerTypes[i].getElementName();
            if (innerTypes[i].getFullyQualifiedName().equals(mtname)) {
                return new LaunchConfigurationProjectMainTypeChange(config, newTypeName, pname);
            }
            change = JDTDebugRefactoringUtil.createChangesForOuterTypeChange(config, innerTypes[i], newTypeName, pname);
            ++i;
        }
        return change;
    }

    public static Change createChangesForPackageMove(IPackageFragment pfragment, IPackageFragmentRoot destination) throws CoreException {
        ArrayList<Change> changes = new ArrayList<Change>();
        ILaunchConfiguration[] configs = JDTDebugRefactoringUtil.getJavaTypeLaunchConfigurations(pfragment.getJavaProject().getElementName());
        String mtname = null;
        int i = 0;
        while (i < configs.length) {
            mtname = configs[i].getAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, null);
            if (mtname != null && mtname.lastIndexOf(pfragment.getElementName()) > -1) {
                changes.add(new LaunchConfigurationProjectMainTypeChange(configs[i], null, destination.getJavaProject().getElementName()));
            }
            ++i;
        }
        return JDTDebugRefactoringUtil.createChangeFromList(changes, RefactoringMessages.LaunchConfigurationProjectMainTypeChange_7);
    }

    public static Change createChangesForPackageRename(IPackageFragment pfragment, String newname) throws CoreException {
        ArrayList<Change> changes = new ArrayList<Change>();
        ILaunchConfiguration[] configs = JDTDebugRefactoringUtil.getJavaTypeLaunchConfigurations(pfragment.getJavaProject().getElementName());
        int i = 0;
        while (i < configs.length) {
            String mtname = configs[i].getAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, null);
            if (mtname != null) {
                String pkname = "";
                int index = mtname.lastIndexOf(46);
                if (index > 0) {
                    pkname = mtname.substring(0, index);
                }
                if (pfragment.getElementName().equals(pkname)) {
                    String ntname = newname + "." + mtname.substring(index + 1);
                    changes.add(new LaunchConfigurationProjectMainTypeChange(configs[i], ntname, null));
                }
            } else {
                changes.add(new LaunchConfigurationProjectMainTypeChange(configs[i], null, null));
            }
            ++i;
        }
        return JDTDebugRefactoringUtil.createChangeFromList(changes, RefactoringMessages.LaunchConfigurationProjectMainTypeChange_7);
    }

    public static Change createChangesForProjectRename(IJavaProject project, String newname) throws CoreException {
        ArrayList<Change> changes = new ArrayList<Change>();
        ILaunchConfiguration[] configs = JDTDebugRefactoringUtil.getJavaTypeLaunchConfigurations(project.getElementName());
        LaunchConfigurationProjectMainTypeChange change = null;
        int i = 0;
        while (i < configs.length) {
            change = new LaunchConfigurationProjectMainTypeChange(configs[i], null, newname);
            String newcname = JDTDebugRefactoringUtil.computeNewContainerName(configs[i]);
            if (newcname != null) {
                change.setNewContainerName(newcname);
            }
            changes.add(change);
            ++i;
        }
        return JDTDebugRefactoringUtil.createChangeFromList(changes, RefactoringMessages.LaunchConfigurationProjectMainTypeChange_7);
    }

    public static Change createChangesForModuleRename(IModuleDescription module, String newname) throws CoreException {
        ArrayList<Change> changes = new ArrayList<Change>();
        ILaunchConfiguration[] configs = JDTDebugRefactoringUtil.getJavaTypeLaunchConfigurationsForModule(module.getElementName());
        LaunchConfigurationProjectMainTypeChange change = null;
        int i = 0;
        while (i < configs.length) {
            change = new LaunchConfigurationProjectMainTypeChange(configs[i], null, newname);
            String newcname = JDTDebugRefactoringUtil.computeNewContainerName(configs[i]);
            if (newcname != null) {
                change.setNewContainerName(newcname);
            }
            changes.add(change);
            ++i;
        }
        return JDTDebugRefactoringUtil.createChangeFromList(changes, RefactoringMessages.LaunchConfigurationProjectMainTypeChange_7);
    }

    protected static Change createChangesForTypeChange(IType type, String newfqname, String pname) throws CoreException {
        ArrayList<Change> changes = new ArrayList<Change>();
        String typename = type.getFullyQualifiedName();
        ILaunchConfiguration[] configs = JDTDebugRefactoringUtil.getJavaTypeLaunchConfigurations(type.getJavaProject().getElementName());
        int i = 0;
        while (i < configs.length) {
            String mtname = configs[i].getAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, null);
            if (typename.equals(mtname)) {
                changes.add(new LaunchConfigurationProjectMainTypeChange(configs[i], newfqname, pname));
            } else {
                Change change = JDTDebugRefactoringUtil.createChangesForOuterTypeChange(configs[i], type, newfqname, pname);
                if (change != null) {
                    changes.add(change);
                }
            }
            ++i;
        }
        return JDTDebugRefactoringUtil.createChangeFromList(changes, RefactoringMessages.LaunchConfigurationProjectMainTypeChange_7);
    }

    public static Change createChangesForTypeMove(IType type, IJavaElement destination) throws CoreException {
        IJavaProject pdestination = destination.getJavaProject();
        String newpname = null;
        if (!type.getJavaProject().equals(pdestination)) {
            newpname = pdestination.getElementName();
        }
        Object newfqname = type.getElementName();
        if (destination instanceof IType) {
            newfqname = ((IType)destination).getFullyQualifiedName() + "$" + type.getElementName();
        } else if (destination instanceof IPackageFragment && !((IPackageFragment)destination).isDefaultPackage()) {
            newfqname = destination.getElementName() + "." + type.getElementName();
        }
        return JDTDebugRefactoringUtil.createChangesForTypeChange(type, (String)newfqname, newpname);
    }

    public static Change createChangesForTypeRename(IType type, String newname) throws CoreException {
        IType dtype = type.getDeclaringType();
        Object newfqname = newname;
        if (dtype == null) {
            IPackageFragment packageFragment = type.getPackageFragment();
            if (!packageFragment.isDefaultPackage()) {
                newfqname = packageFragment.getElementName() + "." + newname;
            }
        } else {
            newfqname = dtype.getFullyQualifiedName() + "$" + newname;
        }
        return JDTDebugRefactoringUtil.createChangesForTypeChange(type, (String)newfqname, null);
    }

    protected static ILaunchConfiguration[] getJavaTypeLaunchConfigurations(String pname) {
        try {
            ILaunchConfiguration[] configs = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations();
            ArrayList<ILaunchConfiguration> list = new ArrayList<ILaunchConfiguration>();
            int i = 0;
            while (i < configs.length) {
                String attrib = configs[i].getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, null);
                if (attrib != null && attrib.equals(pname)) {
                    list.add(configs[i]);
                }
                ++i;
            }
            return list.toArray(new ILaunchConfiguration[list.size()]);
        }
        catch (CoreException e) {
            JDIDebugPlugin.log((Throwable)e);
            return new ILaunchConfiguration[0];
        }
    }

    protected static ILaunchConfiguration[] getJavaTypeLaunchConfigurationsForModule(String pname) {
        try {
            ILaunchConfiguration[] configs = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations();
            ArrayList<ILaunchConfiguration> list = new ArrayList<ILaunchConfiguration>();
            int i = 0;
            while (i < configs.length) {
                String attrib = configs[i].getAttribute(IJavaLaunchConfigurationConstants.ATTR_MODULE_NAME, null);
                if (attrib != null && attrib.equals(pname)) {
                    list.add(configs[i]);
                }
                ++i;
            }
            return list.toArray(new ILaunchConfiguration[list.size()]);
        }
        catch (CoreException e) {
            JDIDebugPlugin.log((Throwable)e);
            return new ILaunchConfiguration[0];
        }
    }
}

