/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.dom;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AnnotatableType;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeMemberDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.ArrayAccess;
import org.eclipse.jdt.core.dom.ArrayCreation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.AssertStatement;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BlockComment;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.BooleanLiteral;
import org.eclipse.jdt.core.dom.BreakStatement;
import org.eclipse.jdt.core.dom.CaseDefaultExpression;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.CharacterLiteral;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConditionalExpression;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.ContinueStatement;
import org.eclipse.jdt.core.dom.CreationReference;
import org.eclipse.jdt.core.dom.Dimension;
import org.eclipse.jdt.core.dom.DoStatement;
import org.eclipse.jdt.core.dom.EmptyStatement;
import org.eclipse.jdt.core.dom.EnhancedForStatement;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.ExportsDirective;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionMethodReference;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.GuardedPattern;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.InstanceofExpression;
import org.eclipse.jdt.core.dom.IntersectionType;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.LabeledStatement;
import org.eclipse.jdt.core.dom.LambdaExpression;
import org.eclipse.jdt.core.dom.LineComment;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MemberRef;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.MethodRef;
import org.eclipse.jdt.core.dom.MethodRefParameter;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.ModuleDeclaration;
import org.eclipse.jdt.core.dom.ModuleDirective;
import org.eclipse.jdt.core.dom.ModuleModifier;
import org.eclipse.jdt.core.dom.ModulePackageAccess;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NameQualifiedType;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.NullLiteral;
import org.eclipse.jdt.core.dom.NullPattern;
import org.eclipse.jdt.core.dom.NumberLiteral;
import org.eclipse.jdt.core.dom.OpensDirective;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.PatternInstanceofExpression;
import org.eclipse.jdt.core.dom.PostfixExpression;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.ProvidesDirective;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.QualifiedType;
import org.eclipse.jdt.core.dom.RecordDeclaration;
import org.eclipse.jdt.core.dom.RequiresDirective;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperFieldAccess;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.SuperMethodReference;
import org.eclipse.jdt.core.dom.SwitchCase;
import org.eclipse.jdt.core.dom.SwitchExpression;
import org.eclipse.jdt.core.dom.SwitchStatement;
import org.eclipse.jdt.core.dom.SynchronizedStatement;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.TextBlock;
import org.eclipse.jdt.core.dom.TextElement;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.ThrowStatement;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclarationStatement;
import org.eclipse.jdt.core.dom.TypeLiteral;
import org.eclipse.jdt.core.dom.TypeMethodReference;
import org.eclipse.jdt.core.dom.TypeParameter;
import org.eclipse.jdt.core.dom.TypePattern;
import org.eclipse.jdt.core.dom.UnionType;
import org.eclipse.jdt.core.dom.UsesDirective;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.WhileStatement;
import org.eclipse.jdt.core.dom.WildcardType;
import org.eclipse.jdt.core.dom.YieldStatement;
import org.eclipse.jdt.internal.corext.dom.GenericVisitor;
import org.eclipse.jdt.internal.corext.dom.IASTSharedValues;
import org.eclipse.jdt.internal.ui.util.ASTHelper;

public class ASTFlattener
extends GenericVisitor {
    protected StringBuffer fBuffer = new StringBuffer();

    public String getResult() {
        return this.fBuffer.toString();
    }

    public void reset() {
        this.fBuffer.setLength(0);
    }

    public static String asString(ASTNode node) {
        Assert.isTrue((node.getAST().apiLevel() == IASTSharedValues.SHARED_AST_LEVEL ? 1 : 0) != 0);
        ASTFlattener flattener = new ASTFlattener();
        node.accept((ASTVisitor)flattener);
        return flattener.getResult();
    }

    @Override
    protected boolean visitNode(ASTNode node) {
        Assert.isTrue((boolean)false, (String)("No implementation to flatten node: " + node.toString()));
        return false;
    }

    private void printModifiers(List<IExtendedModifier> ext) {
        for (IExtendedModifier iExtendedModifier : ext) {
            ASTNode p = (ASTNode)iExtendedModifier;
            p.accept((ASTVisitor)this);
            this.fBuffer.append(" ");
        }
    }

    private void printTypes(List<Type> types, String prefix) {
        if (types.size() > 0) {
            this.fBuffer.append(" " + prefix + " ");
            Type type = types.get(0);
            type.accept((ASTVisitor)this);
            int i = 1;
            int l = types.size();
            while (i < l) {
                this.fBuffer.append(",");
                type = types.get(0);
                type.accept((ASTVisitor)this);
                ++i;
            }
        }
    }

    private void printReferenceTypeArguments(List<Type> typeArguments) {
        this.fBuffer.append("::");
        if (!typeArguments.isEmpty()) {
            this.fBuffer.append('<');
            Iterator<Type> it = typeArguments.iterator();
            while (it.hasNext()) {
                Type t = it.next();
                t.accept((ASTVisitor)this);
                if (!it.hasNext()) continue;
                this.fBuffer.append(',');
            }
            this.fBuffer.append('>');
        }
    }

    void printTypeAnnotations(AnnotatableType node) {
        if (node.getAST().apiLevel() >= 8) {
            this.printAnnotationsList(node.annotations());
        }
    }

    void printAnnotationsList(List<? extends Annotation> annotations) {
        for (Annotation annotation : annotations) {
            annotation.accept((ASTVisitor)this);
            this.fBuffer.append(' ');
        }
    }

    @Deprecated
    private static Type getComponentType(ArrayType node) {
        return node.getComponentType();
    }

    @Deprecated
    private static List<Name> getThrownExceptions(MethodDeclaration node) {
        return node.thrownExceptions();
    }

    @Override
    public boolean visit(AnnotationTypeDeclaration node) {
        if (node.getJavadoc() != null) {
            node.getJavadoc().accept((ASTVisitor)this);
        }
        this.printModifiers(node.modifiers());
        this.fBuffer.append("@interface ");
        node.getName().accept((ASTVisitor)this);
        this.fBuffer.append(" {");
        for (BodyDeclaration d : node.bodyDeclarations()) {
            d.accept((ASTVisitor)this);
        }
        this.fBuffer.append("}");
        return false;
    }

    @Override
    public boolean visit(AnnotationTypeMemberDeclaration node) {
        if (node.getJavadoc() != null) {
            node.getJavadoc().accept((ASTVisitor)this);
        }
        this.printModifiers(node.modifiers());
        node.getType().accept((ASTVisitor)this);
        this.fBuffer.append(" ");
        node.getName().accept((ASTVisitor)this);
        this.fBuffer.append("()");
        if (node.getDefault() != null) {
            this.fBuffer.append(" default ");
            node.getDefault().accept((ASTVisitor)this);
        }
        this.fBuffer.append(";");
        return false;
    }

    @Override
    public boolean visit(AnonymousClassDeclaration node) {
        this.fBuffer.append("{");
        List bodyDeclarations = node.bodyDeclarations();
        for (BodyDeclaration b : bodyDeclarations) {
            b.accept((ASTVisitor)this);
        }
        this.fBuffer.append("}");
        return false;
    }

    @Override
    public boolean visit(ArrayAccess node) {
        node.getArray().accept((ASTVisitor)this);
        this.fBuffer.append("[");
        node.getIndex().accept((ASTVisitor)this);
        this.fBuffer.append("]");
        return false;
    }

    @Override
    public boolean visit(ArrayCreation node) {
        this.fBuffer.append("new ");
        ArrayType at = node.getType();
        int dims = at.getDimensions();
        Type elementType = at.getElementType();
        elementType.accept((ASTVisitor)this);
        Iterator it = node.dimensions().iterator();
        while (it.hasNext()) {
            this.fBuffer.append("[");
            Expression e = (Expression)it.next();
            e.accept((ASTVisitor)this);
            this.fBuffer.append("]");
            --dims;
        }
        int i = 0;
        while (i < dims) {
            this.fBuffer.append("[]");
            ++i;
        }
        if (node.getInitializer() != null) {
            node.getInitializer().accept((ASTVisitor)this);
        }
        return false;
    }

    @Override
    public boolean visit(ArrayInitializer node) {
        this.fBuffer.append("{");
        Iterator it = node.expressions().iterator();
        while (it.hasNext()) {
            Expression e = (Expression)it.next();
            e.accept((ASTVisitor)this);
            if (!it.hasNext()) continue;
            this.fBuffer.append(",");
        }
        this.fBuffer.append("}");
        return false;
    }

    @Override
    public boolean visit(ArrayType node) {
        if (node.getAST().apiLevel() < 8) {
            ASTFlattener.getComponentType(node).accept((ASTVisitor)this);
            this.fBuffer.append("[]");
        } else {
            node.getElementType().accept((ASTVisitor)this);
            List dimensions = node.dimensions();
            for (Dimension dimension : dimensions) {
                dimension.accept((ASTVisitor)this);
            }
        }
        return false;
    }

    @Override
    public boolean visit(AssertStatement node) {
        this.fBuffer.append("assert ");
        node.getExpression().accept((ASTVisitor)this);
        if (node.getMessage() != null) {
            this.fBuffer.append(" : ");
            node.getMessage().accept((ASTVisitor)this);
        }
        this.fBuffer.append(";");
        return false;
    }

    @Override
    public boolean visit(Assignment node) {
        node.getLeftHandSide().accept((ASTVisitor)this);
        this.fBuffer.append(node.getOperator().toString());
        node.getRightHandSide().accept((ASTVisitor)this);
        return false;
    }

    @Override
    public boolean visit(Block node) {
        this.fBuffer.append("{");
        for (Statement s : node.statements()) {
            s.accept((ASTVisitor)this);
        }
        this.fBuffer.append("}");
        return false;
    }

    @Override
    public boolean visit(BlockComment node) {
        this.fBuffer.append("/* */");
        return false;
    }

    @Override
    public boolean visit(BooleanLiteral node) {
        if (node.booleanValue()) {
            this.fBuffer.append("true");
        } else {
            this.fBuffer.append("false");
        }
        return false;
    }

    @Override
    public boolean visit(BreakStatement node) {
        this.fBuffer.append("break");
        if (node.getLabel() != null) {
            this.fBuffer.append(" ");
            node.getLabel().accept((ASTVisitor)this);
        }
        this.fBuffer.append(";");
        return false;
    }

    public boolean visit(CaseDefaultExpression node) {
        if (ASTHelper.isPatternSupported(node.getAST())) {
            this.fBuffer.append("default");
        }
        return false;
    }

    @Override
    public boolean visit(CastExpression node) {
        this.fBuffer.append("(");
        node.getType().accept((ASTVisitor)this);
        this.fBuffer.append(")");
        node.getExpression().accept((ASTVisitor)this);
        return false;
    }

    @Override
    public boolean visit(CatchClause node) {
        this.fBuffer.append("catch (");
        node.getException().accept((ASTVisitor)this);
        this.fBuffer.append(") ");
        node.getBody().accept((ASTVisitor)this);
        return false;
    }

    @Override
    public boolean visit(CharacterLiteral node) {
        this.fBuffer.append(node.getEscapedValue());
        return false;
    }

    @Override
    public boolean visit(ClassInstanceCreation node) {
        Iterator it;
        if (node.getExpression() != null) {
            node.getExpression().accept((ASTVisitor)this);
            this.fBuffer.append(".");
        }
        this.fBuffer.append("new ");
        if (node.getAST().apiLevel() >= 3) {
            if (!node.typeArguments().isEmpty()) {
                this.fBuffer.append("<");
                it = node.typeArguments().iterator();
                while (it.hasNext()) {
                    Type t = (Type)it.next();
                    t.accept((ASTVisitor)this);
                    if (!it.hasNext()) continue;
                    this.fBuffer.append(",");
                }
                this.fBuffer.append(">");
            }
            node.getType().accept((ASTVisitor)this);
        }
        this.fBuffer.append("(");
        it = node.arguments().iterator();
        while (it.hasNext()) {
            Expression e = (Expression)it.next();
            e.accept((ASTVisitor)this);
            if (!it.hasNext()) continue;
            this.fBuffer.append(",");
        }
        this.fBuffer.append(")");
        if (node.getAnonymousClassDeclaration() != null) {
            node.getAnonymousClassDeclaration().accept((ASTVisitor)this);
        }
        return false;
    }

    @Override
    public boolean visit(CompilationUnit node) {
        if (node.getAST().apiLevel() >= 9 && node.getModule() != null) {
            node.getModule().accept((ASTVisitor)this);
        }
        if (node.getPackage() != null) {
            node.getPackage().accept((ASTVisitor)this);
        }
        for (ImportDeclaration d : node.imports()) {
            d.accept((ASTVisitor)this);
        }
        for (ImportDeclaration d : node.types()) {
            d.accept((ASTVisitor)this);
        }
        return false;
    }

    @Override
    public boolean visit(ConditionalExpression node) {
        node.getExpression().accept((ASTVisitor)this);
        this.fBuffer.append("?");
        node.getThenExpression().accept((ASTVisitor)this);
        this.fBuffer.append(":");
        node.getElseExpression().accept((ASTVisitor)this);
        return false;
    }

    @Override
    public boolean visit(ConstructorInvocation node) {
        Iterator it;
        if (node.getAST().apiLevel() >= 3 && !node.typeArguments().isEmpty()) {
            this.fBuffer.append("<");
            it = node.typeArguments().iterator();
            while (it.hasNext()) {
                Type t = (Type)it.next();
                t.accept((ASTVisitor)this);
                if (!it.hasNext()) continue;
                this.fBuffer.append(",");
            }
            this.fBuffer.append(">");
        }
        this.fBuffer.append("this(");
        it = node.arguments().iterator();
        while (it.hasNext()) {
            Expression e = (Expression)it.next();
            e.accept((ASTVisitor)this);
            if (!it.hasNext()) continue;
            this.fBuffer.append(",");
        }
        this.fBuffer.append(");");
        return false;
    }

    @Override
    public boolean visit(ContinueStatement node) {
        this.fBuffer.append("continue");
        if (node.getLabel() != null) {
            this.fBuffer.append(" ");
            node.getLabel().accept((ASTVisitor)this);
        }
        this.fBuffer.append(";");
        return false;
    }

    @Override
    public boolean visit(CreationReference node) {
        node.getType().accept((ASTVisitor)this);
        this.printReferenceTypeArguments(node.typeArguments());
        this.fBuffer.append("new");
        return false;
    }

    @Override
    public boolean visit(Dimension node) {
        this.fBuffer.append(" ");
        this.printAnnotationsList(node.annotations());
        this.fBuffer.append("[]");
        return false;
    }

    @Override
    public boolean visit(DoStatement node) {
        this.fBuffer.append("do ");
        node.getBody().accept((ASTVisitor)this);
        this.fBuffer.append(" while (");
        node.getExpression().accept((ASTVisitor)this);
        this.fBuffer.append(");");
        return false;
    }

    @Override
    public boolean visit(EmptyStatement node) {
        this.fBuffer.append(";");
        return false;
    }

    @Override
    public boolean visit(EnhancedForStatement node) {
        this.fBuffer.append("for (");
        node.getParameter().accept((ASTVisitor)this);
        this.fBuffer.append(" : ");
        node.getExpression().accept((ASTVisitor)this);
        this.fBuffer.append(") ");
        node.getBody().accept((ASTVisitor)this);
        return false;
    }

    @Override
    public boolean visit(EnumConstantDeclaration node) {
        if (node.getJavadoc() != null) {
            node.getJavadoc().accept((ASTVisitor)this);
        }
        this.printModifiers(node.modifiers());
        node.getName().accept((ASTVisitor)this);
        if (!node.arguments().isEmpty()) {
            this.fBuffer.append("(");
            Iterator it = node.arguments().iterator();
            while (it.hasNext()) {
                Expression e = (Expression)it.next();
                e.accept((ASTVisitor)this);
                if (!it.hasNext()) continue;
                this.fBuffer.append(",");
            }
            this.fBuffer.append(")");
        }
        if (node.getAnonymousClassDeclaration() != null) {
            node.getAnonymousClassDeclaration().accept((ASTVisitor)this);
        }
        return false;
    }

    @Override
    public boolean visit(EnumDeclaration node) {
        Iterator it;
        if (node.getJavadoc() != null) {
            node.getJavadoc().accept((ASTVisitor)this);
        }
        this.printModifiers(node.modifiers());
        this.fBuffer.append("enum ");
        node.getName().accept((ASTVisitor)this);
        this.fBuffer.append(" ");
        if (!node.superInterfaceTypes().isEmpty()) {
            this.fBuffer.append("implements ");
            it = node.superInterfaceTypes().iterator();
            while (it.hasNext()) {
                Type t = (Type)it.next();
                t.accept((ASTVisitor)this);
                if (!it.hasNext()) continue;
                this.fBuffer.append(", ");
            }
            this.fBuffer.append(" ");
        }
        this.fBuffer.append("{");
        it = node.enumConstants().iterator();
        while (it.hasNext()) {
            EnumConstantDeclaration d = (EnumConstantDeclaration)it.next();
            d.accept((ASTVisitor)this);
            if (!it.hasNext()) continue;
            this.fBuffer.append(", ");
        }
        if (!node.bodyDeclarations().isEmpty()) {
            this.fBuffer.append("; ");
            for (EnumConstantDeclaration d : node.bodyDeclarations()) {
                d.accept((ASTVisitor)this);
            }
        }
        this.fBuffer.append("}");
        return false;
    }

    @Override
    public boolean visit(ExportsDirective node) {
        return this.visit((ModulePackageAccess)node, "exports");
    }

    @Override
    public boolean visit(ExpressionMethodReference node) {
        node.getExpression().accept((ASTVisitor)this);
        this.printReferenceTypeArguments(node.typeArguments());
        node.getName().accept((ASTVisitor)this);
        return false;
    }

    @Override
    public boolean visit(ExpressionStatement node) {
        node.getExpression().accept((ASTVisitor)this);
        this.fBuffer.append(";");
        return false;
    }

    @Override
    public boolean visit(FieldAccess node) {
        node.getExpression().accept((ASTVisitor)this);
        this.fBuffer.append(".");
        node.getName().accept((ASTVisitor)this);
        return false;
    }

    @Override
    public boolean visit(FieldDeclaration node) {
        if (node.getJavadoc() != null) {
            node.getJavadoc().accept((ASTVisitor)this);
        }
        if (node.getAST().apiLevel() >= 3) {
            this.printModifiers(node.modifiers());
        }
        node.getType().accept((ASTVisitor)this);
        this.fBuffer.append(" ");
        Iterator it = node.fragments().iterator();
        while (it.hasNext()) {
            VariableDeclarationFragment f = (VariableDeclarationFragment)it.next();
            f.accept((ASTVisitor)this);
            if (!it.hasNext()) continue;
            this.fBuffer.append(", ");
        }
        this.fBuffer.append(";");
        return false;
    }

    @Override
    public boolean visit(ForStatement node) {
        this.fBuffer.append("for (");
        for (Expression e : node.initializers()) {
            e.accept((ASTVisitor)this);
        }
        this.fBuffer.append("; ");
        if (node.getExpression() != null) {
            node.getExpression().accept((ASTVisitor)this);
        }
        this.fBuffer.append("; ");
        for (Expression e : node.updaters()) {
            e.accept((ASTVisitor)this);
        }
        this.fBuffer.append(") ");
        node.getBody().accept((ASTVisitor)this);
        return false;
    }

    public boolean visit(GuardedPattern node) {
        if (ASTHelper.isPatternSupported(node.getAST())) {
            node.getPattern().accept((ASTVisitor)this);
            this.fBuffer.append(" && ");
            node.getExpression().accept((ASTVisitor)this);
        }
        return false;
    }

    @Override
    public boolean visit(IfStatement node) {
        this.fBuffer.append("if (");
        node.getExpression().accept((ASTVisitor)this);
        this.fBuffer.append(") ");
        node.getThenStatement().accept((ASTVisitor)this);
        if (node.getElseStatement() != null) {
            this.fBuffer.append(" else ");
            node.getElseStatement().accept((ASTVisitor)this);
        }
        return false;
    }

    @Override
    public boolean visit(ImportDeclaration node) {
        this.fBuffer.append("import ");
        if (node.getAST().apiLevel() >= 3 && node.isStatic()) {
            this.fBuffer.append("static ");
        }
        node.getName().accept((ASTVisitor)this);
        if (node.isOnDemand()) {
            this.fBuffer.append(".*");
        }
        this.fBuffer.append(";");
        return false;
    }

    @Override
    public boolean visit(InfixExpression node) {
        node.getLeftOperand().accept((ASTVisitor)this);
        this.fBuffer.append(' ');
        this.fBuffer.append(node.getOperator().toString());
        this.fBuffer.append(' ');
        node.getRightOperand().accept((ASTVisitor)this);
        List extendedOperands = node.extendedOperands();
        if (!extendedOperands.isEmpty()) {
            this.fBuffer.append(' ');
            for (Expression e : extendedOperands) {
                this.fBuffer.append(node.getOperator().toString()).append(' ');
                e.accept((ASTVisitor)this);
            }
        }
        return false;
    }

    @Override
    public boolean visit(Initializer node) {
        if (node.getJavadoc() != null) {
            node.getJavadoc().accept((ASTVisitor)this);
        }
        if (node.getAST().apiLevel() >= 3) {
            this.printModifiers(node.modifiers());
        }
        node.getBody().accept((ASTVisitor)this);
        return false;
    }

    @Override
    public boolean visit(InstanceofExpression node) {
        node.getLeftOperand().accept((ASTVisitor)this);
        this.fBuffer.append(" instanceof ");
        node.getRightOperand().accept((ASTVisitor)this);
        return false;
    }

    public boolean visit(PatternInstanceofExpression node) {
        node.getLeftOperand().accept((ASTVisitor)this);
        this.fBuffer.append(" instanceof ");
        node.getRightOperand().accept((ASTVisitor)this);
        return false;
    }

    @Override
    public boolean visit(IntersectionType node) {
        Iterator it = node.types().iterator();
        while (it.hasNext()) {
            Type t = (Type)it.next();
            t.accept((ASTVisitor)this);
            if (!it.hasNext()) continue;
            this.fBuffer.append(" & ");
        }
        return false;
    }

    @Override
    public boolean visit(Javadoc node) {
        this.fBuffer.append("/** ");
        for (ASTNode e : node.tags()) {
            e.accept((ASTVisitor)this);
        }
        this.fBuffer.append("\n */");
        return false;
    }

    @Override
    public boolean visit(LabeledStatement node) {
        node.getLabel().accept((ASTVisitor)this);
        this.fBuffer.append(": ");
        node.getBody().accept((ASTVisitor)this);
        return false;
    }

    @Override
    public boolean visit(LambdaExpression node) {
        boolean hasParentheses = node.hasParentheses();
        if (hasParentheses) {
            this.fBuffer.append('(');
        }
        Iterator it = node.parameters().iterator();
        while (it.hasNext()) {
            VariableDeclaration v = (VariableDeclaration)it.next();
            v.accept((ASTVisitor)this);
            if (!it.hasNext()) continue;
            this.fBuffer.append(",");
        }
        if (hasParentheses) {
            this.fBuffer.append(')');
        }
        this.fBuffer.append(" -> ");
        node.getBody().accept((ASTVisitor)this);
        return false;
    }

    @Override
    public boolean visit(LineComment node) {
        this.fBuffer.append("//\n");
        return false;
    }

    @Override
    public boolean visit(MarkerAnnotation node) {
        this.fBuffer.append("@");
        node.getTypeName().accept((ASTVisitor)this);
        return false;
    }

    @Override
    public boolean visit(MemberRef node) {
        if (node.getQualifier() != null) {
            node.getQualifier().accept((ASTVisitor)this);
        }
        this.fBuffer.append("#");
        node.getName().accept((ASTVisitor)this);
        return false;
    }

    @Override
    public boolean visit(MemberValuePair node) {
        node.getName().accept((ASTVisitor)this);
        this.fBuffer.append("=");
        node.getValue().accept((ASTVisitor)this);
        return false;
    }

    @Override
    public boolean visit(MethodRef node) {
        if (node.getQualifier() != null) {
            node.getQualifier().accept((ASTVisitor)this);
        }
        this.fBuffer.append("#");
        node.getName().accept((ASTVisitor)this);
        this.fBuffer.append("(");
        Iterator it = node.parameters().iterator();
        while (it.hasNext()) {
            MethodRefParameter e = (MethodRefParameter)it.next();
            e.accept((ASTVisitor)this);
            if (!it.hasNext()) continue;
            this.fBuffer.append(",");
        }
        this.fBuffer.append(")");
        return false;
    }

    @Override
    public boolean visit(MethodRefParameter node) {
        node.getType().accept((ASTVisitor)this);
        if (node.getAST().apiLevel() >= 3 && node.isVarargs()) {
            this.fBuffer.append("...");
        }
        if (node.getName() != null) {
            this.fBuffer.append(" ");
            node.getName().accept((ASTVisitor)this);
        }
        return false;
    }

    @Override
    public boolean visit(MethodDeclaration node) {
        List<Name> thrownExceptions;
        Type receiverType;
        Iterator it;
        if (node.getJavadoc() != null) {
            node.getJavadoc().accept((ASTVisitor)this);
        }
        if (node.getAST().apiLevel() >= 3) {
            this.printModifiers(node.modifiers());
            if (!node.typeParameters().isEmpty()) {
                this.fBuffer.append("<");
                it = node.typeParameters().iterator();
                while (it.hasNext()) {
                    TypeParameter t = (TypeParameter)it.next();
                    t.accept((ASTVisitor)this);
                    if (!it.hasNext()) continue;
                    this.fBuffer.append(", ");
                }
                this.fBuffer.append("> ");
            }
        }
        if (!node.isConstructor()) {
            if (node.getReturnType2() != null) {
                node.getReturnType2().accept((ASTVisitor)this);
            } else {
                this.fBuffer.append("void");
            }
            this.fBuffer.append(" ");
        }
        node.getName().accept((ASTVisitor)this);
        this.fBuffer.append("(");
        if (node.getAST().apiLevel() >= 8 && (receiverType = node.getReceiverType()) != null) {
            receiverType.accept((ASTVisitor)this);
            this.fBuffer.append(' ');
            SimpleName qualifier = node.getReceiverQualifier();
            if (qualifier != null) {
                qualifier.accept((ASTVisitor)this);
                this.fBuffer.append('.');
            }
            this.fBuffer.append("this");
            if (node.parameters().size() > 0) {
                this.fBuffer.append(',');
            }
        }
        it = node.parameters().iterator();
        while (it.hasNext()) {
            SingleVariableDeclaration v = (SingleVariableDeclaration)it.next();
            v.accept((ASTVisitor)this);
            if (!it.hasNext()) continue;
            this.fBuffer.append(", ");
        }
        this.fBuffer.append(")");
        if (node.getAST().apiLevel() >= 8) {
            List dimensions = node.extraDimensions();
            for (Dimension e : dimensions) {
                e.accept((ASTVisitor)this);
            }
        } else {
            int i = 0;
            while (i < node.getExtraDimensions()) {
                this.fBuffer.append("[]");
                ++i;
            }
        }
        List<Name> list = thrownExceptions = node.getAST().apiLevel() >= 8 ? node.thrownExceptionTypes() : ASTFlattener.getThrownExceptions(node);
        if (!thrownExceptions.isEmpty()) {
            this.fBuffer.append(" throws ");
            Iterator<Name> it2 = thrownExceptions.iterator();
            while (it2.hasNext()) {
                ASTNode n = (ASTNode)it2.next();
                n.accept((ASTVisitor)this);
                if (!it2.hasNext()) continue;
                this.fBuffer.append(", ");
            }
            this.fBuffer.append(" ");
        }
        if (node.getBody() == null) {
            this.fBuffer.append(";");
        } else {
            node.getBody().accept((ASTVisitor)this);
        }
        return false;
    }

    @Override
    public boolean visit(MethodInvocation node) {
        Iterator it;
        if (node.getExpression() != null) {
            node.getExpression().accept((ASTVisitor)this);
            this.fBuffer.append(".");
        }
        if (node.getAST().apiLevel() >= 3 && !node.typeArguments().isEmpty()) {
            this.fBuffer.append("<");
            it = node.typeArguments().iterator();
            while (it.hasNext()) {
                Type t = (Type)it.next();
                t.accept((ASTVisitor)this);
                if (!it.hasNext()) continue;
                this.fBuffer.append(",");
            }
            this.fBuffer.append(">");
        }
        node.getName().accept((ASTVisitor)this);
        this.fBuffer.append("(");
        it = node.arguments().iterator();
        while (it.hasNext()) {
            Expression e = (Expression)it.next();
            e.accept((ASTVisitor)this);
            if (!it.hasNext()) continue;
            this.fBuffer.append(",");
        }
        this.fBuffer.append(")");
        return false;
    }

    @Override
    public boolean visit(Modifier node) {
        this.fBuffer.append(node.getKeyword().toString());
        return false;
    }

    @Override
    public boolean visit(ModuleDeclaration node) {
        if (node.getJavadoc() != null) {
            node.getJavadoc().accept((ASTVisitor)this);
        }
        this.printModifiers(node.annotations());
        if (node.isOpen()) {
            this.fBuffer.append("open ");
        }
        this.fBuffer.append("module");
        this.fBuffer.append(" ");
        node.getName().accept((ASTVisitor)this);
        this.fBuffer.append(" {\n");
        for (ModuleDirective stmt : node.moduleStatements()) {
            stmt.accept((ASTVisitor)this);
        }
        this.fBuffer.append("}");
        return false;
    }

    @Override
    public boolean visit(ModuleModifier node) {
        this.fBuffer.append(node.getKeyword().toString());
        return false;
    }

    private boolean visit(ModulePackageAccess node, String keyword) {
        this.fBuffer.append(keyword);
        this.fBuffer.append(" ");
        node.getName().accept((ASTVisitor)this);
        this.printTypes(node.modules(), "to");
        this.fBuffer.append(";\n");
        return false;
    }

    @Override
    public boolean visit(NameQualifiedType node) {
        node.getQualifier().accept((ASTVisitor)this);
        this.fBuffer.append('.');
        this.printTypeAnnotations((AnnotatableType)node);
        node.getName().accept((ASTVisitor)this);
        return false;
    }

    @Override
    public boolean visit(NormalAnnotation node) {
        this.fBuffer.append("@");
        node.getTypeName().accept((ASTVisitor)this);
        this.fBuffer.append("(");
        Iterator it = node.values().iterator();
        while (it.hasNext()) {
            MemberValuePair p = (MemberValuePair)it.next();
            p.accept((ASTVisitor)this);
            if (!it.hasNext()) continue;
            this.fBuffer.append(",");
        }
        this.fBuffer.append(")");
        return false;
    }

    @Override
    public boolean visit(NullLiteral node) {
        this.fBuffer.append("null");
        return false;
    }

    public boolean visit(NullPattern node) {
        if (ASTHelper.isPatternSupported(node.getAST())) {
            this.fBuffer.append("null");
        }
        return false;
    }

    @Override
    public boolean visit(NumberLiteral node) {
        this.fBuffer.append(node.getToken());
        return false;
    }

    @Override
    public boolean visit(OpensDirective node) {
        return this.visit((ModulePackageAccess)node, "opens");
    }

    @Override
    public boolean visit(PackageDeclaration node) {
        if (node.getAST().apiLevel() >= 3) {
            if (node.getJavadoc() != null) {
                node.getJavadoc().accept((ASTVisitor)this);
            }
            for (Annotation p : node.annotations()) {
                p.accept((ASTVisitor)this);
                this.fBuffer.append(" ");
            }
        }
        this.fBuffer.append("package ");
        node.getName().accept((ASTVisitor)this);
        this.fBuffer.append(";");
        return false;
    }

    @Override
    public boolean visit(ParameterizedType node) {
        node.getType().accept((ASTVisitor)this);
        this.fBuffer.append("<");
        Iterator it = node.typeArguments().iterator();
        while (it.hasNext()) {
            Type t = (Type)it.next();
            t.accept((ASTVisitor)this);
            if (!it.hasNext()) continue;
            this.fBuffer.append(",");
        }
        this.fBuffer.append(">");
        return false;
    }

    @Override
    public boolean visit(ParenthesizedExpression node) {
        this.fBuffer.append("(");
        node.getExpression().accept((ASTVisitor)this);
        this.fBuffer.append(")");
        return false;
    }

    @Override
    public boolean visit(PostfixExpression node) {
        node.getOperand().accept((ASTVisitor)this);
        this.fBuffer.append(node.getOperator().toString());
        return false;
    }

    @Override
    public boolean visit(PrefixExpression node) {
        this.fBuffer.append(node.getOperator().toString());
        node.getOperand().accept((ASTVisitor)this);
        return false;
    }

    @Override
    public boolean visit(PrimitiveType node) {
        this.printTypeAnnotations((AnnotatableType)node);
        this.fBuffer.append(node.getPrimitiveTypeCode().toString());
        return false;
    }

    @Override
    public boolean visit(ProvidesDirective node) {
        this.fBuffer.append("provides");
        this.fBuffer.append(" ");
        node.getName().accept((ASTVisitor)this);
        this.printTypes(node.implementations(), "with");
        this.fBuffer.append(";\n");
        return false;
    }

    @Override
    public boolean visit(QualifiedName node) {
        node.getQualifier().accept((ASTVisitor)this);
        this.fBuffer.append(".");
        node.getName().accept((ASTVisitor)this);
        return false;
    }

    @Override
    public boolean visit(QualifiedType node) {
        node.getQualifier().accept((ASTVisitor)this);
        this.fBuffer.append(".");
        this.printTypeAnnotations((AnnotatableType)node);
        node.getName().accept((ASTVisitor)this);
        return false;
    }

    @Override
    public boolean visit(RecordDeclaration node) {
        TypeParameter t;
        Iterator it;
        if (node.getJavadoc() != null) {
            node.getJavadoc().accept((ASTVisitor)this);
        }
        this.printModifiers(node.modifiers());
        this.fBuffer.append("record ");
        node.getName().accept((ASTVisitor)this);
        this.fBuffer.append(" ");
        if (!node.typeParameters().isEmpty()) {
            this.fBuffer.append("<");
            it = node.typeParameters().iterator();
            while (it.hasNext()) {
                t = (TypeParameter)it.next();
                t.accept((ASTVisitor)this);
                if (!it.hasNext()) continue;
                this.fBuffer.append(",");
            }
            this.fBuffer.append(">");
        }
        this.fBuffer.append(" ");
        this.fBuffer.append("(");
        it = node.recordComponents().iterator();
        while (it.hasNext()) {
            SingleVariableDeclaration v = (SingleVariableDeclaration)it.next();
            v.accept((ASTVisitor)this);
            if (!it.hasNext()) continue;
            this.fBuffer.append(",");
        }
        this.fBuffer.append(")");
        if (!node.superInterfaceTypes().isEmpty()) {
            this.fBuffer.append(" implements ");
            it = node.superInterfaceTypes().iterator();
            while (it.hasNext()) {
                t = (Type)it.next();
                t.accept((ASTVisitor)this);
                if (!it.hasNext()) continue;
                this.fBuffer.append(", ");
            }
            this.fBuffer.append(" ");
        }
        this.fBuffer.append("{");
        if (!node.bodyDeclarations().isEmpty()) {
            this.fBuffer.append("\n");
            for (BodyDeclaration d : node.bodyDeclarations()) {
                d.accept((ASTVisitor)this);
            }
        }
        this.fBuffer.append("}\n");
        return false;
    }

    @Override
    public boolean visit(RequiresDirective node) {
        this.fBuffer.append("requires");
        this.fBuffer.append(" ");
        this.printModifiers(node.modifiers());
        node.getName().accept((ASTVisitor)this);
        this.fBuffer.append(";\n");
        return false;
    }

    @Override
    public boolean visit(ReturnStatement node) {
        this.fBuffer.append("return");
        if (node.getExpression() != null) {
            this.fBuffer.append(" ");
            node.getExpression().accept((ASTVisitor)this);
        }
        this.fBuffer.append(";");
        return false;
    }

    @Override
    public boolean visit(SimpleName node) {
        this.fBuffer.append(node.getIdentifier());
        return false;
    }

    @Override
    public boolean visit(SimpleType node) {
        this.printTypeAnnotations((AnnotatableType)node);
        node.getName().accept((ASTVisitor)this);
        return false;
    }

    @Override
    public boolean visit(SingleMemberAnnotation node) {
        this.fBuffer.append("@");
        node.getTypeName().accept((ASTVisitor)this);
        this.fBuffer.append("(");
        node.getValue().accept((ASTVisitor)this);
        this.fBuffer.append(")");
        return false;
    }

    @Override
    public boolean visit(SingleVariableDeclaration node) {
        if (node.getAST().apiLevel() >= 3) {
            this.printModifiers(node.modifiers());
        }
        node.getType().accept((ASTVisitor)this);
        if (node.getAST().apiLevel() >= 3 && node.isVarargs()) {
            if (node.getAST().apiLevel() >= 8) {
                this.fBuffer.append(' ');
                List annotations = node.varargsAnnotations();
                this.printAnnotationsList(annotations);
            }
            this.fBuffer.append("...");
        }
        this.fBuffer.append(" ");
        node.getName().accept((ASTVisitor)this);
        if (node.getAST().apiLevel() >= 8) {
            List dimensions = node.extraDimensions();
            for (Dimension e : dimensions) {
                e.accept((ASTVisitor)this);
            }
        } else {
            int i = 0;
            while (i < node.getExtraDimensions()) {
                this.fBuffer.append("[]");
                ++i;
            }
        }
        if (node.getInitializer() != null) {
            this.fBuffer.append("=");
            node.getInitializer().accept((ASTVisitor)this);
        }
        return false;
    }

    @Override
    public boolean visit(StringLiteral node) {
        this.fBuffer.append(node.getEscapedValue());
        return false;
    }

    @Override
    public boolean visit(TextBlock node) {
        this.fBuffer.append(node.getEscapedValue());
        return false;
    }

    @Override
    public boolean visit(SuperConstructorInvocation node) {
        Iterator it;
        if (node.getExpression() != null) {
            node.getExpression().accept((ASTVisitor)this);
            this.fBuffer.append(".");
        }
        if (node.getAST().apiLevel() >= 3 && !node.typeArguments().isEmpty()) {
            this.fBuffer.append("<");
            it = node.typeArguments().iterator();
            while (it.hasNext()) {
                Type t = (Type)it.next();
                t.accept((ASTVisitor)this);
                if (!it.hasNext()) continue;
                this.fBuffer.append(",");
            }
            this.fBuffer.append(">");
        }
        this.fBuffer.append("super(");
        it = node.arguments().iterator();
        while (it.hasNext()) {
            Expression e = (Expression)it.next();
            e.accept((ASTVisitor)this);
            if (!it.hasNext()) continue;
            this.fBuffer.append(",");
        }
        this.fBuffer.append(");");
        return false;
    }

    @Override
    public boolean visit(SuperFieldAccess node) {
        if (node.getQualifier() != null) {
            node.getQualifier().accept((ASTVisitor)this);
            this.fBuffer.append(".");
        }
        this.fBuffer.append("super.");
        node.getName().accept((ASTVisitor)this);
        return false;
    }

    @Override
    public boolean visit(SuperMethodInvocation node) {
        Iterator it;
        if (node.getQualifier() != null) {
            node.getQualifier().accept((ASTVisitor)this);
            this.fBuffer.append(".");
        }
        this.fBuffer.append("super.");
        if (node.getAST().apiLevel() >= 3 && !node.typeArguments().isEmpty()) {
            this.fBuffer.append("<");
            it = node.typeArguments().iterator();
            while (it.hasNext()) {
                Type t = (Type)it.next();
                t.accept((ASTVisitor)this);
                if (!it.hasNext()) continue;
                this.fBuffer.append(",");
            }
            this.fBuffer.append(">");
        }
        node.getName().accept((ASTVisitor)this);
        this.fBuffer.append("(");
        it = node.arguments().iterator();
        while (it.hasNext()) {
            Expression e = (Expression)it.next();
            e.accept((ASTVisitor)this);
            if (!it.hasNext()) continue;
            this.fBuffer.append(",");
        }
        this.fBuffer.append(")");
        return false;
    }

    @Override
    public boolean visit(SuperMethodReference node) {
        if (node.getQualifier() != null) {
            node.getQualifier().accept((ASTVisitor)this);
            this.fBuffer.append('.');
        }
        this.fBuffer.append("super");
        this.printReferenceTypeArguments(node.typeArguments());
        node.getName().accept((ASTVisitor)this);
        return false;
    }

    @Override
    public boolean visit(SwitchCase node) {
        if (ASTHelper.isSwitchCaseExpressionsSupportedInAST(node.getAST())) {
            if (node.isDefault() && !this.isCaseDefaultExpression(node)) {
                this.fBuffer.append("default");
                this.fBuffer.append(node.isSwitchLabeledRule() ? " ->" : ":");
            } else {
                this.fBuffer.append("case ");
                Iterator it = node.expressions().iterator();
                while (it.hasNext()) {
                    Expression t = (Expression)it.next();
                    t.accept((ASTVisitor)this);
                    this.fBuffer.append(it.hasNext() ? ", " : (node.isSwitchLabeledRule() ? " ->" : ":"));
                }
            }
        } else if (node.isDefault() && !this.isCaseDefaultExpression(node)) {
            this.fBuffer.append("default :\n");
        } else {
            this.fBuffer.append("case ");
            node.getExpression().accept((ASTVisitor)this);
            this.fBuffer.append(":\n");
        }
        return false;
    }

    private boolean isCaseDefaultExpression(SwitchCase node) {
        return node.expressions() != null && node.expressions().size() == 1 && node.expressions().get(0) instanceof CaseDefaultExpression;
    }

    @Override
    public boolean visit(YieldStatement node) {
        if (ASTHelper.isYieldNodeSupportedInAST(node.getAST()) && node.isImplicit() && node.getExpression() == null) {
            return false;
        }
        this.fBuffer.append("yield");
        if (node.getExpression() != null) {
            this.fBuffer.append(" ");
            node.getExpression().accept((ASTVisitor)this);
        }
        this.fBuffer.append(";");
        return false;
    }

    @Override
    public boolean visit(SwitchStatement node) {
        this.visitSwitchNode((ASTNode)node);
        return false;
    }

    @Override
    public boolean visit(SwitchExpression node) {
        this.visitSwitchNode((ASTNode)node);
        return false;
    }

    private void visitSwitchNode(ASTNode node) {
        this.fBuffer.append("switch (");
        if (node instanceof SwitchExpression) {
            ((SwitchExpression)node).getExpression().accept((ASTVisitor)this);
        } else if (node instanceof SwitchStatement) {
            ((SwitchStatement)node).getExpression().accept((ASTVisitor)this);
        }
        this.fBuffer.append(") ");
        this.fBuffer.append("{\n");
        if (node instanceof SwitchExpression) {
            for (Statement s : ((SwitchExpression)node).statements()) {
                s.accept((ASTVisitor)this);
            }
        } else if (node instanceof SwitchStatement) {
            for (Statement s : ((SwitchStatement)node).statements()) {
                s.accept((ASTVisitor)this);
            }
        }
        this.fBuffer.append("}\n");
    }

    @Override
    public boolean visit(SynchronizedStatement node) {
        this.fBuffer.append("synchronized (");
        node.getExpression().accept((ASTVisitor)this);
        this.fBuffer.append(") ");
        node.getBody().accept((ASTVisitor)this);
        return false;
    }

    @Override
    public boolean visit(TagElement node) {
        if (node.isNested()) {
            this.fBuffer.append("{");
        } else {
            this.fBuffer.append("\n * ");
        }
        boolean previousRequiresWhiteSpace = false;
        if (node.getTagName() != null) {
            this.fBuffer.append(node.getTagName());
            previousRequiresWhiteSpace = true;
        }
        boolean previousRequiresNewLine = false;
        for (ASTNode e : node.fragments()) {
            boolean currentIncludesWhiteSpace = e instanceof TextElement;
            if (previousRequiresNewLine && currentIncludesWhiteSpace) {
                this.fBuffer.append("\n * ");
            }
            previousRequiresNewLine = currentIncludesWhiteSpace;
            if (previousRequiresWhiteSpace && !currentIncludesWhiteSpace) {
                this.fBuffer.append(" ");
            }
            e.accept((ASTVisitor)this);
            boolean bl = previousRequiresWhiteSpace = !currentIncludesWhiteSpace && !(e instanceof TagElement);
        }
        if (node.isNested()) {
            this.fBuffer.append("}");
        }
        return false;
    }

    @Override
    public boolean visit(TextElement node) {
        this.fBuffer.append(node.getText());
        return false;
    }

    @Override
    public boolean visit(ThisExpression node) {
        if (node.getQualifier() != null) {
            node.getQualifier().accept((ASTVisitor)this);
            this.fBuffer.append(".");
        }
        this.fBuffer.append("this");
        return false;
    }

    @Override
    public boolean visit(ThrowStatement node) {
        this.fBuffer.append("throw ");
        node.getExpression().accept((ASTVisitor)this);
        this.fBuffer.append(";");
        return false;
    }

    @Override
    public boolean visit(TryStatement node) {
        this.fBuffer.append("try ");
        if (node.getAST().apiLevel() >= 4 && !node.resources().isEmpty()) {
            this.fBuffer.append("(");
            Iterator it = node.resources().iterator();
            while (it.hasNext()) {
                Expression var = (Expression)it.next();
                var.accept((ASTVisitor)this);
                if (!it.hasNext()) continue;
                this.fBuffer.append(",");
            }
            this.fBuffer.append(") ");
        }
        node.getBody().accept((ASTVisitor)this);
        this.fBuffer.append(" ");
        for (CatchClause cc : node.catchClauses()) {
            cc.accept((ASTVisitor)this);
        }
        if (node.getFinally() != null) {
            this.fBuffer.append("finally ");
            node.getFinally().accept((ASTVisitor)this);
        }
        return false;
    }

    @Override
    public boolean visit(TypeDeclaration node) {
        TypeParameter t;
        Iterator it;
        if (node.getJavadoc() != null) {
            node.getJavadoc().accept((ASTVisitor)this);
        }
        if (node.getAST().apiLevel() >= 3) {
            this.printModifiers(node.modifiers());
        }
        this.fBuffer.append(node.isInterface() ? "interface " : "class ");
        node.getName().accept((ASTVisitor)this);
        if (node.getAST().apiLevel() >= 3 && !node.typeParameters().isEmpty()) {
            this.fBuffer.append("<");
            it = node.typeParameters().iterator();
            while (it.hasNext()) {
                t = (TypeParameter)it.next();
                t.accept((ASTVisitor)this);
                if (!it.hasNext()) continue;
                this.fBuffer.append(",");
            }
            this.fBuffer.append(">");
        }
        this.fBuffer.append(" ");
        if (node.getAST().apiLevel() >= 3) {
            if (node.getSuperclassType() != null) {
                this.fBuffer.append("extends ");
                node.getSuperclassType().accept((ASTVisitor)this);
                this.fBuffer.append(" ");
            }
            if (!node.superInterfaceTypes().isEmpty()) {
                this.fBuffer.append(node.isInterface() ? "extends " : "implements ");
                it = node.superInterfaceTypes().iterator();
                while (it.hasNext()) {
                    t = (Type)it.next();
                    t.accept((ASTVisitor)this);
                    if (!it.hasNext()) continue;
                    this.fBuffer.append(", ");
                }
                this.fBuffer.append(" ");
            }
        }
        if (ASTHelper.isSealedTypeSupportedInAST(node.getAST()) && !node.permittedTypes().isEmpty()) {
            this.fBuffer.append("permits ");
            it = node.permittedTypes().iterator();
            while (it.hasNext()) {
                t = (Type)it.next();
                t.accept((ASTVisitor)this);
                if (!it.hasNext()) continue;
                this.fBuffer.append(", ");
            }
            this.fBuffer.append(" ");
        }
        this.fBuffer.append("{");
        BodyDeclaration prev = null;
        for (BodyDeclaration d : node.bodyDeclarations()) {
            if (prev instanceof EnumConstantDeclaration) {
                if (d instanceof EnumConstantDeclaration) {
                    this.fBuffer.append(", ");
                } else {
                    this.fBuffer.append("; ");
                }
            }
            d.accept((ASTVisitor)this);
            prev = d;
        }
        this.fBuffer.append("}");
        return false;
    }

    @Override
    public boolean visit(TypeDeclarationStatement node) {
        if (node.getAST().apiLevel() >= 3) {
            node.getDeclaration().accept((ASTVisitor)this);
        }
        return false;
    }

    @Override
    public boolean visit(TypeLiteral node) {
        node.getType().accept((ASTVisitor)this);
        this.fBuffer.append(".class");
        return false;
    }

    @Override
    public boolean visit(TypeMethodReference node) {
        node.getType().accept((ASTVisitor)this);
        this.printReferenceTypeArguments(node.typeArguments());
        node.getName().accept((ASTVisitor)this);
        return false;
    }

    @Override
    public boolean visit(TypeParameter node) {
        this.printModifiers(node.modifiers());
        node.getName().accept((ASTVisitor)this);
        if (!node.typeBounds().isEmpty()) {
            this.fBuffer.append(" extends ");
            Iterator it = node.typeBounds().iterator();
            while (it.hasNext()) {
                Type t = (Type)it.next();
                t.accept((ASTVisitor)this);
                if (!it.hasNext()) continue;
                this.fBuffer.append(" & ");
            }
        }
        return false;
    }

    public boolean visit(TypePattern node) {
        if (ASTHelper.isPatternSupported(node.getAST())) {
            node.getPatternVariable().accept((ASTVisitor)this);
        }
        return false;
    }

    @Override
    public boolean visit(UnionType node) {
        Iterator it = node.types().iterator();
        while (it.hasNext()) {
            Type t = (Type)it.next();
            t.accept((ASTVisitor)this);
            if (!it.hasNext()) continue;
            this.fBuffer.append("|");
        }
        return false;
    }

    @Override
    public boolean visit(UsesDirective node) {
        this.fBuffer.append("uses");
        this.fBuffer.append(" ");
        node.getName().accept((ASTVisitor)this);
        this.fBuffer.append(";\n");
        return false;
    }

    @Override
    public boolean visit(VariableDeclarationExpression node) {
        if (node.getAST().apiLevel() >= 3) {
            this.printModifiers(node.modifiers());
        }
        node.getType().accept((ASTVisitor)this);
        this.fBuffer.append(" ");
        Iterator it = node.fragments().iterator();
        while (it.hasNext()) {
            VariableDeclarationFragment f = (VariableDeclarationFragment)it.next();
            f.accept((ASTVisitor)this);
            if (!it.hasNext()) continue;
            this.fBuffer.append(", ");
        }
        return false;
    }

    @Override
    public boolean visit(VariableDeclarationFragment node) {
        node.getName().accept((ASTVisitor)this);
        if (node.getAST().apiLevel() >= 8) {
            List dimensions = node.extraDimensions();
            for (Dimension e : dimensions) {
                e.accept((ASTVisitor)this);
            }
        } else {
            int i = 0;
            while (i < node.getExtraDimensions()) {
                this.fBuffer.append("[]");
                ++i;
            }
        }
        if (node.getInitializer() != null) {
            this.fBuffer.append("=");
            node.getInitializer().accept((ASTVisitor)this);
        }
        return false;
    }

    @Override
    public boolean visit(VariableDeclarationStatement node) {
        if (node.getAST().apiLevel() >= 3) {
            this.printModifiers(node.modifiers());
        }
        node.getType().accept((ASTVisitor)this);
        this.fBuffer.append(" ");
        Iterator it = node.fragments().iterator();
        while (it.hasNext()) {
            VariableDeclarationFragment f = (VariableDeclarationFragment)it.next();
            f.accept((ASTVisitor)this);
            if (!it.hasNext()) continue;
            this.fBuffer.append(", ");
        }
        this.fBuffer.append(";");
        return false;
    }

    @Override
    public boolean visit(WhileStatement node) {
        this.fBuffer.append("while (");
        node.getExpression().accept((ASTVisitor)this);
        this.fBuffer.append(") ");
        node.getBody().accept((ASTVisitor)this);
        return false;
    }

    @Override
    public boolean visit(WildcardType node) {
        this.printTypeAnnotations((AnnotatableType)node);
        this.fBuffer.append("?");
        Type bound = node.getBound();
        if (bound != null) {
            if (node.isUpperBound()) {
                this.fBuffer.append(" extends ");
            } else {
                this.fBuffer.append(" super ");
            }
            bound.accept((ASTVisitor)this);
        }
        return false;
    }
}

