/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.runtime.Platform;
import org.eclipse.rcptt.util.StreamUtil;
import org.eclipse.rcptt.util.UtilPlugin;

public class FileUtil {
    private static final String PATH_SEPARATOR = System.getProperty("file.separator");
    private static final String invalidFileNameChars = "\\/:*?\"<>|";

    public static void deleteFile(File file, boolean deleteRootDir) {
        if (file == null || !file.exists()) {
            return;
        }
        if (file.isFile()) {
            file.delete();
            return;
        }
        if (file.isDirectory()) {
            File[] childs = file.listFiles();
            if (childs != null) {
                File[] fileArray = childs;
                int n = childs.length;
                int n2 = 0;
                while (n2 < n) {
                    File child = fileArray[n2];
                    FileUtil.deleteFile(child, true);
                    ++n2;
                }
            }
            if (deleteRootDir) {
                file.delete();
            }
        }
    }

    public static byte[] getStreamContent(InputStream stream) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            byte[] buffer = new byte[4096];
            int len = 0;
            while ((len = stream.read(buffer)) > 0) {
                output.write(buffer, 0, len);
            }
        }
        finally {
            FileUtil.safeClose(stream);
        }
        return output.toByteArray();
    }

    public static byte[] getStreamContent(InputStream stream, int bufferSize) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            byte[] buffer = new byte[bufferSize];
            int len = stream.read(buffer, 0, bufferSize);
            if (len > 0) {
                output.write(buffer, 0, len);
            }
        }
        finally {
            FileUtil.safeClose(stream);
        }
        return output.toByteArray();
    }

    public static void safeClose(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (Exception exception) {}
    }

    public static void copy(InputStream source, OutputStream destination) throws IOException {
        try {
            FileUtil.copyNoClose(source, destination);
        }
        finally {
            FileUtil.safeClose(source);
            FileUtil.safeClose(destination);
        }
    }

    public static void copyNoClose(InputStream source, OutputStream destination) throws IOException {
        byte[] buffer = new byte[4096];
        int len = 0;
        while ((len = source.read(buffer)) > 0) {
            destination.write(buffer, 0, len);
        }
    }

    public static boolean deleteFiles(File ... listFiles) {
        if (listFiles == null) {
            return true;
        }
        boolean ret = true;
        File[] fileArray = listFiles;
        int n = listFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file != null) {
                if (file.isDirectory()) {
                    ret &= FileUtil.deleteFiles(file.listFiles());
                }
                ret &= file.delete();
            }
            ++n2;
        }
        return ret;
    }

    public static void copyFiles(File dir, File target) {
        if (dir == null) {
            return;
        }
        if (dir.isDirectory()) {
            File[] fileArray = dir.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file != null) {
                    File targetFile = new File(target, file.getName());
                    if (file.isDirectory()) {
                        targetFile.mkdirs();
                        FileUtil.copyFiles(file, targetFile);
                    } else {
                        try {
                            targetFile.getParentFile().mkdirs();
                            FileUtil.copy(new BufferedInputStream(new FileInputStream(file)), new BufferedOutputStream(new FileOutputStream(targetFile)));
                        }
                        catch (Exception e) {
                            UtilPlugin.log("Failed to copy file:" + file.getAbsolutePath() + " to file:" + targetFile, e);
                        }
                    }
                }
                ++n2;
            }
        } else {
            File targetFile = new File(target, dir.getName());
            try {
                FileUtil.copy(new BufferedInputStream(new FileInputStream(dir)), new BufferedOutputStream(new FileOutputStream(targetFile)));
            }
            catch (Exception e) {
                UtilPlugin.log("Failed to copy file:" + dir.getAbsolutePath() + " to file:" + targetFile, e);
            }
        }
    }

    public static String getID(String value) {
        if (value == null) {
            return null;
        }
        StringBuilder textResult = new StringBuilder();
        char[] cArray = value.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (!Character.isLetterOrDigit(c)) {
                textResult.append('_');
            } else {
                textResult.append(c);
            }
            ++n2;
        }
        return textResult.toString();
    }

    public static String limitSize(String id) {
        if (id.length() > 30) {
            return id.substring(id.length() - 30, id.length());
        }
        return id;
    }

    public static String rlimitSize(String id, int len) {
        if (id.length() > len) {
            return id.substring(0, len);
        }
        return id;
    }

    public static String escape(String text) {
        if (text == null) {
            return null;
        }
        StringBuilder textResult = new StringBuilder();
        char[] cArray = text.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            block7: {
                int c;
                block6: {
                    block5: {
                        c = cArray[n2];
                        if (!Platform.getOS().equals("win32")) break block5;
                        if (c != 13) break block6;
                        break block7;
                    }
                    if (Platform.getOS().equals("macosx") && c == 13) {
                        c = 10;
                    }
                }
                if (c == 10) {
                    textResult.append("\\n");
                } else {
                    textResult.append((char)c);
                }
            }
            ++n2;
        }
        return textResult.toString();
    }

    public static String unescape(String substring) {
        return substring.replace("\\n", "\n");
    }

    public static void zipFolder(String srcFolder, String destZipFile) throws IOException {
        ZipOutputStream zip = null;
        BufferedOutputStream fileWriter = null;
        fileWriter = new BufferedOutputStream(new FileOutputStream(destZipFile));
        zip = new ZipOutputStream(fileWriter);
        File folder = new File(srcFolder);
        String[] stringArray = folder.list();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String fileName = stringArray[n2];
            FileUtil.addFileToZip("", String.valueOf(srcFolder) + "/" + fileName, zip);
            ++n2;
        }
        zip.flush();
        zip.close();
    }

    private static void addFileToZip(String path, String srcFile, ZipOutputStream zip) throws IOException {
        File folder = new File(srcFile);
        if (folder.isDirectory()) {
            FileUtil.addFolderToZip(path, srcFile, zip);
        } else {
            byte[] buf = new byte[4096];
            BufferedInputStream in = null;
            try {
                int len;
                in = new BufferedInputStream(new FileInputStream(srcFile));
                zip.putNextEntry(new ZipEntry(String.valueOf(path) + "/" + folder.getName()));
                while ((len = ((InputStream)in).read(buf)) > 0) {
                    zip.write(buf, 0, len);
                }
            }
            catch (Throwable throwable) {
                StreamUtil.closeSilently(in);
                throw throwable;
            }
            StreamUtil.closeSilently(in);
        }
    }

    private static void addFolderToZip(String path, String srcFolder, ZipOutputStream zip) throws IOException {
        File folder = new File(srcFolder);
        String[] stringArray = folder.list();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String fileName = stringArray[n2];
            if (path.equals("")) {
                FileUtil.addFileToZip(folder.getName(), String.valueOf(srcFolder) + "/" + fileName, zip);
            } else {
                FileUtil.addFileToZip(String.valueOf(path) + "/" + folder.getName(), String.valueOf(srcFolder) + "/" + fileName, zip);
            }
            ++n2;
        }
    }

    public static boolean deleteFile(File file) {
        if (file.isDirectory()) {
            FileUtil.deleteFiles(file.listFiles());
        }
        return file.delete();
    }

    public static void copy(InputStream in, OutputStream out, boolean closeIn) throws IOException {
        byte[] buffer = new byte[8192];
        int read = 0;
        while ((read = in.read(buffer)) != -1) {
            out.write(buffer, 0, read);
        }
        if (closeIn) {
            in.close();
        }
    }

    public static void copy(InputStream in, OutputStream out, boolean closeIn, long limit) throws IOException {
        byte[] buffer = new byte[8192];
        int read = 0;
        long cur = 0L;
        while ((read = in.read(buffer)) != -1) {
            out.write(buffer, 0, read);
            if ((cur += (long)read) > limit) break;
        }
        if (closeIn) {
            in.close();
        }
    }

    public static void copy(InputStream in, File file, boolean closeIn) throws IOException {
        BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(file));
        FileUtil.copy(in, fos, closeIn);
        ((OutputStream)fos).flush();
        ((OutputStream)fos).close();
    }

    public static byte[] getContents(File file) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        FileInputStream in = new FileInputStream(file);
        FileUtil.copy((InputStream)in, out, true);
        out.flush();
        return out.toByteArray();
    }

    public static byte[] getContents(File file, long limit) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        FileInputStream in = new FileInputStream(file);
        FileUtil.copy(in, out, true, limit);
        out.flush();
        return out.toByteArray();
    }

    public static String filename(String uri) {
        int lastSlash = uri.lastIndexOf(47);
        if (lastSlash == -1) {
            return "";
        }
        return uri.substring(lastSlash + 1);
    }

    public static int unzip(File zip, File dest) throws IOException {
        ZipEntry entry;
        ZipInputStream z = new ZipInputStream(new BufferedInputStream(new FileInputStream(zip)));
        int filesCount = 0;
        while ((entry = z.getNextEntry()) != null) {
            File entryFile = FileUtil.resolve(dest, entry.getName());
            if (entry.isDirectory()) {
                entryFile.mkdirs();
                continue;
            }
            FileUtil.copy((InputStream)z, entryFile, false);
            ++filesCount;
        }
        z.close();
        return filesCount;
    }

    private static File resolve(File base, String name) {
        name = name.replace("/", PATH_SEPARATOR);
        File file = new File(String.format("%s%s%s", base.getAbsolutePath(), PATH_SEPARATOR, name));
        FileUtil.createFileParent(file.getParentFile());
        return file;
    }

    private static boolean createFileParent(File file) {
        if (!file.exists()) {
            FileUtil.createFileParent(file.getParentFile());
            file.mkdir();
            return true;
        }
        return true;
    }

    public static void unzipToFolder(InputStream stream, File outputFile) {
        try {
            ZipInputStream zin = new ZipInputStream(new BufferedInputStream(stream));
            ZipEntry entry = zin.getNextEntry();
            while (entry != null) {
                String name = entry.getName();
                File file = new File(outputFile, name);
                file.getParentFile().mkdirs();
                if (!entry.isDirectory()) {
                    BufferedOutputStream fout = new BufferedOutputStream(new FileOutputStream(file));
                    FileUtil.copyNoClose(zin, fout);
                    StreamUtil.closeSilently(fout);
                } else {
                    file.mkdir();
                }
                entry = zin.getNextEntry();
            }
            StreamUtil.closeSilently(zin);
        }
        catch (Exception e) {
            UtilPlugin.log(e.getMessage(), e);
        }
    }

    public static void copyNoClose(InputStream source, OutputStream destination, MessageDigest md) throws IOException {
        byte[] buffer = new byte[65536];
        int len = 0;
        while ((len = source.read(buffer)) > 0) {
            destination.write(buffer, 0, len);
            md.update(buffer, 0, len);
        }
    }

    public static boolean traverse(File siteRoot, File root, ITraverseRunnable runnable) {
        File[] list;
        if (siteRoot == null) {
            return true;
        }
        File[] fileArray = list = siteRoot.listFiles();
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f.isDirectory()) {
                if (!FileUtil.traverse(f, root, runnable)) {
                    return false;
                }
                runnable.accept(f, root.toURI().relativize(f.toURI()).getPath());
            } else if (!runnable.accept(f, root.toURI().relativize(f.toURI()).getPath())) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static boolean isInvalidFileNameChar(char c) {
        return invalidFileNameChars.contains(String.valueOf(c));
    }

    public static String escapeFileName(String text, String extension) {
        StringBuilder result = new StringBuilder();
        char[] cArray = text.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (FileUtil.isInvalidFileNameChar(c)) {
                result.append("_");
            } else {
                result.append(c);
            }
            ++n2;
        }
        if (extension != null) {
            result.append("." + extension);
        }
        return result.toString();
    }

    public static interface ITraverseRunnable {
        public boolean accept(File var1, String var2);
    }
}

