/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.recording.aspects.jface;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewerEditor;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.rcptt.tesla.recording.aspects.jface.IJFaceEventListener;
import org.eclipse.swt.events.SelectionEvent;

public final class JFaceEventManager {
    private static Set<IJFaceEventListener> listeners = new HashSet<IJFaceEventListener>();

    private JFaceEventManager() {
    }

    public static void addListener(IJFaceEventListener listener) {
        listeners.add(listener);
    }

    public static void removeListener(IJFaceEventListener listener) {
        listeners.remove(listener);
    }

    public static void activateCellEditor(CellEditor cellEditor) {
        for (IJFaceEventListener listener : listeners) {
            listener.activateCellEditor(cellEditor);
        }
    }

    public static void activateCellEditor(CellEditor cellEditor, ColumnViewerEditorActivationEvent activationEvent) {
        for (IJFaceEventListener listener : listeners) {
            listener.activateCellEditor(cellEditor, activationEvent);
        }
    }

    public static void applyCellEditor(CellEditor cellEditor) {
        for (IJFaceEventListener listener : listeners) {
            listener.applyCellEditor(cellEditor);
        }
    }

    public static void cancelCellEditor(CellEditor cellEditor) {
        for (IJFaceEventListener listener : listeners) {
            listener.cancelCellEditor(cellEditor);
        }
    }

    public static void applyCellEditor(ColumnViewerEditor editor) {
        for (IJFaceEventListener listener : listeners) {
            listener.applyCellEditor(editor);
        }
    }

    public static void cancelCellEditor(ColumnViewerEditor editor) {
        for (IJFaceEventListener listener : listeners) {
            listener.cancelCellEditor(editor);
        }
    }

    public static void recordOpenStrategyEvent(OpenStrategy str, SelectionEvent e) {
        for (IJFaceEventListener listener : listeners) {
            listener.recordOpenStrategyEvent(str, e);
        }
    }

    public static void deactivateCellEditor(CellEditor cellEditor) {
        for (IJFaceEventListener listener : listeners) {
            listener.deactivateCellEditor(cellEditor);
        }
    }
}

