/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.core.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Platform;
import org.eclipse.rcptt.core.model.IContext;
import org.eclipse.rcptt.core.model.IParent;
import org.eclipse.rcptt.core.model.IQ7Element;
import org.eclipse.rcptt.core.model.IQ7Folder;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.model.IQ7Project;
import org.eclipse.rcptt.core.model.ITestCase;
import org.eclipse.rcptt.core.model.ITestSuite;
import org.eclipse.rcptt.core.model.ModelException;
import org.eclipse.rcptt.core.model.search.ISearchScope;
import org.eclipse.rcptt.core.scenario.TestSuiteItem;
import org.eclipse.rcptt.core.workspace.RcpttCore;
import org.eclipse.rcptt.internal.core.RcpttPlugin;
import org.eclipse.rcptt.internal.core.model.Q7Element;
import org.eclipse.rcptt.internal.core.model.Q7ElementInfo;
import org.eclipse.rcptt.internal.core.model.Q7Model;
import org.eclipse.rcptt.internal.core.model.Q7NamedElement;
import org.eclipse.rcptt.internal.core.model.Q7ResourceInfo;
import org.eclipse.rcptt.internal.core.model.cache.ModelCache;
import org.eclipse.rcptt.internal.core.model.deltas.DeltaProcessingState;
import org.eclipse.rcptt.internal.core.model.deltas.DeltaProcessor;
import org.eclipse.rcptt.internal.core.model.deltas.Q7ElementDeltaBuilder;
import org.eclipse.rcptt.internal.core.model.index.IndexManager;
import org.eclipse.rcptt.internal.core.model.index.ProjectIndexerManager;

public class ModelManager {
    private static ModelManager instance;
    private ModelCache cache;
    public DeltaProcessingState deltaState = new DeltaProcessingState();
    private Map<Q7NamedElement, PerWorkingCopyInfo> perWorkingCopyInfos = new HashMap<Q7NamedElement, PerWorkingCopyInfo>(5);
    private final Q7Model model = new Q7Model();
    private IndexManager indexManager;
    private Set<IProject> buildingProjects = new HashSet<IProject>();
    private static final IQ7NamedElement[] EMPTY_NAMED_ELEMENTS;

    static {
        EMPTY_NAMED_ELEMENTS = new IQ7NamedElement[0];
    }

    public ModelManager() {
        if (Platform.isRunning()) {
            this.indexManager = new IndexManager();
        }
    }

    public static synchronized ModelManager getModelManager() {
        if (instance == null) {
            instance = new ModelManager();
        }
        return instance;
    }

    public void startup() {
        this.cache = new ModelCache();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace.addResourceChangeListener((IResourceChangeListener)this.deltaState, 31);
        RcpttCore.getInstance();
        this.getIndexManager().reset();
        ProjectIndexerManager.startIndexing();
    }

    public void shutdown() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace.removeResourceChangeListener((IResourceChangeListener)this.deltaState);
    }

    public synchronized Object getInfo(IQ7Element element) {
        return this.cache.getInfo(element);
    }

    protected synchronized void putInfos(IQ7Element openedElement, Map<IQ7Element, Object> newElements) {
        Object existingInfo = this.cache.peekAtInfo(openedElement);
        if (openedElement instanceof IParent && existingInfo instanceof Q7ElementInfo) {
            IQ7Element[] children = ((Q7ElementInfo)existingInfo).getChildren();
            int i = 0;
            int size = children.length;
            while (i < size) {
                Q7Element child = (Q7Element)children[i];
                try {
                    child.close();
                }
                catch (ModelException modelException) {}
                ++i;
            }
        }
        for (Map.Entry<IQ7Element, Object> element : newElements.entrySet()) {
            this.cache.putInfo(element.getKey(), element.getValue());
        }
    }

    synchronized Object removeInfoAndChildren(Q7Element element) throws ModelException {
        Object info = this.cache.peekAtInfo(element);
        if (info != null) {
            element.closing(info);
            if (element instanceof IParent && info instanceof Q7ElementInfo) {
                IQ7Element[] children = ((Q7ElementInfo)info).getChildren();
                int i = 0;
                int size = children.length;
                while (i < size) {
                    Q7Element child = (Q7Element)children[i];
                    child.close();
                    ++i;
                }
            }
            this.cache.removeInfo(element);
            return info;
        }
        return null;
    }

    private static IQ7Element create(IFile file, IQ7Project project) {
        if (file == null) {
            return null;
        }
        if (project == null) {
            project = RcpttCore.create(file.getProject());
        }
        IQ7Folder folder = project.getFolder(file.getParent().getProjectRelativePath());
        return folder.getNamedElement(file.getName());
    }

    private static IQ7Element create(IFolder file, IQ7Project project) {
        if (file == null) {
            return null;
        }
        if (project == null) {
            project = RcpttCore.create(file.getProject());
        }
        return project.getFolder(file.getProjectRelativePath());
    }

    public static IQ7Element create(IResource resource, IQ7Project project) {
        if (resource == null) {
            return null;
        }
        int type = resource.getType();
        switch (type) {
            case 4: {
                return RcpttCore.create((IProject)resource);
            }
            case 1: {
                return ModelManager.create((IFile)resource, project);
            }
            case 2: {
                return ModelManager.create((IFolder)resource, project);
            }
            case 8: {
                return ModelManager.getModelManager().getModel();
            }
        }
        return null;
    }

    public Q7Model getModel() {
        return this.model;
    }

    public IndexManager getIndexManager() {
        return this.indexManager;
    }

    Object peekAtInfo(IQ7Element element) {
        return this.cache.peekAtInfo(element);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PerWorkingCopyInfo getPerWorkingCopyInfo(Q7NamedElement workingCopy, boolean create, boolean recordUsage) {
        Map<Q7NamedElement, PerWorkingCopyInfo> map = this.perWorkingCopyInfos;
        synchronized (map) {
            PerWorkingCopyInfo info = this.perWorkingCopyInfos.get(workingCopy);
            if (info == null && create) {
                info = new PerWorkingCopyInfo(workingCopy);
                this.perWorkingCopyInfos.put(workingCopy, info);
            }
            if (info != null && recordUsage) {
                PerWorkingCopyInfo perWorkingCopyInfo = info;
                perWorkingCopyInfo.useCount = perWorkingCopyInfo.useCount + 1;
            }
            return info;
        }
    }

    public DeltaProcessor getDeltaProcessor() {
        return this.deltaState.getDeltaProcessor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int discardPerWorkingCopyInfo(Q7NamedElement workingCopy) throws ModelException {
        Q7ElementDeltaBuilder deltaBuilder = null;
        if (workingCopy.hasUnsavedChanges()) {
            deltaBuilder = new Q7ElementDeltaBuilder(workingCopy);
        }
        PerWorkingCopyInfo info = null;
        Map<Q7NamedElement, PerWorkingCopyInfo> map = this.perWorkingCopyInfos;
        synchronized (map) {
            block9: {
                info = this.perWorkingCopyInfos.get(workingCopy);
                if (info != null) break block9;
                return -1;
            }
            PerWorkingCopyInfo perWorkingCopyInfo = info;
            int n = perWorkingCopyInfo.useCount - 1;
            perWorkingCopyInfo.useCount = n;
            if (n == 0) {
                this.perWorkingCopyInfos.remove(workingCopy);
            }
        }
        if (info.useCount == 0) {
            this.removeInfoAndChildren(workingCopy);
            workingCopy.close();
            info.close();
            if (deltaBuilder != null) {
                deltaBuilder.buildDeltas();
                if (deltaBuilder.delta != null && deltaBuilder.delta.getAffectedChildren().length > 0) {
                    this.getDeltaProcessor().registerModelDelta(deltaBuilder.delta);
                }
            }
        }
        return info.useCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void projectStartBuilding(IProject project) {
        Set<IProject> set = this.buildingProjects;
        synchronized (set) {
            this.buildingProjects.add(project);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void projectStopBuilding(IProject project) {
        Set<IProject> set = this.buildingProjects;
        synchronized (set) {
            this.buildingProjects.remove(project);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isProjectBuilding() {
        Set<IProject> set = this.buildingProjects;
        synchronized (set) {
            return !this.buildingProjects.isEmpty();
        }
    }

    public IQ7NamedElement[] findContextUsageInWorkingCopies(String contextId, ISearchScope scope) throws ModelException {
        ArrayList<IQ7NamedElement> result = new ArrayList<IQ7NamedElement>();
        for (PerWorkingCopyInfo info : this.perWorkingCopyInfos.values()) {
            if (!scope.contains(info.workingCopy.getResource().getFullPath())) continue;
            IQ7NamedElement element = info.workingCopy;
            if (element instanceof ITestCase) {
                String[] stringArray = ((ITestCase)element).getContexts();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String cid = stringArray[n2];
                    if (contextId.equals(cid)) {
                        result.add(element);
                    }
                    ++n2;
                }
                continue;
            }
            if (!(element instanceof IContext)) continue;
            for (String cid : RcpttCore.getInstance().getContextReferences((IContext)element)) {
                if (!contextId.equals(cid)) continue;
                result.add(element);
            }
        }
        return result.toArray(EMPTY_NAMED_ELEMENTS);
    }

    public IQ7NamedElement[] findVerificationUsageInWorkingCopies(String verificationId, ISearchScope scope) throws ModelException {
        ArrayList<IQ7NamedElement> result = new ArrayList<IQ7NamedElement>();
        for (PerWorkingCopyInfo info : this.perWorkingCopyInfos.values()) {
            IQ7NamedElement element;
            if (!scope.contains(info.workingCopy.getResource().getFullPath()) || !((element = info.workingCopy) instanceof ITestCase)) continue;
            String[] stringArray = ((ITestCase)element).getVerifications();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String vid = stringArray[n2];
                if (verificationId.equals(vid)) {
                    result.add(element);
                }
                ++n2;
            }
        }
        return result.toArray(EMPTY_NAMED_ELEMENTS);
    }

    public IQ7NamedElement[] findTestCaseUsageInWorkingCopies(String testCaseId, ISearchScope scope) throws ModelException {
        ArrayList<IQ7NamedElement> result = new ArrayList<IQ7NamedElement>();
        for (PerWorkingCopyInfo info : this.perWorkingCopyInfos.values()) {
            IQ7NamedElement element;
            if (!scope.contains(info.workingCopy.getResource().getFullPath()) || !((element = info.workingCopy) instanceof ITestSuite)) continue;
            TestSuiteItem[] testSuiteItemArray = ((ITestSuite)element).getItems();
            int n = testSuiteItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TestSuiteItem i = testSuiteItemArray[n2];
                if (testCaseId.equals(i.getNamedElementId())) {
                    result.add(element);
                }
                ++n2;
            }
        }
        return result.toArray(EMPTY_NAMED_ELEMENTS);
    }

    public IQ7NamedElement[] findTestSuiteUsageInWorkingCopies(String testSuiteId, ISearchScope scope) throws ModelException {
        ArrayList<IQ7NamedElement> result = new ArrayList<IQ7NamedElement>();
        for (PerWorkingCopyInfo info : this.perWorkingCopyInfos.values()) {
            IQ7NamedElement element;
            if (!scope.contains(info.workingCopy.getResource().getFullPath()) || !((element = info.workingCopy) instanceof ITestSuite)) continue;
            TestSuiteItem[] testSuiteItemArray = ((ITestSuite)element).getItems();
            int n = testSuiteItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TestSuiteItem i = testSuiteItemArray[n2];
                if (testSuiteId.equals(i.getNamedElementId())) {
                    result.add(element);
                }
                ++n2;
            }
        }
        return result.toArray(EMPTY_NAMED_ELEMENTS);
    }

    static class PerWorkingCopyInfo {
        private int useCount = 0;
        private IQ7NamedElement workingCopy;
        Q7ResourceInfo resourceInfo;
        boolean complete = false;

        private PerWorkingCopyInfo(IQ7NamedElement workingCopy) {
            this.workingCopy = workingCopy;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public IQ7NamedElement getWorkingCopy() {
            PerWorkingCopyInfo perWorkingCopyInfo = this;
            synchronized (perWorkingCopyInfo) {
                while (true) {
                    if (this.complete) {
                        return this.workingCopy;
                    }
                    try {
                        this.wait(100L);
                    }
                    catch (InterruptedException e) {
                        RcpttPlugin.log(e);
                    }
                }
            }
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append("Info for ");
            buffer.append(((Q7Element)((Object)this.workingCopy)).toStringWithAncestors());
            buffer.append("\nUse count = ");
            buffer.append(this.useCount);
            return buffer.toString();
        }

        private void close() {
            if (this.resourceInfo != null) {
                this.resourceInfo.unload();
            }
        }
    }
}

