/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.core.breakpoints;

import com.ibm.icu.text.MessageFormat;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.VirtualMachine;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugException;
import org.eclipse.jdt.debug.core.IJavaPatternBreakpoint;
import org.eclipse.jdt.internal.debug.core.JDIDebugPlugin;
import org.eclipse.jdt.internal.debug.core.breakpoints.JDIDebugBreakpointMessages;
import org.eclipse.jdt.internal.debug.core.breakpoints.JavaLineBreakpoint;
import org.eclipse.jdt.internal.debug.core.model.JDIDebugTarget;

public class JavaPatternBreakpoint
extends JavaLineBreakpoint
implements IJavaPatternBreakpoint {
    private static final String PATTERN_BREAKPOINT = "org.eclipse.jdt.debug.javaPatternBreakpointMarker";
    protected static final String PATTERN = "org.eclipse.jdt.debug.core.pattern";

    public JavaPatternBreakpoint() {
    }

    public JavaPatternBreakpoint(IResource resource, String sourceName, String pattern, int lineNumber, int charStart, int charEnd, int hitCount, boolean add, Map<String, Object> attributes) throws DebugException {
        this(resource, sourceName, pattern, lineNumber, charStart, charEnd, hitCount, add, attributes, PATTERN_BREAKPOINT);
    }

    public JavaPatternBreakpoint(final IResource resource, final String sourceName, final String pattern, final int lineNumber, final int charStart, final int charEnd, final int hitCount, final boolean add, final Map<String, Object> attributes, final String markerType) throws DebugException {
        IWorkspaceRunnable wr = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                JavaPatternBreakpoint.this.setMarker(resource.createMarker(markerType));
                JavaPatternBreakpoint.this.addLineBreakpointAttributes(attributes, JavaPatternBreakpoint.this.getModelIdentifier(), true, lineNumber, charStart, charEnd);
                JavaPatternBreakpoint.this.addPatternAndHitCount(attributes, sourceName, pattern, hitCount);
                attributes.put("org.eclipse.jdt.debug.core.suspendPolicy", new Integer(JavaPatternBreakpoint.this.getDefaultSuspendPolicy()));
                JavaPatternBreakpoint.this.ensureMarker().setAttributes(attributes);
                JavaPatternBreakpoint.this.register(add);
            }
        };
        this.run(this.getMarkerRule(resource), wr);
    }

    protected String getReferenceTypeName() {
        String name = "";
        try {
            name = this.getPattern();
        }
        catch (CoreException ce) {
            JDIDebugPlugin.log(ce);
        }
        return name;
    }

    @Override
    protected boolean installableReferenceType(ReferenceType type, JDIDebugTarget target) throws CoreException {
        if (this.getSourceName() != null) {
            String sourceName = null;
            try {
                sourceName = type.sourceName();
            }
            catch (AbsentInformationException absentInformationException) {
            }
            catch (VMDisconnectedException e) {
                if (!target.isAvailable()) {
                    return false;
                }
                target.targetRequestFailed(MessageFormat.format((String)JDIDebugBreakpointMessages.JavaPatternBreakpoint_exception_source_name, (Object[])new Object[]{e.toString(), type.name()}), e);
                return false;
            }
            catch (RuntimeException e) {
                target.targetRequestFailed(MessageFormat.format((String)JDIDebugBreakpointMessages.JavaPatternBreakpoint_exception_source_name, (Object[])new Object[]{e.toString(), type.name()}), e);
                return false;
            }
            if (sourceName != null && !this.getSourceName().equalsIgnoreCase(sourceName)) {
                return false;
            }
        }
        String pattern = this.getPattern();
        String queriedType = type.name();
        if (pattern == null || queriedType == null) {
            return false;
        }
        if (queriedType.startsWith(pattern)) {
            return this.queryInstallListeners(target, type);
        }
        return false;
    }

    protected void addPatternAndHitCount(Map<String, Object> attributes, String sourceName, String pattern, int hitCount) {
        attributes.put(PATTERN, pattern);
        if (sourceName != null) {
            attributes.put("org.eclipse.jdt.debug.core.sourceName", sourceName);
        }
        if (hitCount > 0) {
            attributes.put("org.eclipse.jdt.debug.core.hitCount", new Integer(hitCount));
            attributes.put("org.eclipse.jdt.debug.core.expired", Boolean.FALSE);
        }
    }

    @Override
    public String getPattern() throws CoreException {
        return (String)this.ensureMarker().getAttribute(PATTERN);
    }

    @Override
    public String getSourceName() throws CoreException {
        return (String)this.ensureMarker().getAttribute("org.eclipse.jdt.debug.core.sourceName");
    }

    @Override
    protected void createRequests(JDIDebugTarget target) throws CoreException {
        if (target.isTerminated() || this.shouldSkipBreakpoint()) {
            return;
        }
        String referenceTypeName = this.getReferenceTypeName();
        if (referenceTypeName == null) {
            return;
        }
        String classPrepareTypeName = referenceTypeName;
        if (!referenceTypeName.endsWith("*")) {
            classPrepareTypeName = String.valueOf(classPrepareTypeName) + '*';
        }
        this.registerRequest(target.createClassPrepareRequest(classPrepareTypeName), target);
        VirtualMachine vm = target.getVM();
        if (vm == null) {
            target.requestFailed(JDIDebugBreakpointMessages.JavaPatternBreakpoint_Unable_to_add_breakpoint___VM_disconnected__1, new VMDisconnectedException());
        }
        List<ReferenceType> classes = null;
        try {
            classes = vm.allClasses();
        }
        catch (RuntimeException e) {
            target.targetRequestFailed(JDIDebugBreakpointMessages.JavaPatternBreakpoint_0, e);
        }
        if (classes != null) {
            Iterator<ReferenceType> iter = classes.iterator();
            String typeName = null;
            ReferenceType type = null;
            while (iter.hasNext()) {
                type = iter.next();
                typeName = type.name();
                if (typeName == null || !typeName.startsWith(referenceTypeName)) continue;
                this.createRequest(target, type);
            }
        }
    }
}

