/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.touchpoint.eclipse.actions;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.touchpoint.eclipse.Util;
import org.eclipse.equinox.internal.p2.touchpoint.eclipse.actions.Messages;
import org.eclipse.equinox.internal.provisional.frameworkadmin.LauncherData;
import org.eclipse.equinox.internal.provisional.frameworkadmin.Manipulator;
import org.eclipse.equinox.p2.engine.spi.ProvisioningAction;
import org.eclipse.osgi.util.NLS;

public class SetJvmAction
extends ProvisioningAction {
    public static final String ID = "setJvm";

    public IStatus execute(Map<String, Object> parameters) {
        String jvmArg = (String)parameters.get("jvm");
        if (jvmArg == null) {
            return Util.createError(NLS.bind((String)Messages.parameter_not_set, (Object)"jvm", (Object)ID));
        }
        LauncherData launcherData = ((Manipulator)parameters.get("manipulator")).getLauncherData();
        File previous = launcherData.getJvm();
        File jvm = "null".equals(jvmArg) ? null : new File(jvmArg);
        this.getMemento().put("previousValue", (Object)(previous == null ? null : previous.getPath()));
        launcherData.setJvm(jvm);
        if (jvm != null) {
            SetJvmAction.adjustWorkbenchSystemProperties(jvm);
        }
        return Status.OK_STATUS;
    }

    public IStatus undo(Map<String, Object> parameters) {
        String jvmArg = (String)parameters.get("jvm");
        if (jvmArg == null) {
            return Util.createError(NLS.bind((String)Messages.parameter_not_set, (Object)"jvm", (Object)ID));
        }
        String previous = (String)this.getMemento().get("previousValue");
        LauncherData launcherData = ((Manipulator)parameters.get("manipulator")).getLauncherData();
        File jvm = previous == null ? null : new File(previous);
        launcherData.setJvm(jvm);
        if (jvm != null) {
            SetJvmAction.adjustWorkbenchSystemProperties(jvm);
        }
        return Status.OK_STATUS;
    }

    private static void adjustWorkbenchSystemProperties(File jvm) {
        try {
            String fullPath = jvm.getCanonicalPath();
            System.setProperty("eclipse.vm", fullPath);
            String property = System.getProperty("eclipse.commands");
            int index = property.indexOf("-vm");
            if (index != -1) {
                int index2 = property.indexOf(10, index + "-vm\n".length());
                if (index2 == -1) {
                    property = String.valueOf(property.substring(0, index)) + "-vm\n" + fullPath;
                } else {
                    String tmp = String.valueOf(property.substring(0, index)) + "-vm\n" + fullPath;
                    property = String.valueOf(tmp) + property.substring(index2);
                }
                System.setProperty("eclipse.commands", property);
            }
        }
        catch (IOException iOException) {}
    }
}

