/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.builder;

import com.ibm.icu.text.MessageFormat;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.builder.State;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.api.tools.internal.ApiDescriptionManager;
import org.eclipse.pde.api.tools.internal.builder.BaseApiAnalyzer;
import org.eclipse.pde.api.tools.internal.builder.BuildContext;
import org.eclipse.pde.api.tools.internal.builder.BuildStamps;
import org.eclipse.pde.api.tools.internal.builder.BuildState;
import org.eclipse.pde.api.tools.internal.builder.BuilderMessages;
import org.eclipse.pde.api.tools.internal.builder.IncrementalApiBuilder;
import org.eclipse.pde.api.tools.internal.problems.ApiProblemFactory;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.builder.IApiAnalyzer;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiBaseline;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiComponent;
import org.eclipse.pde.api.tools.internal.provisional.problems.IApiProblem;
import org.eclipse.pde.api.tools.internal.util.Util;
import org.eclipse.pde.core.build.IBuild;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.core.build.IBuildModel;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PDEPreferencesManager;
import org.osgi.framework.Version;

public class ApiAnalysisBuilder
extends IncrementalProjectBuilder {
    static final IPath SETTINGS_PATH = new Path(".settings");
    public static final IPath BUILD_PROPERTIES_PATH = new Path("build.properties");
    public static final IPath MANIFEST_PATH = new Path("META-INF/MANIFEST.MF");
    static final Comparator<ManifestElement> fgManifestElementComparator = (o1, o2) -> o1.getValue().compareTo(o2.getValue());
    public static final HashSet<String> IMPORTANT_HEADERS = new HashSet(7);
    static final IPath FILTER_PATH;
    static final IProject[] NO_PROJECTS;
    static final String SOURCE = "API Tools";
    private static boolean buildDisabled;
    private IProject currentproject = null;
    private IApiAnalyzer analyzer = null;
    HashMap<IProject, HashSet<IPath>> output_locs = new HashMap();
    HashMap<IProject, HashSet<IPath>> src_locs = new HashMap();
    private BuildState buildstate = null;
    private static final boolean DISABLE_AUTO_BUILDING_ON_SETTINGS_CHANGE;

    static {
        IMPORTANT_HEADERS.add("system.bundle");
        IMPORTANT_HEADERS.add("Bundle-Version");
        IMPORTANT_HEADERS.add("Require-Bundle");
        IMPORTANT_HEADERS.add("Bundle-RequiredExecutionEnvironment");
        IMPORTANT_HEADERS.add("Export-Package");
        IMPORTANT_HEADERS.add("Import-Package");
        IMPORTANT_HEADERS.add("Bundle-ClassPath");
        FILTER_PATH = SETTINGS_PATH.append(".api_filters");
        NO_PROJECTS = new IProject[0];
        buildDisabled = false;
        DISABLE_AUTO_BUILDING_ON_SETTINGS_CHANGE = Boolean.getBoolean("org.eclipse.disableAutoBuildOnSettingsChange");
    }

    void cleanupMarkers(IResource resource) {
        this.cleanUnusedFilterMarkers(resource);
        this.cleanupUsageMarkers(resource);
        this.cleanupCompatibilityMarkers(resource);
        this.cleanupUnsupportedTagMarkers(resource);
        this.cleanupUnsupportedAnnotationMarkers(resource);
        this.cleanApiUseScanMarkers(resource);
        this.cleanupFatalMarkers(resource);
    }

    void cleanApiUseScanMarkers(IResource resource) {
        try {
            if (resource != null && resource.isAccessible()) {
                IMarker[] markers;
                if (ApiPlugin.DEBUG_BUILDER) {
                    System.out.println("ApiAnalysisBuilder: cleaning api use problems");
                }
                resource.deleteMarkers("org.eclipse.pde.api.tools.marker.apiusescan", true, 2);
                IProject project = resource.getProject();
                IMarker[] iMarkerArray = markers = project.findMarkers("org.eclipse.pde.api.tools.marker.apiusescan", false, 0);
                int n = markers.length;
                int n2 = 0;
                while (n2 < n) {
                    IType typeroot;
                    IMarker marker = iMarkerArray[n2];
                    String typeName = marker.getAttribute("apiUseScanType", null);
                    IJavaElement adaptor = (IJavaElement)resource.getAdapter(IJavaElement.class);
                    if (adaptor != null && adaptor instanceof ICompilationUnit && (typeroot = ((ICompilationUnit)adaptor).findPrimaryType()) != null && typeName != null && typeName.startsWith(typeroot.getFullyQualifiedName())) {
                        marker.delete();
                    }
                    ++n2;
                }
            }
        }
        catch (CoreException e) {
            ApiPlugin.log(e.getStatus());
        }
    }

    void cleanupUnsupportedTagMarkers(IResource resource) {
        try {
            if (resource != null && resource.isAccessible()) {
                if (ApiPlugin.DEBUG_BUILDER) {
                    System.out.println("ApiAnalysisBuilder: cleaning unsupported tag problems");
                }
                resource.deleteMarkers("org.eclipse.pde.api.tools.unsupported_tags", false, 2);
            }
        }
        catch (CoreException e) {
            ApiPlugin.log(e.getStatus());
        }
    }

    void cleanupUnsupportedAnnotationMarkers(IResource resource) {
        try {
            if (resource != null && resource.isAccessible()) {
                if (ApiPlugin.DEBUG_BUILDER) {
                    System.out.println("ApiAnalysisBuilder: cleaning unsupported annotation problems");
                }
                resource.deleteMarkers("org.eclipse.pde.api.tools.unsupported_annotations", false, 2);
            }
        }
        catch (CoreException e) {
            ApiPlugin.log(e.getStatus());
        }
    }

    void cleanupCompatibilityMarkers(IResource resource) {
        try {
            if (resource != null && resource.isAccessible()) {
                resource.deleteMarkers("org.eclipse.pde.api.tools.compatibility", false, 2);
                resource.deleteMarkers("org.eclipse.pde.api.tools.marker.sincetags", false, 2);
                if (resource.getType() == 4) {
                    resource.deleteMarkers("org.eclipse.pde.api.tools.version_numbering", false, 2);
                    resource.deleteMarkers("org.eclipse.pde.api.tools.api_profile", true, 0);
                    resource.deleteMarkers("org.eclipse.pde.api.tools.api_component_resolution", true, 0);
                }
            }
        }
        catch (CoreException e) {
            ApiPlugin.log(e.getStatus());
        }
    }

    void cleanupUsageMarkers(IResource resource) {
        try {
            if (resource != null && resource.isAccessible()) {
                IProject pj;
                resource.deleteMarkers("org.eclipse.pde.api.tools.api_usage", false, 2);
                if (resource.getType() != 4 && (pj = resource.getProject()) != null) {
                    pj.deleteMarkers("org.eclipse.pde.api.tools.api_usage", false, 0);
                }
            }
        }
        catch (CoreException e) {
            ApiPlugin.log(e.getStatus());
        }
    }

    void cleanupFatalMarkers(IResource resource) {
        try {
            if (resource != null && resource.isAccessible()) {
                resource.deleteMarkers("org.eclipse.pde.api.tools.fatal_problem", false, 2);
            }
        }
        catch (CoreException e) {
            ApiPlugin.log(e.getStatus());
        }
    }

    void cleanUnusedFilterMarkers(IResource resource) {
        try {
            if (resource != null && resource.isAccessible()) {
                resource.deleteMarkers("org.eclipse.pde.api.tools.unused_filters", false, 2);
            }
        }
        catch (CoreException ce) {
            ApiPlugin.log(ce.getStatus());
        }
    }

    /*
     * Loose catch block
     */
    protected IProject[] build(int kind, Map<String, String> args, IProgressMonitor monitor) throws CoreException {
        IProject[] projects;
        block90: {
            IApiBaseline baseline;
            SubMonitor localMonitor;
            block89: {
                Throwable throwable2222;
                block91: {
                    PDEPreferencesManager prefs = PDECore.getDefault().getPreferencesManager();
                    boolean disableAPIAnalysisBuilder = prefs.getBoolean("Preferences.MainPage.disableAPIAnalysisBuilder");
                    if (disableAPIAnalysisBuilder) {
                        return NO_PROJECTS;
                    }
                    this.currentproject = this.getProject();
                    if (buildDisabled || this.shouldAbort(this.currentproject)) {
                        return NO_PROJECTS;
                    }
                    BuildStamps.incBuildStamp(this.currentproject);
                    if (ApiPlugin.DEBUG_BUILDER) {
                        System.out.println("\nApiAnalysisBuilder: Starting build of " + this.currentproject.getName() + " @ " + new Date(System.currentTimeMillis()));
                    }
                    localMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)BuilderMessages.api_analysis_builder, (int)8);
                    IApiBaseline wbaseline = ApiPlugin.getDefault().getApiBaselineManager().getWorkspaceBaseline();
                    if (wbaseline == null) {
                        if (ApiPlugin.DEBUG_BUILDER) {
                            System.err.println("ApiAnalysisBuilder: Could not retrieve a workspace baseline");
                        }
                        return NO_PROJECTS;
                    }
                    projects = this.getRequiredProjects(true);
                    baseline = ApiPlugin.getDefault().getApiBaselineManager().getDefaultApiBaseline();
                    try {
                        SubMonitor switchMonitor = localMonitor.split(4);
                        switch (kind) {
                            case 6: {
                                if (ApiPlugin.DEBUG_BUILDER) {
                                    System.out.println("ApiAnalysisBuilder: Performing full build as requested");
                                }
                                this.buildAll(baseline, wbaseline, (IProgressMonitor)switchMonitor);
                                break;
                            }
                            case 9: 
                            case 10: {
                                this.buildstate = BuildState.getLastBuiltState(this.currentproject);
                                if (this.buildstate == null) {
                                    this.buildAll(baseline, wbaseline, (IProgressMonitor)switchMonitor);
                                    break;
                                }
                                if (this.worthDoingFullBuild(projects)) {
                                    this.buildAll(baseline, wbaseline, (IProgressMonitor)switchMonitor);
                                    break;
                                }
                                IResourceDelta[] deltas = this.getDeltas(projects);
                                if (deltas.length < 1) {
                                    this.buildAll(baseline, wbaseline, (IProgressMonitor)switchMonitor);
                                    break;
                                }
                                IResourceDelta filters = null;
                                boolean full = false;
                                IResourceDelta[] iResourceDeltaArray = deltas;
                                int n = deltas.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    IResourceDelta delta = iResourceDeltaArray[n2];
                                    full = this.shouldFullBuild(delta);
                                    if (full) break;
                                    filters = delta.findMember(FILTER_PATH);
                                    if (filters != null) {
                                        switch (filters.getKind()) {
                                            case 1: 
                                            case 2: {
                                                full = true;
                                                break;
                                            }
                                            case 4: {
                                                full = (filters.getFlags() & 0x40100) > 0;
                                                break;
                                            }
                                        }
                                        if (full) break;
                                    }
                                    ++n2;
                                }
                                if (full) {
                                    if (ApiPlugin.DEBUG_BUILDER) {
                                        System.out.println("ApiAnalysisBuilder: Performing full build since MANIFEST.MF or .api_filters was modified");
                                    }
                                    this.buildAll(baseline, wbaseline, (IProgressMonitor)switchMonitor);
                                    break;
                                }
                                switchMonitor.setWorkRemaining(2);
                                State state = (State)JavaModelManager.getJavaModelManager().getLastBuiltState(this.currentproject, (IProgressMonitor)switchMonitor.split(1));
                                if (state == null) {
                                    this.buildAll(baseline, wbaseline, (IProgressMonitor)switchMonitor.split(1));
                                    break;
                                }
                                BuildState.setLastBuiltState(this.currentproject, null);
                                IncrementalApiBuilder builder = new IncrementalApiBuilder(this);
                                builder.build(baseline, wbaseline, deltas, state, this.buildstate, (IProgressMonitor)switchMonitor.split(1));
                                break;
                            }
                        }
                        localMonitor.split(1);
                        break block89;
                    }
                    catch (OperationCanceledException operationCanceledException) {
                        if (ApiPlugin.DEBUG_BUILDER) {
                            System.out.println("ApiAnalysisBuilder: Trapped OperationCanceledException");
                        }
                        try {
                            localMonitor.split(1);
                            if (this.analyzer != null) {
                                this.analyzer.dispose();
                                this.analyzer = null;
                            }
                            if (projects.length < 1 && baseline != null) {
                                baseline.close();
                            }
                            localMonitor.split(1);
                            if (this.buildstate != null) {
                                IPluginModelBase base;
                                IProject[] iProjectArray = projects;
                                int n = projects.length;
                                int n3 = 0;
                                while (n3 < n) {
                                    IProject project = iProjectArray[n3];
                                    if (Util.isApiProject(project)) {
                                        this.buildstate.addApiToolingDependentProject(project.getName());
                                    }
                                    ++n3;
                                }
                                this.buildstate.setBuildPathCRC(BuildState.computeBuildPathCRC(this.currentproject));
                                IFile manifest = (IFile)this.currentproject.findMember(MANIFEST_PATH);
                                if (manifest != null && manifest.exists()) {
                                    try {
                                        this.buildstate.setManifestState(ManifestElement.parseBundleManifest((InputStream)manifest.getContents(), null));
                                    }
                                    catch (Exception e) {
                                        ApiPlugin.log((IStatus)new Status(4, "org.eclipse.pde.api.tools", "Error parsing the manifest of: " + this.currentproject.getName(), (Throwable)e));
                                    }
                                }
                                if ((base = PluginRegistry.findModel((IProject)this.currentproject)) != null) {
                                    try {
                                        IBuildModel model = PluginRegistry.createBuildModel((IPluginModelBase)base);
                                        if (model != null) {
                                            this.buildstate.setBuildPropertiesState(model);
                                        }
                                    }
                                    catch (CoreException ce) {
                                        ApiPlugin.log(ce);
                                    }
                                }
                                BuildState.saveBuiltState(this.currentproject, this.buildstate);
                                this.buildstate = null;
                                localMonitor.split(1);
                            }
                            SubMonitor.done((IProgressMonitor)monitor);
                        }
                        catch (OperationCanceledException operationCanceledException2) {
                            if (ApiPlugin.DEBUG_BUILDER) {
                                System.out.println("ApiAnalysisBuilder: Trapped OperationCanceledException");
                            }
                            break block90;
                        }
                    }
                    catch (CoreException e) {
                        IStatus status = e.getStatus();
                        if (status == null || status.getCode() != 123) {
                            throw e;
                        }
                        ApiPlugin.log(e);
                        try {
                            localMonitor.split(1);
                            if (this.analyzer != null) {
                                this.analyzer.dispose();
                                this.analyzer = null;
                            }
                            if (projects.length < 1 && baseline != null) {
                                baseline.close();
                            }
                            localMonitor.split(1);
                            if (this.buildstate != null) {
                                IProject[] iProjectArray = projects;
                                int ce = projects.length;
                                int base = 0;
                                while (base < ce) {
                                    IProject project = iProjectArray[base];
                                    if (Util.isApiProject(project)) {
                                        this.buildstate.addApiToolingDependentProject(project.getName());
                                    }
                                    ++base;
                                }
                                this.buildstate.setBuildPathCRC(BuildState.computeBuildPathCRC(this.currentproject));
                                IFile manifest = (IFile)this.currentproject.findMember(MANIFEST_PATH);
                                if (manifest != null && manifest.exists()) {
                                    try {
                                        this.buildstate.setManifestState(ManifestElement.parseBundleManifest((InputStream)manifest.getContents(), null));
                                    }
                                    catch (Exception e2) {
                                        ApiPlugin.log((IStatus)new Status(4, "org.eclipse.pde.api.tools", "Error parsing the manifest of: " + this.currentproject.getName(), (Throwable)e2));
                                    }
                                }
                                if ((base = PluginRegistry.findModel((IProject)this.currentproject)) != null) {
                                    try {
                                        IBuildModel model = PluginRegistry.createBuildModel((IPluginModelBase)base);
                                        if (model != null) {
                                            this.buildstate.setBuildPropertiesState(model);
                                        }
                                    }
                                    catch (CoreException ce2) {
                                        ApiPlugin.log(ce2);
                                    }
                                }
                                BuildState.saveBuiltState(this.currentproject, this.buildstate);
                                this.buildstate = null;
                                localMonitor.split(1);
                            }
                            SubMonitor.done((IProgressMonitor)monitor);
                        }
                        catch (OperationCanceledException operationCanceledException) {
                            if (ApiPlugin.DEBUG_BUILDER) {
                                System.out.println("ApiAnalysisBuilder: Trapped OperationCanceledException");
                            }
                            break block90;
                        }
                        catch (Throwable throwable2222) {
                            try {
                                localMonitor.split(1);
                                if (this.analyzer != null) {
                                    this.analyzer.dispose();
                                    this.analyzer = null;
                                }
                                if (projects.length < 1 && baseline != null) {
                                    baseline.close();
                                }
                                localMonitor.split(1);
                                if (this.buildstate != null) {
                                    IProject[] iProjectArray = projects;
                                    int ce2 = projects.length;
                                    int base = 0;
                                    while (base < ce2) {
                                        IProject project = iProjectArray[base];
                                        if (Util.isApiProject(project)) {
                                            this.buildstate.addApiToolingDependentProject(project.getName());
                                        }
                                        ++base;
                                    }
                                    this.buildstate.setBuildPathCRC(BuildState.computeBuildPathCRC(this.currentproject));
                                    IFile manifest = (IFile)this.currentproject.findMember(MANIFEST_PATH);
                                    if (manifest != null && manifest.exists()) {
                                        try {
                                            this.buildstate.setManifestState(ManifestElement.parseBundleManifest((InputStream)manifest.getContents(), null));
                                        }
                                        catch (Exception e3) {
                                            ApiPlugin.log((IStatus)new Status(4, "org.eclipse.pde.api.tools", "Error parsing the manifest of: " + this.currentproject.getName(), (Throwable)e3));
                                        }
                                    }
                                    if ((base = PluginRegistry.findModel((IProject)this.currentproject)) != null) {
                                        try {
                                            IBuildModel model = PluginRegistry.createBuildModel((IPluginModelBase)base);
                                            if (model != null) {
                                                this.buildstate.setBuildPropertiesState(model);
                                            }
                                        }
                                        catch (CoreException ce) {
                                            ApiPlugin.log(ce);
                                        }
                                    }
                                    BuildState.saveBuiltState(this.currentproject, this.buildstate);
                                    this.buildstate = null;
                                    localMonitor.split(1);
                                }
                                SubMonitor.done((IProgressMonitor)monitor);
                            }
                            catch (OperationCanceledException operationCanceledException) {
                                if (!ApiPlugin.DEBUG_BUILDER) break block91;
                                System.out.println("ApiAnalysisBuilder: Trapped OperationCanceledException");
                            }
                        }
                    }
                }
                throw throwable2222;
            }
            try {
                localMonitor.split(1);
                if (this.analyzer != null) {
                    this.analyzer.dispose();
                    this.analyzer = null;
                }
                if (projects.length < 1 && baseline != null) {
                    baseline.close();
                }
                localMonitor.split(1);
                if (this.buildstate != null) {
                    IProject[] iProjectArray = projects;
                    int ce = projects.length;
                    int base = 0;
                    while (base < ce) {
                        IProject project = iProjectArray[base];
                        if (Util.isApiProject(project)) {
                            this.buildstate.addApiToolingDependentProject(project.getName());
                        }
                        ++base;
                    }
                    this.buildstate.setBuildPathCRC(BuildState.computeBuildPathCRC(this.currentproject));
                    IFile manifest = (IFile)this.currentproject.findMember(MANIFEST_PATH);
                    if (manifest != null && manifest.exists()) {
                        try {
                            this.buildstate.setManifestState(ManifestElement.parseBundleManifest((InputStream)manifest.getContents(), null));
                        }
                        catch (Exception e) {
                            ApiPlugin.log((IStatus)new Status(4, "org.eclipse.pde.api.tools", "Error parsing the manifest of: " + this.currentproject.getName(), (Throwable)e));
                        }
                    }
                    if ((base = PluginRegistry.findModel((IProject)this.currentproject)) != null) {
                        try {
                            IBuildModel model = PluginRegistry.createBuildModel((IPluginModelBase)base);
                            if (model != null) {
                                this.buildstate.setBuildPropertiesState(model);
                            }
                        }
                        catch (CoreException ce3) {
                            ApiPlugin.log(ce3);
                        }
                    }
                    BuildState.saveBuiltState(this.currentproject, this.buildstate);
                    this.buildstate = null;
                    localMonitor.split(1);
                }
                SubMonitor.done((IProgressMonitor)monitor);
            }
            catch (OperationCanceledException operationCanceledException) {
                if (!ApiPlugin.DEBUG_BUILDER) break block90;
                System.out.println("ApiAnalysisBuilder: Trapped OperationCanceledException");
            }
        }
        if (ApiPlugin.DEBUG_BUILDER) {
            System.out.println("ApiAnalysisBuilder: Finished build of " + this.currentproject.getName() + " @ " + new Date(System.currentTimeMillis()));
        }
        return projects;
    }

    boolean shouldFullBuild(IResourceDelta delta) {
        switch (delta.getKind()) {
            case 4: {
                IResourceDelta subdelta = delta.findMember(MANIFEST_PATH);
                if (subdelta != null) {
                    IFile file = (IFile)subdelta.getResource();
                    return file.getProject().equals((Object)this.currentproject) && this.compareManifest(file, this.buildstate);
                }
                subdelta = delta.findMember(BUILD_PROPERTIES_PATH);
                if (subdelta != null) {
                    IFile file = (IFile)subdelta.getResource();
                    return file.getProject().equals((Object)this.currentproject) && this.compareBuildProperties(this.buildstate);
                }
                subdelta = delta.findMember(SETTINGS_PATH);
                if (subdelta == null || DISABLE_AUTO_BUILDING_ON_SETTINGS_CHANGE) break;
                return true;
            }
        }
        return false;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    boolean compareManifest(IFile manifest, BuildState state) {
        block14: {
            if (state != null) {
                try {
                    Map<String, String> stateheaders = state.getManifestState();
                    if (stateheaders == null) break block14;
                    Map headers = ManifestElement.parseBundleManifest((InputStream)manifest.getContents(), null);
                    Map.Entry<String, String> entry2 = null;
                    for (Map.Entry<String, String> entry2 : stateheaders.entrySet()) {
                        String key = entry2.getKey();
                        String value = (String)headers.get(key);
                        ManifestElement[] e1 = ManifestElement.parseHeader((String)key, (String)value);
                        ManifestElement[] e2 = ManifestElement.parseHeader((String)key, (String)entry2.getValue());
                        if (e1 != null && e2 != null && e1.length == e2.length) {
                            Arrays.sort(e1, fgManifestElementComparator);
                            Arrays.sort(e2, fgManifestElementComparator);
                            int j = 0;
                            while (j < e1.length) {
                                String key2;
                                Object[] v2;
                                Object[] v1 = e1[j].getValueComponents();
                                if (v1.length == (v2 = e2[j].getValueComponents()).length) {
                                    Arrays.sort(v1);
                                    Arrays.sort(v2);
                                    int k = 0;
                                    while (k < v2.length) {
                                        if (!((String)v1[k]).equals(v2[k])) {
                                            return true;
                                        }
                                        ++k;
                                    }
                                } else {
                                    return true;
                                }
                                Enumeration e = e1[j].getDirectiveKeys();
                                if (e != null) {
                                    while (e.hasMoreElements()) {
                                        key2 = (String)e.nextElement();
                                        if (Util.equalsOrNull(e1[j].getDirective(key2), e2[j].getDirective(key2))) continue;
                                        return true;
                                    }
                                }
                                if ((e = e1[j].getKeys()) != null) {
                                    while (e.hasMoreElements()) {
                                        key2 = (String)e.nextElement();
                                        if (Util.equalsOrNull(e1[j].getAttribute(key2), e2[j].getAttribute(key2))) continue;
                                        return true;
                                    }
                                }
                                ++j;
                            }
                            continue;
                        }
                        return true;
                    }
                    return false;
                }
                catch (Exception e) {
                    ApiPlugin.log(e);
                    return false;
                }
            }
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean compareBuildProperties(BuildState state) {
        if (state == null) return true;
        Map<String, String> map = state.getBuildPropertiesState();
        if (map == null) return false;
        IPluginModelBase base = PluginRegistry.findModel((IProject)this.currentproject);
        if (base == null) return false;
        try {
            Map.Entry<String, String> entry;
            IBuildEntry be;
            IBuildModel model = PluginRegistry.createBuildModel((IPluginModelBase)base);
            if (model == null) return false;
            IBuild ibuild = model.getBuild();
            Iterator<Map.Entry<String, String>> i = map.entrySet().iterator();
            do {
                if (i.hasNext()) continue;
                return false;
            } while ((be = ibuild.getEntry((entry = i.next()).getKey())) == null || entry.getValue().equals(Util.deepToString(be.getTokens())));
            return true;
        }
        catch (CoreException ce) {
            ApiPlugin.log(ce);
            return false;
        }
    }

    boolean shouldAbort(IProject project) throws CoreException {
        return !project.isAccessible() || !project.hasNature("org.eclipse.pde.api.tools.apiAnalysisNature") || this.hasBeenBuilt(project) || this.hasFatalProblems(project);
    }

    boolean hasFatalProblems(IProject project) throws CoreException {
        IMarker[] problems;
        boolean hasFatalProblem = false;
        IMarker[] iMarkerArray = problems = project.findMarkers("org.eclipse.jdt.core.problem", true, 0);
        int n = problems.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker iMarker = iMarkerArray[n2];
            Object att = iMarker.getAttribute("severity");
            if (att != null && att instanceof Integer && (Integer)att == 2) {
                hasFatalProblem = true;
                break;
            }
            ++n2;
        }
        if (hasFatalProblem) {
            this.cleanupMarkers((IResource)project);
            IApiProblem problem = ApiProblemFactory.newFatalProblem(Path.EMPTY.toString(), new String[]{project.getName()}, 1);
            this.createMarkerForProblem(0x70000000, "org.eclipse.pde.api.tools.fatal_problem", problem);
            return true;
        }
        this.cleanupFatalMarkers((IResource)project);
        return false;
    }

    boolean worthDoingFullBuild(IProject[] projects) {
        Set<String> apiToolingDependentProjects = this.buildstate.getApiToolingDependentProjects();
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject currentProject = iProjectArray[n2];
            if (Util.isApiProject(currentProject)) {
                if (!apiToolingDependentProjects.contains(currentProject.getName())) {
                    return true;
                }
            } else if (apiToolingDependentProjects.contains(currentProject.getName())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    void buildAll(IApiBaseline baseline, IApiBaseline wbaseline, IProgressMonitor monitor) throws CoreException {
        PDEPreferencesManager prefs = PDECore.getDefault().getPreferencesManager();
        boolean disableAPIAnalysisBuilder = prefs.getBoolean("Preferences.MainPage.disableAPIAnalysisBuilder");
        if (disableAPIAnalysisBuilder) {
            return;
        }
        SubMonitor localMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)BuilderMessages.api_analysis_on_0, (int)4);
        try {
            BuildState.setLastBuiltState(this.currentproject, null);
            this.buildstate = new BuildState();
            localMonitor.subTask(NLS.bind((String)BuilderMessages.ApiAnalysisBuilder_initializing_analyzer, (Object)this.currentproject.getName()));
            this.cleanupMarkers((IResource)this.currentproject);
            IPluginModelBase currentModel = this.getCurrentModel();
            if (currentModel != null) {
                localMonitor.subTask(BuilderMessages.building_workspace_profile);
                localMonitor.split(1);
                String id = currentModel.getBundleDescription().getSymbolicName();
                IApiComponent apiComponent = wbaseline.getApiComponent(id);
                Set<IApiComponent> apiComponentMultiple = wbaseline.getAllApiComponents(id);
                if (!apiComponentMultiple.isEmpty()) {
                    for (IApiComponent iApiComponent : apiComponentMultiple) {
                        Version workspaceBaselineVersion = new Version(iApiComponent.getVersion());
                        Version currentProjectVersion = currentModel.getBundleDescription().getVersion();
                        if (new Version(currentProjectVersion.getMajor(), currentProjectVersion.getMinor(), currentProjectVersion.getMicro()).compareTo(workspaceBaselineVersion) != 0) continue;
                        apiComponent = iApiComponent;
                        break;
                    }
                }
                if (apiComponent != null) {
                    if (this.getAnalyzer() instanceof BaseApiAnalyzer) {
                        ((BaseApiAnalyzer)this.getAnalyzer()).checkBaselineMismatch(baseline, wbaseline);
                    }
                    this.getAnalyzer().analyzeComponent(this.buildstate, null, null, baseline, apiComponent, new BuildContext(), (IProgressMonitor)localMonitor.split(1));
                    localMonitor.split(1);
                    this.createMarkers();
                    localMonitor.split(1);
                }
            }
        }
        finally {
            if (localMonitor != null) {
                localMonitor.done();
            }
        }
    }

    protected void createMarkers() {
        try {
            IResource manifest = Util.getManifestFile(this.currentproject);
            if (manifest != null) {
                manifest.deleteMarkers("org.eclipse.pde.api.tools.version_numbering", false, 0);
            }
            this.currentproject.deleteMarkers("org.eclipse.pde.api.tools.api_profile", false, 0);
            this.currentproject.deleteMarkers("org.eclipse.pde.api.tools.api_component_resolution", false, 0);
        }
        catch (CoreException e) {
            ApiPlugin.log(e);
        }
        IApiProblem[] problems = this.getAnalyzer().getProblems();
        String type = null;
        IApiProblem[] iApiProblemArray = problems;
        int n = problems.length;
        int n2 = 0;
        while (n2 < n) {
            IApiProblem problem = iApiProblemArray[n2];
            int category = problem.getCategory();
            type = this.getProblemTypeFromCategory(category, problem.getKind());
            if (type != null) {
                if (ApiPlugin.DEBUG_BUILDER) {
                    System.out.println("ApiAnalysisBuilder: creating marker for: " + problem.toString());
                }
                this.createMarkerForProblem(category, type, problem);
            }
            ++n2;
        }
    }

    String getProblemTypeFromCategory(int category, int kind) {
        switch (category) {
            case 0x60000000: {
                return "org.eclipse.pde.api.tools.api_component_resolution";
            }
            case 0x50000000: {
                return "org.eclipse.pde.api.tools.api_profile";
            }
            case 0x10000000: {
                return "org.eclipse.pde.api.tools.compatibility";
            }
            case 0x40000000: {
                return "org.eclipse.pde.api.tools.marker.sincetags";
            }
            case 0x20000000: {
                if (kind == 7) {
                    return "org.eclipse.pde.api.tools.unsupported_tags";
                }
                if (kind == 13) {
                    return "org.eclipse.pde.api.tools.unsupported_annotations";
                }
                if (kind == 10) {
                    return "org.eclipse.pde.api.tools.unused_filters";
                }
                return "org.eclipse.pde.api.tools.api_usage";
            }
            case 0x30000000: {
                return "org.eclipse.pde.api.tools.version_numbering";
            }
            case -2147483648: {
                return "org.eclipse.pde.api.tools.marker.apiusescan";
            }
        }
        return null;
    }

    void createMarkerForProblem(int category, String type, IApiProblem problem) {
        IResource resource = this.resolveResource(problem);
        if (resource == null) {
            return;
        }
        try {
            String typeName;
            IWorkspaceRoot root;
            IMarker[] findMarkers;
            if (category == Integer.MIN_VALUE) {
                IMarker[] markers;
                IMarker[] iMarkerArray = markers = resource.findMarkers(type, true, 0);
                int n = markers.length;
                int n2 = 0;
                while (n2 < n) {
                    IMarker marker = iMarkerArray[n2];
                    String msg = marker.getAttribute("message", null);
                    if (msg == null || msg.equalsIgnoreCase(problem.getMessage())) {
                        int problemSeverity;
                        int markerSeverity = marker.getAttribute("severity", 0);
                        if (markerSeverity == (problemSeverity = ApiPlugin.getDefault().getSeverityLevel(ApiProblemFactory.getProblemSeverityId(problem), this.currentproject))) {
                            return;
                        }
                    } else {
                        marker.delete();
                    }
                    ++n2;
                }
            }
            IMarker marker = null;
            marker = problem.getKind() == 2 && category == 0x50000000 ? ((findMarkers = (root = ResourcesPlugin.getWorkspace().getRoot()).findMarkers(type, false, 0)).length == 0 ? root.createMarker(type) : findMarkers[0]) : resource.createMarker(type);
            int line = problem.getLineNumber();
            switch (category) {
                case -2147483648: 
                case 0x30000000: 
                case 0x50000000: 
                case 0x60000000: {
                    break;
                }
                default: {
                    ++line;
                }
            }
            marker.setAttributes(new String[]{"message", "severity", "lineNumber", "charStart", "charEnd", "sourceId", "problemid"}, new Object[]{problem.getMessage(), ApiPlugin.getDefault().getSeverityLevel(ApiProblemFactory.getProblemSeverityId(problem), this.currentproject), line, problem.getCharStart(), problem.getCharEnd(), SOURCE, problem.getId()});
            String[] args = problem.getMessageArguments();
            if (args.length > 0) {
                marker.setAttribute("messagearguments", (Object)this.createArgAttribute(args));
            }
            if ((typeName = problem.getTypeName()) != null) {
                marker.setAttribute("problemTypeName", (Object)typeName);
            }
            if (problem.getExtraMarkerAttributeIds().length > 0) {
                marker.setAttributes(problem.getExtraMarkerAttributeIds(), problem.getExtraMarkerAttributeValues());
            }
            if (ApiPlugin.DEBUG_BUILDER) {
                System.out.println("ApiAnalysisBuilder: Created the marker: " + marker.getId() + " - " + marker.getAttributes().entrySet());
            }
        }
        catch (CoreException e) {
            ApiPlugin.log(e);
            return;
        }
    }

    IResource resolveResource(IApiProblem problem) {
        String resourcePath = problem.getResourcePath();
        if (resourcePath == null) {
            return null;
        }
        IResource resource = this.currentproject.findMember((IPath)new Path(resourcePath));
        if (resource == null) {
            IJavaProject jp = JavaCore.create((IProject)this.currentproject);
            try {
                IType type = jp.findType(problem.getTypeName());
                if (type != null) {
                    return type.getResource();
                }
            }
            catch (JavaModelException javaModelException) {}
            return null;
        }
        if (!resource.isAccessible()) {
            return null;
        }
        return resource;
    }

    String createArgAttribute(String[] args) {
        StringBuilder buff = new StringBuilder();
        int i = 0;
        while (i < args.length) {
            buff.append(args[i]);
            if (i < args.length - 1) {
                buff.append("#");
            }
            ++i;
        }
        return buff.toString();
    }

    protected void clean(IProgressMonitor monitor) throws CoreException {
        this.currentproject = this.getProject();
        SubMonitor localmonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)MessageFormat.format((String)BuilderMessages.CleaningAPIDescription, (Object[])new Object[]{this.currentproject.getName()}), (int)2);
        try {
            this.cleanupUsageMarkers((IResource)this.currentproject);
            this.cleanupCompatibilityMarkers((IResource)this.currentproject);
            this.cleanupUnsupportedTagMarkers((IResource)this.currentproject);
            this.cleanupUnsupportedAnnotationMarkers((IResource)this.currentproject);
            this.currentproject.deleteMarkers("org.eclipse.pde.api.tools.unused_filters", false, 2);
            localmonitor.split(1);
            this.cleanupApiDescription(this.currentproject);
            localmonitor.split(1);
        }
        finally {
            BuildState.setLastBuiltState(this.currentproject, null);
            localmonitor.done();
        }
    }

    void cleanupApiDescription(IProject project) {
        if (project != null && project.exists()) {
            ApiDescriptionManager.getManager().clean(JavaCore.create((IProject)project), true, false);
        }
    }

    IPluginModelBase getCurrentModel() {
        IPluginModelBase[] workspaceModels = PluginRegistry.getWorkspaceModels();
        IPath location = this.currentproject.getLocation();
        IPluginModelBase currentModel = null;
        BundleDescription desc = null;
        int i = 0;
        int max = workspaceModels.length;
        while (i < max) {
            desc = workspaceModels[i].getBundleDescription();
            if (desc != null) {
                Path path = new Path(desc.getLocation());
                if (path.equals((Object)location)) {
                    currentModel = workspaceModels[i];
                    break;
                }
            } else if (ApiPlugin.DEBUG_BUILDER) {
                System.out.println("ApiAnalysisBuilder: Tried to look up bundle description for: " + workspaceModels[i].toString());
            }
            ++i;
        }
        return currentModel;
    }

    IResourceDelta[] getDeltas(IProject[] projects) {
        if (ApiPlugin.DEBUG_BUILDER) {
            System.out.println("ApiAnalysisBuilder: Searching for deltas for build of project: " + this.currentproject.getName());
        }
        ArrayList<IResourceDelta> deltas = new ArrayList<IResourceDelta>();
        IResourceDelta delta = this.getDelta(this.currentproject);
        if (delta != null) {
            if (ApiPlugin.DEBUG_BUILDER) {
                System.out.println("ApiAnalysisBuilder: Found a delta: " + delta);
            }
            deltas.add(delta);
        }
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            delta = this.getDelta(project);
            if (delta != null) {
                if (ApiPlugin.DEBUG_BUILDER) {
                    System.out.println("ApiAnalysisBuilder: Found a delta: " + delta);
                }
                deltas.add(delta);
            }
            ++n2;
        }
        return deltas.toArray(new IResourceDelta[deltas.size()]);
    }

    protected synchronized IApiAnalyzer getAnalyzer() {
        if (this.analyzer == null) {
            this.analyzer = new BaseApiAnalyzer();
        }
        return this.analyzer;
    }

    IProject[] getRequiredProjects(boolean includebinaries) throws CoreException {
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        if (this.currentproject == null || workspaceRoot == null) {
            return new IProject[0];
        }
        ArrayList<IProject> projects = new ArrayList<IProject>();
        try {
            IClasspathEntry[] entries;
            IPackageFragmentRoot[] roots;
            IJavaProject javaProject = JavaCore.create((IProject)this.currentproject);
            HashSet<IPath> blocations = new HashSet<IPath>();
            blocations.add(javaProject.getOutputLocation());
            this.output_locs.put(this.currentproject, blocations);
            HashSet<IPath> slocations = new HashSet<IPath>();
            IPackageFragmentRoot[] iPackageFragmentRootArray = roots = javaProject.getPackageFragmentRoots();
            int n = roots.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
                if (!root.isArchive()) {
                    slocations.add(root.getPath());
                }
                ++n2;
            }
            this.src_locs.put(this.currentproject, slocations);
            IClasspathEntry[] iClasspathEntryArray = entries = javaProject.getResolvedClasspath(true);
            int n3 = entries.length;
            n = 0;
            while (n < n3) {
                IClasspathEntry entry = iClasspathEntryArray[n];
                IPath path = entry.getPath();
                IProject p = null;
                switch (entry.getEntryKind()) {
                    case 2: {
                        p = workspaceRoot.getProject(path.lastSegment());
                        if (!this.isOptional(entry) || p.hasNature("org.eclipse.pde.api.tools.apiAnalysisNature")) break;
                        p = null;
                        break;
                    }
                    case 1: {
                        IResource resource;
                        if (!includebinaries || path.segmentCount() <= 1 || !((resource = workspaceRoot.findMember(path.segment(0))) instanceof IProject)) break;
                        p = (IProject)resource;
                        break;
                    }
                    case 3: {
                        IPath entrypath = entry.getOutputLocation();
                        if (entrypath == null) break;
                        blocations.add(entrypath);
                        break;
                    }
                }
                if (p != null && !projects.contains(p)) {
                    projects.add(p);
                    javaProject = JavaCore.create((IProject)p);
                    HashSet<IPath> bins = new HashSet<IPath>();
                    HashSet<IPath> srcs = new HashSet<IPath>();
                    if (javaProject.exists()) {
                        bins.add(javaProject.getOutputLocation());
                        IClasspathEntry[] source = javaProject.getRawClasspath();
                        IPath entrypath = null;
                        IClasspathEntry[] iClasspathEntryArray2 = source;
                        int n4 = source.length;
                        int n5 = 0;
                        while (n5 < n4) {
                            IClasspathEntry element = iClasspathEntryArray2[n5];
                            if (element.getEntryKind() == 3) {
                                srcs.add(element.getPath());
                                entrypath = element.getOutputLocation();
                                if (entrypath != null) {
                                    bins.add(entrypath);
                                }
                            }
                            ++n5;
                        }
                        this.output_locs.put(p, bins);
                        this.src_locs.put(p, srcs);
                    }
                }
                ++n;
            }
        }
        catch (JavaModelException javaModelException) {
            return new IProject[0];
        }
        IProject[] result = new IProject[projects.size()];
        projects.toArray(result);
        return result;
    }

    HashSet<IPath> getProjectOutputPaths(IProject project) {
        return this.output_locs.get(project);
    }

    boolean isOptional(IClasspathEntry entry) {
        IClasspathAttribute[] attribs;
        IClasspathAttribute[] iClasspathAttributeArray = attribs = entry.getExtraAttributes();
        int n = attribs.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathAttribute attribute = iClasspathAttributeArray[n2];
            if ("optional".equals(attribute.getName()) && "true".equals(attribute.getValue())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public String toString() {
        return NLS.bind((String)BuilderMessages.ApiAnalysisBuilder_builder_for_project, this.currentproject != null ? this.currentproject.getName() : null);
    }
}

