/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.quickaccess;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.commands.ExpressionContext;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandImageService;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.quickaccess.CommandElement;
import org.eclipse.ui.internal.quickaccess.QuickAccessMessages;
import org.eclipse.ui.quickaccess.QuickAccessElement;
import org.eclipse.ui.quickaccess.QuickAccessProvider;

public class CommandProvider
extends QuickAccessProvider {
    private IEvaluationContext currentSnapshot;
    private final Map<String, CommandElement> idToCommand = Collections.synchronizedMap(new HashMap());
    private IHandlerService handlerService;
    private ICommandService commandService;
    private EHandlerService ehandlerService;
    private ICommandImageService commandImageService;
    private boolean allCommandsRetrieved;

    void setSnapshot(IEvaluationContext c) {
        this.reset();
        this.currentSnapshot = c;
    }

    @Override
    public String getId() {
        return "org.eclipse.ui.commands";
    }

    @Override
    public QuickAccessElement getElementForId(String id) {
        this.retrieveCommand(id);
        return this.idToCommand.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QuickAccessElement[] getElements() {
        if (!this.allCommandsRetrieved) {
            ICommandService commandService = this.getCommandService();
            Collection commandIds = commandService.getDefinedCommandIds();
            for (String commandId : commandIds) {
                this.retrieveCommand(commandId);
            }
            this.allCommandsRetrieved = true;
        }
        Map<String, CommandElement> map = this.idToCommand;
        synchronized (map) {
            return (QuickAccessElement[])this.idToCommand.values().stream().toArray(QuickAccessElement[]::new);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void retrieveCommand(String currentCommandId) {
        boolean commandRetrieved = this.idToCommand.containsKey(currentCommandId);
        if (!commandRetrieved) {
            ICommandService commandService = this.getCommandService();
            EHandlerService ehandlerService = this.getEHandlerService();
            Command command = commandService.getCommand(currentCommandId);
            ParameterizedCommand pcmd = new ParameterizedCommand(command, null);
            if (command != null && ehandlerService.canExecute(pcmd)) {
                try {
                    Collection combinations = ParameterizedCommand.generateCombinations((Command)command);
                    for (ParameterizedCommand pc : combinations) {
                        String id = pc.serialize();
                        Map<String, CommandElement> map = this.idToCommand;
                        synchronized (map) {
                            this.idToCommand.put(id, new CommandElement(pc, id, this));
                        }
                    }
                }
                catch (NotDefinedException notDefinedException) {}
            }
        }
    }

    @Override
    public ImageDescriptor getImageDescriptor() {
        return WorkbenchImages.getImageDescriptor("IMG_OBJ_NODE");
    }

    @Override
    public String getName() {
        return QuickAccessMessages.QuickAccess_Commands;
    }

    EHandlerService getEHandlerService() {
        if (this.ehandlerService == null) {
            if (this.currentSnapshot instanceof ExpressionContext) {
                IEclipseContext ctx = ((ExpressionContext)this.currentSnapshot).eclipseContext;
                this.ehandlerService = (EHandlerService)ctx.get(EHandlerService.class);
            } else {
                this.ehandlerService = (EHandlerService)PlatformUI.getWorkbench().getService(EHandlerService.class);
            }
        }
        return this.ehandlerService;
    }

    ICommandService getCommandService() {
        if (this.commandService == null) {
            if (this.currentSnapshot instanceof ExpressionContext) {
                IEclipseContext ctx = ((ExpressionContext)this.currentSnapshot).eclipseContext;
                this.commandService = (ICommandService)ctx.get(ICommandService.class);
            } else {
                this.commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
            }
        }
        return this.commandService;
    }

    IHandlerService getHandlerService() {
        if (this.handlerService == null) {
            if (this.currentSnapshot instanceof ExpressionContext) {
                IEclipseContext ctx = ((ExpressionContext)this.currentSnapshot).eclipseContext;
                this.handlerService = (IHandlerService)ctx.get(IHandlerService.class);
            } else {
                this.handlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
            }
        }
        return this.handlerService;
    }

    public ICommandImageService getCommandImageService() {
        if (this.commandImageService == null) {
            if (this.currentSnapshot instanceof ExpressionContext) {
                IEclipseContext ctx = ((ExpressionContext)this.currentSnapshot).eclipseContext;
                this.commandImageService = (ICommandImageService)ctx.get(ICommandImageService.class);
            } else {
                this.commandImageService = (ICommandImageService)PlatformUI.getWorkbench().getService(ICommandImageService.class);
            }
        }
        return this.commandImageService;
    }

    IEvaluationContext getContextSnapshot() {
        return this.currentSnapshot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doReset() {
        this.allCommandsRetrieved = false;
        Map<String, CommandElement> map = this.idToCommand;
        synchronized (map) {
            this.idToCommand.clear();
        }
        if (this.currentSnapshot instanceof ExpressionContext) {
            ((ExpressionContext)this.currentSnapshot).eclipseContext.dispose();
        }
        this.currentSnapshot = null;
    }
}

