/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.selection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.egit.core.AdapterUtils;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.egit.ui.internal.ResourcePropertyTester;
import org.eclipse.egit.ui.internal.selection.SelectionUtils;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.ui.IWorkingSet;

public class SelectionPropertyTester
extends PropertyTester {
    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        Collection collection = (Collection)receiver;
        if (collection.isEmpty()) {
            return false;
        }
        if ("projectsSingleRepository".equals(property)) {
            Repository repository = SelectionPropertyTester.getRepositoryOfProjects(collection, true);
            return SelectionPropertyTester.testRepositoryProperties(repository, args);
        }
        if ("projectsWithRepositories".equals(property)) {
            Repository repository = SelectionPropertyTester.getRepositoryOfProjects(collection, false);
            return repository != null;
        }
        if ("selectionSingleRepository".equals(property)) {
            return SelectionUtils.getRepository(SelectionPropertyTester.getStructuredSelection(collection)) != null;
        }
        if ("resourcesMultipleRepositories".equals(property)) {
            return this.resourceSelectionContainsMoreThanOneRepository(collection, args);
        }
        if ("selectionMultipleRepositories".equals(property)) {
            return this.selectionContainsMoreThanOneRepository(collection, args);
        }
        if ("resourcesSingleRepository".equals(property)) {
            IStructuredSelection selection = SelectionPropertyTester.getStructuredSelection(collection);
            IResource[] resources = SelectionUtils.getSelectedResources(selection);
            Repository repository = SelectionPropertyTester.getRepositoryOfResources(resources);
            return SelectionPropertyTester.testRepositoryProperties(repository, args);
        }
        if ("fileOrFolderInRepository".equals(property)) {
            RepositoryMapping m;
            if (collection.size() != 1) {
                return false;
            }
            IStructuredSelection selection = SelectionPropertyTester.getStructuredSelection(collection);
            if (selection.size() != 1) {
                return false;
            }
            Object firstElement = selection.getFirstElement();
            IResource resource = AdapterUtils.adaptToAnyResource((Object)firstElement);
            if (resource != null && (resource instanceof IFile || resource instanceof IFolder) && (m = RepositoryMapping.getMapping((IResource)resource)) != null) {
                if (resource instanceof IFolder && resource.equals((Object)m.getContainer())) {
                    return false;
                }
                return SelectionPropertyTester.testRepositoryProperties(m.getRepository(), args);
            }
        } else if ("resourcesAllInRepository".equals(property)) {
            IStructuredSelection selection = SelectionPropertyTester.getStructuredSelection(collection);
            IResource[] resources = SelectionUtils.getSelectedResources(selection);
            Collection<Repository> repositories = SelectionPropertyTester.getRepositories(resources);
            if (repositories.isEmpty()) {
                return false;
            }
            if (args != null && args.length > 0) {
                for (Repository repository : repositories) {
                    if (SelectionPropertyTester.testRepositoryProperties(repository, args)) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    private boolean resourceSelectionContainsMoreThanOneRepository(Collection<?> collection, Object[] args) {
        IStructuredSelection selection = SelectionPropertyTester.getStructuredSelection(collection);
        IResource[] resources = SelectionUtils.getSelectedResources(selection);
        Set<Repository> repos = Stream.of(resources).map(SelectionPropertyTester::getRepositoryOfMapping).collect(Collectors.toSet());
        return this.testMultipleRepositoryProperties(repos, args);
    }

    private boolean selectionContainsMoreThanOneRepository(Collection<?> collection, Object[] args) {
        IStructuredSelection selection = SelectionPropertyTester.getStructuredSelection(collection);
        Repository[] repos = SelectionUtils.getRepositories(selection);
        return this.testMultipleRepositoryProperties(Arrays.asList(repos), args);
    }

    private boolean testMultipleRepositoryProperties(Collection<Repository> repos, Object[] args) {
        if (repos.size() < 2) {
            return false;
        }
        return repos.stream().allMatch(r -> SelectionPropertyTester.testRepositoryProperties(r, args));
    }

    @NonNull
    private static IStructuredSelection getStructuredSelection(Collection<?> collection) {
        Object firstElement = collection.iterator().next();
        if (collection.size() == 1 && firstElement instanceof ITextSelection) {
            return SelectionUtils.getStructuredSelection((ISelection)((ITextSelection)firstElement));
        }
        return new StructuredSelection(new ArrayList(collection));
    }

    private static boolean testRepositoryProperties(Repository repository, Object[] properties) {
        if (repository == null) {
            return false;
        }
        Object[] objectArray = properties;
        int n = properties.length;
        int n2 = 0;
        while (n2 < n) {
            Object arg = objectArray[n2];
            String s = (String)arg;
            if (!ResourcePropertyTester.testRepositoryState(repository, s)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private static Repository getRepositoryOfProjects(Collection<?> collection, boolean single) {
        Repository repo = null;
        for (Object element : collection) {
            IContainer container = (IContainer)AdapterUtils.adapt(element, IProject.class);
            RepositoryMapping mapping = null;
            if (container != null) {
                mapping = RepositoryMapping.getMapping((IResource)container);
            } else {
                container = (IContainer)AdapterUtils.adapt(element, IContainer.class);
                if (container != null) {
                    mapping = RepositoryMapping.getMapping((IResource)container);
                }
            }
            if (container != null && mapping != null && container.equals((Object)mapping.getContainer())) {
                Repository r = mapping.getRepository();
                if (single && r != null && repo != null && r != repo) {
                    return null;
                }
                if (r == null) continue;
                repo = r;
                continue;
            }
            IWorkingSet workingSet = (IWorkingSet)AdapterUtils.adapt(element, IWorkingSet.class);
            if (workingSet == null) continue;
            IAdaptable[] iAdaptableArray = workingSet.getElements();
            int n = iAdaptableArray.length;
            int n2 = 0;
            while (n2 < n) {
                IAdaptable adaptable = iAdaptableArray[n2];
                Repository r = SelectionPropertyTester.getRepositoryOfProject(adaptable);
                if (single && r != null && repo != null && r != repo) {
                    return null;
                }
                if (r != null) {
                    repo = r;
                }
                ++n2;
            }
        }
        return repo;
    }

    private static Repository getRepositoryOfResources(IResource[] resources) {
        Repository repo = null;
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            Repository r = SelectionPropertyTester.getRepositoryOfMapping(resource);
            if (r != null && repo != null && r != repo) {
                return null;
            }
            if (r != null) {
                repo = r;
            }
            ++n2;
        }
        return repo;
    }

    private static Collection<Repository> getRepositories(IResource[] resources) {
        HashSet<Repository> result = new HashSet<Repository>();
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            Repository r = SelectionPropertyTester.getRepositoryOfMapping(resource);
            if (r == null) {
                return Collections.emptySet();
            }
            result.add(r);
            ++n2;
        }
        return result;
    }

    private static Repository getRepositoryOfProject(Object object) {
        IProject project = (IProject)AdapterUtils.adapt((Object)object, IProject.class);
        if (project != null) {
            return SelectionPropertyTester.getRepositoryOfMapping((IResource)project);
        }
        return null;
    }

    private static Repository getRepositoryOfMapping(IResource resource) {
        RepositoryMapping mapping = RepositoryMapping.getMapping((IResource)resource);
        if (mapping != null) {
            return mapping.getRepository();
        }
        return null;
    }
}

