/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ua.ui.editor.cheatsheet.simple.details;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.pde.internal.core.util.PDETextHelper;
import org.eclipse.pde.internal.ua.core.cheatsheet.simple.ISimpleCSHelpObject;
import org.eclipse.pde.internal.ua.ui.editor.cheatsheet.CSAbstractSubDetails;
import org.eclipse.pde.internal.ua.ui.editor.cheatsheet.ICSMaster;
import org.eclipse.pde.internal.ua.ui.editor.cheatsheet.simple.details.SimpleDetailsMessages;
import org.eclipse.pde.internal.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ui.parts.ComboPart;
import org.eclipse.pde.internal.ui.util.FileExtensionsFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class SimpleCSHelpDetails
extends CSAbstractSubDetails {
    private Text fHelpText = null;
    private ComboPart fHelpCombo = null;
    private Label fHelpLabel = null;
    private Button fHelpBrowse = null;
    private ISimpleCSHelpObject fHelpObject = null;
    private Section fHelpSection = null;
    private boolean fBlockListeners = false;
    private static final String F_NO_HELP = SimpleDetailsMessages.SimpleCSHelpDetails_none;
    private static final String F_HELP_CONTEXT_ID = SimpleDetailsMessages.SimpleCSHelpDetails_helpContextID;
    private static final String F_HELP_DOCUMENT_LINK = SimpleDetailsMessages.SimpleCSHelpDetails_helpDocumentLink;

    public SimpleCSHelpDetails(ICSMaster section) {
        super(section, "simplecs-context");
    }

    public void setData(ISimpleCSHelpObject object) {
        this.fHelpObject = object;
    }

    @Override
    public void createDetails(Composite parent) {
        int columnSpan = 3;
        FormToolkit toolkit = this.getToolkit();
        GridData data = null;
        Label label = null;
        Color foreground = toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE");
        this.fHelpSection = toolkit.createSection(parent, 386);
        this.fHelpSection.clientVerticalSpacing = 6;
        this.fHelpSection.setText(SimpleDetailsMessages.SimpleCSHelpDetails_helpSectionText);
        this.fHelpSection.setDescription(SimpleDetailsMessages.SimpleCSHelpDetails_helpSectionDesc);
        this.fHelpSection.setLayout((Layout)FormLayoutFactory.createClearGridLayout((boolean)false, (int)1));
        data = new GridData(768);
        this.fHelpSection.setLayoutData((Object)data);
        Composite helpSectionClient = toolkit.createComposite((Composite)this.fHelpSection);
        helpSectionClient.setLayout((Layout)FormLayoutFactory.createSectionClientGridLayout((boolean)false, (int)columnSpan));
        label = toolkit.createLabel(helpSectionClient, SimpleDetailsMessages.SimpleCSHelpDetails_attrType, 64);
        label.setForeground(foreground);
        this.fHelpCombo = new ComboPart();
        this.fHelpCombo.createControl(helpSectionClient, toolkit, 8);
        GridData comboData = new GridData(768);
        comboData.horizontalSpan = columnSpan - 1;
        this.fHelpCombo.getControl().setLayoutData((Object)comboData);
        this.fHelpCombo.add(F_NO_HELP);
        this.fHelpCombo.add(F_HELP_CONTEXT_ID);
        this.fHelpCombo.add(F_HELP_DOCUMENT_LINK);
        this.fHelpCombo.setText(F_NO_HELP);
        this.fHelpLabel = toolkit.createLabel(helpSectionClient, SimpleDetailsMessages.SimpleCSHelpDetails_attrValue, 64);
        this.fHelpLabel.setForeground(foreground);
        this.fHelpText = toolkit.createText(helpSectionClient, null);
        data = new GridData(768);
        this.fHelpText.setLayoutData((Object)data);
        this.fHelpBrowse = toolkit.createButton(helpSectionClient, SimpleDetailsMessages.SimpleCSHelpDetails_browse, 8);
        toolkit.paintBordersFor(helpSectionClient);
        this.fHelpSection.setClient((Control)helpSectionClient);
        this.markDetailsPart((Control)this.fHelpSection);
    }

    @Override
    public void hookListeners() {
        this.fHelpCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (SimpleCSHelpDetails.this.fHelpObject == null) {
                    return;
                }
                String selection = SimpleCSHelpDetails.this.fHelpCombo.getSelection();
                if (!selection.equals(F_NO_HELP)) {
                    if (selection.equals(F_HELP_CONTEXT_ID)) {
                        SimpleCSHelpDetails.this.fHelpObject.setHref(null);
                        SimpleCSHelpDetails.this.fHelpBrowse.setEnabled(false);
                    } else {
                        SimpleCSHelpDetails.this.fHelpObject.setContextId(null);
                        SimpleCSHelpDetails.this.fHelpBrowse.setEnabled(true);
                    }
                    SimpleCSHelpDetails.this.fHelpLabel.setVisible(true);
                    SimpleCSHelpDetails.this.fHelpText.setVisible(true);
                    SimpleCSHelpDetails.this.fHelpBrowse.setVisible(true);
                    SimpleCSHelpDetails.this.fHelpText.setFocus();
                    SimpleCSHelpDetails.this.fHelpText.setText("");
                    SimpleCSHelpDetails.this.fHelpText.setToolTipText("");
                } else {
                    SimpleCSHelpDetails.this.fHelpLabel.setVisible(false);
                    SimpleCSHelpDetails.this.fHelpText.setVisible(false);
                    SimpleCSHelpDetails.this.fHelpBrowse.setVisible(false);
                    SimpleCSHelpDetails.this.fHelpObject.setContextId(null);
                    SimpleCSHelpDetails.this.fHelpObject.setHref(null);
                }
            }
        });
        this.fHelpText.addModifyListener(e -> {
            if (this.fBlockListeners) {
                return;
            }
            if (this.fHelpObject == null) {
                return;
            }
            String selection = this.fHelpCombo.getSelection();
            if (selection.equals(F_HELP_CONTEXT_ID)) {
                this.fHelpObject.setContextId(this.fHelpText.getText());
            } else {
                this.fHelpObject.setHref(this.fHelpText.getText());
            }
            this.fHelpText.setToolTipText(this.fHelpText.getText());
        });
        this.fHelpBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SimpleCSHelpDetails.this.handleButtonSelectedEventBrowse(e);
            }
        });
    }

    private void handleButtonSelectedEventBrowse(SelectionEvent event) {
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getManagedForm().getForm().getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        dialog.setAllowMultiple(false);
        dialog.setTitle(SimpleDetailsMessages.SimpleCSHelpDetails_dialogTitle);
        dialog.setMessage(SimpleDetailsMessages.SimpleCSHelpDetails_dialogMessage);
        FileExtensionsFilter filter = new FileExtensionsFilter();
        filter.addFileExtension("htm");
        filter.addFileExtension("html");
        filter.addFileExtension("shtml");
        filter.addFileExtension("xhtml");
        dialog.addFilter((ViewerFilter)filter);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        dialog.setInput((Object)root);
        Path path = new Path(this.fHelpText.getText());
        if (!path.isEmpty() && path.isAbsolute() && path.segmentCount() > 1) {
            IFile helpDocumentFile = root.getFile((IPath)path);
            dialog.setInitialSelection((Object)helpDocumentFile);
        }
        if (dialog.open() == 0) {
            Object result = dialog.getFirstResult();
            if (!(result instanceof IFile)) {
                return;
            }
            IFile file = (IFile)result;
            String absolutePath = file.getFullPath().toPortableString();
            this.fHelpText.setText(absolutePath);
        }
    }

    @Override
    public void updateFields() {
        if (this.fHelpObject == null) {
            return;
        }
        boolean editable = this.isEditableElement();
        boolean expanded = false;
        this.fBlockListeners = true;
        if (PDETextHelper.isDefined((String)this.fHelpObject.getContextId())) {
            this.fHelpText.setText(this.fHelpObject.getContextId());
            this.fHelpText.setToolTipText(this.fHelpObject.getContextId());
            this.fHelpCombo.setText(F_HELP_CONTEXT_ID);
            expanded = true;
        } else if (PDETextHelper.isDefined((String)this.fHelpObject.getHref())) {
            this.fHelpText.setText(this.fHelpObject.getHref());
            this.fHelpText.setToolTipText(this.fHelpObject.getHref());
            this.fHelpCombo.setText(F_HELP_DOCUMENT_LINK);
            expanded = true;
        } else {
            this.fHelpCombo.setText(F_NO_HELP);
        }
        this.fBlockListeners = false;
        this.fHelpSection.setExpanded(expanded);
        this.fHelpText.setEnabled(editable);
        this.fHelpText.setVisible(expanded);
        this.fHelpLabel.setVisible(expanded);
        this.fHelpBrowse.setVisible(expanded);
        this.fHelpCombo.setEnabled(editable);
    }

    public void commit(boolean onSave) {
        super.commit(onSave);
    }
}

