/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.LineAttributes;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.cairo.Cairo;
import org.eclipse.swt.internal.gtk.GDK;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkRGBA;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.gtk.PangoAttribute;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Tree;

public final class GC
extends Resource {
    public long handle;
    Drawable drawable;
    GCData data;
    private double[] cairoTransformationMatrix;
    private double[] currentTransform;
    private Rectangle clipping;
    static final int FOREGROUND = 1;
    static final int BACKGROUND = 2;
    static final int FONT = 4;
    static final int LINE_STYLE = 8;
    static final int LINE_CAP = 16;
    static final int LINE_JOIN = 32;
    static final int LINE_WIDTH = 64;
    static final int LINE_MITERLIMIT = 128;
    static final int BACKGROUND_BG = 256;
    static final int DRAW_OFFSET = 512;
    static final int DRAW = 761;
    static final int FILL = 2;
    static final float[] LINE_DOT = new float[]{1.0f, 1.0f};
    static final float[] LINE_DASH = new float[]{3.0f, 1.0f};
    static final float[] LINE_DASHDOT = new float[]{3.0f, 1.0f, 1.0f, 1.0f};
    static final float[] LINE_DASHDOTDOT = new float[]{3.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f};
    static final float[] LINE_DOT_ZERO = new float[]{3.0f, 3.0f};
    static final float[] LINE_DASH_ZERO = new float[]{18.0f, 6.0f};
    static final float[] LINE_DASHDOT_ZERO = new float[]{9.0f, 6.0f, 3.0f, 6.0f};
    static final float[] LINE_DASHDOTDOT_ZERO = new float[]{9.0f, 3.0f, 3.0f, 3.0f, 3.0f, 3.0f};

    GC() {
    }

    public GC(Drawable drawable) {
        this(drawable, 0);
    }

    public GC(Drawable drawable, int style) {
        if (drawable == null) {
            SWT.error(4);
        }
        GCData data = new GCData();
        data.style = GC.checkStyle(style);
        long gdkGC = drawable.internal_new_GC(data);
        Device device = data.device;
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        this.device = data.device = device;
        this.init(drawable, data, gdkGC);
        this.init();
    }

    static void addCairoString(long cairo, String string, float x, float y, Font font) {
        byte[] buffer = Converter.wcsToMbcs(string, true);
        long layout = OS.pango_cairo_create_layout(cairo);
        if (layout == 0L) {
            SWT.error(2);
        }
        OS.pango_layout_set_text(layout, buffer, -1);
        OS.pango_layout_set_font_description(layout, font.handle);
        double[] currentX = new double[1];
        double[] currentY = new double[1];
        Cairo.cairo_get_current_point(cairo, currentX, currentY);
        if (currentX[0] != (double)x || currentY[0] != (double)y) {
            Cairo.cairo_move_to(cairo, x, y);
        }
        OS.pango_cairo_layout_path(cairo, layout);
        OS.g_object_unref(layout);
    }

    static int checkStyle(int style) {
        if ((style & 0x2000000) != 0) {
            style &= 0xFBFFFFFF;
        }
        return style & 0x6000000;
    }

    public static GC gtk_new(long handle, GCData data) {
        GC gc = new GC();
        gc.device = data.device;
        gc.init(null, data, handle);
        return gc;
    }

    public static GC gtk_new(Drawable drawable, GCData data) {
        GC gc = new GC();
        long gdkGC = drawable.internal_new_GC(data);
        gc.device = data.device;
        gc.init(drawable, data, gdkGC);
        return gc;
    }

    void checkGC(int mask) {
        int state = this.data.state;
        if ((state & mask) == mask) {
            return;
        }
        state = (state ^ mask) & mask;
        this.data.state |= mask;
        long cairo = this.data.cairo;
        if ((state & 3) != 0) {
            Pattern pattern;
            GdkColor color = null;
            GdkRGBA colorRGBA = null;
            if ((state & 1) != 0) {
                if (GTK.GTK3) {
                    colorRGBA = this.data.foregroundRGBA;
                } else {
                    color = this.data.foreground;
                }
                pattern = this.data.foregroundPattern;
                this.data.state &= 0xFFFFFFFD;
            } else {
                if (GTK.GTK3) {
                    colorRGBA = this.data.backgroundRGBA;
                } else {
                    color = this.data.background;
                }
                pattern = this.data.backgroundPattern;
                this.data.state &= 0xFFFFFFFE;
            }
            if (pattern != null) {
                if ((this.data.style & 0x8000000) != 0 && pattern.surface != 0L) {
                    long newPattern = Cairo.cairo_pattern_create_for_surface(pattern.surface);
                    if (newPattern == 0L) {
                        SWT.error(2);
                    }
                    Cairo.cairo_pattern_set_extend(newPattern, 1);
                    double[] matrix = new double[]{-1.0, 0.0, 0.0, 1.0, 0.0, 0.0};
                    Cairo.cairo_pattern_set_matrix(newPattern, matrix);
                    Cairo.cairo_set_source(cairo, newPattern);
                    Cairo.cairo_pattern_destroy(newPattern);
                } else {
                    Cairo.cairo_set_source(cairo, pattern.handle);
                }
            } else if (GTK.GTK3) {
                Cairo.cairo_set_source_rgba(cairo, colorRGBA.red, colorRGBA.green, colorRGBA.blue, (float)this.data.alpha / 255.0f);
            } else {
                Cairo.cairo_set_source_rgba(cairo, (float)(color.red & 0xFFFF) / 65535.0f, (float)(color.green & 0xFFFF) / 65535.0f, (float)(color.blue & 0xFFFF) / 65535.0f, (float)this.data.alpha / 255.0f);
            }
        }
        if ((state & 4) != 0 && this.data.layout != 0L) {
            Font font = this.data.font;
            OS.pango_layout_set_font_description(this.data.layout, font.handle);
        }
        if ((state & 0x10) != 0) {
            int cap_style = 0;
            switch (this.data.lineCap) {
                case 2: {
                    cap_style = 1;
                    break;
                }
                case 1: {
                    cap_style = 0;
                    break;
                }
                case 3: {
                    cap_style = 2;
                }
            }
            Cairo.cairo_set_line_cap(cairo, cap_style);
        }
        if ((state & 0x20) != 0) {
            int join_style = 0;
            switch (this.data.lineJoin) {
                case 1: {
                    join_style = 0;
                    break;
                }
                case 2: {
                    join_style = 1;
                    break;
                }
                case 3: {
                    join_style = 2;
                }
            }
            Cairo.cairo_set_line_join(cairo, join_style);
        }
        if ((state & 0x40) != 0) {
            Cairo.cairo_set_line_width(cairo, this.data.lineWidth == 0.0f ? (float)DPIUtil.autoScaleUp(this.drawable, 1) : this.data.lineWidth);
            switch (this.data.lineStyle) {
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    state |= 8;
                }
            }
        }
        if ((state & 8) != 0) {
            float dashesOffset = 0.0f;
            float[] dashes = null;
            float width = this.data.lineWidth;
            switch (this.data.lineStyle) {
                case 1: {
                    break;
                }
                case 2: {
                    dashes = width != 0.0f ? LINE_DASH : LINE_DASH_ZERO;
                    break;
                }
                case 3: {
                    dashes = width != 0.0f ? LINE_DOT : LINE_DOT_ZERO;
                    break;
                }
                case 4: {
                    dashes = width != 0.0f ? LINE_DASHDOT : LINE_DASHDOT_ZERO;
                    break;
                }
                case 5: {
                    dashes = width != 0.0f ? LINE_DASHDOTDOT : LINE_DASHDOTDOT_ZERO;
                    break;
                }
                case 6: {
                    dashes = this.data.lineDashes;
                }
            }
            if (dashes != null) {
                dashesOffset = this.data.lineDashesOffset;
                double[] cairoDashes = new double[dashes.length];
                int i = 0;
                while (i < cairoDashes.length) {
                    cairoDashes[i] = width == 0.0f || this.data.lineStyle == 6 ? dashes[i] : dashes[i] * width;
                    ++i;
                }
                Cairo.cairo_set_dash(cairo, cairoDashes, cairoDashes.length, dashesOffset);
            } else {
                Cairo.cairo_set_dash(cairo, null, 0, 0.0);
            }
        }
        if ((state & 0x80) != 0) {
            Cairo.cairo_set_miter_limit(cairo, this.data.lineMiterLimit);
        }
        if ((state & 0x200) != 0) {
            double strokeWidth;
            this.data.cairoYoffset = 0.0;
            this.data.cairoXoffset = 0.0;
            double[] matrix = new double[6];
            Cairo.cairo_get_matrix(cairo, matrix);
            double[] dx = new double[]{1.0};
            double[] dy = new double[]{1.0};
            Cairo.cairo_user_to_device_distance(cairo, dx, dy);
            double scaling = dx[0];
            if (scaling < 0.0) {
                scaling = -scaling;
            }
            if ((strokeWidth = (double)this.data.lineWidth * scaling) == 0.0 || (int)strokeWidth % 2 == 1) {
                this.data.cairoXoffset = 0.5 / scaling;
            }
            if ((scaling = dy[0]) < 0.0) {
                scaling = -scaling;
            }
            if ((strokeWidth = (double)this.data.lineWidth * scaling) == 0.0 || (int)strokeWidth % 2 == 1) {
                this.data.cairoYoffset = 0.5 / scaling;
            }
        }
    }

    long convertRgn(long rgn, double[] matrix) {
        long newRgn = GDK.gdk_region_new();
        if (this.isIdentity(matrix)) {
            GDK.gdk_region_union(newRgn, rgn);
            return newRgn;
        }
        int[] nRects = new int[1];
        long[] rects = new long[1];
        Region.gdk_region_get_rectangles(rgn, rects, nRects);
        GdkRectangle rect = new GdkRectangle();
        int[] pointArray = new int[8];
        double[] x = new double[1];
        double[] y = new double[1];
        int i = 0;
        while (i < nRects[0]) {
            OS.memmove(rect, rects[0] + (long)(i * GdkRectangle.sizeof), (long)GdkRectangle.sizeof);
            x[0] = rect.x;
            y[0] = rect.y;
            Cairo.cairo_matrix_transform_point(matrix, x, y);
            pointArray[0] = (int)x[0];
            pointArray[1] = (int)y[0];
            x[0] = rect.x + rect.width;
            y[0] = rect.y;
            Cairo.cairo_matrix_transform_point(matrix, x, y);
            pointArray[2] = (int)Math.round(x[0]);
            pointArray[3] = (int)y[0];
            x[0] = rect.x + rect.width;
            y[0] = rect.y + rect.height;
            Cairo.cairo_matrix_transform_point(matrix, x, y);
            pointArray[4] = (int)Math.round(x[0]);
            pointArray[5] = (int)Math.round(y[0]);
            x[0] = rect.x;
            y[0] = rect.y + rect.height;
            Cairo.cairo_matrix_transform_point(matrix, x, y);
            pointArray[6] = (int)x[0];
            pointArray[7] = (int)Math.round(y[0]);
            long polyRgn = Region.gdk_region_polygon(pointArray, pointArray.length / 2, 0);
            GDK.gdk_region_union(newRgn, polyRgn);
            GDK.gdk_region_destroy(polyRgn);
            ++i;
        }
        if (rects[0] != 0L) {
            OS.g_free(rects[0]);
        }
        return newRgn;
    }

    public void copyArea(Image image, int x, int y) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (image == null) {
            SWT.error(4);
        }
        if (image.type != 0 || image.isDisposed()) {
            SWT.error(5);
        }
        Point loc = DPIUtil.autoScaleUp(this.drawable, new Point(x, y));
        this.copyAreaInPixels(image, loc.x, loc.y);
    }

    void copyAreaInPixels(Image image, int x, int y) {
        long cairo = Cairo.cairo_create(image.surface);
        if (cairo == 0L) {
            SWT.error(2);
        }
        Cairo.cairo_translate(cairo, -x, -y);
        Cairo.cairo_push_group(cairo);
        if (this.data.image != null) {
            Cairo.cairo_set_source_surface(cairo, this.data.image.surface, 0.0, 0.0);
        } else if (this.data.drawable != 0L) {
            GDK.gdk_cairo_set_source_window(cairo, this.data.drawable, 0, 0);
        } else {
            Cairo.cairo_destroy(cairo);
            return;
        }
        Cairo.cairo_set_operator(cairo, 1);
        Cairo.cairo_paint(cairo);
        Cairo.cairo_pop_group_to_source(cairo);
        Cairo.cairo_paint(cairo);
        Cairo.cairo_destroy(cairo);
    }

    public void copyArea(int srcX, int srcY, int width, int height, int destX, int destY) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        Rectangle src = DPIUtil.autoScaleUp(this.drawable, new Rectangle(srcX, srcY, width, height));
        Point dest = DPIUtil.autoScaleUp(this.drawable, new Point(destX, destY));
        this.copyAreaInPixels(src.x, src.y, src.width, src.height, dest.x, dest.y);
    }

    void copyAreaInPixels(int srcX, int srcY, int width, int height, int destX, int destY) {
        this.copyAreaInPixels(srcX, srcY, width, height, destX, destY, true);
    }

    public void copyArea(int srcX, int srcY, int width, int height, int destX, int destY, boolean paint) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        Rectangle srcLoc = DPIUtil.autoScaleUp(this.drawable, new Rectangle(srcX, srcY, width, height));
        Point destLoc = DPIUtil.autoScaleUp(this.drawable, new Point(destX, destY));
        this.copyAreaInPixels(srcLoc.x, srcLoc.y, srcLoc.width, srcLoc.height, destLoc.x, destLoc.y, paint);
    }

    void copyAreaInPixels(int srcX, int srcY, int width, int height, int destX, int destY, boolean paint) {
        if (width <= 0 || height <= 0) {
            return;
        }
        int deltaX = destX - srcX;
        int deltaY = destY - srcY;
        if (deltaX == 0 && deltaY == 0) {
            return;
        }
        long drawable = this.data.drawable;
        if (this.data.image != null) {
            Cairo.cairo_set_source_surface(this.handle, this.data.image.surface, deltaX, deltaY);
            Cairo.cairo_rectangle(this.handle, destX, destY, width, height);
            Cairo.cairo_set_operator(this.handle, 1);
            Cairo.cairo_fill(this.handle);
        } else if (drawable != 0L) {
            Cairo.cairo_save(this.handle);
            Cairo.cairo_rectangle(this.handle, destX, destY, width, height);
            Cairo.cairo_clip(this.handle);
            Cairo.cairo_translate(this.handle, deltaX, deltaY);
            Cairo.cairo_set_operator(this.handle, 1);
            Cairo.cairo_push_group(this.handle);
            GDK.gdk_cairo_set_source_window(this.handle, drawable, 0, 0);
            Cairo.cairo_paint(this.handle);
            Cairo.cairo_pop_group_to_source(this.handle);
            Cairo.cairo_rectangle(this.handle, destX - deltaX, destY - deltaY, width, height);
            Cairo.cairo_clip(this.handle);
            Cairo.cairo_paint(this.handle);
            Cairo.cairo_restore(this.handle);
            if (paint) {
                long visibleRegion = GTK.GTK3 ? GDK.gdk_window_get_visible_region(drawable) : GDK.gdk_drawable_get_visible_region(drawable);
                GdkRectangle srcRect = new GdkRectangle();
                srcRect.x = srcX;
                srcRect.y = srcY;
                srcRect.width = width;
                srcRect.height = height;
                long copyRegion = GDK.gdk_region_rectangle(srcRect);
                GDK.gdk_region_intersect(copyRegion, visibleRegion);
                long invalidateRegion = GDK.gdk_region_rectangle(srcRect);
                GDK.gdk_region_subtract(invalidateRegion, visibleRegion);
                GDK.gdk_region_offset(invalidateRegion, deltaX, deltaY);
                GDK.gdk_window_invalidate_region(drawable, invalidateRegion, false);
                GDK.gdk_region_destroy(visibleRegion);
                GDK.gdk_region_destroy(copyRegion);
                GDK.gdk_region_destroy(invalidateRegion);
            }
        }
        if (this.data.image == null & paint) {
            boolean disjoint = destX + width < srcX || srcX + width < destX || destY + height < srcY || srcY + height < destY;
            GdkRectangle rect = new GdkRectangle();
            if (disjoint) {
                rect.x = srcX;
                rect.y = srcY;
                rect.width = Math.max(0, width);
                rect.height = Math.max(0, height);
                GDK.gdk_window_invalidate_rect(drawable, rect, false);
            } else {
                if (deltaX != 0) {
                    int newX = destX - deltaX;
                    if (deltaX < 0) {
                        newX = destX + width;
                    }
                    rect.x = newX;
                    rect.y = srcY;
                    rect.width = Math.abs(deltaX);
                    rect.height = Math.max(0, height);
                    GDK.gdk_window_invalidate_rect(drawable, rect, false);
                }
                if (deltaY != 0) {
                    int newY = destY - deltaY;
                    if (deltaY < 0) {
                        newY = destY + height;
                    }
                    rect.x = srcX;
                    rect.y = newY;
                    rect.width = Math.max(0, width);
                    rect.height = Math.abs(deltaY);
                    GDK.gdk_window_invalidate_rect(drawable, rect, false);
                }
            }
        }
    }

    void createLayout() {
        long context = GDK.gdk_pango_context_get();
        if (context == 0L) {
            SWT.error(2);
        }
        this.data.context = context;
        long layout = OS.pango_layout_new(context);
        if (layout == 0L) {
            SWT.error(2);
        }
        this.data.layout = layout;
        OS.pango_context_set_language(context, GTK.gtk_get_default_language());
        OS.pango_context_set_base_dir(context, (this.data.style & 0x8000000) != 0 ? 1 : 0);
        OS.pango_layout_set_auto_dir(layout, false);
    }

    void disposeLayout() {
        this.data.string = null;
        if (this.data.context != 0L) {
            OS.g_object_unref(this.data.context);
        }
        if (this.data.layout != 0L) {
            OS.g_object_unref(this.data.layout);
        }
        this.data.context = 0L;
        this.data.layout = 0L;
    }

    @Override
    void destroy() {
        Image image;
        if (this.data.disposeCairo) {
            long cairo = this.data.cairo;
            Cairo.cairo_destroy(cairo);
        }
        this.data.cairo = 0L;
        long clipRgn = this.data.clipRgn;
        if (clipRgn != 0L) {
            GDK.gdk_region_destroy(clipRgn);
        }
        if ((image = this.data.image) != null) {
            image.memGC = null;
            if (image.transparentPixel != -1) {
                image.createMask();
            }
        }
        this.disposeLayout();
        if (this.drawable != null) {
            this.drawable.internal_dispose_GC(this.handle, this.data);
        }
        this.data.clipRgn = 0L;
        this.data.drawable = 0L;
        this.drawable = null;
        this.handle = 0L;
        this.data.image = null;
        this.data.string = null;
        this.data = null;
    }

    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        Rectangle loc = DPIUtil.autoScaleUp(this.drawable, new Rectangle(x, y, width, height));
        this.drawArcInPixels(loc.x, loc.y, loc.width, loc.height, startAngle, arcAngle);
    }

    void drawArcInPixels(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.checkGC(761);
        if (width < 0) {
            x += width;
            width = -width;
        }
        if (height < 0) {
            y += height;
            height = -height;
        }
        if (width == 0 || height == 0 || arcAngle == 0) {
            return;
        }
        long cairo = this.data.cairo;
        double xOffset = this.data.cairoXoffset;
        double yOffset = this.data.cairoYoffset;
        if (width == height) {
            if (arcAngle >= 0) {
                Cairo.cairo_arc_negative(cairo, (double)x + xOffset + (double)((float)width / 2.0f), (double)y + yOffset + (double)((float)height / 2.0f), (float)width / 2.0f, (float)(-startAngle) * (float)Math.PI / 180.0f, (float)(-(startAngle + arcAngle)) * (float)Math.PI / 180.0f);
            } else {
                Cairo.cairo_arc(cairo, (double)x + xOffset + (double)((float)width / 2.0f), (double)y + yOffset + (double)((float)height / 2.0f), (float)width / 2.0f, (float)(-startAngle) * (float)Math.PI / 180.0f, (float)(-(startAngle + arcAngle)) * (float)Math.PI / 180.0f);
            }
        } else {
            Cairo.cairo_save(cairo);
            Cairo.cairo_translate(cairo, (double)x + xOffset + (double)((float)width / 2.0f), (double)y + yOffset + (double)((float)height / 2.0f));
            Cairo.cairo_scale(cairo, (float)width / 2.0f, (float)height / 2.0f);
            if (arcAngle >= 0) {
                Cairo.cairo_arc_negative(cairo, 0.0, 0.0, 1.0, (float)(-startAngle) * (float)Math.PI / 180.0f, (float)(-(startAngle + arcAngle)) * (float)Math.PI / 180.0f);
            } else {
                Cairo.cairo_arc(cairo, 0.0, 0.0, 1.0, (float)(-startAngle) * (float)Math.PI / 180.0f, (float)(-(startAngle + arcAngle)) * (float)Math.PI / 180.0f);
            }
            Cairo.cairo_restore(cairo);
        }
        Cairo.cairo_stroke(cairo);
    }

    public void drawFocus(int x, int y, int width, int height) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        Rectangle loc = DPIUtil.autoScaleUp(this.drawable, new Rectangle(x, y, width, height));
        this.drawFocusInPixels(loc.x, loc.y, loc.width, loc.height);
    }

    void drawFocusInPixels(int x, int y, int width, int height) {
        long cairo = this.data.cairo;
        this.checkGC(1);
        if (GTK.GTK3) {
            long context = GTK.gtk_widget_get_style_context(this.data.device.shellHandle);
            GTK.gtk_render_focus(context, cairo, x, y, width, height);
        } else {
            int[] lineWidth = new int[1];
            GTK.gtk_widget_style_get(this.data.device.shellHandle, OS.focus_line_width, lineWidth, 0L);
            Cairo.cairo_save(cairo);
            Cairo.cairo_set_line_width(cairo, lineWidth[0]);
            double[] dashes = new double[]{1.0, 1.0};
            double dash_offset = (float)(-lineWidth[0]) / 2.0f;
            while (dash_offset < 0.0) {
                dash_offset += 2.0;
            }
            Cairo.cairo_set_dash(cairo, dashes, dashes.length, dash_offset);
            Cairo.cairo_rectangle(cairo, (float)x + (float)lineWidth[0] / 2.0f, (float)y + (float)lineWidth[0] / 2.0f, width, height);
            Cairo.cairo_stroke(cairo);
            Cairo.cairo_restore(cairo);
        }
    }

    public void drawImage(Image image, int x, int y) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (image == null) {
            SWT.error(4);
        }
        if (image.isDisposed()) {
            SWT.error(5);
        }
        Point loc = DPIUtil.autoScaleUp(this.drawable, new Point(x, y));
        this.drawImageInPixels(image, loc.x, loc.y);
    }

    void drawImageInPixels(Image image, int x, int y) {
        this.drawImage(image, 0, 0, -1, -1, x, y, -1, -1, true);
    }

    public void drawImage(Image image, int srcX, int srcY, int srcWidth, int srcHeight, int destX, int destY, int destWidth, int destHeight) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (srcWidth == 0 || srcHeight == 0 || destWidth == 0 || destHeight == 0) {
            return;
        }
        if (srcX < 0 || srcY < 0 || srcWidth < 0 || srcHeight < 0 || destWidth < 0 || destHeight < 0) {
            SWT.error(5);
        }
        if (image == null) {
            SWT.error(4);
        }
        if (image.isDisposed()) {
            SWT.error(5);
        }
        Rectangle srcRect = DPIUtil.autoScaleUp(this.drawable, new Rectangle(srcX, srcY, srcWidth, srcHeight));
        Rectangle destRect = DPIUtil.autoScaleUp(this.drawable, new Rectangle(destX, destY, destWidth, destHeight));
        this.drawImage(image, srcRect.x, srcRect.y, srcRect.width, srcRect.height, destRect.x, destRect.y, destRect.width, destRect.height, false);
    }

    void drawImage(Image srcImage, int srcX, int srcY, int srcWidth, int srcHeight, int destX, int destY, int destWidth, int destHeight, boolean simple) {
        srcImage.refreshImageForZoom();
        int imgWidth = srcImage.width;
        int imgHeight = srcImage.height;
        if (simple) {
            srcWidth = destWidth = imgWidth;
            srcHeight = destHeight = imgHeight;
        } else {
            boolean bl = simple = srcX == 0 && srcY == 0 && srcWidth == destWidth && destWidth == imgWidth && srcHeight == destHeight && destHeight == imgHeight;
            if (srcX + srcWidth > imgWidth + 1 || srcY + srcHeight > imgHeight + 1) {
                SWT.error(5);
            }
        }
        long cairo = this.data.cairo;
        if (this.data.alpha != 0) {
            srcImage.createSurface();
            Cairo.cairo_save(cairo);
            if ((this.data.style & 0x8000000) != 0) {
                Cairo.cairo_scale(cairo, -1.0, 1.0);
                Cairo.cairo_translate(cairo, -2 * destX - destWidth, 0.0);
            }
            Cairo.cairo_rectangle(cairo, destX, destY, destWidth, destHeight);
            Cairo.cairo_clip(cairo);
            if (srcWidth != destWidth || srcHeight != destHeight) {
                float scaleX = (float)destWidth / (float)srcWidth;
                float scaleY = (float)destHeight / (float)srcHeight;
                Cairo.cairo_translate(cairo, destX - (int)((float)srcX * scaleX), destY - (int)((float)srcY * scaleY));
                Cairo.cairo_scale(cairo, scaleX, scaleY);
            } else {
                Cairo.cairo_translate(cairo, destX - srcX, destY - srcY);
            }
            int filter = 1;
            switch (this.data.interpolation) {
                case -1: {
                    filter = 1;
                    break;
                }
                case 0: {
                    filter = 3;
                    break;
                }
                case 1: {
                    filter = 0;
                    break;
                }
                case 2: {
                    filter = 2;
                }
            }
            long pattern = Cairo.cairo_pattern_create_for_surface(srcImage.surface);
            if (pattern == 0L) {
                SWT.error(2);
            }
            if (srcWidth != destWidth || srcHeight != destHeight) {
                Cairo.cairo_pattern_set_extend(pattern, 3);
            }
            Cairo.cairo_pattern_set_filter(pattern, filter);
            Cairo.cairo_set_source(cairo, pattern);
            if (this.data.alpha != 255) {
                Cairo.cairo_paint_with_alpha(cairo, (float)this.data.alpha / 255.0f);
            } else {
                Cairo.cairo_paint(cairo);
            }
            Cairo.cairo_restore(cairo);
            Cairo.cairo_pattern_destroy(pattern);
        }
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        Point loc1 = DPIUtil.autoScaleUp(this.drawable, new Point(x1, y1));
        Point loc2 = DPIUtil.autoScaleUp(this.drawable, new Point(x2, y2));
        this.drawLineInPixels(loc1.x, loc1.y, loc2.x, loc2.y);
    }

    void drawLineInPixels(int x1, int y1, int x2, int y2) {
        this.checkGC(761);
        long cairo = this.data.cairo;
        double xOffset = this.data.cairoXoffset;
        double yOffset = this.data.cairoYoffset;
        if (Cairo.cairo_version() >= Cairo.CAIRO_VERSION_ENCODE(1, 12, 0)) {
            Cairo.cairo_set_antialias(cairo, 6);
        }
        Cairo.cairo_move_to(cairo, (double)x1 + xOffset, (double)y1 + yOffset);
        Cairo.cairo_line_to(cairo, (double)x2 + xOffset, (double)y2 + yOffset);
        Cairo.cairo_stroke(cairo);
    }

    public void drawOval(int x, int y, int width, int height) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        Rectangle rect = DPIUtil.autoScaleUp(this.drawable, new Rectangle(x, y, width, height));
        this.drawOvalInPixels(rect.x, rect.y, rect.width, rect.height);
    }

    void drawOvalInPixels(int x, int y, int width, int height) {
        this.checkGC(761);
        if (width < 0) {
            x += width;
            width = -width;
        }
        if (height < 0) {
            y += height;
            height = -height;
        }
        long cairo = this.data.cairo;
        double xOffset = this.data.cairoXoffset;
        double yOffset = this.data.cairoYoffset;
        if (width == height) {
            Cairo.cairo_arc_negative(cairo, (double)x + xOffset + (double)((float)width / 2.0f), (double)y + yOffset + (double)((float)height / 2.0f), (float)width / 2.0f, 0.0, -6.2831854820251465);
        } else {
            Cairo.cairo_save(cairo);
            Cairo.cairo_translate(cairo, (double)x + xOffset + (double)((float)width / 2.0f), (double)y + yOffset + (double)((float)height / 2.0f));
            Cairo.cairo_scale(cairo, (float)width / 2.0f, (float)height / 2.0f);
            Cairo.cairo_arc_negative(cairo, 0.0, 0.0, 1.0, 0.0, -6.2831854820251465);
            Cairo.cairo_restore(cairo);
        }
        Cairo.cairo_stroke(cairo);
    }

    public void drawPath(Path path) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (path == null) {
            SWT.error(4);
        }
        if (path.handle == 0L) {
            SWT.error(5);
        }
        this.initCairo();
        this.checkGC(761);
        long cairo = this.data.cairo;
        Cairo.cairo_save(cairo);
        double xOffset = this.data.cairoXoffset;
        double yOffset = this.data.cairoYoffset;
        Cairo.cairo_translate(cairo, xOffset, yOffset);
        long copy = Cairo.cairo_copy_path(path.handle);
        if (copy == 0L) {
            SWT.error(2);
        }
        Cairo.cairo_append_path(cairo, copy);
        Cairo.cairo_path_destroy(copy);
        Cairo.cairo_stroke(cairo);
        Cairo.cairo_restore(cairo);
    }

    public void drawPoint(int x, int y) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        Point loc = DPIUtil.autoScaleUp(this.drawable, new Point(x, y));
        this.drawPointInPixels(loc.x, loc.y);
    }

    void drawPointInPixels(int x, int y) {
        this.checkGC(761);
        long cairo = this.data.cairo;
        Cairo.cairo_rectangle(cairo, x, y, 1.0, 1.0);
        Cairo.cairo_fill(cairo);
    }

    public void drawPolygon(int[] pointArray) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (pointArray == null) {
            SWT.error(4);
        }
        int[] scaledPointArray = DPIUtil.autoScaleUp(this.drawable, pointArray);
        this.drawPolygonInPixels(scaledPointArray);
    }

    void drawPolygonInPixels(int[] pointArray) {
        this.checkGC(761);
        long cairo = this.data.cairo;
        this.drawPolyline(cairo, pointArray, true);
        Cairo.cairo_stroke(cairo);
    }

    public void drawPolyline(int[] pointArray) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (pointArray == null) {
            SWT.error(4);
        }
        int[] scaledPointArray = DPIUtil.autoScaleUp(this.drawable, pointArray);
        this.drawPolylineInPixels(scaledPointArray);
    }

    void drawPolylineInPixels(int[] pointArray) {
        this.checkGC(761);
        long cairo = this.data.cairo;
        this.drawPolyline(cairo, pointArray, false);
        Cairo.cairo_stroke(cairo);
    }

    void drawPolyline(long cairo, int[] pointArray, boolean close) {
        int count = pointArray.length / 2;
        if (count == 0) {
            return;
        }
        double xOffset = this.data.cairoXoffset;
        double yOffset = this.data.cairoYoffset;
        Cairo.cairo_move_to(cairo, (double)pointArray[0] + xOffset, (double)pointArray[1] + yOffset);
        int i = 1;
        int j = 2;
        while (i < count) {
            Cairo.cairo_line_to(cairo, (double)pointArray[j] + xOffset, (double)pointArray[j + 1] + yOffset);
            ++i;
            j += 2;
        }
        if (close) {
            Cairo.cairo_close_path(cairo);
        }
    }

    public void drawRectangle(int x, int y, int width, int height) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        this.drawRectangle(new Rectangle(x, y, width, height));
    }

    void drawRectangleInPixels(int x, int y, int width, int height) {
        this.checkGC(761);
        if (width < 0) {
            x += width;
            width = -width;
        }
        if (height < 0) {
            y += height;
            height = -height;
        }
        long cairo = this.data.cairo;
        double xOffset = this.data.cairoXoffset;
        double yOffset = this.data.cairoYoffset;
        Cairo.cairo_rectangle(cairo, (double)x + xOffset, (double)y + yOffset, width, height);
        Cairo.cairo_stroke(cairo);
    }

    public void drawRectangle(Rectangle rect) {
        if (rect == null) {
            SWT.error(4);
        }
        this.drawRectangleInPixels(DPIUtil.autoScaleUp(this.drawable, rect));
    }

    void drawRectangleInPixels(Rectangle rect) {
        this.drawRectangleInPixels(rect.x, rect.y, rect.width, rect.height);
    }

    public void drawRoundRectangle(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        Rectangle rect = DPIUtil.autoScaleUp(this.drawable, new Rectangle(x, y, width, height));
        Point arcSize = DPIUtil.autoScaleUp(this.drawable, new Point(arcWidth, arcHeight));
        this.drawRoundRectangleInPixels(rect.x, rect.y, rect.width, rect.height, arcSize.x, arcSize.y);
    }

    void drawRoundRectangleInPixels(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.checkGC(761);
        int nx = x;
        int ny = y;
        int nw = width;
        int nh = height;
        int naw = arcWidth;
        int nah = arcHeight;
        if (nw < 0) {
            nw = 0 - nw;
            nx -= nw;
        }
        if (nh < 0) {
            nh = 0 - nh;
            ny -= nh;
        }
        if (naw < 0) {
            naw = 0 - naw;
        }
        if (nah < 0) {
            nah = 0 - nah;
        }
        long cairo = this.data.cairo;
        double xOffset = this.data.cairoXoffset;
        double yOffset = this.data.cairoYoffset;
        if (naw == 0 || nah == 0) {
            Cairo.cairo_rectangle(cairo, (double)x + xOffset, (double)y + yOffset, width, height);
        } else {
            float naw2 = (float)naw / 2.0f;
            float nah2 = (float)nah / 2.0f;
            float fw = (float)nw / naw2;
            float fh = (float)nh / nah2;
            Cairo.cairo_save(cairo);
            Cairo.cairo_translate(cairo, (double)nx + xOffset, (double)ny + yOffset);
            Cairo.cairo_scale(cairo, naw2, nah2);
            Cairo.cairo_move_to(cairo, fw - 1.0f, 0.0);
            Cairo.cairo_arc(cairo, fw - 1.0f, 1.0, 1.0, 4.71238898038469, Math.PI * 2);
            Cairo.cairo_arc(cairo, fw - 1.0f, fh - 1.0f, 1.0, 0.0, 1.5707963267948966);
            Cairo.cairo_arc(cairo, 1.0, fh - 1.0f, 1.0, 1.5707963267948966, Math.PI);
            Cairo.cairo_arc(cairo, 1.0, 1.0, 1.0, Math.PI, 4.71238898038469);
            Cairo.cairo_close_path(cairo);
            Cairo.cairo_restore(cairo);
        }
        Cairo.cairo_stroke(cairo);
    }

    public void drawString(String string, int x, int y) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (string == null) {
            SWT.error(4);
        }
        this.drawString(string, x, y, false);
    }

    void drawStringInPixels(String string, int x, int y) {
        this.drawStringInPixels(string, x, y, false);
    }

    public void drawString(String string, int x, int y, boolean isTransparent) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (string == null) {
            SWT.error(4);
        }
        Point loc = DPIUtil.autoScaleUp(this.drawable, new Point(x, y));
        this.drawStringInPixels(string, loc.x, loc.y, isTransparent);
    }

    void drawStringInPixels(String string, int x, int y, boolean isTransparent) {
        this.drawTextInPixels(string, x, y, isTransparent ? 1 : 0);
    }

    public void drawText(String string, int x, int y) {
        this.drawText(string, x, y, 6);
    }

    void drawTextInPixels(String string, int x, int y) {
        this.drawTextInPixels(string, x, y, 6);
    }

    public void drawText(String string, int x, int y, boolean isTransparent) {
        Point loc = DPIUtil.autoScaleUp(this.drawable, new Point(x, y));
        this.drawTextInPixels(string, loc.x, loc.y, isTransparent);
    }

    void drawTextInPixels(String string, int x, int y, boolean isTransparent) {
        int flags = 6;
        if (isTransparent) {
            flags |= 1;
        }
        this.drawTextInPixels(string, x, y, flags);
    }

    public void drawText(String string, int x, int y, int flags) {
        Point loc = DPIUtil.autoScaleUp(this.drawable, new Point(x, y));
        this.drawTextInPixels(string, loc.x, loc.y, flags);
    }

    void drawTextInPixels(String string, int x, int y, int flags) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (string == null) {
            SWT.error(4);
        }
        if (string.length() == 0) {
            return;
        }
        long cairo = this.data.cairo;
        this.setString(string, flags);
        this.checkGC(4);
        if ((flags & 1) == 0) {
            this.checkGC(2);
            if (this.data.stringWidth == -1) {
                this.computeStringSize();
            }
            Cairo.cairo_rectangle(cairo, x, y, this.data.stringWidth, this.data.stringHeight);
            Cairo.cairo_fill(cairo);
        }
        this.checkGC(1);
        if ((this.data.style & 0x8000000) != 0) {
            Cairo.cairo_save(cairo);
            if (this.data.stringWidth == -1) {
                this.computeStringSize();
            }
            Cairo.cairo_scale(cairo, -1.0, 1.0);
            Cairo.cairo_translate(cairo, -2 * x - this.data.stringWidth, 0.0);
        }
        Cairo.cairo_move_to(cairo, x, y);
        OS.pango_cairo_show_layout(cairo, this.data.layout);
        if ((this.data.style & 0x8000000) != 0) {
            Cairo.cairo_restore(cairo);
        }
        Cairo.cairo_new_path(cairo);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof GC)) {
            return false;
        }
        return this.handle == ((GC)object).handle;
    }

    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        Rectangle rect = DPIUtil.autoScaleUp(this.drawable, new Rectangle(x, y, width, height));
        this.fillArcInPixels(rect.x, rect.y, rect.width, rect.height, startAngle, arcAngle);
    }

    void fillArcInPixels(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.checkGC(2);
        if (width < 0) {
            x += width;
            width = -width;
        }
        if (height < 0) {
            y += height;
            height = -height;
        }
        if (width == 0 || height == 0 || arcAngle == 0) {
            return;
        }
        long cairo = this.data.cairo;
        if (width == height) {
            if (arcAngle >= 0) {
                Cairo.cairo_arc_negative(cairo, (float)x + (float)width / 2.0f, (float)y + (float)height / 2.0f, (float)width / 2.0f, (float)(-startAngle) * (float)Math.PI / 180.0f, (float)(-(startAngle + arcAngle)) * (float)Math.PI / 180.0f);
            } else {
                Cairo.cairo_arc(cairo, (float)x + (float)width / 2.0f, (float)y + (float)height / 2.0f, (float)width / 2.0f, (float)(-startAngle) * (float)Math.PI / 180.0f, (float)(-(startAngle + arcAngle)) * (float)Math.PI / 180.0f);
            }
            Cairo.cairo_line_to(cairo, (float)x + (float)width / 2.0f, (float)y + (float)height / 2.0f);
        } else {
            Cairo.cairo_save(cairo);
            Cairo.cairo_translate(cairo, (float)x + (float)width / 2.0f, (float)y + (float)height / 2.0f);
            Cairo.cairo_scale(cairo, (float)width / 2.0f, (float)height / 2.0f);
            if (arcAngle >= 0) {
                Cairo.cairo_arc_negative(cairo, 0.0, 0.0, 1.0, (float)(-startAngle) * (float)Math.PI / 180.0f, (float)(-(startAngle + arcAngle)) * (float)Math.PI / 180.0f);
            } else {
                Cairo.cairo_arc(cairo, 0.0, 0.0, 1.0, (float)(-startAngle) * (float)Math.PI / 180.0f, (float)(-(startAngle + arcAngle)) * (float)Math.PI / 180.0f);
            }
            Cairo.cairo_line_to(cairo, 0.0, 0.0);
            Cairo.cairo_restore(cairo);
        }
        Cairo.cairo_fill(cairo);
    }

    public void fillGradientRectangle(int x, int y, int width, int height, boolean vertical) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        Rectangle rect = DPIUtil.autoScaleUp(this.drawable, new Rectangle(x, y, width, height));
        this.fillGradientRectangleInPixels(rect.x, rect.y, rect.width, rect.height, vertical);
    }

    void fillGradientRectangleInPixels(int x, int y, int width, int height, boolean vertical) {
        RGB foregroundRGB;
        if (width == 0 || height == 0) {
            return;
        }
        RGB backgroundRGB = this.getBackground().getRGB();
        RGB fromRGB = foregroundRGB = this.getForeground().getRGB();
        RGB toRGB = backgroundRGB;
        boolean swapColors = false;
        if (width < 0) {
            x += width;
            width = -width;
            if (!vertical) {
                swapColors = true;
            }
        }
        if (height < 0) {
            y += height;
            height = -height;
            if (vertical) {
                swapColors = true;
            }
        }
        if (swapColors) {
            fromRGB = backgroundRGB;
            toRGB = foregroundRGB;
        }
        if (fromRGB.equals(toRGB)) {
            this.fillRectangleInPixels(x, y, width, height);
            return;
        }
        long cairo = this.data.cairo;
        long pattern = vertical ? Cairo.cairo_pattern_create_linear(0.0, 0.0, 0.0, 1.0) : Cairo.cairo_pattern_create_linear(0.0, 0.0, 1.0, 0.0);
        Cairo.cairo_pattern_add_color_stop_rgba(pattern, 0.0, (float)fromRGB.red / 255.0f, (float)fromRGB.green / 255.0f, (float)fromRGB.blue / 255.0f, (float)this.data.alpha / 255.0f);
        Cairo.cairo_pattern_add_color_stop_rgba(pattern, 1.0, (float)toRGB.red / 255.0f, (float)toRGB.green / 255.0f, (float)toRGB.blue / 255.0f, (float)this.data.alpha / 255.0f);
        Cairo.cairo_save(cairo);
        Cairo.cairo_translate(cairo, x, y);
        Cairo.cairo_scale(cairo, width, height);
        Cairo.cairo_rectangle(cairo, 0.0, 0.0, 1.0, 1.0);
        Cairo.cairo_set_source(cairo, pattern);
        Cairo.cairo_fill(cairo);
        Cairo.cairo_restore(cairo);
        Cairo.cairo_pattern_destroy(pattern);
    }

    public void fillOval(int x, int y, int width, int height) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        Rectangle rect = DPIUtil.autoScaleUp(this.drawable, new Rectangle(x, y, width, height));
        this.fillOvalInPixels(rect.x, rect.y, rect.width, rect.height);
    }

    void fillOvalInPixels(int x, int y, int width, int height) {
        this.checkGC(2);
        if (width < 0) {
            x += width;
            width = -width;
        }
        if (height < 0) {
            y += height;
            height = -height;
        }
        long cairo = this.data.cairo;
        if (width == height) {
            Cairo.cairo_arc_negative(cairo, (float)x + (float)width / 2.0f, (float)y + (float)height / 2.0f, (float)width / 2.0f, 0.0, 6.2831854820251465);
        } else {
            Cairo.cairo_save(cairo);
            Cairo.cairo_translate(cairo, (float)x + (float)width / 2.0f, (float)y + (float)height / 2.0f);
            Cairo.cairo_scale(cairo, (float)width / 2.0f, (float)height / 2.0f);
            Cairo.cairo_arc_negative(cairo, 0.0, 0.0, 1.0, 0.0, 6.2831854820251465);
            Cairo.cairo_restore(cairo);
        }
        Cairo.cairo_fill(cairo);
    }

    public void fillPath(Path path) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (path == null) {
            SWT.error(4);
        }
        if (path.handle == 0L) {
            SWT.error(5);
        }
        this.initCairo();
        this.checkGC(2);
        long cairo = this.data.cairo;
        long copy = Cairo.cairo_copy_path(path.handle);
        if (copy == 0L) {
            SWT.error(2);
        }
        Cairo.cairo_append_path(cairo, copy);
        Cairo.cairo_path_destroy(copy);
        Cairo.cairo_fill(cairo);
    }

    public void fillPolygon(int[] pointArray) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (pointArray == null) {
            SWT.error(4);
        }
        int[] scaledPointArray = DPIUtil.autoScaleUp(this.drawable, pointArray);
        this.fillPolygonInPixels(scaledPointArray);
    }

    void fillPolygonInPixels(int[] pointArray) {
        this.checkGC(2);
        long cairo = this.data.cairo;
        this.drawPolyline(cairo, pointArray, true);
        Cairo.cairo_fill(cairo);
    }

    public void fillRectangle(int x, int y, int width, int height) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        this.fillRectangle(new Rectangle(x, y, width, height));
    }

    void fillRectangleInPixels(int x, int y, int width, int height) {
        this.checkGC(2);
        if (width < 0) {
            x += width;
            width = -width;
        }
        if (height < 0) {
            y += height;
            height = -height;
        }
        long cairo = this.data.cairo;
        Cairo.cairo_rectangle(cairo, x, y, width, height);
        Cairo.cairo_fill(cairo);
    }

    public void fillRectangle(Rectangle rect) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (rect == null) {
            SWT.error(4);
        }
        this.fillRectangleInPixels(DPIUtil.autoScaleUp(this.drawable, rect));
    }

    void fillRectangleInPixels(Rectangle rect) {
        this.fillRectangleInPixels(rect.x, rect.y, rect.width, rect.height);
    }

    public void fillRoundRectangle(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        Rectangle rect = DPIUtil.autoScaleUp(this.drawable, new Rectangle(x, y, width, height));
        Point arcSize = DPIUtil.autoScaleUp(this.drawable, new Point(arcWidth, arcHeight));
        this.fillRoundRectangleInPixels(rect.x, rect.y, rect.width, rect.height, arcSize.x, arcSize.y);
    }

    void fillRoundRectangleInPixels(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.checkGC(2);
        int nx = x;
        int ny = y;
        int nw = width;
        int nh = height;
        int naw = arcWidth;
        int nah = arcHeight;
        if (nw < 0) {
            nw = 0 - nw;
            nx -= nw;
        }
        if (nh < 0) {
            nh = 0 - nh;
            ny -= nh;
        }
        if (naw < 0) {
            naw = 0 - naw;
        }
        if (nah < 0) {
            nah = 0 - nah;
        }
        long cairo = this.data.cairo;
        if (naw == 0 || nah == 0) {
            Cairo.cairo_rectangle(cairo, x, y, width, height);
        } else {
            float naw2 = (float)naw / 2.0f;
            float nah2 = (float)nah / 2.0f;
            float fw = (float)nw / naw2;
            float fh = (float)nh / nah2;
            Cairo.cairo_save(cairo);
            Cairo.cairo_translate(cairo, nx, ny);
            Cairo.cairo_scale(cairo, naw2, nah2);
            Cairo.cairo_move_to(cairo, fw - 1.0f, 0.0);
            Cairo.cairo_arc(cairo, fw - 1.0f, 1.0, 1.0, 4.71238898038469, Math.PI * 2);
            Cairo.cairo_arc(cairo, fw - 1.0f, fh - 1.0f, 1.0, 0.0, 1.5707963267948966);
            Cairo.cairo_arc(cairo, 1.0, fh - 1.0f, 1.0, 1.5707963267948966, Math.PI);
            Cairo.cairo_arc(cairo, 1.0, 1.0, 1.0, Math.PI, 4.71238898038469);
            Cairo.cairo_close_path(cairo);
            Cairo.cairo_restore(cairo);
        }
        Cairo.cairo_fill(cairo);
    }

    int fixMnemonic(char[] buffer) {
        int i = 0;
        int j = 0;
        int mnemonic = -1;
        while (i < buffer.length) {
            if ((buffer[j++] = buffer[i++]) != '&' || i == buffer.length) continue;
            if (buffer[i] == '&') {
                ++i;
                continue;
            }
            if (mnemonic == -1) {
                mnemonic = j;
            }
            --j;
        }
        while (j < buffer.length) {
            buffer[j++] = '\u0000';
        }
        return mnemonic;
    }

    public int getAdvanceWidth(char ch) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        return this.stringExtentInPixels((String)new String((char[])new char[]{ch})).x;
    }

    public boolean getAdvanced() {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        return this.data.cairo != 0L;
    }

    public int getAlpha() {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        return this.data.alpha;
    }

    public int getAntialias() {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (this.data.cairo == 0L) {
            return -1;
        }
        int antialias = Cairo.cairo_get_antialias(this.data.cairo);
        switch (antialias) {
            case 0: {
                return -1;
            }
            case 1: {
                return 0;
            }
            case 2: 
            case 3: {
                return 1;
            }
        }
        return -1;
    }

    public Color getBackground() {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (GTK.GTK3) {
            return Color.gtk_new(this.data.device, this.data.backgroundRGBA);
        }
        return Color.gtk_new(this.data.device, this.data.background);
    }

    public Pattern getBackgroundPattern() {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        return this.data.backgroundPattern;
    }

    public int getCharWidth(char ch) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        return this.stringExtentInPixels((String)new String((char[])new char[]{ch})).x;
    }

    public Rectangle getClipping() {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        return DPIUtil.autoScaleDown(this.drawable, this.getClippingInPixels());
    }

    Rectangle getClippingInPixels() {
        int x = 0;
        int y = 0;
        int width = 0;
        int height = 0;
        int[] w = new int[1];
        int[] h = new int[1];
        this.getSize(w, h);
        width = w[0];
        height = h[0];
        long cairo = this.data.cairo;
        long clipRgn = this.data.clipRgn;
        long damageRgn = this.data.damageRgn;
        if (clipRgn != 0L || damageRgn != 0L || cairo != 0L) {
            long rgn = GDK.gdk_region_new();
            GdkRectangle rect = new GdkRectangle();
            rect.width = width;
            rect.height = height;
            GDK.gdk_region_union_with_rect(rgn, rect);
            if (damageRgn != 0L) {
                GDK.gdk_region_intersect(rgn, damageRgn);
            }
            if (clipRgn != 0L) {
                if (!(this.data.clippingTransform == null || GTK.GTK_VERSION >= OS.VERSION(3, 14, 0) && OS.CAIRO_CONTEXT_REUSE)) {
                    clipRgn = this.convertRgn(clipRgn, this.data.clippingTransform);
                    GDK.gdk_region_intersect(rgn, clipRgn);
                    GDK.gdk_region_destroy(clipRgn);
                } else {
                    GDK.gdk_region_intersect(rgn, clipRgn);
                }
            }
            if (!(cairo == 0L || GTK.GTK_VERSION >= OS.VERSION(3, 14, 0) && OS.CAIRO_CONTEXT_REUSE)) {
                double[] matrix = new double[6];
                Cairo.cairo_get_matrix(cairo, matrix);
                Cairo.cairo_matrix_invert(matrix);
                clipRgn = this.convertRgn(rgn, matrix);
                GDK.gdk_region_destroy(rgn);
                rgn = clipRgn;
            }
            GDK.gdk_region_get_clipbox(rgn, rect);
            GDK.gdk_region_destroy(rgn);
            x = rect.x;
            y = rect.y;
            width = rect.width;
            height = rect.height;
        }
        return new Rectangle(x, y, width, height);
    }

    public void getClipping(Region region) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (region == null) {
            SWT.error(4);
        }
        if (region.isDisposed()) {
            SWT.error(5);
        }
        long clipping = region.handle;
        GDK.gdk_region_subtract(clipping, clipping);
        long cairo = this.data.cairo;
        long clipRgn = this.data.clipRgn;
        if (clipRgn == 0L) {
            GdkRectangle rect = new GdkRectangle();
            int[] width = new int[1];
            int[] height = new int[1];
            this.getSize(width, height);
            rect.width = width[0];
            rect.height = height[0];
            GDK.gdk_region_union_with_rect(clipping, rect);
        } else if (!(this.data.clippingTransform == null || GTK.GTK_VERSION >= OS.VERSION(3, 14, 0) && OS.CAIRO_CONTEXT_REUSE)) {
            long rgn = this.convertRgn(clipRgn, this.data.clippingTransform);
            GDK.gdk_region_union(clipping, rgn);
            GDK.gdk_region_destroy(rgn);
        } else {
            GDK.gdk_region_union(clipping, clipRgn);
        }
        if (this.data.damageRgn != 0L) {
            GDK.gdk_region_intersect(clipping, this.data.damageRgn);
        }
        if (!(cairo == 0L || GTK.GTK_VERSION >= OS.VERSION(3, 14, 0) && OS.CAIRO_CONTEXT_REUSE)) {
            double[] matrix = new double[6];
            Cairo.cairo_get_matrix(cairo, matrix);
            Cairo.cairo_matrix_invert(matrix);
            long rgn = this.convertRgn(clipping, matrix);
            GDK.gdk_region_subtract(clipping, clipping);
            GDK.gdk_region_union(clipping, rgn);
            GDK.gdk_region_destroy(rgn);
        }
    }

    public int getFillRule() {
        long cairo;
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if ((cairo = this.data.cairo) == 0L) {
            return 1;
        }
        return Cairo.cairo_get_fill_rule(cairo) == 0 ? 2 : 1;
    }

    public Font getFont() {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        return this.data.font;
    }

    public FontMetrics getFontMetrics() {
        int ascentInPoints;
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (this.data.context == 0L) {
            this.createLayout();
        }
        this.checkGC(4);
        Font font = this.data.font;
        long context = this.data.context;
        long lang = OS.pango_context_get_language(context);
        long metrics = OS.pango_context_get_metrics(context, font.handle, lang);
        FontMetrics fm = new FontMetrics();
        int ascent = OS.pango_font_metrics_get_ascent(metrics);
        int descent = OS.pango_font_metrics_get_descent(metrics);
        fm.ascentInPoints = ascentInPoints = DPIUtil.autoScaleDown(this.drawable, OS.PANGO_PIXELS(ascent));
        int heightInPoints = DPIUtil.autoScaleDown(this.drawable, OS.PANGO_PIXELS(ascent + descent));
        fm.descentInPoints = heightInPoints - ascentInPoints;
        fm.averageCharWidthInPoints = DPIUtil.autoScaleDown(this.drawable, OS.PANGO_PIXELS(OS.pango_font_metrics_get_approximate_char_width(metrics)));
        OS.pango_font_metrics_unref(metrics);
        return fm;
    }

    public Color getForeground() {
        if (this.handle == 0L) {
            SWT.error(24);
        }
        if (GTK.GTK3) {
            return Color.gtk_new(this.data.device, this.data.foregroundRGBA);
        }
        return Color.gtk_new(this.data.device, this.data.foreground);
    }

    public Pattern getForegroundPattern() {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        return this.data.foregroundPattern;
    }

    public GCData getGCData() {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        return this.data;
    }

    public int getInterpolation() {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        return this.data.interpolation;
    }

    public LineAttributes getLineAttributes() {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        LineAttributes attributes = this.getLineAttributesInPixels();
        attributes.width = DPIUtil.autoScaleDown(this.drawable, attributes.width);
        return attributes;
    }

    LineAttributes getLineAttributesInPixels() {
        float[] dashes = null;
        if (this.data.lineDashes != null) {
            dashes = new float[this.data.lineDashes.length];
            System.arraycopy(this.data.lineDashes, 0, dashes, 0, dashes.length);
        }
        return new LineAttributes(this.data.lineWidth, this.data.lineCap, this.data.lineJoin, this.data.lineStyle, dashes, this.data.lineDashesOffset, this.data.lineMiterLimit);
    }

    public int getLineCap() {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        return this.data.lineCap;
    }

    public int[] getLineDash() {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (this.data.lineDashes == null) {
            return null;
        }
        int[] lineDashes = new int[this.data.lineDashes.length];
        int i = 0;
        while (i < lineDashes.length) {
            lineDashes[i] = (int)this.data.lineDashes[i];
            ++i;
        }
        return lineDashes;
    }

    public int getLineJoin() {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        return this.data.lineJoin;
    }

    public int getLineStyle() {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        return this.data.lineStyle;
    }

    public int getLineWidth() {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        return (int)DPIUtil.autoScaleDown(this.drawable, this.data.lineWidth);
    }

    int getLineWidthInPixels() {
        return (int)this.data.lineWidth;
    }

    public int getStyle() {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        return this.data.style;
    }

    void getSize(int[] width, int[] height) {
        if (this.data.width != -1 && this.data.height != -1) {
            width[0] = this.data.width;
            height[0] = this.data.height;
            return;
        }
        if (this.data.drawable != 0L) {
            width[0] = GDK.gdk_window_get_width(this.data.drawable);
            height[0] = GDK.gdk_window_get_height(this.data.drawable);
            return;
        }
        long surface = Cairo.cairo_get_target(this.handle);
        switch (Cairo.cairo_surface_get_type(surface)) {
            case 0: {
                width[0] = Cairo.cairo_image_surface_get_width(surface);
                height[0] = Cairo.cairo_image_surface_get_height(surface);
                break;
            }
            case 3: {
                width[0] = Cairo.cairo_xlib_surface_get_width(surface);
                height[0] = Cairo.cairo_xlib_surface_get_height(surface);
            }
        }
    }

    public int getTextAntialias() {
        long options;
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (this.data.cairo == 0L) {
            return -1;
        }
        int antialias = 0;
        if (this.data.context != 0L && (options = OS.pango_cairo_context_get_font_options(this.data.context)) != 0L) {
            antialias = Cairo.cairo_font_options_get_antialias(options);
        }
        switch (antialias) {
            case 0: {
                return -1;
            }
            case 1: {
                return 0;
            }
            case 2: 
            case 3: {
                return 1;
            }
        }
        return -1;
    }

    public void getTransform(Transform transform) {
        long cairo;
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (transform == null) {
            SWT.error(4);
        }
        if (transform.isDisposed()) {
            SWT.error(5);
        }
        if ((cairo = this.data.cairo) != 0L) {
            if (GTK.GTK_VERSION >= OS.VERSION(3, 14, 0) && OS.CAIRO_CONTEXT_REUSE) {
                transform.handle = this.currentTransform != null ? (double[])this.currentTransform.clone() : new double[]{1.0, 0.0, 0.0, 1.0, 0.0, 0.0};
            } else {
                Cairo.cairo_get_matrix(cairo, transform.handle);
                double[] identity = this.identity();
                Cairo.cairo_matrix_invert(identity);
                Cairo.cairo_matrix_multiply(transform.handle, transform.handle, identity);
            }
        } else {
            transform.setElements(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
        }
    }

    public boolean getXORMode() {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        return this.data.xorMode;
    }

    public int hashCode() {
        return (int)this.handle;
    }

    double[] identity() {
        double[] identity = new double[6];
        if ((this.data.style & 0x8000000) != 0) {
            int[] w = new int[1];
            int[] h = new int[1];
            this.getSize(w, h);
            Cairo.cairo_matrix_init(identity, -1.0, 0.0, 0.0, 1.0, w[0], 0.0);
        } else {
            Cairo.cairo_matrix_init_identity(identity);
        }
        if (this.data.identity != null) {
            Cairo.cairo_matrix_multiply(identity, this.data.identity, identity);
        }
        return identity;
    }

    void init(Drawable drawable, GCData data, long gdkGC) {
        Image image;
        if (GTK.GTK3) {
            if (data.foregroundRGBA != null) {
                data.state &= 0xFFFFFFFE;
            }
            if (data.backgroundRGBA != null) {
                data.state &= 0xFFFFFEFD;
            }
        } else {
            if (data.foreground != null) {
                data.state &= 0xFFFFFFFE;
            }
            if (data.background != null) {
                data.state &= 0xFFFFFEFD;
            }
        }
        if (data.font != null) {
            data.state &= 0xFFFFFFFB;
        }
        if ((image = data.image) != null) {
            image.memGC = this;
            if (image.transparentPixel != -1) {
                image.destroyMask();
            }
        }
        this.drawable = drawable;
        this.data = data;
        long cairo = data.cairo = (this.handle = gdkGC);
        Cairo.cairo_set_fill_rule(cairo, 1);
        data.state &= 0xFFFFFD80;
        this.setClipping(data.clipRgn);
        this.initCairo();
        if ((data.style & 0x8000000) != 0) {
            if (GTK.GTK_VERSION >= OS.VERSION(3, 14, 0) && OS.CAIRO_CONTEXT_REUSE) {
                int[] w = new int[1];
                int[] h = new int[1];
                this.getSize(w, h);
                Cairo.cairo_translate(cairo, w[0], 0.0);
                Cairo.cairo_scale(cairo, -1.0, 1.0);
            } else {
                Cairo.cairo_set_matrix(data.cairo, this.identity());
            }
        }
        if (OS.CAIRO_CONTEXT_REUSE) {
            if (this.cairoTransformationMatrix == null) {
                this.cairoTransformationMatrix = new double[6];
            }
            Cairo.cairo_get_matrix(data.cairo, this.cairoTransformationMatrix);
            this.clipping = this.getClipping();
        }
    }

    void initCairo() {
        long cairo = this.data.cairo;
        if (cairo != 0L) {
            return;
        }
        this.data.cairo = cairo = GDK.gdk_cairo_create(this.data.drawable);
        if (cairo == 0L) {
            SWT.error(2);
        }
        this.data.disposeCairo = true;
        Cairo.cairo_set_fill_rule(cairo, 1);
        this.data.state &= 0xFFFFFD80;
        this.setCairoClip(this.data.damageRgn, this.data.clipRgn);
    }

    void computeStringSize() {
        int[] width = new int[1];
        int[] height = new int[1];
        OS.pango_layout_get_pixel_size(this.data.layout, width, height);
        this.data.stringHeight = height[0];
        this.data.stringWidth = width[0];
    }

    public boolean isClipped() {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        return this.data.clipRgn != 0L;
    }

    @Override
    public boolean isDisposed() {
        return this.handle == 0L;
    }

    boolean isIdentity(double[] matrix) {
        if (matrix == null) {
            return true;
        }
        return matrix[0] == 1.0 && matrix[1] == 0.0 && matrix[2] == 0.0 && matrix[3] == 1.0 && matrix[4] == 0.0 && matrix[5] == 0.0;
    }

    public void setAdvanced(boolean advanced) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (!advanced) {
            this.setAlpha(255);
            this.setAntialias(-1);
            this.setBackgroundPattern(null);
            this.resetClipping();
            this.setForegroundPattern(null);
            this.setInterpolation(-1);
            this.setTextAntialias(-1);
            this.setTransform(null);
        }
    }

    public void setAlpha(int alpha) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (this.data.cairo == 0L && (alpha & 0xFF) == 255) {
            return;
        }
        this.initCairo();
        this.data.alpha = alpha & 0xFF;
        this.data.state &= 0xFFFFFEFC;
    }

    public void setAntialias(int antialias) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (this.data.cairo == 0L && antialias == -1) {
            return;
        }
        int mode = 0;
        switch (antialias) {
            case -1: {
                mode = 0;
                break;
            }
            case 0: {
                mode = 1;
                break;
            }
            case 1: {
                mode = 2;
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.initCairo();
        long cairo = this.data.cairo;
        Cairo.cairo_set_antialias(cairo, mode);
    }

    public void setBackground(Color color) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (color == null) {
            SWT.error(4);
        }
        if (color.isDisposed()) {
            SWT.error(5);
        }
        if (GTK.GTK3) {
            this.data.backgroundRGBA = color.handleRGBA;
        } else {
            this.data.background = color.handle;
        }
        this.data.backgroundPattern = null;
        this.data.state &= 0xFFFFFEFD;
    }

    public void setBackgroundPattern(Pattern pattern) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (pattern != null && pattern.isDisposed()) {
            SWT.error(5);
        }
        if (this.data.cairo == 0L && pattern == null) {
            return;
        }
        this.initCairo();
        if (this.data.backgroundPattern == pattern) {
            return;
        }
        this.data.backgroundPattern = pattern;
        this.data.state &= 0xFFFFFFFD;
    }

    static void setCairoFont(long cairo, Font font) {
        if (font == null || font.isDisposed()) {
            return;
        }
        GC.setCairoFont(cairo, font.handle);
    }

    static void setCairoFont(long cairo, long font) {
        long family = OS.pango_font_description_get_family(font);
        int length = C.strlen(family);
        byte[] buffer = new byte[length + 1];
        C.memmove(buffer, family, (long)length);
        double height = OS.PANGO_PIXELS(OS.pango_font_description_get_size(font)) * 96 / 72;
        int pangoStyle = OS.pango_font_description_get_style(font);
        int pangoWeight = OS.pango_font_description_get_weight(font);
        int slant = 0;
        if (pangoStyle == 2) {
            slant = 1;
        }
        if (pangoStyle == 1) {
            slant = 2;
        }
        int weight = 0;
        if (pangoWeight == 700) {
            weight = 1;
        }
        Cairo.cairo_select_font_face(cairo, buffer, slant, weight);
        Cairo.cairo_set_font_size(cairo, height);
    }

    static void setCairoRegion(long cairo, long rgn) {
        GDK.gdk_cairo_region(cairo, rgn);
    }

    static void setCairoPatternColor(long pattern, int offset, Color c, int alpha) {
        if (GTK.GTK3) {
            GdkRGBA rgba = c.handleRGBA;
            Cairo.cairo_pattern_add_color_stop_rgba(pattern, offset, rgba.red, rgba.green, rgba.blue, (float)alpha / 255.0f);
        } else {
            GdkColor color = c.handle;
            double aa = (double)(alpha & 0xFF) / 255.0;
            double red = (double)(color.red & 0xFFFF) / 65535.0;
            double green = (double)(color.green & 0xFFFF) / 65535.0;
            double blue = (double)(color.blue & 0xFFFF) / 65535.0;
            Cairo.cairo_pattern_add_color_stop_rgba(pattern, offset, red, green, blue, aa);
        }
    }

    void setCairoClip(long damageRgn, long clipRgn) {
        long cairo = this.data.cairo;
        if (this.data.drawable != 0L && !GTK.GTK3) {
            GDK.gdk_cairo_reset_clip(cairo, this.data.drawable);
        } else {
            Cairo.cairo_reset_clip(cairo);
        }
        if (damageRgn != 0L) {
            double[] matrix = new double[6];
            Cairo.cairo_get_matrix(cairo, matrix);
            double[] identity = new double[6];
            Cairo.cairo_matrix_init_identity(identity);
            Cairo.cairo_set_matrix(cairo, identity);
            GC.setCairoRegion(cairo, damageRgn);
            Cairo.cairo_clip(cairo);
            Cairo.cairo_set_matrix(cairo, matrix);
        }
        if (clipRgn != 0L) {
            long clipRgnCopy = GDK.gdk_region_new();
            GDK.gdk_region_union(clipRgnCopy, clipRgn);
            if (GTK.GTK_VERSION >= OS.VERSION(3, 14, 0) && OS.CAIRO_CONTEXT_REUSE) {
                this.limitClipping(clipRgnCopy);
            }
            GC.setCairoRegion(cairo, clipRgnCopy);
            Cairo.cairo_clip(cairo);
            GDK.gdk_region_destroy(clipRgnCopy);
        }
    }

    private void limitClipping(long gcClipping) {
        Region clippingRegion = new Region();
        if (this.currentTransform != null) {
            double[] invertedCurrentTransform = (double[])this.currentTransform.clone();
            Cairo.cairo_matrix_invert(invertedCurrentTransform);
            int[] clippingWithoutUserTransform = GC.transformRectangle(invertedCurrentTransform, this.clipping);
            clippingRegion.add(clippingWithoutUserTransform);
            GDK.gdk_region_intersect(gcClipping, clippingRegion.handle);
        } else {
            clippingRegion.add(this.clipping);
        }
        GDK.gdk_region_intersect(gcClipping, clippingRegion.handle);
        clippingRegion.dispose();
    }

    private static int[] transformRectangle(double[] affineTransformation, Rectangle rectangle) {
        Point[] endPoints = new Point[]{new Point(rectangle.x, rectangle.y), new Point(rectangle.x + rectangle.width, rectangle.y), new Point(rectangle.x + rectangle.width, rectangle.y + rectangle.height), new Point(rectangle.x, rectangle.y + rectangle.height)};
        return GC.transformPoints(affineTransformation, endPoints);
    }

    private static int[] transformPoints(double[] transformation, Point[] points) {
        int[] transformedPoints = new int[points.length * 2];
        double[] px = new double[1];
        double[] py = new double[1];
        int i = 0;
        while (i < points.length) {
            px[0] = points[i].x;
            py[0] = points[i].y;
            Cairo.cairo_matrix_transform_point(transformation, px, py);
            transformedPoints[i * 2 + 0] = (int)Math.round(px[0]);
            transformedPoints[i * 2 + 1] = (int)Math.round(py[0]);
            ++i;
        }
        return transformedPoints;
    }

    void setClipping(long clipRgn) {
        long cairo = this.data.cairo;
        if (clipRgn == 0L) {
            if (this.data.clipRgn != 0L) {
                GDK.gdk_region_destroy(this.data.clipRgn);
                this.data.clipRgn = 0L;
            }
            this.data.clippingTransform = null;
            this.setCairoClip(this.data.damageRgn, 0L);
        } else {
            if (this.data.clipRgn == 0L) {
                this.data.clipRgn = GDK.gdk_region_new();
            }
            GDK.gdk_region_subtract(this.data.clipRgn, this.data.clipRgn);
            GDK.gdk_region_union(this.data.clipRgn, clipRgn);
            if (GTK.GTK_VERSION < OS.VERSION(3, 14, 0) || !OS.CAIRO_CONTEXT_REUSE) {
                if (this.data.clippingTransform == null) {
                    this.data.clippingTransform = new double[6];
                }
                Cairo.cairo_get_matrix(cairo, this.data.clippingTransform);
            }
            this.setCairoClip(this.data.damageRgn, clipRgn);
        }
    }

    public void setClipping(int x, int y, int width, int height) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        this.setClippingInPixels(DPIUtil.autoScaleUp(this.drawable, x), DPIUtil.autoScaleUp(this.drawable, y), DPIUtil.autoScaleUp(this.drawable, width), DPIUtil.autoScaleUp(this.drawable, height));
    }

    void setClippingInPixels(int x, int y, int width, int height) {
        if (width < 0) {
            x += width;
            width = -width;
        }
        if (height < 0) {
            y += height;
            height = -height;
        }
        GdkRectangle rect = new GdkRectangle();
        rect.x = x;
        rect.y = y;
        rect.width = width;
        rect.height = height;
        long clipRgn = GDK.gdk_region_new();
        GDK.gdk_region_union_with_rect(clipRgn, rect);
        this.setClipping(clipRgn);
        GDK.gdk_region_destroy(clipRgn);
    }

    public void setClipping(Path path) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (path != null && path.isDisposed()) {
            SWT.error(44);
        }
        this.resetClipping();
        if (path != null) {
            this.initCairo();
            long cairo = this.data.cairo;
            long copy = Cairo.cairo_copy_path(path.handle);
            if (copy == 0L) {
                SWT.error(2);
            }
            Cairo.cairo_append_path(cairo, copy);
            Cairo.cairo_path_destroy(copy);
            Cairo.cairo_clip(cairo);
        }
    }

    public void setClipping(Rectangle rect) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        this.setClippingInPixels(DPIUtil.autoScaleUp(this.drawable, rect));
    }

    void setClippingInPixels(Rectangle rect) {
        if (GTK.GTK_VERSION >= OS.VERSION(3, 9, 0) && (this.drawable instanceof Tree || this.drawable instanceof Table)) {
            return;
        }
        if (rect == null) {
            this.resetClipping();
        } else {
            this.setClippingInPixels(rect.x, rect.y, rect.width, rect.height);
        }
    }

    private void resetClipping() {
        if (GTK.GTK_VERSION >= OS.VERSION(3, 14, 0) && OS.CAIRO_CONTEXT_REUSE) {
            this.setClipping(this.clipping);
        } else {
            this.setClipping(0L);
        }
    }

    public void setClipping(Region region) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (region != null && region.isDisposed()) {
            SWT.error(5);
        }
        if (region != null) {
            this.setClipping(region.handle);
        } else {
            this.resetClipping();
        }
    }

    public void setFont(Font font) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (font != null && font.isDisposed()) {
            SWT.error(5);
        }
        this.data.font = font != null ? font : this.data.device.systemFont;
        this.data.state &= 0xFFFFFFFB;
        this.data.stringHeight = -1;
        this.data.stringWidth = -1;
    }

    public void setFillRule(int rule) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        int cairo_mode = 1;
        switch (rule) {
            case 2: {
                cairo_mode = 0;
                break;
            }
            case 1: {
                cairo_mode = 1;
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.initCairo();
        Cairo.cairo_set_fill_rule(this.data.cairo, cairo_mode);
    }

    public void setForeground(Color color) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (color == null) {
            SWT.error(4);
        }
        if (color.isDisposed()) {
            SWT.error(5);
        }
        if (GTK.GTK3) {
            this.data.foregroundRGBA = color.handleRGBA;
        } else {
            this.data.foreground = color.handle;
        }
        this.data.foregroundPattern = null;
        this.data.state &= 0xFFFFFFFE;
    }

    public void setForegroundPattern(Pattern pattern) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (pattern != null && pattern.isDisposed()) {
            SWT.error(5);
        }
        if (this.data.cairo == 0L && pattern == null) {
            return;
        }
        this.initCairo();
        if (this.data.foregroundPattern == pattern) {
            return;
        }
        this.data.foregroundPattern = pattern;
        this.data.state &= 0xFFFFFFFE;
    }

    public void setInterpolation(int interpolation) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (this.data.cairo == 0L && interpolation == -1) {
            return;
        }
        switch (interpolation) {
            case -1: 
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.initCairo();
        this.data.interpolation = interpolation;
    }

    public void setLineAttributes(LineAttributes attributes) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (attributes == null) {
            SWT.error(4);
        }
        attributes.width = DPIUtil.autoScaleUp(this.drawable, attributes.width);
        this.setLineAttributesInPixels(attributes);
    }

    void setLineAttributesInPixels(LineAttributes attributes) {
        float miterLimit;
        int cap;
        int join;
        int lineStyle;
        int mask = 0;
        float lineWidth = attributes.width;
        if (lineWidth != this.data.lineWidth) {
            mask |= 0x240;
        }
        if ((lineStyle = attributes.style) != this.data.lineStyle) {
            mask |= 8;
            switch (lineStyle) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
                case 6: {
                    if (attributes.dash != null) break;
                    lineStyle = 1;
                    break;
                }
                default: {
                    SWT.error(5);
                }
            }
        }
        if ((join = attributes.join) != this.data.lineJoin) {
            mask |= 0x20;
            switch (join) {
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
                default: {
                    SWT.error(5);
                }
            }
        }
        if ((cap = attributes.cap) != this.data.lineCap) {
            mask |= 0x10;
            switch (cap) {
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
                default: {
                    SWT.error(5);
                }
            }
        }
        float[] dashes = attributes.dash;
        float[] lineDashes = this.data.lineDashes;
        if (dashes != null && dashes.length > 0) {
            boolean changed = lineDashes == null || lineDashes.length != dashes.length;
            int i = 0;
            while (i < dashes.length) {
                float dash = dashes[i];
                if (dash <= 0.0f) {
                    SWT.error(5);
                }
                if (!changed && lineDashes[i] != dash) {
                    changed = true;
                }
                ++i;
            }
            if (changed) {
                float[] newDashes = new float[dashes.length];
                System.arraycopy(dashes, 0, newDashes, 0, dashes.length);
                dashes = newDashes;
                mask |= 8;
            } else {
                dashes = lineDashes;
            }
        } else if (lineDashes != null && lineDashes.length > 0) {
            mask |= 8;
        } else {
            dashes = lineDashes;
        }
        float dashOffset = attributes.dashOffset;
        if (dashOffset != this.data.lineDashesOffset) {
            mask |= 8;
        }
        if ((miterLimit = attributes.miterLimit) != this.data.lineMiterLimit) {
            mask |= 0x80;
        }
        this.initCairo();
        if (mask == 0) {
            return;
        }
        this.data.lineWidth = lineWidth;
        this.data.lineStyle = lineStyle;
        this.data.lineCap = cap;
        this.data.lineJoin = join;
        this.data.lineDashes = dashes;
        this.data.lineDashesOffset = dashOffset;
        this.data.lineMiterLimit = miterLimit;
        this.data.state &= ~mask;
    }

    public void setLineCap(int cap) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (this.data.lineCap == cap) {
            return;
        }
        switch (cap) {
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.data.lineCap = cap;
        this.data.state &= 0xFFFFFFEF;
    }

    public void setLineDash(int[] dashes) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        float[] lineDashes = this.data.lineDashes;
        if (dashes != null && dashes.length > 0) {
            boolean changed = this.data.lineStyle != 6 || lineDashes == null || lineDashes.length != dashes.length;
            int i = 0;
            while (i < dashes.length) {
                int dash = dashes[i];
                if (dash <= 0) {
                    SWT.error(5);
                }
                if (!changed && lineDashes[i] != (float)dash) {
                    changed = true;
                }
                ++i;
            }
            if (!changed) {
                return;
            }
            this.data.lineDashes = new float[dashes.length];
            i = 0;
            while (i < dashes.length) {
                this.data.lineDashes[i] = dashes[i];
                ++i;
            }
            this.data.lineStyle = 6;
        } else {
            if (this.data.lineStyle == 1 && (lineDashes == null || lineDashes.length == 0)) {
                return;
            }
            this.data.lineDashes = null;
            this.data.lineStyle = 1;
        }
        this.data.state &= 0xFFFFFFF7;
    }

    public void setLineJoin(int join) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (this.data.lineJoin == join) {
            return;
        }
        switch (join) {
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.data.lineJoin = join;
        this.data.state &= 0xFFFFFFDF;
    }

    public void setLineStyle(int lineStyle) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (this.data.lineStyle == lineStyle) {
            return;
        }
        switch (lineStyle) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                if (this.data.lineDashes != null) break;
                lineStyle = 1;
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.data.lineStyle = lineStyle;
        this.data.state &= 0xFFFFFFF7;
    }

    public void setLineWidth(int lineWidth) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        this.setLineWidthInPixels(DPIUtil.autoScaleUp(this.drawable, lineWidth));
    }

    void setLineWidthInPixels(int lineWidth) {
        if (this.data.lineWidth == (float)lineWidth) {
            return;
        }
        this.data.lineWidth = lineWidth;
        this.data.state &= 0xFFFFFDBF;
    }

    void setString(String string, int flags) {
        byte[] buffer;
        int mnemonic;
        if (this.data.layout == 0L) {
            this.createLayout();
        }
        if (string == this.data.string && (flags & 0xFFFFFFFE) == (this.data.drawFlags & 0xFFFFFFFE)) {
            return;
        }
        int length = string.length();
        long layout = this.data.layout;
        char[] text = new char[length];
        string.getChars(0, length, text, 0);
        if ((flags & 8) != 0 && (mnemonic = this.fixMnemonic(text)) != -1) {
            char[] text1 = new char[mnemonic - 1];
            System.arraycopy(text, 0, text1, 0, text1.length);
            byte[] buffer1 = Converter.wcsToMbcs(text1, false);
            char[] text2 = new char[text.length - mnemonic];
            System.arraycopy(text, mnemonic - 1, text2, 0, text2.length);
            byte[] buffer2 = Converter.wcsToMbcs(text2, false);
            buffer = new byte[buffer1.length + buffer2.length];
            System.arraycopy(buffer1, 0, buffer, 0, buffer1.length);
            System.arraycopy(buffer2, 0, buffer, buffer1.length, buffer2.length);
            long attr_list = OS.pango_attr_list_new();
            long attr = OS.pango_attr_underline_new(3);
            PangoAttribute attribute = new PangoAttribute();
            OS.memmove(attribute, attr, (long)PangoAttribute.sizeof);
            attribute.start_index = buffer1.length;
            attribute.end_index = buffer1.length + 1;
            OS.memmove(attr, attribute, (long)PangoAttribute.sizeof);
            OS.pango_attr_list_insert(attr_list, attr);
            OS.pango_layout_set_attributes(layout, attr_list);
            OS.pango_attr_list_unref(attr_list);
        } else {
            buffer = Converter.wcsToMbcs(text, false);
            OS.pango_layout_set_attributes(layout, 0L);
        }
        OS.pango_layout_set_text(layout, buffer, buffer.length);
        OS.pango_layout_set_single_paragraph_mode(layout, (flags & 2) == 0);
        OS.pango_layout_set_tabs(layout, (flags & 4) != 0 ? 0L : this.data.device.emptyTab);
        this.data.string = string;
        this.data.stringHeight = -1;
        this.data.stringWidth = -1;
        this.data.drawFlags = flags;
    }

    public void setTextAntialias(int antialias) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (this.data.cairo == 0L && antialias == -1) {
            return;
        }
        int mode = 0;
        switch (antialias) {
            case -1: {
                mode = 0;
                break;
            }
            case 0: {
                mode = 1;
                break;
            }
            case 1: {
                mode = 2;
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.initCairo();
        long options = Cairo.cairo_font_options_create();
        Cairo.cairo_font_options_set_antialias(options, mode);
        if (this.data.context == 0L) {
            this.createLayout();
        }
        OS.pango_cairo_context_set_font_options(this.data.context, options);
        Cairo.cairo_font_options_destroy(options);
    }

    public void setTransform(Transform transform) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (transform != null && transform.isDisposed()) {
            SWT.error(5);
        }
        if (this.data.cairo == 0L && transform == null) {
            return;
        }
        this.initCairo();
        long cairo = this.data.cairo;
        if (GTK.GTK_VERSION >= OS.VERSION(3, 14, 0) && OS.CAIRO_CONTEXT_REUSE) {
            if (this.currentTransform != null) {
                Cairo.cairo_set_matrix(cairo, this.cairoTransformationMatrix);
                this.currentTransform = null;
            }
            if (transform != null) {
                this.currentTransform = (double[])transform.handle.clone();
                double[] transformMatrix = this.identity();
                Cairo.cairo_matrix_multiply(transformMatrix, transform.handle, transformMatrix);
                Cairo.cairo_transform(cairo, transformMatrix);
            }
        } else {
            double[] identity = this.identity();
            if (transform != null) {
                Cairo.cairo_matrix_multiply(identity, transform.handle, identity);
            }
            Cairo.cairo_set_matrix(cairo, identity);
        }
        this.data.state &= 0xFFFFFDFF;
    }

    @Deprecated
    public void setXORMode(boolean xor) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (Cairo.cairo_version() >= Cairo.CAIRO_VERSION_ENCODE(1, 10, 0)) {
            Cairo.cairo_set_operator(this.handle, xor ? 23 : 2);
        }
        this.data.xorMode = xor;
    }

    public Point stringExtent(String string) {
        return DPIUtil.autoScaleDown(this.drawable, this.stringExtentInPixels(string));
    }

    Point stringExtentInPixels(String string) {
        return this.textExtentInPixels(string, 0);
    }

    public Point textExtent(String string) {
        return DPIUtil.autoScaleDown(this.drawable, this.textExtentInPixels(string));
    }

    Point textExtentInPixels(String string) {
        return this.textExtentInPixels(string, 6);
    }

    public Point textExtent(String string, int flags) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (string == null) {
            SWT.error(4);
        }
        return DPIUtil.autoScaleDown(this.drawable, this.textExtentInPixels(string, flags));
    }

    Point textExtentInPixels(String string, int flags) {
        this.setString(string, flags);
        this.checkGC(4);
        if (this.data.stringWidth == -1) {
            this.computeStringSize();
        }
        return new Point(this.data.stringWidth, this.data.stringHeight);
    }

    public String toString() {
        if (this.isDisposed()) {
            return "GC {*DISPOSED*}";
        }
        return "GC {" + this.handle + "}";
    }
}

