/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.commands.internal;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.HandlerEvent;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.e4.core.commands.ExpressionContext;
import org.eclipse.e4.core.commands.internal.HandlerServiceImpl;
import org.eclipse.e4.core.commands.internal.SetEnabled;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;

public class HandlerServiceHandler
extends AbstractHandler {
    private static final String FAILED_TO_FIND_HANDLER_DURING_EXECUTION = "Failed to find handler during execution";
    private static final String HANDLER_MISSING_EXECUTE_ANNOTATION = " handler is missing @Execute";
    private static final Object missingExecute = new Object();
    protected String commandId;

    public HandlerServiceHandler(String commandId) {
        this.commandId = commandId;
    }

    public boolean isEnabled() {
        IEclipseContext executionContext;
        HandlerServiceImpl.ExecutionContexts contexts = HandlerServiceImpl.peek();
        IEclipseContext iEclipseContext = executionContext = contexts != null ? contexts.context : null;
        if (executionContext == null) {
            return super.isEnabled();
        }
        Object handler = HandlerServiceImpl.lookUpHandler(executionContext, this.commandId);
        if (handler == null) {
            this.setBaseEnabled(false);
            return super.isEnabled();
        }
        IEclipseContext staticContext = contexts.staticContext;
        Boolean result = (Boolean)ContextInjectionFactory.invoke((Object)handler, CanExecute.class, (IEclipseContext)executionContext, (IEclipseContext)staticContext, (Object)Boolean.TRUE);
        this.setBaseEnabled(result);
        return super.isEnabled();
    }

    public void setEnabled(Object evaluationContext) {
        boolean createContext = false;
        IEclipseContext executionContext = this.getExecutionContext(evaluationContext);
        if (executionContext == null) {
            return;
        }
        Object handler = HandlerServiceImpl.lookUpHandler(executionContext, this.commandId);
        if (handler == null) {
            return;
        }
        IEclipseContext staticContext = this.getStaticContext(executionContext);
        if (staticContext == null) {
            staticContext = EclipseContextFactory.create();
            createContext = true;
        }
        ContextInjectionFactory.invoke((Object)handler, SetEnabled.class, (IEclipseContext)executionContext, (IEclipseContext)staticContext, (Object)Boolean.TRUE);
        if (createContext) {
            staticContext.dispose();
        }
    }

    private IEclipseContext getStaticContext(IEclipseContext executionContext) {
        HandlerServiceImpl.ExecutionContexts pair = HandlerServiceImpl.peek();
        if (pair != null) {
            IEclipseContext cfr_ignored_0 = pair.context;
            return pair.staticContext;
        }
        return null;
    }

    protected IEclipseContext getExecutionContext(Object evalObj) {
        if (evalObj instanceof IEclipseContext) {
            return (IEclipseContext)evalObj;
        }
        if (evalObj instanceof ExpressionContext) {
            return ((ExpressionContext)evalObj).eclipseContext;
        }
        if (evalObj instanceof IEvaluationContext) {
            return this.getExecutionContext(((IEvaluationContext)evalObj).getParent());
        }
        HandlerServiceImpl.ExecutionContexts pair = HandlerServiceImpl.peek();
        if (pair != null) {
            return pair.context;
        }
        return null;
    }

    public boolean isHandled() {
        HandlerServiceImpl.ExecutionContexts contexts = HandlerServiceImpl.peek();
        if (contexts != null) {
            Object handler = HandlerServiceImpl.lookUpHandler(contexts.context, this.commandId);
            if (handler instanceof IHandler) {
                return ((IHandler)handler).isHandled();
            }
            return handler != null;
        }
        return false;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IEclipseContext executionContext = this.getExecutionContext(event.getApplicationContext());
        if (executionContext == null) {
            throw new ExecutionException(FAILED_TO_FIND_HANDLER_DURING_EXECUTION, (Throwable)new NotHandledException(FAILED_TO_FIND_HANDLER_DURING_EXECUTION));
        }
        Object handler = HandlerServiceImpl.lookUpHandler(executionContext, this.commandId);
        if (handler == null) {
            return null;
        }
        IEclipseContext staticContext = this.getStaticContext(executionContext);
        IEclipseContext localStaticContext = null;
        try {
            Object result;
            if (staticContext == null) {
                staticContext = localStaticContext = EclipseContextFactory.create((String)"tmp-staticContext");
                staticContext.set("parmMap::", (Object)event.getParameters());
            }
            if ((result = ContextInjectionFactory.invoke((Object)handler, Execute.class, (IEclipseContext)executionContext, (IEclipseContext)staticContext, (Object)missingExecute)) == missingExecute) {
                throw new ExecutionException(String.valueOf(handler.getClass().getName()) + HANDLER_MISSING_EXECUTE_ANNOTATION, (Throwable)new NotHandledException(((Object)((Object)this)).getClass().getName()));
            }
            Object object = result;
            return object;
        }
        finally {
            if (localStaticContext != null) {
                localStaticContext.dispose();
            }
        }
    }

    public void fireHandlerChanged(HandlerEvent handlerEvent) {
        super.fireHandlerChanged(handlerEvent);
    }

    public void overrideEnabled(boolean b) {
        this.setBaseEnabled(b);
    }
}

