/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.model;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Date;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.update.configurator.IPlatformConfiguration;
import org.eclipse.update.core.ISite;
import org.eclipse.update.core.SiteFeatureReference;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.core.model.SiteModel;
import org.eclipse.update.internal.configurator.FeatureEntry;
import org.eclipse.update.internal.configurator.PlatformConfiguration;
import org.eclipse.update.internal.configurator.SiteEntry;
import org.eclipse.update.internal.core.BaseSiteLocalFactory;
import org.eclipse.update.internal.core.Messages;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.core.UpdateManagerUtils;
import org.eclipse.update.internal.model.ConfiguredSiteModel;
import org.eclipse.update.internal.model.InstallConfigurationModel;

public class InstallConfigurationParser {
    private PlatformConfiguration platformConfig;
    private URL siteURL;
    private InstallConfigurationModel config;
    private ConfiguredSiteModel configSite;

    public InstallConfigurationParser(IPlatformConfiguration platformConfig, InstallConfigurationModel config, boolean light) throws IOException, CoreException {
        Assert.isTrue((boolean)(platformConfig instanceof PlatformConfiguration));
        this.platformConfig = (PlatformConfiguration)platformConfig;
        this.config = config;
        if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_PARSING) {
            UpdateCore.debug("Start parsing Configuration:" + config.getURL().toExternalForm());
        }
        if (light) {
            this.processConfigurationLight(this.platformConfig);
        } else {
            this.processConfig(this.platformConfig);
        }
    }

    private void processSite(SiteEntry siteEntry) throws CoreException, IOException {
        this.siteURL = siteEntry.getURL();
        try {
            this.siteURL = FileLocator.toFileURL((URL)this.siteURL);
            if (this.siteURL.getProtocol().equals("file")) {
                this.siteURL = new File(this.siteURL.getFile()).toURL();
            }
        }
        catch (IOException iOException) {}
        ISite site = SiteManager.getSite(this.siteURL, null);
        BaseSiteLocalFactory factory = new BaseSiteLocalFactory();
        this.configSite = factory.createConfigurationSiteModel((SiteModel)((Object)site), siteEntry.getSitePolicy().getType());
        this.configSite.setPlatformURLString(siteEntry.getURL().toExternalForm());
        this.configSite.setEnabled(siteEntry.isEnabled());
        this.configSite.setUpdatable(siteEntry.isUpdateable());
        this.config.addConfigurationSiteModel(this.configSite);
        this.configSite.setInstallConfigurationModel(this.config);
        FeatureEntry[] features = siteEntry.getFeatureEntries();
        int i = 0;
        while (i < features.length) {
            this.processFeature(features[i]);
            ++i;
        }
    }

    private void processFeature(FeatureEntry feature) throws CoreException, IOException {
        String path = feature.getURL();
        URL url = UpdateManagerUtils.getURL(this.siteURL, path, null);
        if (url != null) {
            SiteFeatureReference ref = new SiteFeatureReference();
            ref.setSite((ISite)((Object)this.configSite.getSiteModel()));
            ref.setURL(url);
            this.configSite.getConfigurationPolicyModel().addConfiguredFeatureReference(ref);
            if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_PARSING) {
                UpdateCore.debug("End Processing DefaultFeature Tag: url:" + url.toExternalForm());
            }
        } else {
            UpdateCore.log(Messages.InstallConfigurationParser_FeatureReferenceNoURL, new Exception());
        }
    }

    private void processConfig(PlatformConfiguration platformConfig) throws IOException, CoreException {
        this.processConfigurationLight(platformConfig);
        SiteEntry[] sites = platformConfig.getConfiguration().getSites();
        int i = 0;
        while (i < sites.length) {
            this.processSite(sites[i]);
            ++i;
        }
    }

    private void processConfigurationLight(PlatformConfiguration platformConfig) {
        Date date = new Date(platformConfig.getChangeStamp());
        this.config.setCreationDate(date);
        this.config.setLabel(date.toString());
        this.config.setCurrent(date.equals(PlatformConfiguration.getCurrent().getConfiguration().getDate()));
    }
}

