/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.ui;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.util.JavaConventionsUtil;
import org.eclipse.jdt.internal.junit.BasicElementLabels;
import org.eclipse.jdt.internal.junit.Messages;
import org.eclipse.jdt.internal.junit.model.TestCaseElement;
import org.eclipse.jdt.internal.junit.model.TestElement;
import org.eclipse.jdt.internal.junit.ui.JUnitMessages;
import org.eclipse.jdt.internal.junit.ui.OpenEditorAction;
import org.eclipse.jdt.internal.junit.ui.TestRunnerViewPart;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;

public class OpenTestAction
extends OpenEditorAction {
    private String fMethodName;
    private IMethod fMethod;
    private int fLineNumber = -1;

    public OpenTestAction(TestRunnerViewPart testRunnerPart, TestCaseElement testCase) {
        this(testRunnerPart, testCase.getClassName(), OpenTestAction.extractRealMethodName(testCase), true);
        String trace = testCase.getTrace();
        if (trace != null) {
            String rawClassName = TestElement.extractRawClassName((String)testCase.getTestName());
            rawClassName = rawClassName.replaceAll("\\.", "\\\\.");
            Pattern pattern = Pattern.compile("at " + (rawClassName = rawClassName.replaceAll("\\$", "\\\\\\$")) + '.' + this.fMethodName + "\\(.*:(\\d+)\\)");
            Matcher matcher = pattern.matcher(trace);
            if (matcher.find()) {
                try {
                    this.fLineNumber = Integer.parseInt(matcher.group(1));
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
    }

    public OpenTestAction(TestRunnerViewPart testRunner, String className) {
        this(testRunner, className, null, true);
    }

    private OpenTestAction(TestRunnerViewPart testRunner, String className, String method, boolean activate) {
        super(testRunner, className, activate);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.jdt.junit.open_test_action_context");
        this.fMethodName = method;
    }

    private static String extractRealMethodName(TestCaseElement testCase) {
        if (testCase.isIgnored() && JavaConventions.validateJavaTypeName((String)testCase.getTestName(), (String)"1.5", (String)"1.5").getSeverity() != 4) {
            return null;
        }
        String testMethodName = testCase.getTestMethodName();
        int i = 0;
        while (i < testMethodName.length()) {
            if (!Character.isJavaIdentifierPart(testMethodName.charAt(i))) {
                return testMethodName.substring(0, i);
            }
            ++i;
        }
        return testMethodName;
    }

    @Override
    protected IJavaElement findElement(IJavaProject project, String className) throws JavaModelException {
        IType type = this.findType(project, className);
        if (type == null) {
            return null;
        }
        if (this.fMethodName == null) {
            return type;
        }
        IMethod method = this.findMethod(type);
        if (method == null) {
            IType[] supertypes;
            ITypeHierarchy typeHierarchy = type.newSupertypeHierarchy(null);
            IType[] iTypeArray = supertypes = typeHierarchy.getAllSuperclasses(type);
            int n = supertypes.length;
            int n2 = 0;
            while (n2 < n) {
                IType supertype = iTypeArray[n2];
                method = this.findMethod(supertype);
                if (method != null) break;
                ++n2;
            }
        }
        if (method == null) {
            String title = JUnitMessages.OpenTestAction_dialog_title;
            String message = Messages.format((String)JUnitMessages.OpenTestAction_error_methodNoFound, (Object)BasicElementLabels.getJavaElementName((String)this.fMethodName));
            MessageDialog.openInformation((Shell)this.getShell(), (String)title, (String)message);
            return type;
        }
        this.fMethod = method;
        return method;
    }

    private IMethod findMethod(IType type) {
        ArrayList<IMethod> foundMethods;
        block8: {
            IStatus status = JavaConventionsUtil.validateMethodName((String)this.fMethodName, (IJavaElement)type);
            if (!status.isOK()) {
                return null;
            }
            IMethod method = type.getMethod(this.fMethodName, new String[0]);
            if (method != null && method.exists()) {
                return method;
            }
            try {
                foundMethods = new ArrayList<IMethod>();
                IMethod[] iMethodArray = type.getMethods();
                int n = iMethodArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IMethod method2 = iMethodArray[n2];
                    String methodName = method2.getElementName();
                    IAnnotation methodAnnotation = method2.getAnnotation("Test");
                    if ((methodName.startsWith("test") || methodAnnotation != null && methodAnnotation.exists()) && this.fMethodName.equals(methodName)) {
                        foundMethods.add(method2);
                    }
                    ++n2;
                }
                if (!foundMethods.isEmpty()) break block8;
                return null;
            }
            catch (JavaModelException javaModelException) {
                return null;
            }
        }
        if (foundMethods.size() > 1) {
            IMethod[] elements = foundMethods.toArray(new IMethod[foundMethods.size()]);
            String title = JUnitMessages.OpenTestAction_dialog_title;
            String message = JUnitMessages.OpenTestAction_select_element;
            return (IMethod)SelectionConverter.selectJavaElement((IJavaElement[])elements, (Shell)this.getShell(), (String)title, (String)message);
        }
        return (IMethod)foundMethods.get(0);
    }

    @Override
    protected void reveal(ITextEditor textEditor) {
        if (this.fLineNumber >= 0) {
            try {
                IDocument document = textEditor.getDocumentProvider().getDocument((Object)textEditor.getEditorInput());
                int lineOffset = document.getLineOffset(this.fLineNumber - 1);
                int lineLength = document.getLineLength(this.fLineNumber - 1);
                if (this.fMethod != null) {
                    try {
                        ISourceRange sr = this.fMethod.getSourceRange();
                        if (sr == null || sr.getOffset() == -1 || lineOffset < sr.getOffset() || sr.getOffset() + sr.getLength() < lineOffset + lineLength) {
                            throw new BadLocationException();
                        }
                    }
                    catch (JavaModelException javaModelException) {}
                }
                textEditor.selectAndReveal(lineOffset, lineLength);
                return;
            }
            catch (BadLocationException badLocationException) {}
        }
        if (this.fMethod != null) {
            try {
                ISourceRange range = this.fMethod.getNameRange();
                if (range != null && range.getOffset() >= 0) {
                    textEditor.selectAndReveal(range.getOffset(), range.getLength());
                }
            }
            catch (JavaModelException javaModelException) {}
        }
    }
}

