/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.refactoring;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.internal.junit.Messages;
import org.eclipse.jdt.internal.junit.refactoring.LaunchConfigChange;
import org.eclipse.jdt.internal.junit.refactoring.LaunchConfigurationContainer;
import org.eclipse.jdt.internal.junit.ui.JUnitMessages;
import org.eclipse.ltk.core.refactoring.Change;

public class LaunchConfigSetAttributeChange
extends LaunchConfigChange {
    private String fNewValue;
    private final String fAttributeName;

    public LaunchConfigSetAttributeChange(LaunchConfigurationContainer config, String attributeName, String newValue, boolean shouldFlagWarning) {
        super(config, shouldFlagWarning);
        this.fNewValue = newValue;
        this.fAttributeName = attributeName;
    }

    protected Change getUndo(String oldValue) throws CoreException {
        return new LaunchConfigSetAttributeChange(this.fConfig, this.fAttributeName, oldValue, this.shouldFlagWarning());
    }

    public String getChangedAttributeName() {
        return this.fAttributeName;
    }

    protected void alterLaunchConfiguration(ILaunchConfigurationWorkingCopy copy) throws CoreException {
        copy.setAttribute(this.fAttributeName, this.fNewValue);
    }

    protected String getOldValue(ILaunchConfiguration config) throws CoreException {
        return config.getAttribute(this.fAttributeName, null);
    }

    public String getName() {
        return Messages.format((String)JUnitMessages.LaunchConfigSetAttributeChange_name, (Object[])new Object[]{this.fAttributeName, this.fConfig.getName()});
    }
}

