/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ecl.doc;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.rcptt.ecl.core.util.EclCommandNameConvention;
import org.eclipse.rcptt.ecl.doc.EclDocCommandDocumentation;
import org.eclipse.rcptt.ecl.doc.EclDocParameter;
import org.eclipse.rcptt.ecl.doc.EclDocPlugin;
import org.eclipse.rcptt.ecl.doc.EclDocWriter;
import org.eclipse.rcptt.ecl.doc.IEclDocProvider;
import org.eclipse.rcptt.ecl.internal.core.CorePlugin;
import org.eclipse.rcptt.ecl.runtime.CoreUtils;

public class EclDocCommand
implements IEclDocProvider {
    private EClass eclass;
    private String name;
    private EclDocCommandDocumentation docs;
    private List<EclDocParameter> params;
    private static ArrayList<EclDocCommand> commands = null;
    private static HashMap<String, EclDocCommand> commandsByName = null;
    private static List<String> excludedCommands = Arrays.asList("recognize", "contains-image", "sequence", "parallel", "get-advanced-info", "control-not-found", "pipeline", "setup-player", "shutdown-player", "get-global", "set-global", "script", "get-region", "get-region-text", "alert", "get-memory-usage", "get-val", "proc-instance", "save-session", "restore-session", "upload-file", "declaration", "unzip-file", "shoutdown-player", "path-utils", "list-executed-suites", "kill-all-executed", "binary-op");
    private static EClass COMMAND = (EClass)EPackage.Registry.INSTANCE.getEPackage("http://www.eclipse.org/ecl/core.ecore").getEClassifier("Command");

    public EclDocCommand(EClass eclass) {
        this.eclass = eclass;
        this.name = EclCommandNameConvention.toCommandName((String)eclass.getName());
    }

    public boolean isExcluded() {
        return excludedCommands.contains(this.name);
    }

    public String getName() {
        return this.name;
    }

    public boolean isInternal() {
        return this.eclass.getEAnnotation("http://www.eclipse.org/ecl/internal") != null;
    }

    public EClass getEClass() {
        return this.eclass;
    }

    public EclDocCommandDocumentation getDocumentation() {
        if (this.docs == null) {
            this.docs = new EclDocCommandDocumentation(this);
        }
        return this.docs;
    }

    public List<EclDocParameter> getParameters() {
        if (this.params != null) {
            return this.params;
        }
        this.params = new ArrayList<EclDocParameter>();
        EList features = this.getEClass().getEAllStructuralFeatures();
        for (EStructuralFeature f : features) {
            this.params.add(new EclDocParameter(f));
        }
        return this.params;
    }

    public EclDocParameter findParameter(String name) {
        if (name.length() > 1 && name.charAt(0) == '-') {
            name = name.substring(1);
        }
        for (EclDocParameter p : this.getParameters()) {
            if (!p.getName().equals(name)) continue;
            return p;
        }
        return null;
    }

    public static synchronized List<EclDocCommand> getAllPublicCommands() {
        CorePlugin.getScriptletManager().getAllCommandNames();
        if (commands != null) {
            return commands;
        }
        commands = new ArrayList();
        commandsByName = new HashMap();
        Object[] objectArray = EPackage.Registry.INSTANCE.values().toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            try {
                if (o instanceof EPackage.Descriptor) {
                    o = ((EPackage.Descriptor)o).getEPackage();
                }
                if (o instanceof EPackage) {
                    EPackage p = (EPackage)o;
                    for (EClassifier classifier : p.getEClassifiers()) {
                        EclDocCommand command;
                        EClass class_;
                        if (!(classifier instanceof EClass) || (class_ = (EClass)classifier).isAbstract() || !class_.getEAllSuperTypes().contains((Object)COMMAND) || (command = new EclDocCommand(class_)).isInternal() || command.isExcluded() || commandsByName.containsKey(command.getName())) continue;
                        commands.add(command);
                        commandsByName.put(command.getName(), command);
                    }
                }
            }
            catch (Exception e) {
                EclDocPlugin.err("Failed to load documentation from: " + o, e);
            }
            ++n2;
        }
        Collections.sort(commands, new Comparator<EclDocCommand>(){

            @Override
            public int compare(EclDocCommand a, EclDocCommand b) {
                return a.getName().compareTo(b.getName());
            }
        });
        return commands;
    }

    public static synchronized EclDocCommand get(String name) {
        if (commandsByName == null) {
            EclDocCommand.getAllPublicCommands();
        }
        return commandsByName.get(name);
    }

    private static void writeParam(EclDocParameter param, EclDocWriter w) throws IOException {
        String paramDesc;
        String literal;
        w.dd();
        w.b(param.getName());
        int lower = param.getLowerBound();
        int upper = param.getUpperBound();
        if (upper != lower) {
            if (lower == 0 && upper == 1) {
                w.raw(" optional");
            } else {
                w.raw(" (");
                if (upper >= lower) {
                    w.raw(lower);
                    w.raw(", ");
                    w.raw(upper);
                } else {
                    w.raw(lower);
                    w.raw(", ");
                    w.raw("&infin;");
                }
                w.raw(")");
            }
        } else if (lower != 1) {
            w.raw(" ");
            w.raw(lower);
        }
        w.raw(" ");
        w.raw(param.getFriendlyTypeName());
        if (param.isOptional() && !CoreUtils.isBlank((String)(literal = param.getFriendlyDefaultLiteral()))) {
            w.raw(" = ");
            w.raw(literal);
        }
        if (!CoreUtils.isBlank((String)(paramDesc = param.getDocumentation().getDescription()))) {
            w.raw(": ");
            w.raw(paramDesc);
        }
        w.close();
    }

    @Override
    public void writeEclDoc(EclDocWriter w) throws IOException {
        String example;
        String returns;
        String desc = this.getDocumentation().getDescription();
        desc = CoreUtils.isBlank((String)desc) ? this.getName() : desc;
        w.text(desc);
        EclDocParameter inputParam = null;
        ArrayList<EclDocParameter> params = new ArrayList<EclDocParameter>();
        for (EclDocParameter p : this.getParameters()) {
            if (p.isInput()) {
                inputParam = p;
                continue;
            }
            if (p.isInternal()) continue;
            params.add(p);
        }
        if (inputParam != null) {
            w.dl();
            w.dt("Input:");
            EclDocCommand.writeParam(inputParam, w);
            w.close();
        }
        if (params.size() > 0) {
            w.dl();
            w.dt("Parameters:");
            for (EclDocParameter p : params) {
                EclDocCommand.writeParam(p, w);
            }
            w.close();
        }
        if (!CoreUtils.isBlank((String)(returns = this.getDocumentation().getReturns()))) {
            w.dl();
            w.dt("Output:");
            w.dd(returns);
            w.close();
        }
        if (!CoreUtils.isBlank((String)(example = this.getDocumentation().getExample()))) {
            w.dl();
            w.dt("Example:");
            w.dd();
            w.pre(example);
            w.close();
            w.close();
        }
    }
}

