/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.recording.core.swt;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.bindings.keys.KeySequence;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.bindings.keys.ParseException;
import org.eclipse.jface.bindings.keys.SWTKeySupport;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.rcptt.logging.Q7LoggingManager;
import org.eclipse.rcptt.tesla.core.TeslaFeatures;
import org.eclipse.rcptt.tesla.core.protocol.ProtocolFactory;
import org.eclipse.rcptt.tesla.core.protocol.Type;
import org.eclipse.rcptt.tesla.core.protocol.raw.AssertionFocus;
import org.eclipse.rcptt.tesla.core.protocol.raw.Command;
import org.eclipse.rcptt.tesla.core.protocol.raw.Element;
import org.eclipse.rcptt.tesla.core.protocol.raw.RawFactory;
import org.eclipse.rcptt.tesla.core.protocol.raw.SetMode;
import org.eclipse.rcptt.tesla.internal.core.TeslaCore;
import org.eclipse.rcptt.tesla.internal.ui.player.SWTUIPlayer;
import org.eclipse.rcptt.tesla.internal.ui.processors.SWTUIProcessor;
import org.eclipse.rcptt.tesla.recording.aspects.IAbstractSWTEventListener;
import org.eclipse.rcptt.tesla.recording.aspects.IAssertSWTEventListener;
import org.eclipse.rcptt.tesla.recording.aspects.ISkipAwareEventListener;
import org.eclipse.rcptt.tesla.recording.aspects.SWTEventManager;
import org.eclipse.rcptt.tesla.recording.aspects.WorkbenchEventManager;
import org.eclipse.rcptt.tesla.recording.core.IRecordingHelper;
import org.eclipse.rcptt.tesla.recording.core.IRecordingProcessor;
import org.eclipse.rcptt.tesla.recording.core.TeslaRecorder;
import org.eclipse.rcptt.tesla.recording.core.swt.IRecordingDescriber;
import org.eclipse.rcptt.tesla.recording.core.swt.RecordingDescriberManager;
import org.eclipse.rcptt.tesla.recording.core.swt.SWTRecordingHelper;
import org.eclipse.rcptt.tesla.recording.core.swt.util.RecordedEvent;
import org.eclipse.rcptt.tesla.swt.events.TeslaEventManager;
import org.eclipse.rcptt.util.swt.ShellUtilsProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolItem;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.ToolTip;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public class SWTAssertManager
implements IRecordingProcessor,
IAssertSWTEventListener,
ISkipAwareEventListener {
    private Set<String> widgetClasses = new HashSet<String>();
    private TeslaRecorder recorder;
    private IRecordingDescriber freezedCtrl;
    private Widget freezedCtrlWidget;
    private Point freezedPoint;
    private Shell selectionShell;
    private IRecordingDescriber lastFocusedWidget;
    private SWTUIPlayer player;
    private List<IRecordingDescriber> widgetsOnMove = new ArrayList<IRecordingDescriber>();
    private Set<Shell> menuShells = new HashSet<Shell>();
    private Composite bar;
    private Map<MenuItem, MenuItem> menuMap = new HashMap<MenuItem, MenuItem>();
    private List<Menu> menus = new ArrayList<Menu>();
    private Control beforeFreezeFocus = null;

    public void clear() {
        this.lastFocusedWidget = null;
        this.freezedCtrl = null;
    }

    public void initialize(TeslaRecorder teslaRecorder) {
        if (TeslaFeatures.isActivityLogging()) {
            Q7LoggingManager.logMessage((String)"assert engine", (String)"");
        }
        this.recorder = teslaRecorder;
        this.player = SWTRecordingHelper.getHelper().getPlayer();
        SWTEventManager.addListener((IAbstractSWTEventListener)this);
    }

    public int getInitLevel() {
        return 300;
    }

    public void setFreeze(final boolean value, SetMode command) {
        this.widgetClasses.clear();
        if (command != null) {
            this.widgetClasses.addAll((Collection<String>)command.getWidgetClasses());
        }
        if (TeslaFeatures.isActivityLogging()) {
            Q7LoggingManager.logMessage((String)"assert engine", (String)("set freeze mode to: " + value));
        }
        final Display display = PlatformUI.getWorkbench().getDisplay();
        boolean oldValue = SWTEventManager.getFreeze();
        if (display.isDisposed()) {
            SWTEventManager.setFreeze((boolean)false);
            WorkbenchEventManager.setFreeze((boolean)false);
            return;
        }
        SWTEventManager.setIgnoreFreeze((Shell[])this.player.getIgnored());
        SWTEventManager.setFreeze((boolean)value);
        WorkbenchEventManager.setFreeze((boolean)value);
        if (!value) {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    SWTAssertManager.this.callCreateHover(value, null);
                    SWTAssertManager.this.disposeMenuPopups();
                    SWTAssertManager.this.clearPopupMenus();
                }
            });
        }
        if (value != oldValue) {
            if (!value && !display.isDisposed()) {
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        Shell shell = display.getActiveShell();
                        if (shell != null) {
                            try {
                                ShellUtilsProvider.getShellUtils().forceActive(shell);
                            }
                            catch (CoreException e) {
                                throw new RuntimeException(e);
                            }
                            if (SWTAssertManager.this.beforeFreezeFocus != null) {
                                Shell[] shells;
                                Shell[] shellArray = shells = display.getShells();
                                int n = shells.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    Shell s = shellArray[n2];
                                    String creationMethod = TeslaEventManager.getManager().getShellCreationMethod(s);
                                    if ("AbstractTableInformationControl.<init>()".equals(creationMethod)) {
                                        try {
                                            ShellUtilsProvider.getShellUtils().forceActive(s);
                                        }
                                        catch (CoreException e) {
                                            throw new RuntimeException(e);
                                        }
                                        s.forceFocus();
                                    }
                                    ++n2;
                                }
                            }
                        }
                    }
                });
            } else {
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        SWTAssertManager.this.beforeFreezeFocus = display.getFocusControl();
                    }
                });
            }
        }
        if (!value) {
            this.freezedCtrl = null;
            this.lastFocusedWidget = null;
        }
    }

    private void disposeMenuPopups() {
        if (TeslaFeatures.isActivityLogging()) {
            Q7LoggingManager.logMessage((String)"assert engine", (String)"dispose popup menus");
        }
        for (Shell menuShell : this.menuShells) {
            if (menuShell == null) continue;
            menuShell.dispose();
        }
        this.menuShells.clear();
    }

    private Widget getChild(Widget parent, int x, int y) {
        if (!(parent instanceof Control)) {
            return parent;
        }
        Control control = (Control)parent;
        int relX = x - control.getBounds().x;
        int relY = y - control.getBounds().y;
        if (!(parent instanceof Composite)) {
            return parent;
        }
        Composite c = (Composite)parent;
        Control[] controlArray = c.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control ctrl = controlArray[n2];
            if (ctrl.getBounds().contains(relX, relY) && ctrl.isVisible()) {
                return this.getChild((Widget)ctrl, relX, relY);
            }
            ++n2;
        }
        return parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean handleEventInFreeze(Widget widget, int type, Event event) {
        if (TeslaFeatures.isActivityLogging()) {
            try {
                RecordedEvent toRecording = new RecordedEvent(((SWTUIProcessor)this.recorder.getProcessor(SWTUIProcessor.class)).getPlayer(), event, type, widget);
                Q7LoggingManager.logMessage((String)"assert engine.events", (String)("event: " + toRecording.toString()));
            }
            catch (Throwable throwable) {}
        }
        try {
            Object lastFreezed;
            SWTEventManager.setShouldProceed((boolean)true);
            if (type == 2 && event != null) {
                if (this.isShortcutRequest(event, this.recorder.getRecordModeShortcuts())) {
                    if (TeslaFeatures.isActivityLogging()) {
                        Q7LoggingManager.logMessage((String)"assert engine", (String)"send record mode request");
                    }
                    this.recorder.executeCommand((Command)ProtocolFactory.eINSTANCE.createRecordingModeRequest());
                }
                if (this.isShortcutRequest(event, this.recorder.getStopRecordShortcuts())) {
                    if (TeslaFeatures.isActivityLogging()) {
                        Q7LoggingManager.logMessage((String)"assert engine", (String)"send stop record request");
                    }
                    Type stopType = ProtocolFactory.eINSTANCE.createType();
                    stopType.setState(Integer.valueOf(event.stateMask));
                    stopType.setCharacter(event.character);
                    stopType.setCode(Integer.valueOf(event.keyCode));
                    this.recorder.executeCommand((Command)stopType);
                }
            }
            if (widget instanceof Control) {
                Control ctrl = (Control)widget;
                if (this.selectionShell != null && ctrl.getShell().equals(this.selectionShell)) {
                    if (Platform.getOS().equals("macosx") && this.lastFocusedWidget != null && this.lastFocusedWidget.getWidget() != null && type == 5) {
                        widget = this.getChild(this.lastFocusedWidget.getWidget(), event.x, event.y);
                    } else {
                        return true;
                    }
                }
                for (Shell menuShell : this.menuShells) {
                    if (!ctrl.getShell().equals(menuShell)) continue;
                    return true;
                }
            }
            if (widget instanceof Control && !((Control)widget).isVisible()) {
                return false;
            }
            if (event == null) {
                event = new Event();
            }
            this.callCreateHover(true, this.getShell(widget));
            if (widget instanceof MenuItem && this.menuMap.containsKey(widget)) {
                widget = (Widget)this.menuMap.get(widget);
            }
            IRecordingDescriber assertDescr = this.selectAllowedParent(RecordingDescriberManager.getDescriber(widget, event.x, event.y, true));
            if (type == 13 && widget instanceof MenuItem) {
                if (TeslaFeatures.isActivityLogging()) {
                    Q7LoggingManager.logMessage((String)"assert engine", (String)("assertion target locked for menu item: " + ((MenuItem)widget).getText()));
                }
                this.seachForElement(assertDescr.searchForElement(this.recorder), true, assertDescr);
                this.freezedCtrl = assertDescr;
            }
            if (type == 1 && this.freezedCtrl != null) {
                block8 : switch (event.keyCode) {
                    case 0x1000001: {
                        if (TeslaFeatures.isActivityLogging()) {
                            Q7LoggingManager.logMessage((String)"assert engine", (String)"switch assertion target lock to control parent");
                        }
                        this.freezedCtrl = this.freezedCtrl.getParent();
                        this.updateHoverAccordingTo(this.freezedCtrl, this.freezedPoint.x, this.freezedPoint.y);
                        break;
                    }
                    case 0x1000002: {
                        IRecordingDescriber child;
                        if (TeslaFeatures.isActivityLogging()) {
                            Q7LoggingManager.logMessage((String)"assert engine", (String)"switch assertion target lock to child");
                        }
                        if ((child = RecordingDescriberManager.getDescriber(this.freezedCtrlWidget, this.freezedPoint.x, this.freezedPoint.y, true)).equals(this.freezedCtrl)) break;
                        while (true) {
                            IRecordingDescriber parent;
                            if (this.freezedCtrl.equals(parent = child.getParent())) {
                                this.freezedCtrl = child;
                                this.updateHoverAccordingTo(this.freezedCtrl, this.freezedPoint.x, this.freezedPoint.y);
                                break block8;
                            }
                            if (parent.equals(child)) {
                                this.freezedCtrl = child;
                                this.updateHoverAccordingTo(this.freezedCtrl, this.freezedPoint.x, this.freezedPoint.y);
                                break block8;
                            }
                            child = parent;
                        }
                    }
                }
            }
            if (type == 4) {
                for (Shell menuShell : this.menuShells) {
                    if (menuShell == null || !(widget instanceof Control) || ((Control)widget).getShell().equals(menuShell)) continue;
                    this.menuShells.remove(menuShell);
                    menuShell.dispose();
                }
                if (event.button == 1) {
                    if (this.freezedCtrl == null) {
                        if (TeslaFeatures.isActivityLogging()) {
                            Q7LoggingManager.logMessage((String)"assert engine", (String)"assertion target locked");
                        }
                        this.freezedCtrl = assertDescr;
                        this.freezedPoint = new Point(event.x, event.y);
                        this.freezedCtrlWidget = widget;
                        this.updateHoverAccordingTo(this.freezedCtrl, event.x, event.y);
                    } else {
                        if (TeslaFeatures.isActivityLogging()) {
                            Q7LoggingManager.logMessage((String)"assert engine", (String)"unlock assertion target");
                        }
                        lastFreezed = this.freezedCtrl;
                        this.freezedCtrl = null;
                        this.updateHoverAccordingTo(assertDescr, event.x, event.y);
                        if (lastFreezed != null) {
                            lastFreezed.redraw();
                        }
                    }
                } else if (event.button == 3 && widget instanceof Control) {
                    if (TeslaFeatures.isActivityLogging()) {
                        Q7LoggingManager.logMessage((String)"assert engine", (String)"show popup menu");
                    }
                    this.showPopupMenu(event, (Control)widget, assertDescr);
                }
            }
            if ((type == 5 || type == 6 || type == 7 || type == 30 || type == 41) && this.freezedCtrl == null) {
                lastFreezed = this.widgetsOnMove;
                synchronized (lastFreezed) {
                    this.widgetsOnMove.add(assertDescr);
                }
                final Event fevent = event;
                if (widget != null) {
                    widget.getDisplay().timerExec(150, new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            List list = SWTAssertManager.this.widgetsOnMove;
                            synchronized (list) {
                                if (SWTAssertManager.this.widgetsOnMove.size() > 0) {
                                    if (SWTAssertManager.this.freezedCtrl == null) {
                                        Widget w;
                                        IRecordingDescriber lastWidget = (IRecordingDescriber)SWTAssertManager.this.widgetsOnMove.get(SWTAssertManager.this.widgetsOnMove.size() - 1);
                                        if (!(lastWidget.equals(SWTAssertManager.this.lastFocusedWidget) && SWTAssertManager.this.selectionShell.isVisible() || (w = lastWidget.getWidget()).isDisposed())) {
                                            SWTAssertManager.this.updateHoverAccordingTo(lastWidget, fevent.x, fevent.y);
                                        }
                                        SWTAssertManager.this.lastFocusedWidget = lastWidget;
                                    }
                                    SWTAssertManager.this.widgetsOnMove.clear();
                                }
                            }
                        }
                    });
                }
            }
            if (type == 3 || type == 32 || type == 5 || type == 4 || type == 1 || type == 2 || type == 13 || type == 8 || type == 37 || type == 38 || type == 27 || type == 15 || type == 14 || type == 26 || type == 17 || type == 18 || type == 19 || type == 20 || type == 27 || type == 24 || type == 35 || type == 6 || type == 7 || type == 16 || type == 31) {
                return false;
            }
            return type != 5 || !(widget instanceof Canvas);
            {
            }
        }
        finally {
            SWTEventManager.setShouldProceed((boolean)false);
        }
    }

    public boolean isShortcutRequest(Event e, String[] shortcuts) {
        if (shortcuts == null) {
            return false;
        }
        int accelerator = SWTKeySupport.convertEventToUnmodifiedAccelerator((Event)e);
        KeySequence sequence = KeySequence.getInstance((KeyStroke)SWTKeySupport.convertAcceleratorToKeyStroke((int)accelerator));
        if (shortcuts != null) {
            String[] stringArray = shortcuts;
            int n = shortcuts.length;
            int n2 = 0;
            while (n2 < n) {
                String formatted = stringArray[n2];
                try {
                    KeySequence shortcut = KeySequence.getInstance((String)formatted);
                    if (sequence.equals((Object)shortcut)) {
                        return true;
                    }
                }
                catch (ParseException parseException) {
                    TeslaCore.log((String)("Invalid shortcut: " + formatted));
                }
                ++n2;
            }
        }
        return false;
    }

    private void showPopupMenu(Event event, Control c, IRecordingDescriber describer) {
        if (TeslaFeatures.isActivityLogging()) {
            Q7LoggingManager.logMessage((String)"assert engine", (String)("show popup menu for: " + c.getClass().toString()));
        }
        Menu menu = null;
        this.player.getEvents().sendEvent((Widget)c, 35, event.x, event.y, 0x100000);
        menu = c.getMenu();
        if (menu != null && !menu.isDisposed()) {
            this.player.getEvents().sendEvent((Widget)menu, 22);
            Menu popupMenu = new Menu((Decorations)this.getShell((Widget)c), 8);
            this.clearPopupMenus();
            this.copyMenuTo(menu, popupMenu);
            this.menus.add(popupMenu);
            popupMenu.setVisible(true);
        }
    }

    private void clearPopupMenus() {
        for (MenuItem item : this.menuMap.keySet()) {
            if (item.isDisposed()) continue;
            item.dispose();
        }
        this.menuMap.clear();
        for (Menu menu : this.menus) {
            if (menu.isDisposed()) continue;
            menu.dispose();
        }
        this.menus.clear();
    }

    private void copyMenuTo(Menu menu, Menu popupMenu) {
        if (TeslaFeatures.isActivityLogging()) {
            Q7LoggingManager.logMessage((String)"assert engine", (String)"copy popup menu");
        }
        MenuItem[] menuItemArray = menu.getItems();
        int n = menuItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            MenuItem i = menuItemArray[n2];
            MenuItem copy = new MenuItem(popupMenu, i.getStyle());
            this.menuMap.put(copy, i);
            String text = i.getText();
            String text2 = "";
            if (text.contains("\t")) {
                int tabIndex = text.indexOf(9);
                text2 = text.substring(tabIndex + 1);
                text = text.substring(0, tabIndex);
            }
            copy.setText(String.valueOf(text) + (!i.getEnabled() ? " (disabled)" : "") + "\t" + text2);
            if (i.getImage() != null) {
                copy.setImage(new Image((Device)i.getDisplay(), i.getImage(), i.getEnabled() ? 0 : 1));
            }
            copy.setSelection(i.getSelection());
            if ((copy.getStyle() & 0x40) != 0) {
                this.player.getEvents().sendEvent((Widget)i, 30);
                if (i.getMenu() != null) {
                    this.player.getEvents().sendEvent((Widget)i.getMenu(), 22);
                    Menu menuCopy = new Menu(copy);
                    this.copyMenuTo(i.getMenu(), menuCopy);
                    copy.setMenu(menuCopy);
                }
            }
            ++n2;
        }
    }

    private void showMenuAt(Event event, Control c, Menu menu) {
        Shell menuShell = new Shell(this.getShell((Widget)c), 12);
        this.menuShells.add(menuShell);
        menuShell.setLayout((Layout)new FillLayout());
        this.bar = new Composite((Composite)menuShell, 2048);
        this.bar.setLayout((Layout)new GridLayout(1, false));
        Color color = c.getDisplay().getSystemColor(25);
        this.bar.setBackground(color);
        menuShell.setBackground(color);
        MenuItem[] menuItemArray = menu.getItems();
        int n = menuItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            MenuItem i = menuItemArray[n2];
            if (i.getStyle() == 2) {
                Label l = new Label(this.bar, 258);
                GridDataFactory.fillDefaults().grab(true, false).span(1, 1).applyTo((Control)l);
            } else {
                Composite line = new Composite(this.bar, 0);
                GridLayoutFactory.fillDefaults().numColumns(3).applyTo(line);
                GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)line);
                Label l = new Label(line, 0);
                Image img = i.getImage();
                if (img != null) {
                    l.setImage(new Image((Device)c.getDisplay(), img, 0));
                }
                Label l2 = new Label(line, 0);
                GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)l2);
                String text = i.getText();
                String text2 = "";
                if (text.contains("\t")) {
                    int tabIndex = text.indexOf(9);
                    text2 = text.substring(tabIndex + 1);
                    text = text.substring(0, tabIndex);
                }
                l2.setText(text);
                Label l3 = new Label(line, 0);
                l3.setText(text2);
                l.setEnabled(i.getEnabled());
                l2.setEnabled(i.getEnabled());
                line.setBackground(color);
                l.setBackground(color);
                l2.setBackground(color);
                l3.setBackground(color);
            }
            ++n2;
        }
        Point pos = c.toDisplay(event.x, event.y);
        Point size = this.bar.computeSize(-1, -1);
        menuShell.setBounds(pos.x, pos.y, size.x + 5, size.y + 5);
        menuShell.layout();
        menuShell.open();
    }

    private Shell getShell(Widget widget) {
        if (widget instanceof TreeItem) {
            return ((TreeItem)widget).getParent().getShell();
        }
        if (widget instanceof TableItem) {
            return ((TableItem)widget).getParent().getShell();
        }
        if (widget instanceof ToolItem) {
            return ((ToolItem)widget).getParent().getShell();
        }
        if (widget instanceof CoolItem) {
            return ((CoolItem)widget).getParent().getShell();
        }
        if (widget instanceof ScrollBar) {
            return ((ScrollBar)widget).getParent().getShell();
        }
        if (widget instanceof ToolTip) {
            return ((ToolTip)widget).getParent();
        }
        if (widget instanceof Control) {
            return ((Control)widget).getShell();
        }
        if (widget instanceof Menu) {
            return ((Menu)widget).getShell();
        }
        if (widget instanceof MenuItem) {
            return ((MenuItem)widget).getParent().getShell();
        }
        return null;
    }

    private synchronized void updateHover(Rectangle bounds, Point point, boolean controlEquals, boolean inactive) {
        if (this.selectionShell == null || this.selectionShell.isDisposed() || this.selectionShell.getParent() != null && this.selectionShell.getParent().isDisposed()) {
            this.selectionShell = null;
            this.freezedCtrl = null;
            return;
        }
        bounds.width += 6;
        bounds.height += 6;
        int px = point.x - 3;
        int py = point.y - 3;
        Rectangle displayBounds = this.selectionShell.getDisplay().getBounds();
        if (px + bounds.width > displayBounds.width) {
            bounds.width = displayBounds.width - px;
            if (bounds.width < 0) {
                bounds.width = 1;
            }
        }
        if (py + bounds.height > displayBounds.height) {
            bounds.height = displayBounds.height - py;
            if (bounds.height < 0) {
                bounds.height = 1;
            }
        }
        this.selectionShell.setBounds(px, py, bounds.width, bounds.height);
        Region region = new Region();
        int p0x = 7;
        int p0y = 7;
        int st = 2;
        region.add(0, 0, p0x, st);
        region.add(0, 0, st, p0x);
        region.add(bounds.width - p0x, 0, p0x, st);
        region.add(bounds.width - st, 0, st, p0y);
        region.add(bounds.width - p0x, bounds.height - st, p0x, st);
        region.add(bounds.width - st, bounds.height - p0y, 2, p0y);
        region.add(0, bounds.height - st, p0x, st);
        region.add(0, bounds.height - p0y, 2, p0y);
        if (controlEquals) {
            region.add(0, 0, bounds.width, 2);
            region.add(0, bounds.height - 2, bounds.width, 2);
            region.add(0, 0, 2, bounds.height);
            region.add(bounds.width - 2, 0, 2, bounds.height);
        }
        this.selectionShell.setBackground(this.selectionShell.getDisplay().getSystemColor(!inactive ? 3 : 2));
        Region oldRegion = this.selectionShell.getRegion();
        if (oldRegion != null && !oldRegion.isDisposed()) {
            oldRegion.dispose();
        }
        this.selectionShell.setRegion(region);
        if (!this.selectionShell.isVisible()) {
            this.selectionShell.setVisible(true);
        }
        this.selectionShell.redraw();
        this.selectionShell.moveAbove(null);
        this.selectionShell.setAlpha(127);
    }

    private synchronized void callCreateHover(boolean value, Shell parent) {
        Composite composite;
        if (!this.menuShells.isEmpty()) {
            return;
        }
        if (this.selectionShell != null && !this.selectionShell.isDisposed() && !this.selectionShell.getDisplay().equals(Display.getCurrent())) {
            this.selectionShell.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    SWTAssertManager.this.selectionShell.dispose();
                }
            });
            this.lastFocusedWidget = null;
            this.selectionShell = null;
            this.widgetsOnMove.clear();
        }
        if (this.selectionShell != null && this.selectionShell.isDisposed()) {
            this.selectionShell = null;
        } else if (this.selectionShell != null && (composite = this.selectionShell.getParent()) != null && composite.isDisposed()) {
            this.selectionShell = null;
            this.freezedCtrl = null;
        }
        if (this.selectionShell == null && value) {
            this.selectionShell = new Shell(16396);
            this.selectionShell.setBackground(this.selectionShell.getDisplay().getSystemColor(3));
            this.selectionShell.setText("Hover");
        } else if (!value && this.selectionShell != null) {
            this.selectionShell.dispose();
            this.selectionShell = null;
        }
    }

    private void updateHoverAccordingTo(IRecordingDescriber descr, int x, int y) {
        if (this.selectionShell != null) {
            Rectangle rectangle = descr.getBounds();
            Point point = descr.getPoint();
            boolean fixed = descr.equals(this.freezedCtrl);
            if (point != null) {
                boolean isAllowedToSelect = this.isAllowedToSelect(descr);
                this.updateHover(rectangle, point, fixed, !isAllowedToSelect);
                if (isAllowedToSelect) {
                    descr.setNeedLogging(fixed);
                    this.seachForElement(descr.searchForElement(this.recorder), fixed, descr);
                }
            }
        }
    }

    private IRecordingDescriber selectAllowedParent(IRecordingDescriber widget) {
        if (this.widgetClasses.size() == 0) {
            return widget;
        }
        IRecordingDescriber descr = null;
        IRecordingDescriber parent = widget;
        do {
            if (this.isAllowedToSelect(parent)) {
                return parent;
            }
            descr = parent;
            parent = parent.getParent();
        } while (descr.getWidget() != parent.getWidget());
        return widget;
    }

    private boolean isAllowedToSelect(IRecordingDescriber descr) {
        if (this.widgetClasses.size() == 0) {
            return true;
        }
        return this.widgetClasses.contains(descr.getWidget().getClass().getCanonicalName());
    }

    private void seachForElement(Element element, boolean fixed, IRecordingDescriber descr) {
        if (element != null) {
            AssertionFocus focus = RawFactory.eINSTANCE.createAssertionFocus();
            focus.setElement((Element)EcoreUtil.copy((EObject)element));
            focus.setPointFixed(fixed);
            if (fixed) {
                Image img;
                if (TeslaFeatures.isActivityLogging()) {
                    Q7LoggingManager.logMessage((String)"assert engine", (String)"assert properties of element: ");
                }
                if (TeslaFeatures.getInstance().isTrue("org.eclipse.rcptt.tesla.recording.iml.imaging.use") && (img = descr.captureImage()) != null) {
                    focus.setImageCapture(SWTUIPlayer.captureControlImage((Image)img));
                }
            }
            this.recorder.safeExecuteCommand((Command)focus);
        }
    }

    public void resetAssertSelection() {
        if (TeslaFeatures.isActivityLogging()) {
            Q7LoggingManager.logMessage((String)"assert engine", (String)"reset assert target lock");
        }
        this.freezedCtrl = null;
        this.lastFocusedWidget = null;
        Display display = PlatformUI.getWorkbench().getDisplay();
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                if (SWTAssertManager.this.selectionShell != null) {
                    SWTAssertManager.this.selectionShell.dispose();
                    SWTAssertManager.this.selectionShell = null;
                }
                SWTAssertManager.this.selectionShell = new Shell(16396);
                SWTAssertManager.this.selectionShell.setBackground(SWTAssertManager.this.selectionShell.getDisplay().getSystemColor(3));
                SWTAssertManager.this.selectionShell.setText("Hover");
                SWTAssertManager.this.disposeMenuPopups();
                SWTAssertManager.this.clearPopupMenus();
            }
        });
    }

    public IRecordingHelper getHelper() {
        return null;
    }

    public boolean isSkipEvent(Widget widget, int type, Event event, boolean send) {
        if (event != null && type == 1) {
            return this.isShortcutRequest(event, this.recorder.getAssertModeShortcuts());
        }
        return false;
    }
}

