/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.dialogs;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.ITypedElement;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.egit.core.AdaptableFileTreeIterator;
import org.eclipse.egit.core.ContainerTreeIterator;
import org.eclipse.egit.core.internal.CompareCoreUtils;
import org.eclipse.egit.core.internal.storage.GitFileRevision;
import org.eclipse.egit.core.internal.storage.WorkingTreeFileRevision;
import org.eclipse.egit.core.internal.util.ResourceUtil;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.UIUtils;
import org.eclipse.egit.ui.internal.CompareUtils;
import org.eclipse.egit.ui.internal.EgitUiEditorUtils;
import org.eclipse.egit.ui.internal.UIIcons;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.actions.BooleanPrefAction;
import org.eclipse.egit.ui.internal.revision.FileRevisionTypedElement;
import org.eclipse.egit.ui.internal.revision.GitCompareFileRevisionEditorInput;
import org.eclipse.egit.ui.internal.revision.LocalFileRevision;
import org.eclipse.egit.ui.internal.revision.ResourceEditableRevision;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jgit.dircache.DirCacheIterator;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.AndTreeFilter;
import org.eclipse.jgit.treewalk.filter.NotIgnoredFilter;
import org.eclipse.jgit.treewalk.filter.OrTreeFilter;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.part.ViewPart;

public class CompareTreeView
extends ViewPart
implements IMenuListener,
IShowInSource {
    public static final String INDEX_VERSION = "%%%INDEX%%%";
    public static final String ID = "org.eclipse.egit.ui.CompareTreeView";
    private static final Image FILE_IMAGE = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");
    private static final Image FOLDER_IMAGE = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
    private final Image SAME_CONTENT = new Image(FILE_IMAGE.getDevice(), FILE_IMAGE, 1);
    private Image ADDED = UIIcons.ELCL16_ADD.createImage();
    private Image DELETED = UIIcons.ELCL16_DELETE.createImage();
    private RepositoryMapping repositoryMapping;
    private TreeViewer tree;
    private ActionFactory.IWorkbenchAction showEqualsAction;
    private ActionFactory.IWorkbenchAction compareModeAction;
    private Map<IPath, FileNode> fileNodes = new HashMap<IPath, FileNode>();
    private Map<IPath, ContainerNode> containerNodes = new HashMap<IPath, ContainerNode>();
    private List<ActionFactory.IWorkbenchAction> actionsToDispose = new ArrayList<ActionFactory.IWorkbenchAction>();
    private Object input;
    private String compareVersion;
    private String baseVersion;
    private boolean showEquals = false;

    public void createPartControl(Composite parent) {
        Composite main = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().spacing(0, 0).applyTo(main);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)main);
        this.tree = new TreeViewer(main, 2);
        this.tree.setContentProvider((IContentProvider)new PathNodeContentProvider());
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.tree.getTree());
        this.tree.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                CompareTreeView.this.reactOnOpen(event);
            }
        });
        this.tree.getTree().setEnabled(false);
        this.createActions();
        this.getViewSite().setSelectionProvider((ISelectionProvider)this.tree);
        this.createContextMenu();
    }

    private void createActions() {
        CompareUtils.ReuseCompareEditorAction reuseCompareEditorAction = new CompareUtils.ReuseCompareEditorAction();
        this.actionsToDispose.add(reuseCompareEditorAction);
        this.getViewSite().getActionBars().getMenuManager().add((IAction)reuseCompareEditorAction);
        this.compareModeAction = new BooleanPrefAction((IPersistentPreferenceStore)Activator.getDefault().getPreferenceStore(), "CompareTreeView_compare_mode", UIText.CompareTreeView_CompareModeTooltip){

            @Override
            public void apply(boolean value) {
            }
        };
        this.compareModeAction.setImageDescriptor(UIIcons.ELCL16_COMPARE_VIEW);
        this.compareModeAction.setEnabled(true);
        this.actionsToDispose.add(this.compareModeAction);
        this.getViewSite().getActionBars().getToolBarManager().add((IAction)this.compareModeAction);
        this.showEqualsAction = new BooleanPrefAction((IPersistentPreferenceStore)Activator.getDefault().getPreferenceStore(), "CompareTreeView_ShowEquals", UIText.CompareTreeView_EqualFilesTooltip){

            @Override
            public void apply(boolean value) {
                CompareTreeView.this.buildTrees(false);
            }
        };
        this.showEqualsAction.setImageDescriptor(UIIcons.ELCL16_FILTER);
        this.showEqualsAction.setEnabled(false);
        this.actionsToDispose.add(this.showEqualsAction);
        this.getViewSite().getActionBars().getToolBarManager().add((IAction)this.showEqualsAction);
        Action expandAllAction = new Action(UIText.CompareTreeView_ExpandAllTooltip){

            public void run() {
                CompareTreeView.this.tree.expandAll();
            }
        };
        expandAllAction.setImageDescriptor(UIIcons.EXPAND_ALL);
        this.getViewSite().getActionBars().getToolBarManager().add((IAction)expandAllAction);
        Action collapseAllAction = new Action(UIText.CompareTreeView_CollapseAllTooltip){

            public void run() {
                CompareTreeView.this.tree.collapseAll();
            }
        };
        collapseAllAction.setImageDescriptor(UIIcons.COLLAPSEALL);
        this.getViewSite().getActionBars().getToolBarManager().add((IAction)collapseAllAction);
    }

    private void reactOnOpen(OpenEvent event) {
        Object selected = ((IStructuredSelection)event.getSelection()).getFirstElement();
        if (selected instanceof ContainerNode) {
            TreeViewer tv;
            tv.setExpandedState(selected, !(tv = (TreeViewer)event.getViewer()).getExpandedState(selected));
        } else if (selected instanceof FileNode) {
            FileNode fileNode = (FileNode)selected;
            boolean compareMode = Activator.getDefault().getPreferenceStore().getBoolean("CompareTreeView_compare_mode");
            if (compareMode) {
                ITypedElement left = this.getTypedElement(fileNode, fileNode.leftRevision, this.getBaseVersionText());
                ITypedElement right = this.getTypedElement(fileNode, fileNode.rightRevision, this.getCompareVersionText());
                GitCompareFileRevisionEditorInput compareInput = new GitCompareFileRevisionEditorInput(left, right, PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage());
                CompareUtils.openInCompare(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (CompareEditorInput)compareInput);
            } else {
                IFile file = fileNode.getFile();
                if (file != null) {
                    this.openFileInEditor(file.getLocation().toOSString());
                }
            }
        }
    }

    private ITypedElement getTypedElement(FileNode node, IFileRevision fileRevision, String versionName) {
        if (fileRevision instanceof LocalFileRevision) {
            LocalFileRevision localFileRevision = (LocalFileRevision)fileRevision;
            return new ResourceEditableRevision(fileRevision, localFileRevision.getFile(), (IRunnableContext)PlatformUI.getWorkbench().getProgressService());
        }
        if (fileRevision == null) {
            return new GitCompareFileRevisionEditorInput.EmptyTypedElement(NLS.bind((String)UIText.CompareTreeView_ItemNotFoundInVersionMessage, (Object)node.getPath(), (Object)versionName));
        }
        Repository repository = this.getRepository();
        String encoding = repository == null ? null : CompareCoreUtils.getResourceEncoding((Repository)repository, (String)node.getRepoRelativePath());
        return new FileRevisionTypedElement(fileRevision, encoding);
    }

    private String getBaseVersionText() {
        if (this.baseVersion == null) {
            return UIText.CompareTreeView_WorkspaceVersionText;
        }
        return CompareUtils.truncatedRevision(this.baseVersion);
    }

    private String getCompareVersionText() {
        if (this.compareVersion.equals(INDEX_VERSION)) {
            return UIText.CompareTreeView_IndexVersionText;
        }
        return CompareUtils.truncatedRevision(this.compareVersion);
    }

    public void setFocus() {
        this.tree.getTree().setFocus();
    }

    public void setInput(IResource[] input, String compareVersion) {
        this.setResourceInput(input);
        this.baseVersion = null;
        this.compareVersion = compareVersion;
        this.buildTrees(true);
        this.updateControls();
    }

    private void setResourceInput(IResource[] input) {
        if (input.length > 0) {
            IResource originalInput;
            ArrayList<IResource> resources = new ArrayList<IResource>(input.length);
            ArrayList<IPath> allPaths = new ArrayList<IPath>(input.length);
            IResource[] iResourceArray = input;
            int n = input.length;
            int n2 = 0;
            while (n2 < n) {
                originalInput = iResourceArray[n2];
                allPaths.add(originalInput.getFullPath());
                ++n2;
            }
            iResourceArray = input;
            n = input.length;
            n2 = 0;
            while (n2 < n) {
                originalInput = iResourceArray[n2];
                boolean skip = false;
                for (IPath path : allPaths) {
                    if (!path.isPrefixOf(originalInput.getFullPath()) || path.segmentCount() >= originalInput.getFullPath().segmentCount()) continue;
                    skip = true;
                    break;
                }
                if (!skip) {
                    resources.add(originalInput);
                }
                ++n2;
            }
            this.input = resources.toArray(new IResource[resources.size()]);
        } else {
            this.input = input;
        }
    }

    public void setInput(IResource[] input, String baseVersion, String compareVersion) {
        this.setResourceInput(input);
        this.baseVersion = baseVersion;
        this.compareVersion = compareVersion;
        this.buildTrees(true);
        this.updateControls();
    }

    public void setInput(Repository input, String baseVersion, String compareVersion) {
        this.input = input;
        this.baseVersion = baseVersion;
        this.compareVersion = compareVersion;
        this.buildTrees(true);
        this.updateControls();
    }

    private void updateControls() {
        for (ActionFactory.IWorkbenchAction action : this.actionsToDispose) {
            action.setEnabled(this.input != null);
        }
        this.tree.getTree().setEnabled(this.input != null);
        if (this.input == null) {
            this.setContentDescription(UIText.CompareTreeView_NoInputText);
        } else {
            String name;
            if (this.input instanceof IResource[]) {
                IResource[] resources = (IResource[])this.input;
                name = resources.length == 1 ? resources[0].getFullPath().makeRelative().toString() : UIText.CompareTreeView_MultipleResourcesHeaderText;
            } else if (this.input instanceof Repository) {
                name = Activator.getDefault().getRepositoryUtil().getRepositoryName((Repository)this.input);
            } else {
                throw new IllegalStateException();
            }
            if (this.baseVersion == null) {
                this.setContentDescription(NLS.bind((String)UIText.CompareTreeView_ComparingWorkspaceVersionDescription, (Object)name, (Object)this.getCompareVersionText()));
            } else {
                this.setContentDescription(NLS.bind((String)UIText.CompareTreeView_ComparingTwoVersionDescription, (Object[])new String[]{name, CompareUtils.truncatedRevision(this.baseVersion), this.getCompareVersionText()}));
            }
        }
    }

    private void buildTrees(final boolean buildMaps) {
        RevCommit baseCommit;
        RevCommit compareCommit;
        Repository repo;
        final Object[] wsExpaneded = this.tree.getExpandedElements();
        final ISelection wsSel = this.tree.getSelection();
        this.tree.setInput(null);
        this.tree.setContentProvider((IContentProvider)new PathNodeContentProvider());
        this.tree.setComparator((ViewerComparator)new PathNodeTreeComparator());
        this.tree.setLabelProvider((IBaseLabelProvider)new PathNodeLabelProvider());
        this.tree.setFilters((ViewerFilter[])new PathNodeFilter[]{new PathNodeFilter()});
        for (ActionFactory.IWorkbenchAction action : this.actionsToDispose) {
            action.setEnabled(false);
        }
        this.showEquals = Activator.getDefault().getPreferenceStore().getBoolean("CompareTreeView_ShowEquals");
        if (this.input instanceof IResource[]) {
            this.repositoryMapping = RepositoryMapping.getMapping((IResource)((IResource[])this.input)[0]);
            if (this.repositoryMapping == null || this.repositoryMapping.getRepository() == null) {
                return;
            }
            repo = this.repositoryMapping.getRepository();
        } else if (this.input instanceof Repository) {
            repo = (Repository)this.input;
        } else {
            return;
        }
        try {
            Throwable throwable = null;
            Object var8_10 = null;
            try (RevWalk rw = new RevWalk(repo);){
                ObjectId commitId = repo.resolve(this.compareVersion);
                RevCommit revCommit = compareCommit = commitId != null ? rw.parseCommit((AnyObjectId)commitId) : null;
                if (this.baseVersion == null) {
                    baseCommit = null;
                } else {
                    commitId = repo.resolve(this.baseVersion);
                    baseCommit = rw.parseCommit((AnyObjectId)commitId);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            Activator.handleError(e.getMessage(), e, true);
            return;
        }
        this.showBusy(true);
        try {
            try {
                new ProgressMonitorDialog(this.getViewSite().getShell()).run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        try {
                            if (buildMaps) {
                                CompareTreeView.this.buildMaps(repo, baseCommit, compareCommit, monitor);
                            }
                            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    CompareTreeView.this.tree.setInput(CompareTreeView.this.input);
                                    CompareTreeView.this.tree.setExpandedElements(wsExpaneded);
                                    CompareTreeView.this.tree.setSelection(wsSel);
                                    CompareTreeView.this.updateControls();
                                }
                            });
                        }
                        catch (IOException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                });
            }
            catch (InvocationTargetException e) {
                Activator.handleError(e.getTargetException().getMessage(), e.getTargetException(), true);
                this.showBusy(false);
            }
            catch (InterruptedException interruptedException) {
                this.input = null;
                this.showBusy(false);
            }
        }
        finally {
            this.showBusy(false);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void buildMaps(Repository repository, RevCommit baseCommit, RevCommit compareCommit, IProgressMonitor monitor) throws InterruptedException, IOException {
        monitor.beginTask(UIText.CompareTreeView_AnalyzingRepositoryTaskText, -1);
        previousTimeMilliseconds = System.currentTimeMillis();
        useIndex = this.compareVersion.equals("%%%INDEX%%%");
        this.fileNodes.clear();
        this.containerNodes.clear();
        checkIgnored = false;
        try {
            var9_8 = null;
            var10_10 = null;
            try {
                tw = new TreeWalk(repository);
                try {
                    if (baseCommit == null) {
                        checkIgnored = true;
                        baseTreeIndex = tw.addTree((AbstractTreeIterator)new AdaptableFileTreeIterator(repository, ResourcesPlugin.getWorkspace().getRoot()));
                    } else {
                        baseTreeIndex = tw.addTree((AbstractTreeIterator)new CanonicalTreeParser(null, repository.newObjectReader(), (AnyObjectId)baseCommit.getTree()));
                    }
                    compareTreeIndex = useIndex == false ? tw.addTree((AbstractTreeIterator)new CanonicalTreeParser(null, repository.newObjectReader(), (AnyObjectId)compareCommit.getTree())) : tw.addTree((AbstractTreeIterator)new DirCacheIterator(repository.readDirCache()));
                    if (this.input instanceof IResource[]) {
                        resources = (IResource[])this.input;
                        orFilters = new ArrayList<PathFilter>(resources.length);
                        var19_17 = resources;
                        var18_18 = resources.length;
                        var17_20 = 0;
                        while (var17_20 < var18_18) {
                            resource = var19_17[var17_20];
                            relPath = this.repositoryMapping.getRepoRelativePath(resource);
                            if (relPath != null && relPath.length() > 0) {
                                orFilters.add(PathFilter.create((String)relPath));
                            }
                            ++var17_20;
                        }
                        if (checkIgnored) {
                            if (orFilters.size() > 1) {
                                andFilter = AndTreeFilter.create((TreeFilter)new NotIgnoredFilter(baseTreeIndex), (TreeFilter)OrTreeFilter.create(orFilters));
                                tw.setFilter(andFilter);
                            } else if (orFilters.size() == 1) {
                                andFilter = AndTreeFilter.create((TreeFilter)new NotIgnoredFilter(baseTreeIndex), (TreeFilter)((TreeFilter)orFilters.get(0)));
                                tw.setFilter(andFilter);
                            } else {
                                tw.setFilter((TreeFilter)new NotIgnoredFilter(baseTreeIndex));
                            }
                        } else if (orFilters.size() > 1) {
                            tw.setFilter(OrTreeFilter.create(orFilters));
                        } else if (orFilters.size() == 1) {
                            tw.setFilter((TreeFilter)orFilters.get(0));
                        }
                    }
                    tw.setRecursive(true);
                    if (!monitor.isCanceled()) ** GOTO lbl106
                    throw new InterruptedException();
lbl-1000:
                    // 1 sources

                    {
                        if (monitor.isCanceled()) {
                            throw new InterruptedException();
                        }
                        compareVersionIterator = tw.getTree(compareTreeIndex, AbstractTreeIterator.class);
                        baseVersionIterator = tw.getTree(baseTreeIndex, AbstractTreeIterator.class);
                        left = null;
                        right = null;
                        repoRelativePath = baseVersionIterator != null ? baseVersionIterator.getEntryPathString() : compareVersionIterator.getEntryPathString();
                        currentPath = new Path(repoRelativePath);
                        currentTimeMilliseconds = System.currentTimeMillis();
                        size1 = -1L;
                        size2 = -1L;
                        if (compareVersionIterator != null && baseVersionIterator != null) {
                            size1 = this.getEntrySize(tw, compareVersionIterator);
                            size2 = this.getEntrySize(tw, baseVersionIterator);
                        }
                        if (size1 > 100000L || size2 > 100000L || currentTimeMilliseconds - previousTimeMilliseconds > 500L) {
                            monitor.setTaskName(currentPath.toString());
                            previousTimeMilliseconds = currentTimeMilliseconds;
                        }
                        type = null;
                        if (compareVersionIterator != null && baseVersionIterator != null) {
                            equalContent = compareVersionIterator.getEntryObjectId().equals((AnyObjectId)baseVersionIterator.getEntryObjectId());
                            type = equalContent != false ? PathNode.Type.FILE_BOTH_SIDES_SAME : PathNode.Type.FILE_BOTH_SIDES_DIFFER;
                        } else if (compareVersionIterator != null && baseVersionIterator == null) {
                            type = PathNode.Type.FILE_DELETED;
                        } else if (compareVersionIterator == null && baseVersionIterator != null) {
                            type = PathNode.Type.FILE_ADDED;
                        }
                        file = null;
                        if (type != PathNode.Type.FILE_BOTH_SIDES_SAME) {
                            file = ResourceUtil.getFileForLocation((Repository)repository, (String)repoRelativePath);
                        }
                        if (baseVersionIterator != null) {
                            if (baseCommit == null) {
                                if (file != null) {
                                    left = new LocalFileRevision(file);
                                } else {
                                    path = this.getRepositoryPath().append(repoRelativePath);
                                    left = new WorkingTreeFileRevision(path.toFile());
                                }
                            } else {
                                left = GitFileRevision.inCommit((Repository)repository, (RevCommit)baseCommit, (String)repoRelativePath, (ObjectId)tw.getObjectId(baseTreeIndex));
                            }
                        }
                        if (compareVersionIterator != null) {
                            right = useIndex == false ? GitFileRevision.inCommit((Repository)repository, (RevCommit)compareCommit, (String)repoRelativePath, (ObjectId)tw.getObjectId(compareTreeIndex)) : GitFileRevision.inIndex((Repository)repository, (String)repoRelativePath);
                        }
                        containerPath = currentPath.removeLastSegments(1);
                        containerNode = this.getOrCreateContainerNode(containerPath, type);
                        fileNode = new FileNode((IPath)currentPath, file, type, (IFileRevision)left, (IFileRevision)right);
                        containerNode.addChild(fileNode);
                        this.fileNodes.put((IPath)currentPath, fileNode);
                        if (type == PathNode.Type.FILE_BOTH_SIDES_SAME) continue;
                        path = currentPath;
                        while (path.segmentCount() > 0) {
                            path = path.removeLastSegments(1);
                            node = this.containerNodes.get(path);
                            node.setOnlyEqualContent(false);
                        }
lbl106:
                        // 3 sources

                        ** while (tw.next())
                    }
lbl107:
                    // 1 sources

                }
                finally {
                    if (tw != null) {
                        tw.close();
                    }
                }
            }
            catch (Throwable var10_11) {
                if (var9_8 == null) {
                    var9_8 = var10_11;
                } else if (var9_8 != var10_11) {
                    var9_8.addSuppressed(var10_11);
                }
                throw var9_8;
            }
        }
        finally {
            monitor.done();
        }
    }

    private long getEntrySize(TreeWalk tw, AbstractTreeIterator iterator) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        if (iterator instanceof ContainerTreeIterator) {
            return ((ContainerTreeIterator)iterator).getEntryContentLength();
        }
        if (iterator instanceof FileTreeIterator) {
            return ((FileTreeIterator)iterator).getEntryContentLength();
        }
        try {
            return tw.getObjectReader().getObjectSize((AnyObjectId)iterator.getEntryObjectId(), 3);
        }
        catch (MissingObjectException missingObjectException) {
            return 0L;
        }
    }

    private ContainerNode getOrCreateContainerNode(IPath containerPath, PathNode.Type fileType) {
        ContainerNode containerNode = this.containerNodes.get(containerPath);
        if (containerNode != null) {
            return containerNode;
        }
        Repository repository = this.getRepository();
        IContainer resource = repository == null ? null : ResourceUtil.getContainerForLocation((Repository)repository, (String)containerPath.toString());
        ContainerNode node = new ContainerNode(containerPath, resource);
        node.setOnlyEqualContent(fileType == PathNode.Type.FILE_BOTH_SIDES_SAME);
        this.containerNodes.put(containerPath, node);
        if (containerPath.segmentCount() > 0) {
            IPath parentPath = containerPath.removeLastSegments(1);
            ContainerNode parentNode = this.getOrCreateContainerNode(parentPath, fileType);
            parentNode.addChild(node);
        }
        return node;
    }

    public void dispose() {
        super.dispose();
        for (ActionFactory.IWorkbenchAction action : this.actionsToDispose) {
            action.dispose();
        }
        this.ADDED.dispose();
        this.DELETED.dispose();
        this.SAME_CONTENT.dispose();
    }

    public void menuAboutToShow(IMenuManager manager) {
        ITreeSelection selection = (ITreeSelection)this.tree.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        manager.add((IContributionItem)new Separator("group.open"));
        manager.add((IContributionItem)new Separator("additions"));
        IAction openAction = this.createOpenAction(selection);
        if (openAction != null) {
            manager.appendToGroup("group.open", openAction);
        }
        MenuManager showInSubMenu = UIUtils.createShowInMenu(this.getSite().getWorkbenchWindow());
        manager.appendToGroup("group.open", (IContributionItem)showInSubMenu);
    }

    public ShowInContext getShowInContext() {
        IPath repoPath = this.getRepositoryPath();
        ITreeSelection selection = (ITreeSelection)this.tree.getSelection();
        ArrayList<IResource> resources = new ArrayList<IResource>();
        for (Object obj : selection) {
            PathNode pathNode;
            IResource resource;
            if (obj instanceof IResource) {
                resources.add((IResource)obj);
                continue;
            }
            if (!(obj instanceof PathNode) || repoPath == null || (resource = ResourceUtil.getResourceForLocation((IPath)repoPath.append((pathNode = (PathNode)obj).getRepoRelativePath()))) == null) continue;
            resources.add(resource);
        }
        return new ShowInContext(null, (ISelection)new StructuredSelection(resources));
    }

    private void createContextMenu() {
        MenuManager manager = new MenuManager("#PopupMenu");
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener((IMenuListener)this);
        Menu contextMenu = manager.createContextMenu(this.tree.getControl());
        this.tree.getControl().setMenu(contextMenu);
        this.getSite().registerContextMenu(manager, (ISelectionProvider)this.tree);
    }

    private void openFileInEditor(String filePath) {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        File file = new File(filePath);
        if (!file.exists()) {
            String message = NLS.bind((String)UIText.CommitFileDiffViewer_FileDoesNotExist, (Object)filePath);
            Activator.showError(message, null);
        }
        IWorkbenchPage page = window.getActivePage();
        EgitUiEditorUtils.openEditor(file, page);
    }

    private IAction createOpenAction(ITreeSelection selection) {
        final List<String> pathsToOpen = this.getSelectedPaths(selection);
        if (pathsToOpen == null || pathsToOpen.isEmpty()) {
            return null;
        }
        return new Action(UIText.CommitFileDiffViewer_OpenWorkingTreeVersionInEditorMenuLabel){

            public void run() {
                for (String filePath : pathsToOpen) {
                    CompareTreeView.this.openFileInEditor(filePath);
                }
            }
        };
    }

    private List<String> getSelectedPaths(ITreeSelection selection) {
        IPath repoPath = this.getRepositoryPath();
        ArrayList<String> pathsToOpen = new ArrayList<String>();
        for (Object obj : selection) {
            if (obj instanceof IFile) {
                pathsToOpen.add(((IFile)obj).getLocation().toOSString());
                continue;
            }
            if (obj instanceof PathNode && repoPath != null) {
                PathNode pathNode = (PathNode)obj;
                if (pathNode.getType() == PathNode.Type.FOLDER || pathNode.getType() == PathNode.Type.FILE_DELETED) {
                    return null;
                }
                pathsToOpen.add(repoPath.append(pathNode.getPath()).toOSString());
                continue;
            }
            return null;
        }
        return pathsToOpen;
    }

    private IPath getRepositoryPath() {
        Repository repo = this.getRepository();
        if (repo != null) {
            return new Path(repo.getWorkTree().getAbsolutePath());
        }
        return null;
    }

    private Repository getRepository() {
        if (this.repositoryMapping != null) {
            return this.repositoryMapping.getRepository();
        }
        if (this.input instanceof Repository) {
            return (Repository)this.input;
        }
        return null;
    }

    static class ContainerNode
    extends PathNode {
        private final List<PathNode> children = new ArrayList<PathNode>();
        private final IContainer resource;
        private boolean onlyEqualContent = false;

        public ContainerNode(IPath path, IContainer resource) {
            super(path);
            this.resource = resource;
        }

        @Override
        public PathNode.Type getType() {
            return PathNode.Type.FOLDER;
        }

        public List<PathNode> getChildren() {
            return this.children;
        }

        public void addChild(PathNode child) {
            this.children.add(child);
        }

        public IContainer getResource() {
            return this.resource;
        }

        public void setOnlyEqualContent(boolean onlyEqualContent) {
            this.onlyEqualContent = onlyEqualContent;
        }

        public boolean isOnlyEqualContent() {
            return this.onlyEqualContent;
        }
    }

    static class FileNode
    extends PathNode {
        private final IFile file;
        private final PathNode.Type type;
        private final IFileRevision leftRevision;
        private final IFileRevision rightRevision;

        public FileNode(IPath path, IFile file, PathNode.Type type, IFileRevision leftRevision, IFileRevision rightRevision) {
            super(path);
            this.file = file;
            this.type = type;
            this.leftRevision = leftRevision;
            this.rightRevision = rightRevision;
        }

        @Override
        public PathNode.Type getType() {
            return this.type;
        }

        public IFile getFile() {
            return this.file;
        }
    }

    static abstract class PathNode {
        private final IPath path;

        public PathNode(IPath path) {
            this.path = path;
        }

        public abstract Type getType();

        public IPath getPath() {
            return this.path;
        }

        public String getRepoRelativePath() {
            return this.path.toString();
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + this.path.hashCode();
            result = 31 * result + this.getType().hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PathNode other = (PathNode)obj;
            if (!this.path.equals((Object)other.path)) {
                return false;
            }
            return this.getType().equals((Object)other.getType());
        }

        public String toString() {
            return String.valueOf(this.getType().name()) + ": " + this.path.toString();
        }

        public static enum Type {
            FOLDER,
            FILE_ADDED,
            FILE_DELETED,
            FILE_BOTH_SIDES_DIFFER,
            FILE_BOTH_SIDES_SAME;

        }
    }

    private final class PathNodeContentProvider
    implements ITreeContentProvider {
        private PathNodeContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            ContainerNode rootContainer = (ContainerNode)CompareTreeView.this.containerNodes.get(new Path(""));
            if (rootContainer.isOnlyEqualContent() && !CompareTreeView.this.showEquals) {
                return new String[]{UIText.CompareTreeView_NoDifferencesFoundMessage};
            }
            if (CompareTreeView.this.input instanceof IResource[]) {
                IResource[] resources = (IResource[])CompareTreeView.this.input;
                Object[] nodes = new PathNode[resources.length];
                int i = 0;
                while (i < resources.length) {
                    IResource resource = resources[i];
                    Path path = new Path(CompareTreeView.this.repositoryMapping.getRepoRelativePath(resource));
                    nodes[i] = resource instanceof IFile ? (PathNode)CompareTreeView.this.fileNodes.get(path) : (PathNode)CompareTreeView.this.containerNodes.get(path);
                    ++i;
                }
                return nodes;
            }
            return new PathNode[]{rootContainer};
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof ContainerNode) {
                ContainerNode containerNode = (ContainerNode)parentElement;
                return containerNode.getChildren().toArray();
            }
            return new Object[0];
        }

        public boolean hasChildren(Object element) {
            if (element instanceof ContainerNode) {
                ContainerNode containerNode = (ContainerNode)element;
                return !containerNode.getChildren().isEmpty();
            }
            return false;
        }

        public Object getParent(Object element) {
            if (element instanceof PathNode) {
                PathNode pathNode = (PathNode)element;
                IPath path = pathNode.getPath();
                if (path.segmentCount() == 0) {
                    return null;
                }
                return CompareTreeView.this.containerNodes.get(path.removeLastSegments(1));
            }
            return null;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }
    }

    private final class PathNodeFilter
    extends ViewerFilter {
        private PathNodeFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (CompareTreeView.this.showEquals) {
                return true;
            }
            if (element instanceof FileNode) {
                FileNode fileNode = (FileNode)element;
                return fileNode.getType() != PathNode.Type.FILE_BOTH_SIDES_SAME;
            }
            if (element instanceof ContainerNode) {
                ContainerNode containerNode = (ContainerNode)element;
                return !containerNode.isOnlyEqualContent();
            }
            if (element instanceof String) {
                return true;
            }
            return true;
        }
    }

    private final class PathNodeLabelProvider
    extends BaseLabelProvider
    implements ILabelProvider {
        private final WorkbenchLabelProvider workbenchLabelProvider = new WorkbenchLabelProvider();

        private PathNodeLabelProvider() {
        }

        public Image getImage(Object element) {
            if (element instanceof String) {
                return null;
            }
            if (element instanceof ContainerNode) {
                ContainerNode containerNode = (ContainerNode)element;
                IContainer resource = containerNode.getResource();
                if (resource != null && resource.isAccessible()) {
                    return this.workbenchLabelProvider.getImage((Object)resource);
                }
                return FOLDER_IMAGE;
            }
            FileNode fileNode = (FileNode)element;
            PathNode.Type type = fileNode.getType();
            switch (type) {
                case FILE_BOTH_SIDES_SAME: {
                    return CompareTreeView.this.SAME_CONTENT;
                }
                case FILE_BOTH_SIDES_DIFFER: {
                    if (fileNode.getFile() != null) {
                        return this.workbenchLabelProvider.getImage((Object)fileNode.getFile());
                    }
                    return FILE_IMAGE;
                }
                case FILE_ADDED: {
                    return CompareTreeView.this.ADDED;
                }
                case FILE_DELETED: {
                    return CompareTreeView.this.DELETED;
                }
                case FOLDER: {
                    return FOLDER_IMAGE;
                }
            }
            return null;
        }

        public String getText(Object element) {
            if (element instanceof String) {
                return (String)element;
            }
            IPath path = ((PathNode)element).getPath();
            if (path.segmentCount() == 0) {
                return UIText.CompareTreeView_RepositoryRootName;
            }
            return path.lastSegment();
        }

        public void dispose() {
            super.dispose();
            this.workbenchLabelProvider.dispose();
        }
    }

    private static final class PathNodeTreeComparator
    extends ViewerComparator {
        private static final int UNKNOWNCATEGORY = 50;

        private PathNodeTreeComparator() {
        }

        public int category(Object element) {
            if (element instanceof PathNode) {
                return ((PathNode)element).getType().ordinal();
            }
            return 50;
        }
    }
}

