/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ecl.internal.core;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.rcptt.ecl.core.CorePackage;
import org.eclipse.rcptt.ecl.core.Declaration;
import org.eclipse.rcptt.ecl.core.Proc;
import org.eclipse.rcptt.ecl.core.ProcInstance;
import org.eclipse.rcptt.ecl.core.Val;
import org.eclipse.rcptt.ecl.core.util.EclCommandNameConvention;
import org.eclipse.rcptt.ecl.internal.core.CorePlugin;

public class LocalProcManager {
    private EPackage epackage;
    private Map<String, Proc> declarations = new LinkedHashMap<String, Proc>();

    protected EPackage getPackage() {
        if (this.epackage == null) {
            this.epackage = EcoreFactory.eINSTANCE.createEPackage();
            String randomName = UUID.randomUUID().toString();
            this.epackage.setName(randomName);
            this.epackage.setNsPrefix(randomName);
            this.epackage.setNsURI(randomName);
        }
        return this.epackage;
    }

    public synchronized Iterable<Proc> declarations() {
        return this.declarations.values();
    }

    public synchronized void declare(Proc proc) throws CoreException {
        LocalProcManager.verifyInputParamsCount(proc);
        EPackage pkg = this.getPackage();
        LocalProcManager.verifyNoSuchProc(proc, pkg);
        EClass eclass = EcoreFactory.eINSTANCE.createEClass();
        eclass.getESuperTypes().add((Object)CorePackage.Literals.PROC_INSTANCE);
        String scriptletName = EclCommandNameConvention.toScriptletName(proc.getName());
        eclass.setName(scriptletName);
        for (Declaration decl : proc.getVals()) {
            if (!(decl instanceof Val)) continue;
            Val val = (Val)decl;
            EReference reference = EcoreFactory.eINSTANCE.createEReference();
            reference.setName(val.getName());
            reference.setEType((EClassifier)EcorePackage.Literals.EOBJECT);
            reference.setContainment(true);
            if (val.isInput()) {
                EAnnotation inputAnn = EcoreFactory.eINSTANCE.createEAnnotation();
                inputAnn.setSource("http://www.eclipse.org/ecl/input");
                reference.getEAnnotations().add((Object)inputAnn);
            }
            eclass.getEStructuralFeatures().add((Object)reference);
        }
        pkg.getEClassifiers().add((Object)eclass);
        this.declarations.put(scriptletName, proc);
    }

    public ProcInstance createCommand(String className) {
        Proc proc = this.declarations.get(className);
        if (proc == null) {
            return null;
        }
        EPackage pkg = this.getPackage();
        EClass commandClass = (EClass)pkg.getEClassifier(className);
        ProcInstance command = (ProcInstance)pkg.getEFactoryInstance().create(commandClass);
        command.eSet((EStructuralFeature)CorePackage.Literals.PROC_INSTANCE__DEFINITION, proc);
        for (Declaration decl : proc.getVals()) {
            Val val;
            if (!(decl instanceof Val) || (val = (Val)decl).getValue() == null) continue;
            command.eSet(commandClass.getEStructuralFeature(val.getName()), EcoreUtil.copy((EObject)val.getValue()));
        }
        return command;
    }

    private static void verifyNoSuchProc(Proc proc, EPackage pkg) throws CoreException {
        if (pkg.getEClassifier(EclCommandNameConvention.toScriptletName(proc.getName())) != null) {
            throw new CoreException(CorePlugin.err(String.format("proc '%s' already declared", proc.getName())));
        }
    }

    private static void verifyInputParamsCount(Proc proc) throws CoreException {
        int inputValCount = 0;
        for (Declaration declaration : proc.getVals()) {
            if (!(declaration instanceof Val) || !((Val)declaration).isInput()) continue;
            ++inputValCount;
        }
        if (inputValCount > 1) {
            throw new CoreException(CorePlugin.err("Only one parameter can be initialized from input"));
        }
    }
}

