/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.launching.aut;

import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.rcptt.core.launching.events.AutBundleState;
import org.eclipse.rcptt.internal.core.RcpttPlugin;
import org.eclipse.rcptt.internal.ui.Images;
import org.eclipse.rcptt.internal.ui.Messages;
import org.eclipse.rcptt.internal.ui.Q7UIPlugin;
import org.eclipse.rcptt.launching.AutLaunch;
import org.eclipse.rcptt.ui.launching.LaunchUtils;
import org.eclipse.rcptt.ui.launching.aut.AUTProvider;
import org.eclipse.rcptt.ui.launching.aut.AutContentProvider;
import org.eclipse.rcptt.ui.launching.aut.AutElement;
import org.eclipse.rcptt.ui.launching.aut.AutLaunchElement;
import org.eclipse.rcptt.ui.launching.aut.IAUTConfigWizard;
import org.eclipse.rcptt.util.swt.ShellUtilsProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public abstract class BasicAUTComposite {
    private ILaunchListener launchListener = null;
    protected TreeViewer viewer;
    private AutLaunch launch;
    private AutContentProvider contentProvider;

    public void setLaunchListener(ILaunchListener listener) {
        this.launchListener = listener;
    }

    protected IWizard getInitWizard(String kind) {
        IExtensionPoint wizard = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.rcptt.ui.autWizard");
        if (wizard != null) {
            IConfigurationElement[] elements;
            IConfigurationElement[] iConfigurationElementArray = elements = wizard.getConfigurationElements();
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement iConfigurationElement = iConfigurationElementArray[n2];
                try {
                    if (kind.equals(iConfigurationElement.getAttribute("kind"))) {
                        return (IWizard)iConfigurationElement.createExecutableExtension("class");
                    }
                }
                catch (Throwable e) {
                    RcpttPlugin.log((Throwable)e);
                }
                ++n2;
            }
        }
        return null;
    }

    protected abstract void updateButtonsEnablement();

    public void create(Composite parent, boolean border) {
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(composite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite);
        Composite viewerComposite = new Composite(composite, 0);
        GridLayoutFactory.fillDefaults().applyTo(viewerComposite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)viewerComposite);
        this.viewer = new TreeViewer(viewerComposite, 0x302 | (border ? 2048 : 0));
        GridDataFactory.fillDefaults().grab(true, true).applyTo(this.viewer.getControl());
        this.viewer.setLabelProvider((IBaseLabelProvider)new StyledAUTLabelProvider());
        this.contentProvider = new AutContentProvider();
        this.viewer.setContentProvider((IContentProvider)this.contentProvider);
        this.viewer.setInput(new Object());
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                BasicAUTComposite.this.updateEnablement();
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                BasicAUTComposite.this.launch();
            }
        });
        this.createButtonsBar(composite);
        this.updateEnablement();
    }

    protected boolean launch() {
        this.launch = null;
        AutElement element = this.getElement();
        if (element != null) {
            if (element.isLaunched() && element instanceof AutLaunchElement) {
                this.launch = ((AutLaunchElement)element).getLaunch();
            } else {
                Shell shell = this.viewer.getControl().getShell();
                this.launch = LaunchUtils.launch(element.getAut(), shell);
            }
        }
        if (this.launch != null && this.launchListener != null) {
            this.launchListener.launched(this.launch);
        }
        return this.launch != null;
    }

    public AutLaunch getLaunch() {
        return this.launch;
    }

    protected void configure() {
        AutElement element = this.getElement();
        if (element != null) {
            Shell shell = this.viewer.getControl().getShell();
            ILaunchConfiguration config = element.getAut().getConfig();
            if (config != null) {
                IWizard configWizard = this.getInitWizard("edit");
                if (configWizard != null && configWizard instanceof IAUTConfigWizard) {
                    ((IAUTConfigWizard)configWizard).setLaunchConfiguration(config);
                    WizardDialog dialog = new WizardDialog(shell, configWizard){

                        protected void configureShell(Shell newShell) {
                            super.configureShell(newShell);
                            newShell.setImage(Images.getImageDescriptor("icons/q7.gif").createImage());
                        }
                    };
                    ((IAUTConfigWizard)configWizard).setWizardDialog(dialog);
                    dialog.setHelpAvailable(false);
                    dialog.open();
                } else {
                    DebugUITools.openLaunchConfigurationPropertiesDialog((Shell)shell, (ILaunchConfiguration)config, (String)"org.eclipse.debug.ui.launchGroup.run");
                }
            }
            try {
                ShellUtilsProvider.getShellUtils().forceActive(shell);
            }
            catch (CoreException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void updateEnablement() {
        this.updateButtonsEnablement();
    }

    public void addListener(ISelectionChangedListener iSelectionChangedListener) {
        this.viewer.addSelectionChangedListener(iSelectionChangedListener);
    }

    protected void stop() {
        AutElement element = this.getElement();
        if (element != null) {
            element.stop();
        }
    }

    public void removeAUT() {
        ArrayList<AutElement> elements = new ArrayList<AutElement>();
        ISelection selection = this.viewer.getSelection();
        if (selection instanceof IStructuredSelection) {
            for (Object next : (IStructuredSelection)selection) {
                elements.add((AutElement)next);
            }
        }
        if (elements.size() != 0) {
            StringBuilder names = new StringBuilder();
            for (AutElement iautElement : elements) {
                if (names.length() > 0) {
                    names.append(", ");
                }
                names.append(iautElement.getName());
            }
            MessageDialog dialog = new MessageDialog(this.viewer.getControl().getShell(), this.getMessageTitle(), null, MessageFormat.format(Messages.BasicAUTComposite_RemoveApprovalMsg, names.toString()), 3, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0){};
            int value = dialog.open();
            if (value == 0) {
                for (AutElement element : elements) {
                    try {
                        element.remove();
                    }
                    catch (CoreException e) {
                        Q7UIPlugin.log(e);
                    }
                }
            }
        }
    }

    protected String getMessageTitle() {
        return Messages.BasicAUTComposite_MessageTitle;
    }

    public void addAut() {
        Shell shell = this.viewer.getControl().getShell();
        WizardDialog dialog = new WizardDialog(shell, this.getInitWizard("new")){

            protected void configureShell(Shell newShell) {
                super.configureShell(newShell);
                newShell.setImage(Images.getImageDescriptor("icons/q7.gif").createImage());
            }
        };
        dialog.setHelpAvailable(false);
        dialog.open();
        try {
            ShellUtilsProvider.getShellUtils().forceActive(shell);
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
    }

    protected ImageDescriptor getDeleteImage() {
        return PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_DELETE");
    }

    protected ImageDescriptor getNewImage() {
        return PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_NEW_WIZARD");
    }

    public boolean isSelectionOK() {
        return this.getElement() != null;
    }

    public boolean doOk() {
        return this.launch();
    }

    protected void createButtonsBar(Composite composite) {
    }

    protected AutElement getElement() {
        Object element;
        ISelection selection = this.viewer.getSelection();
        if (selection instanceof IStructuredSelection && (element = ((IStructuredSelection)selection).getFirstElement()) instanceof AutElement) {
            return (AutElement)element;
        }
        return null;
    }

    public void setInitialSelection() {
        Object[] elements = this.contentProvider.getElements(null);
        if (elements.length > 0) {
            this.viewer.setSelection((ISelection)new StructuredSelection(elements[0]));
        }
        this.updateEnablement();
    }

    public static interface ILaunchListener {
        public void launched(AutLaunch var1);
    }

    protected class StyledAUTLabelProvider
    extends StyledCellLabelProvider {
        protected StyledAUTLabelProvider() {
        }

        public void update(ViewerCell cell) {
            Object element = cell.getElement();
            if (element instanceof AutElement) {
                AutElement e = (AutElement)element;
                cell.setImage(AUTProvider.getImage(e));
                StyledString styledString = new StyledString(AUTProvider.getText(e));
                cell.setText(styledString.toString());
                cell.setStyleRanges(styledString.getStyleRanges());
            } else if (element instanceof AutContentProvider.Bundles) {
                cell.setText("Bundles");
                cell.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ELEMENTS"));
            } else if (element instanceof AutBundleState) {
                AutBundleState state = (AutBundleState)element;
                StyledString styledString = new StyledString(state.getId());
                styledString.append(" at " + state.getLocation(), StyledString.QUALIFIER_STYLER);
                cell.setText(styledString.toString());
                cell.setStyleRanges(styledString.getStyleRanges());
                cell.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_PROJECT"));
            } else {
                cell.setText("Unknown element");
            }
            super.update(cell);
        }
    }
}

