/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.search;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.jdt.internal.core.OverflowingLRUCache;
import org.eclipse.jdt.internal.core.util.LRUCache;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiComponent;
import org.eclipse.pde.api.tools.internal.search.IReferenceCollection;
import org.eclipse.pde.api.tools.internal.search.IReferenceDescriptor;
import org.eclipse.pde.api.tools.internal.search.SearchMessages;
import org.eclipse.pde.api.tools.internal.search.UseScanParser;
import org.eclipse.pde.api.tools.internal.search.UseScanReferenceVisitor;
import org.eclipse.pde.api.tools.internal.util.FileManager;
import org.eclipse.pde.api.tools.internal.util.Util;

public class UseScanManager {
    private static UseScanCache fApiComponentCache;
    private static UseScanManager fUseScanProcessor;
    private static String tempLocation;
    public static final String STATE_DELIM = "*";
    public static final String LOCATION_DELIM = "|";
    public static final String ESCAPE_REGEX = "\\";
    public static final Pattern NAME_REGEX;
    public static final int DEFAULT_CACHE_SIZE = 1000;
    private String[] fLocations = null;
    static FileFilter USESCAN_FILTER;

    static {
        tempLocation = "${workspace_loc}/.metadata/.plugins/org.eclipse.pde.api.tools/ApiUseScans/";
        NAME_REGEX = Pattern.compile("^.* \\(.*\\)$");
        USESCAN_FILTER = new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                if (NAME_REGEX.matcher(pathname.getName()).matches()) {
                    throw new RuntimeException(pathname.getName());
                }
                return false;
            }
        };
    }

    private UseScanManager() {
    }

    public static synchronized UseScanManager getInstance() {
        if (fUseScanProcessor == null) {
            fUseScanProcessor = new UseScanManager();
            fApiComponentCache = new UseScanCache(1000);
        }
        return fUseScanProcessor;
    }

    public IReferenceDescriptor[] getExternalDependenciesFor(IApiComponent apiComponent, String[] apiUseTypes, IProgressMonitor monitor) {
        IReferenceCollection references = (IReferenceCollection)fApiComponentCache.get(apiComponent);
        if (references == null) {
            references = apiComponent.getExternalDependencies();
        }
        SubMonitor localmonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)SearchMessages.collecting_external_dependencies, (int)10);
        try {
            ArrayList<String> unavailableMembers = new ArrayList<String>();
            if (apiUseTypes != null && apiUseTypes.length > 0) {
                int i = 0;
                while (i < apiUseTypes.length) {
                    if (!references.hasReferencesTo(apiUseTypes[i])) {
                        unavailableMembers.add(apiUseTypes[i]);
                    }
                    ++i;
                }
                if (unavailableMembers.size() > 0) {
                    this.fetch(apiComponent, unavailableMembers.toArray(new String[unavailableMembers.size()]), references, monitor);
                }
                Util.updateMonitor((IProgressMonitor)localmonitor, 1);
                IReferenceDescriptor[] iReferenceDescriptorArray = references.getExternalDependenciesTo(apiUseTypes);
                return iReferenceDescriptorArray;
            }
            this.fetch(apiComponent, null, references, (IProgressMonitor)localmonitor.newChild(8));
            Util.updateMonitor((IProgressMonitor)localmonitor, 1);
            IReferenceDescriptor[] iReferenceDescriptorArray = references.getAllExternalDependencies();
            return iReferenceDescriptorArray;
        }
        finally {
            localmonitor.done();
        }
    }

    private void fetch(IApiComponent apiComponent, String[] types, IReferenceCollection references, IProgressMonitor monitor) {
        block17: {
            UseScanParser parser = new UseScanParser();
            UseScanReferenceVisitor visitor = new UseScanReferenceVisitor(apiComponent, types, references);
            SubMonitor localmonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)SearchMessages.load_external_dependencies, (int)10);
            try {
                try {
                    String[] locations = this.fLocations == null ? this.getReportLocations() : this.fLocations;
                    if (locations == null) break block17;
                    IStringVariableManager stringManager = null;
                    localmonitor.setWorkRemaining(locations.length * 2);
                    int i = 0;
                    while (i < locations.length) {
                        block18: {
                            File file;
                            block19: {
                                Util.updateMonitor((IProgressMonitor)localmonitor, 1);
                                file = new File(locations[i]);
                                if (!file.exists()) break block18;
                                if (!file.isFile()) break block19;
                                if (!Util.isArchive(file.getName())) break block18;
                                String destDirPath = String.valueOf(tempLocation) + file.getName() + '.' + file.getAbsolutePath().hashCode();
                                if (stringManager == null) {
                                    stringManager = VariablesPlugin.getDefault().getStringVariableManager();
                                }
                                destDirPath = stringManager.performStringSubstitution(destDirPath);
                                locations[i] = String.valueOf(destDirPath) + '/' + file.lastModified();
                                File unzipDirLoc = new File(destDirPath);
                                if (unzipDirLoc.exists()) {
                                    String[] childDirs = unzipDirLoc.list();
                                    int j = 0;
                                    while (j < childDirs.length) {
                                        if (!childDirs[j].equals(String.valueOf(file.lastModified()))) {
                                            FileManager.getManager().recordTempFileRoot(String.valueOf(destDirPath) + '/' + childDirs[j]);
                                        }
                                        ++j;
                                    }
                                } else {
                                    Util.unzip(file.getPath(), locations[i]);
                                }
                            }
                            try {
                                locations[i] = UseScanManager.getExactScanLocation(locations[i]);
                                if (locations[i] == null) {
                                    String message = file.isDirectory() ? NLS.bind((String)SearchMessages.UseScanManager_InvalidDir, (Object)file.getAbsolutePath()) : NLS.bind((String)SearchMessages.UseScanManager_InvalidArchive, (Object)file.getAbsolutePath());
                                    throw new Exception(message);
                                }
                                parser.parse(locations[i], (IProgressMonitor)localmonitor.newChild(2), visitor);
                                Util.updateMonitor((IProgressMonitor)localmonitor);
                            }
                            catch (Exception e) {
                                ApiPlugin.log(e);
                            }
                        }
                        ++i;
                    }
                    fApiComponentCache.remove(apiComponent);
                    fApiComponentCache.put(apiComponent, references);
                }
                catch (Exception e) {
                    ApiPlugin.log(e);
                    localmonitor.done();
                }
            }
            finally {
                localmonitor.done();
            }
        }
    }

    public static String getExactScanLocation(String location) {
        File file = new File(location);
        if (UseScanManager.isValidDirectory(file)) {
            return location;
        }
        file = new File(location, "xml");
        if (UseScanManager.isValidDirectory(file)) {
            return file.getAbsolutePath();
        }
        return null;
    }

    public static boolean isValidDirectory(File file) {
        if (file.exists() && file.isDirectory()) {
            try {
                file.listFiles(USESCAN_FILTER);
            }
            catch (RuntimeException rte) {
                File f = new File(file, rte.getMessage());
                try {
                    if (f.exists() && f.isDirectory()) {
                        f.listFiles(USESCAN_FILTER);
                    }
                }
                catch (RuntimeException runtimeException) {
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isValidArchive(File file) {
        String fname = file.getName().toLowerCase();
        if (file.exists() && Util.isArchive(fname)) {
            Enumeration<ZipEntry> entries = null;
            if (fname.endsWith(".jar")) {
                try {
                    JarFile jfile = new JarFile(file);
                    entries = jfile.entries();
                }
                catch (IOException iOException) {
                    return false;
                }
            }
            if (fname.endsWith(".zip")) {
                try {
                    ZipFile zfile = new ZipFile(file);
                    entries = zfile.entries();
                }
                catch (IOException iOException) {
                    return false;
                }
            }
            if (entries != null) {
                while (entries.hasMoreElements()) {
                    Path path;
                    int count;
                    ZipEntry o = entries.nextElement();
                    if (!o.isDirectory() || (count = (path = new Path(o.getName())).segmentCount()) <= 2) continue;
                    return NAME_REGEX.matcher(path.segment(0)).matches() || NAME_REGEX.matcher(path.segment(1)).matches();
                }
            }
        }
        return false;
    }

    public static boolean isValidScanLocation(String location) {
        if (location != null && location.length() > 0) {
            Path path = new Path(location);
            File file = path.toFile();
            return UseScanManager.isValidDirectory(file) || UseScanManager.isValidArchive(file);
        }
        return false;
    }

    public String[] getReportLocations() {
        IEclipsePreferences node = InstanceScope.INSTANCE.getNode("org.eclipse.pde.api.tools");
        String apiUseScanPaths = node.get("API_USE_SCAN_LOCATION", null);
        if (apiUseScanPaths == null || apiUseScanPaths.length() == 0) {
            return new String[0];
        }
        String[] locations = apiUseScanPaths.split("\\|");
        ArrayList<String> locationList = new ArrayList<String>(locations.length);
        int i = 0;
        while (i < locations.length) {
            String[] values = locations[i].split("\\*");
            if (Boolean.valueOf(values[1]).booleanValue()) {
                locationList.add(values[0]);
            }
            ++i;
        }
        return locationList.toArray(new String[locationList.size()]);
    }

    public void setReportLocations(String[] locations) {
        this.fLocations = locations;
    }

    public void setCacheSize(int size) {
        fApiComponentCache.setSpaceLimit(size);
    }

    public void clearCache() {
        Enumeration elementss = fApiComponentCache.elements();
        while (elementss.hasMoreElements()) {
            IReferenceCollection reference = (IReferenceCollection)elementss.nextElement();
            reference.clear();
        }
        fApiComponentCache.flush();
    }

    private static class UseScanCache
    extends OverflowingLRUCache {
        public UseScanCache(int size) {
            super(size);
        }

        public UseScanCache(int size, int overflow) {
            super(size, overflow);
        }

        protected boolean close(LRUCache.LRUCacheEntry entry) {
            IReferenceCollection references = (IReferenceCollection)entry.value;
            references.clear();
            return true;
        }

        protected LRUCache newInstance(int size, int newOverflow) {
            return new UseScanCache(size, newOverflow);
        }
    }
}

