/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.monitoring;

import java.lang.management.LockInfo;
import java.lang.management.ThreadInfo;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.internal.monitoring.Messages;
import org.eclipse.ui.internal.monitoring.MonitoringPlugin;
import org.eclipse.ui.monitoring.IUiFreezeEventLogger;
import org.eclipse.ui.monitoring.StackSample;
import org.eclipse.ui.monitoring.UiFreezeEvent;

public class DefaultUiFreezeEventLogger
implements IUiFreezeEventLogger {
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss.SSS");
    private final long longEventErrorThresholdMillis;

    public DefaultUiFreezeEventLogger(long longEventErrorThresholdMillis) {
        this.longEventErrorThresholdMillis = longEventErrorThresholdMillis;
    }

    @Override
    public void log(UiFreezeEvent event) {
        long lastTimestamp = event.getStartTimestamp();
        String startTime = dateFormat.format(new Date(lastTimestamp));
        String template = event.isStillRunning() ? Messages.DefaultUiFreezeEventLogger_ui_freeze_ongoing_header_2 : Messages.DefaultUiFreezeEventLogger_ui_freeze_finished_header_2;
        long duration = event.getTotalDuration();
        String format = duration >= 100000L ? "%.0f" : (duration >= 10L ? "%.2g" : "%.1g");
        String header = NLS.bind((String)template, (Object)String.format(format, (double)duration / 1000.0), (Object)startTime);
        StackSample[] stackTraceSamples = event.getStackTraceSamples();
        if (stackTraceSamples.length == 0 && (event.isStarvedAwake() || event.isStarvedAsleep())) {
            String note = event.isStarvedAwake() || event.isStarvedAsleep() ? Messages.DefaultUiFreezeEventLogger_starved_awake_and_asleep : (event.isStarvedAwake() ? Messages.DefaultUiFreezeEventLogger_starved_awake : Messages.DefaultUiFreezeEventLogger_starved_asleep);
            header = String.valueOf(header) + note;
        }
        int severity = duration >= this.longEventErrorThresholdMillis ? 4 : 2;
        SeverityMultiStatus loggedEvent = new SeverityMultiStatus(severity, "org.eclipse.ui.monitoring", header, null);
        StackSample[] stackSampleArray = stackTraceSamples;
        int n = stackTraceSamples.length;
        int n2 = 0;
        while (n2 < n) {
            StackSample sample = stackSampleArray[n2];
            double deltaInSeconds = (double)(sample.getTimestamp() - lastTimestamp) / 1000.0;
            ThreadInfo[] threads = sample.getStackTraces();
            Exception stackTrace = new Exception(Messages.DefaultUiFreezeEventLogger_stack_trace_header);
            stackTrace.setStackTrace(threads[0].getStackTrace());
            String traceText = NLS.bind((String)Messages.DefaultUiFreezeEventLogger_sample_header_2, (Object)dateFormat.format(sample.getTimestamp()), (Object)String.format("%.3f", deltaInSeconds));
            SeverityMultiStatus traceStatus = new SeverityMultiStatus(1, "org.eclipse.ui.monitoring", String.format("%s\n%s", traceText, DefaultUiFreezeEventLogger.createThreadMessage(threads[0])), stackTrace);
            loggedEvent.add((IStatus)traceStatus);
            int j = 1;
            while (j < threads.length) {
                traceStatus.add(DefaultUiFreezeEventLogger.createThreadStatus(threads[j]));
                ++j;
            }
            lastTimestamp = sample.getTimestamp();
            ++n2;
        }
        MonitoringPlugin.getDefault().getLog().log((IStatus)loggedEvent);
    }

    private static IStatus createThreadStatus(ThreadInfo thread) {
        Exception stackTrace = new Exception(Messages.DefaultUiFreezeEventLogger_stack_trace_header);
        stackTrace.setStackTrace(thread.getStackTrace());
        StringBuilder threadText = DefaultUiFreezeEventLogger.createThreadMessage(thread);
        String lockName = thread.getLockName();
        if (lockName != null && !lockName.isEmpty()) {
            LockInfo lock = thread.getLockInfo();
            String lockOwnerName = thread.getLockOwnerName();
            if (lockOwnerName == null) {
                threadText.append(NLS.bind((String)Messages.DefaultUiFreezeEventLogger_waiting_for_1, (Object)DefaultUiFreezeEventLogger.getClassAndHashCode(lock)));
            } else {
                threadText.append(NLS.bind((String)Messages.DefaultUiFreezeEventLogger_waiting_for_with_lock_owner_3, (Object[])new Object[]{DefaultUiFreezeEventLogger.getClassAndHashCode(lock), lockOwnerName, thread.getLockOwnerId()}));
            }
        }
        LockInfo[] lockInfoArray = thread.getLockedSynchronizers();
        int n = lockInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            LockInfo lockInfo = lockInfoArray[n2];
            threadText.append(NLS.bind((String)Messages.DefaultUiFreezeEventLogger_holding_1, (Object)DefaultUiFreezeEventLogger.getClassAndHashCode(lockInfo)));
            ++n2;
        }
        return new Status(1, "org.eclipse.ui.monitoring", threadText.toString(), (Throwable)stackTrace);
    }

    private static StringBuilder createThreadMessage(ThreadInfo thread) {
        String threadDetails = NLS.bind((String)Messages.DefaultUiFreezeEventLogger_thread_details, (Object)thread.getThreadId(), (Object)((Object)thread.getThreadState()));
        StringBuilder threadText = new StringBuilder(NLS.bind((String)Messages.DefaultUiFreezeEventLogger_thread_header_2, (Object)thread.getThreadName(), (Object)threadDetails));
        return threadText;
    }

    private static String getClassAndHashCode(LockInfo info) {
        return String.format("%s@%08x", info.getClassName(), info.getIdentityHashCode());
    }

    private static class SeverityMultiStatus
    extends MultiStatus {
        public SeverityMultiStatus(int severity, String pluginId, String message, Throwable exception) {
            super(pluginId, 0, message, exception);
            this.setSeverity(severity);
        }
    }
}

