/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.dialogs.CommitLabelProvider;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class CommitSelectDialog
extends TitleAreaDialog {
    private final List<RevCommit> commits = new ArrayList<RevCommit>();
    private RevCommit selected;

    public CommitSelectDialog(Shell parent, List<RevCommit> commits) {
        super(parent);
        this.setShellStyle(this.getShellStyle() | 0x4F0);
        this.commits.addAll(commits);
        this.setHelpAvailable(false);
    }

    public RevCommit getSelectedCommit() {
        return this.selected;
    }

    protected Control createDialogArea(Composite parent) {
        Composite main = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().applyTo(main);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)main);
        TableViewer tv = new TableViewer(main, 67588);
        GridDataFactory.fillDefaults().grab(true, true).applyTo(tv.getControl());
        tv.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        tv.setLabelProvider((IBaseLabelProvider)new CommitLabelProvider());
        Table table = tv.getTable();
        TableColumn c0 = new TableColumn(table, 0);
        c0.setWidth(70);
        c0.setText(UIText.CommitSelectDialog_IdColumn);
        TableColumn c1 = new TableColumn(table, 0);
        c1.setWidth(200);
        c1.setText(UIText.CommitSelectDialog_MessageColumn);
        TableColumn c2 = new TableColumn(table, 0);
        c2.setWidth(200);
        c2.setText(UIText.CommitSelectDialog_AuthoColumn);
        TableColumn c3 = new TableColumn(table, 0);
        c3.setWidth(150);
        c3.setText(UIText.CommitSelectDialog_DateColumn);
        tv.setInput(this.commits);
        table.setHeaderVisible(true);
        tv.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!event.getSelection().isEmpty()) {
                    CommitSelectDialog.this.selected = (RevCommit)((IStructuredSelection)event.getSelection()).getFirstElement();
                } else {
                    CommitSelectDialog.this.selected = null;
                }
                CommitSelectDialog.this.getButton(0).setEnabled(CommitSelectDialog.this.selected != null);
            }
        });
        tv.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                CommitSelectDialog.this.okPressed();
            }
        });
        return main;
    }

    public void create() {
        super.create();
        this.setTitle(UIText.CommitSelectDialog_Title);
        this.setMessage(UIText.CommitSelectDialog_Message);
        this.getButton(0).setEnabled(false);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(UIText.CommitSelectDialog_WindowTitle);
    }
}

