/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.wizards.buildpaths;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jdt.internal.ui.wizards.IStatusChangeListener;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.ArchiveFileFilter;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.BuildPathSupport;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.FolderSelectionDialog;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.util.BidiUtils;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class ExternalAnnotationsAttachmentBlock {
    private final IStatusChangeListener fContext;
    private StringButtonDialogField fWorkspaceFileNameField;
    private StringButtonDialogField fExternalFileNameField;
    private SelectionButtonDialogField fExternalFolderButton;
    private SelectionButtonDialogField fExternalRadio;
    private SelectionButtonDialogField fWorkspaceRadio;
    private IStatus fWorkspaceNameStatus;
    private IStatus fExternalNameStatus;
    private final IWorkspaceRoot fWorkspaceRoot;
    private Control fSWTWidget;
    private final IPath fEntry;

    public ExternalAnnotationsAttachmentBlock(IStatusChangeListener context, IPath entry) {
        this.fContext = context;
        this.fEntry = entry == null ? Path.EMPTY : entry;
        this.fWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        this.fWorkspaceNameStatus = new StatusInfo();
        this.fExternalNameStatus = new StatusInfo();
        AnnotationsAttachmentAdapter adapter = new AnnotationsAttachmentAdapter();
        this.fWorkspaceRadio = new SelectionButtonDialogField(16);
        this.fWorkspaceRadio.setDialogFieldListener(adapter);
        this.fWorkspaceRadio.setLabelText(NewWizardMessages.AnnotationsAttachmentBlock_workspace_radiolabel);
        this.fWorkspaceFileNameField = new StringButtonDialogField(adapter);
        this.fWorkspaceFileNameField.setDialogFieldListener(adapter);
        this.fWorkspaceFileNameField.setLabelText(NewWizardMessages.AnnotationsAttachmentBlock_filename_workspace_label);
        this.fWorkspaceFileNameField.setButtonLabel(NewWizardMessages.AnnotationsAttachmentBlock_filename_workspace_browse);
        this.fExternalRadio = new SelectionButtonDialogField(16);
        this.fExternalRadio.setDialogFieldListener(adapter);
        this.fExternalRadio.setLabelText(NewWizardMessages.AnnotationsAttachmentBlock_external_radiolabel);
        this.fExternalFileNameField = new StringButtonDialogField(adapter);
        this.fExternalFileNameField.setDialogFieldListener(adapter);
        this.fExternalFileNameField.setLabelText(NewWizardMessages.AnnotationsAttachmentBlock_filename_external_label);
        this.fExternalFileNameField.setButtonLabel(NewWizardMessages.AnnotationsAttachmentBlock_filename_externalfile_button);
        this.fExternalFolderButton = new SelectionButtonDialogField(8);
        this.fExternalFolderButton.setDialogFieldListener(adapter);
        this.fExternalFolderButton.setLabelText(NewWizardMessages.AnnotationsAttachmentBlock_filename_externalfolder_button);
        this.setDefaults();
    }

    public void setDefaults() {
        String path;
        IPath annotationsAttachmentPath = this.fEntry;
        String string = path = annotationsAttachmentPath == null ? null : annotationsAttachmentPath.toPortableString();
        if (this.isWorkspacePath(annotationsAttachmentPath)) {
            this.fWorkspaceRadio.setSelection(true);
            this.fWorkspaceFileNameField.setText(path);
        } else if (path != null && path.length() != 0) {
            this.fExternalRadio.setSelection(true);
            this.fExternalFileNameField.setText(path);
        } else {
            this.fWorkspaceRadio.setSelection(true);
            this.fExternalRadio.setSelection(false);
        }
    }

    private boolean isWorkspacePath(IPath path) {
        if (path == null || path.getDevice() != null) {
            return false;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (workspace == null) {
            return false;
        }
        return workspace.getRoot().findMember(path) != null;
    }

    public IPath getAnnotationsPath() {
        return this.getFilePath();
    }

    public Control createControl(Composite parent) {
        PixelConverter converter = new PixelConverter((Control)parent);
        this.fSWTWidget = parent;
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 3;
        composite.setLayout((Layout)layout);
        int widthHint = converter.convertWidthInCharsToPixels(60);
        GridData gd = new GridData(4, 1, false, false, 3, 1);
        gd.widthHint = converter.convertWidthInCharsToPixels(50);
        Label message = new Label(composite, 16448);
        message.setLayoutData((Object)gd);
        message.setText(NewWizardMessages.AnnotationsAttachmentBlock_message);
        this.fWorkspaceRadio.doFillIntoGrid(composite, 3);
        this.fWorkspaceFileNameField.doFillIntoGrid(composite, 3);
        LayoutUtil.setHorizontalIndent((Control)this.fWorkspaceFileNameField.getLabelControl(null));
        Text workspaceFileNameField = this.fWorkspaceFileNameField.getTextControl(null);
        LayoutUtil.setWidthHint((Control)workspaceFileNameField, widthHint);
        LayoutUtil.setHorizontalGrabbing((Control)workspaceFileNameField);
        BidiUtils.applyBidiProcessing((Text)workspaceFileNameField, (String)"file");
        DialogField.createEmptySpace(composite, 3);
        this.fExternalRadio.doFillIntoGrid(composite, 3);
        this.fExternalFileNameField.doFillIntoGrid(composite, 3);
        LayoutUtil.setHorizontalIndent((Control)this.fExternalFileNameField.getLabelControl(null));
        Text externalFileNameField = this.fExternalFileNameField.getTextControl(null);
        LayoutUtil.setWidthHint((Control)externalFileNameField, widthHint);
        LayoutUtil.setHorizontalGrabbing((Control)externalFileNameField);
        BidiUtils.applyBidiProcessing((Text)externalFileNameField, (String)"file");
        DialogField.createEmptySpace(composite, 2);
        this.fExternalFolderButton.doFillIntoGrid(composite, 1);
        this.fWorkspaceRadio.attachDialogField(this.fWorkspaceFileNameField);
        this.fExternalRadio.attachDialogFields(new DialogField[]{this.fExternalFileNameField, this.fExternalFolderButton});
        Dialog.applyDialogFont((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.jdt.ui.annotations_attachment_dialog_context");
        return composite;
    }

    private void attachmentChangeControlPressed(DialogField field) {
        IPath jarFilePath;
        if (field == this.fWorkspaceFileNameField) {
            IPath jarFilePath2 = this.chooseInternal();
            if (jarFilePath2 != null) {
                this.fWorkspaceFileNameField.setText(jarFilePath2.toString());
            }
        } else if (field == this.fExternalFileNameField && (jarFilePath = this.chooseExtJarFile()) != null) {
            this.fExternalFileNameField.setText(jarFilePath.toString());
        }
    }

    private void attachmentDialogFieldChanged(DialogField field) {
        if (field == this.fWorkspaceFileNameField) {
            this.fWorkspaceNameStatus = this.updateFileNameStatus(this.fWorkspaceFileNameField);
        } else if (field == this.fExternalFileNameField) {
            this.fExternalNameStatus = this.updateFileNameStatus(this.fExternalFileNameField);
        } else if (field == this.fExternalFolderButton) {
            IPath folderPath = this.chooseExtFolder();
            if (folderPath != null) {
                this.fExternalFileNameField.setText(folderPath.toString());
            }
            return;
        }
        this.doStatusLineUpdate();
    }

    private void doStatusLineUpdate() {
        IStatus status;
        boolean isWorkSpace = this.fWorkspaceRadio.isSelected();
        if (isWorkSpace) {
            this.fWorkspaceFileNameField.enableButton(this.canBrowseFileName());
            status = this.fWorkspaceNameStatus;
        } else {
            this.fExternalFileNameField.enableButton(this.canBrowseFileName());
            status = this.fExternalNameStatus;
        }
        this.fContext.statusChanged(status);
    }

    private boolean canBrowseFileName() {
        return true;
    }

    private IStatus updateFileNameStatus(StringButtonDialogField field) {
        boolean exists;
        StatusInfo status = new StatusInfo();
        String fileName = field.getText();
        if (fileName.length() == 0) {
            return status;
        }
        if (!Path.EMPTY.isValidPath(fileName)) {
            status.setError(NewWizardMessages.AnnotationsAttachmentBlock_filename_error_notvalid);
            return status;
        }
        IPath filePath = Path.fromOSString((String)fileName);
        File file = filePath.toFile();
        IResource res = this.fWorkspaceRoot.findMember(filePath);
        boolean isVirtual = false;
        if (res != null) {
            IPath location = res.getLocation();
            exists = location != null ? location.toFile().exists() : res.exists();
            isVirtual = res.isVirtual();
        } else {
            exists = file.exists();
        }
        if (!exists) {
            String message = Messages.format(NewWizardMessages.AnnotationsAttachmentBlock_filename_error_filenotexists, BasicElementLabels.getPathLabel(filePath, false));
            status.setError(message);
            return status;
        }
        if (isVirtual) {
            status.setError(NewWizardMessages.AnnotationsAttachmentBlock_filename_error_virtual);
            return status;
        }
        if (!filePath.isAbsolute()) {
            status.setError(NewWizardMessages.AnnotationsAttachmentBlock_filename_error_notabsolute);
            return status;
        }
        return status;
    }

    private IPath getFilePath() {
        String filePath = this.fWorkspaceRadio.isSelected() ? this.fWorkspaceFileNameField.getText() : this.fExternalFileNameField.getText();
        return Path.fromOSString((String)filePath).makeAbsolute();
    }

    private IPath chooseExtJarFile() {
        IPath currPath = this.getFilePath();
        if (currPath.segmentCount() == 0) {
            currPath = this.fEntry;
        }
        if (ArchiveFileFilter.isArchivePath(currPath, true)) {
            currPath = currPath.removeLastSegments(1);
        }
        FileDialog dialog = new FileDialog(this.getShell());
        dialog.setText(NewWizardMessages.AnnotationsAttachmentBlock_extjardialog_text);
        dialog.setFilterExtensions(ArchiveFileFilter.JAR_ZIP_FILTER_EXTENSIONS);
        dialog.setFilterPath(currPath.toOSString());
        String res = dialog.open();
        if (res != null) {
            return Path.fromOSString((String)res).makeAbsolute();
        }
        return null;
    }

    private IPath chooseExtFolder() {
        IPath currPath = this.getFilePath();
        if (currPath.segmentCount() == 0) {
            currPath = this.fEntry;
        }
        if (ArchiveFileFilter.isArchivePath(currPath, true)) {
            currPath = currPath.removeLastSegments(1);
        }
        DirectoryDialog dialog = new DirectoryDialog(this.getShell());
        dialog.setMessage(NewWizardMessages.AnnotationsAttachmentBlock_extfolderdialog_message);
        dialog.setText(NewWizardMessages.AnnotationsAttachmentBlock_extfolderdialog_text);
        dialog.setFilterPath(currPath.toOSString());
        String res = dialog.open();
        if (res != null) {
            return Path.fromOSString((String)res).makeAbsolute();
        }
        return null;
    }

    private IPath chooseInternal() {
        String initSelection = this.fWorkspaceFileNameField.getText();
        ArchiveFileFilter filter = new ArchiveFileFilter(null, false, false);
        WorkbenchLabelProvider lp = new WorkbenchLabelProvider();
        WorkbenchContentProvider cp = new WorkbenchContentProvider();
        IResource initSel = null;
        if (initSelection.length() > 0) {
            initSel = this.fWorkspaceRoot.findMember((IPath)new Path(initSelection));
        }
        if (initSel == null) {
            initSel = this.fWorkspaceRoot.findMember(this.fEntry);
        }
        FolderSelectionDialog dialog = new FolderSelectionDialog(this.getShell(), (ILabelProvider)lp, (ITreeContentProvider)cp);
        dialog.setAllowMultiple(false);
        dialog.addFilter(filter);
        dialog.setTitle(NewWizardMessages.AnnotationsAttachmentBlock_intjardialog_title);
        dialog.setMessage(NewWizardMessages.AnnotationsAttachmentBlock_intjardialog_message);
        dialog.setInput(this.fWorkspaceRoot);
        dialog.setInitialSelection(initSel);
        dialog.setValidator(new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                Object selectedObject;
                if (selection != null && selection.length == 1 && (selectedObject = selection[0]) instanceof IResource && ((IResource)selectedObject).isVirtual()) {
                    return new StatusInfo(4, NewWizardMessages.AnnotationsAttachmentBlock_filename_error_virtual);
                }
                return new Status(0, "org.eclipse.ui", 0, "", null);
            }
        });
        if (dialog.open() == 0) {
            IResource res = (IResource)dialog.getFirstResult();
            return res.getFullPath();
        }
        return null;
    }

    private Shell getShell() {
        if (this.fSWTWidget != null) {
            return this.fSWTWidget.getShell();
        }
        return JavaPlugin.getActiveWorkbenchShell();
    }

    public static IRunnableWithProgress getRunnable(final Shell shell, final IClasspathEntry newEntry, final IJavaProject jproject, final IPath containerPath, final boolean isReferencedEntry) {
        return new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    String[] changedAttributes = new String[]{"annotationpath"};
                    BuildPathSupport.modifyClasspathEntry(shell, newEntry, changedAttributes, jproject, containerPath, isReferencedEntry, monitor);
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
            }
        };
    }

    private class AnnotationsAttachmentAdapter
    implements IStringButtonAdapter,
    IDialogFieldListener {
        private AnnotationsAttachmentAdapter() {
        }

        public void changeControlPressed(DialogField field) {
            ExternalAnnotationsAttachmentBlock.this.attachmentChangeControlPressed(field);
        }

        public void dialogFieldChanged(DialogField field) {
            ExternalAnnotationsAttachmentBlock.this.attachmentDialogFieldChanged(field);
        }
    }
}

