/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.ecl.internal.impl.commands;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.rcptt.ecl.core.Command;
import org.eclipse.rcptt.tesla.core.protocol.MouseEvent;
import org.eclipse.rcptt.tesla.core.protocol.MouseEventKind;
import org.eclipse.rcptt.tesla.core.protocol.ProtocolFactory;
import org.eclipse.rcptt.tesla.core.protocol.raw.Element;
import org.eclipse.rcptt.tesla.ecl.impl.AbstractActionService;
import org.eclipse.rcptt.tesla.ecl.impl.TeslaBridge;
import org.eclipse.rcptt.tesla.ecl.internal.impl.TeslaImplPlugin;
import org.eclipse.rcptt.tesla.ecl.model.ControlHandler;
import org.eclipse.rcptt.tesla.ecl.model.Mouse;
import org.eclipse.rcptt.util.swt.KeysAndButtons;

public class MouseService
extends AbstractActionService {
    @Override
    protected Object exec(Command command) throws CoreException {
        Mouse cmd = (Mouse)command;
        ControlHandler control = cmd.getControl();
        Element element = TeslaBridge.find(control);
        MouseEvent me = ProtocolFactory.eINSTANCE.createMouseEvent();
        MouseEventKind kind = MouseService.parseKind(cmd.getEvent());
        int button = MouseService.getButton(cmd.getButton());
        me.setElement(element);
        me.setKind(MouseService.parseKind(cmd.getEvent()));
        me.setX(cmd.getX());
        me.setY(cmd.getY());
        me.setCount(MouseService.getCount(kind));
        me.setButton(button);
        me.setStateMask(KeysAndButtons.stateMaskFromStr((String)cmd.getWith()) | MouseService.getButtonMask(button, kind));
        TeslaBridge.getPlayer().safeExecuteCommand((org.eclipse.rcptt.tesla.core.protocol.raw.Command)me);
        return control;
    }

    private static int getButtonMask(int button, MouseEventKind kind) throws CoreException {
        if (button == 0) {
            return 0;
        }
        if (MouseService.isIncludeButtonToMask(kind)) {
            return KeysAndButtons.getButtonMask((int)button);
        }
        return 0;
    }

    private static boolean isIncludeButtonToMask(MouseEventKind kind) {
        return kind == MouseEventKind.UP;
    }

    private static int getButton(String buttonName) throws CoreException {
        if (buttonName == null || buttonName.length() == 0) {
            return 0;
        }
        return KeysAndButtons.getButtonNumber((String)buttonName);
    }

    private static int getCount(MouseEventKind kind) {
        switch (kind) {
            case DOUBLE_CLICK: {
                return 2;
            }
            case DOWN: {
                return 1;
            }
            case UP: {
                return 1;
            }
            case ENTER: {
                return 0;
            }
            case EXIT: {
                return 0;
            }
            case MOVE: {
                return 0;
            }
        }
        return 0;
    }

    private static MouseEventKind parseKind(String str) throws CoreException {
        for (MouseEventKind kind : MouseEventKind.VALUES) {
            if (!kind.getLiteral().equalsIgnoreCase(str)) continue;
            return kind;
        }
        throw new CoreException(TeslaImplPlugin.err(String.format("Unsupported mouse action %s", str)));
    }
}

