/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.internal;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.compare.internal.CompareMessages;
import org.eclipse.compare.internal.MergeSourceViewer;
import org.eclipse.compare.internal.TextEditorPropertyAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IPainter;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.WhitespaceCharacterPainter;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.editors.text.EditorsUI;

public class ShowWhitespaceAction
extends TextEditorPropertyAction {
    private Map fPainters;
    private boolean isWhitespaceShowing;
    private boolean[] fNeedsPainters;
    private boolean fShowLeadingSpaces;
    private boolean fShowEnclosedSpaces;
    private boolean fShowTrailingSpaces;
    private boolean fShowLeadingIdeographicSpaces;
    private boolean fShowEnclosedIdeographicSpaces;
    private boolean fShowTrailingIdeographicSpace;
    private boolean fShowLeadingTabs;
    private boolean fShowEnclosedTabs;
    private boolean fShowTrailingTabs;
    private boolean fShowCarriageReturn;
    private boolean fShowLineFeed;
    private IPreferenceStore fStore = EditorsUI.getPreferenceStore();
    private int fAlpha;

    public ShowWhitespaceAction(MergeSourceViewer[] viewers, boolean[] needsPainters) {
        super(CompareMessages.ShowWhitespaceAction_0, viewers, "showWhitespaceCharacters");
        this.fNeedsPainters = needsPainters;
        this.synchronizeWithPreference();
    }

    protected void synchronizeWithPreference() {
        boolean checked = false;
        if (this.fStore != null) {
            checked = this.fStore.getBoolean(this.getPreferenceKey());
            this.fShowLeadingSpaces = this.fStore.getBoolean("showLeadingSpaces");
            this.fShowEnclosedSpaces = this.fStore.getBoolean("showEnclosedSpaces");
            this.fShowTrailingSpaces = this.fStore.getBoolean("showTrailingSpaces");
            this.fShowLeadingIdeographicSpaces = this.fStore.getBoolean("showLeadingIdeographicSpaces");
            this.fShowEnclosedIdeographicSpaces = this.fStore.getBoolean("showEnclosedIdeographicSpaces");
            this.fShowTrailingIdeographicSpace = this.fStore.getBoolean("showTrailingIdeographicSpaces");
            this.fShowLeadingTabs = this.fStore.getBoolean("showLeadingTabs");
            this.fShowEnclosedTabs = this.fStore.getBoolean("showEnclosedTabs");
            this.fShowTrailingTabs = this.fStore.getBoolean("showTrailingTabs");
            this.fShowCarriageReturn = this.fStore.getBoolean("showCarriageReturn");
            this.fShowLineFeed = this.fStore.getBoolean("showLineFeed");
            this.fAlpha = this.fStore.getInt("whitespaceCharacterAlphaValue");
        }
        if (checked != this.isChecked()) {
            if (this.toggleState(checked)) {
                this.setChecked(checked);
            }
        } else if (this.fNeedsPainters != null && checked) {
            this.hideWhitespace();
            this.showWhitespace();
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        String property = event.getProperty();
        if (property.equals(this.getPreferenceKey()) || "showLeadingSpaces".equals(property) || "showEnclosedSpaces".equals(property) || "showTrailingSpaces".equals(property) || "showLeadingIdeographicSpaces".equals(property) || "showEnclosedIdeographicSpaces".equals(property) || "showTrailingIdeographicSpaces".equals(property) || "showLeadingTabs".equals(property) || "showEnclosedTabs".equals(property) || "showTrailingTabs".equals(property) || "showCarriageReturn".equals(property) || "showLineFeed".equals(property) || "whitespaceCharacterAlphaValue".equals(property)) {
            this.synchronizeWithPreference();
        }
    }

    protected boolean toggleState(boolean checked) {
        if (this.fNeedsPainters == null) {
            return false;
        }
        if (checked) {
            this.showWhitespace();
        } else {
            this.hideWhitespace();
        }
        return true;
    }

    private synchronized Map getPainters() {
        if (this.fPainters == null) {
            this.fPainters = new HashMap();
        }
        return this.fPainters;
    }

    private void showWhitespace() {
        if (this.isWhitespaceShowing) {
            return;
        }
        try {
            Map painters = this.getPainters();
            MergeSourceViewer[] viewers = this.getViewers();
            int i = 0;
            while (i < viewers.length) {
                if (this.fNeedsPainters[i]) {
                    MergeSourceViewer viewer = viewers[i];
                    SourceViewer sourceViewer = viewer.getSourceViewer();
                    WhitespaceCharacterPainter painter = this.fStore != null ? new WhitespaceCharacterPainter((ITextViewer)sourceViewer, this.fShowLeadingSpaces, this.fShowEnclosedSpaces, this.fShowTrailingSpaces, this.fShowLeadingIdeographicSpaces, this.fShowEnclosedIdeographicSpaces, this.fShowTrailingIdeographicSpace, this.fShowLeadingTabs, this.fShowEnclosedTabs, this.fShowTrailingTabs, this.fShowCarriageReturn, this.fShowLineFeed, this.fAlpha) : new WhitespaceCharacterPainter((ITextViewer)sourceViewer);
                    sourceViewer.addPainter((IPainter)painter);
                    painters.put(viewer, painter);
                }
                ++i;
            }
        }
        finally {
            this.isWhitespaceShowing = true;
        }
    }

    private void hideWhitespace() {
        Map painters = this.getPainters();
        Iterator iterator = painters.keySet().iterator();
        while (iterator.hasNext()) {
            MergeSourceViewer viewer = (MergeSourceViewer)iterator.next();
            WhitespaceCharacterPainter painter = (WhitespaceCharacterPainter)painters.get(viewer);
            if (painter == null) continue;
            viewer.getSourceViewer().removePainter((IPainter)painter);
            painter.deactivate(true);
        }
        painters.clear();
        this.isWhitespaceShowing = false;
    }
}

