/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.weaving.aspectj.loadtime;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.aspectj.weaver.IUnwovenClassFile;
import org.aspectj.weaver.bcel.BcelWeakClassLoaderReference;
import org.aspectj.weaver.loadtime.ClassLoaderWeavingAdaptor;
import org.aspectj.weaver.loadtime.IWeavingContext;
import org.aspectj.weaver.tools.GeneratedClassHandler;
import org.aspectj.weaver.tools.Trace;
import org.aspectj.weaver.tools.TraceFactory;
import org.eclipse.equinox.weaving.aspectj.AspectJWeavingStarter;
import org.eclipse.equinox.weaving.aspectj.loadtime.OSGiWeavingContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSGiWeavingAdaptor
extends ClassLoaderWeavingAdaptor {
    private static Trace trace = TraceFactory.getTraceFactory().getTrace(ClassLoaderWeavingAdaptor.class);
    private final ClassLoader classLoader;
    private Method defineClassMethod;
    private boolean initialized;
    private final Object initializeLock = new Object();
    private final String namespace;
    private final OSGiWeavingContext weavingContext;

    public OSGiWeavingAdaptor(ClassLoader classLoader, OSGiWeavingContext oSGiWeavingContext, String string) {
        this.classLoader = classLoader;
        this.weavingContext = oSGiWeavingContext;
        this.namespace = string;
    }

    private void defineClass(ClassLoader classLoader, String string, byte[] byArray) {
        if (trace.isTraceEnabled()) {
            trace.enter("defineClass", (Object)this, new Object[]{classLoader, string, byArray});
        }
        Object object = null;
        this.debug("generating class '" + string + "'");
        try {
            if (this.defineClassMethod == null) {
                this.defineClassMethod = ClassLoader.class.getDeclaredMethod("defineClass", String.class, byArray.getClass(), Integer.TYPE, Integer.TYPE);
            }
            this.defineClassMethod.setAccessible(true);
            object = this.defineClassMethod.invoke((Object)classLoader, string, byArray, new Integer(0), new Integer(byArray.length));
        }
        catch (InvocationTargetException invocationTargetException) {
            if (invocationTargetException.getTargetException() instanceof LinkageError) {
                this.warn("define generated class failed", invocationTargetException.getTargetException());
            } else {
                this.warn("define generated class failed", invocationTargetException.getTargetException());
            }
        }
        catch (Exception exception) {
            this.warn("define generated class failed", exception);
        }
        if (trace.isTraceEnabled()) {
            trace.exit("defineClass", object);
        }
    }

    public Map<String, byte[]> getGeneratedClassesFor(String string) {
        Map map = this.generatedClasses;
        HashMap<String, byte[]> hashMap = new HashMap<String, byte[]>();
        for (String string2 : map.keySet()) {
            IUnwovenClassFile iUnwovenClassFile = (IUnwovenClassFile)map.get(string2);
            if (string.equals(string2)) continue;
            hashMap.put(string2, iUnwovenClassFile.getBytes());
        }
        this.flushGeneratedClasses();
        return hashMap;
    }

    public String getNamespace() {
        return this.namespace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() {
        Object object = this.initializeLock;
        synchronized (object) {
            if (!this.initialized) {
                super.initialize(this.classLoader, (IWeavingContext)this.weavingContext);
                this.generatedClassHandler = new OSGiGeneratedClassHandler(this.classLoader);
                this.initialized = true;
                if (AspectJWeavingStarter.verbose) {
                    if (this.isEnabled()) {
                        System.err.println("[org.eclipse.equinox.weaving.aspectj] info weaving bundle '" + this.weavingContext.getClassLoaderName() + "'");
                    } else {
                        System.err.println("[org.eclipse.equinox.weaving.aspectj] info not weaving bundle '" + this.weavingContext.getClassLoaderName() + "'");
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] weaveClass(String string, byte[] byArray, boolean bl) throws IOException {
        Object object = this.initializeLock;
        synchronized (object) {
            if (!this.initialized) {
                super.initialize(this.classLoader, (IWeavingContext)this.weavingContext);
                this.generatedClassHandler = new OSGiGeneratedClassHandler(this.classLoader);
                this.initialized = true;
            }
        }
        object = this;
        synchronized (object) {
            byArray = super.weaveClass(string, byArray, bl);
        }
        ((OSGiGeneratedClassHandler)this.generatedClassHandler).defineGeneratedClasses();
        return byArray;
    }

    class GeneratedClass {
        private final byte[] bytes;
        private final String name;

        public GeneratedClass(String string, byte[] byArray) {
            this.name = string;
            this.bytes = byArray;
        }

        public byte[] getBytes() {
            return this.bytes;
        }

        public String getName() {
            return this.name;
        }
    }

    class OSGiGeneratedClassHandler
    implements GeneratedClassHandler {
        private final ConcurrentLinkedQueue<GeneratedClass> classesToBeDefined;
        private final BcelWeakClassLoaderReference loaderRef;

        public OSGiGeneratedClassHandler(ClassLoader classLoader) {
            this.loaderRef = new BcelWeakClassLoaderReference(classLoader);
            this.classesToBeDefined = new ConcurrentLinkedQueue();
        }

        public void acceptClass(String string, byte[] byArray) {
            try {
                if (OSGiWeavingAdaptor.this.shouldDump(string.replace('/', '.'), false)) {
                    OSGiWeavingAdaptor.this.dump(string, byArray, false);
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            this.classesToBeDefined.offer(new GeneratedClass(string, byArray));
        }

        public void acceptClass(String string, byte[] byArray, byte[] byArray2) {
            this.acceptClass(string, byArray2);
        }

        public void defineGeneratedClasses() {
            while (!this.classesToBeDefined.isEmpty()) {
                GeneratedClass generatedClass = this.classesToBeDefined.poll();
                if (generatedClass == null) break;
                OSGiWeavingAdaptor.this.defineClass(this.loaderRef.getClassLoader(), generatedClass.getName(), generatedClass.getBytes());
            }
        }
    }
}

