/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.internal.ui.player;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.rcptt.reporting.core.ReportHelper;
import org.eclipse.rcptt.reporting.core.ReportManager;
import org.eclipse.rcptt.sherlock.core.INodeBuilder;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.ReportFactory;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.Screenshot;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.ScreenshotKind;
import org.eclipse.rcptt.tesla.internal.ui.player.PlayerTextUtils;
import org.eclipse.rcptt.tesla.internal.ui.player.SWTScreenCapturer;
import org.eclipse.rcptt.tesla.swt.ShellUtilsProvider;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ReportScreenshotProvider {
    private static SWTScreenCapturer screenCapturer;

    public static void takeScreenshot(final Display display, final boolean onError, final String messagePrefix) {
        if (screenCapturer == null) {
            screenCapturer = new SWTScreenCapturer();
        }
        final ArrayList toProceed = new ArrayList();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                Shell[] shells;
                Shell[] shellArray = shells = display.getShells();
                int n = shells.length;
                int n2 = 0;
                while (n2 < n) {
                    Shell shell = shellArray[n2];
                    if (!shell.isDisposed() && shell.isVisible()) {
                        toProceed.add(shell);
                    }
                    ++n2;
                }
            }
        });
        for (final Shell s : toProceed) {
            display.syncExec(new Runnable(){

                @Override
                public void run() {
                    if (!s.isDisposed() && s.isVisible()) {
                        if (s.getMinimized()) {
                            s.setMinimized(false);
                        }
                        s.setActive();
                        try {
                            ShellUtilsProvider.getShellUtils().forceActive(s);
                        }
                        catch (CoreException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
            });
            display.syncExec(new Runnable(){

                @Override
                public void run() {
                    if (!s.isDisposed() && s.isVisible()) {
                        ReportScreenshotProvider.makeScreenshot(display, s, messagePrefix, onError);
                    }
                }
            });
        }
    }

    public static void makeScreenshot(Display display, Shell shell, String message, boolean onError) {
        byte[] shotData;
        if (shell.isDisposed()) {
            return;
        }
        Rectangle bounds = display.getBounds();
        String finalMessage = message;
        String postFix = PlayerTextUtils.replaceNonUnicode(shell.getText());
        if (postFix != null) {
            finalMessage = String.valueOf(message) + "(" + postFix + ")";
        }
        int minx = bounds.width;
        int miny = bounds.height;
        int maxx = 0;
        int maxy = 0;
        Rectangle rectangle = shell.getBounds();
        rectangle.x -= 10;
        rectangle.y -= 10;
        rectangle.width += 20;
        rectangle.height += 20;
        Point displayPoint = new Point(rectangle.x, rectangle.y);
        if (minx > displayPoint.x) {
            minx = displayPoint.x;
        }
        if (miny > displayPoint.y) {
            miny = displayPoint.y;
        }
        if (maxx < displayPoint.x + rectangle.width) {
            maxx = displayPoint.x + rectangle.width;
        }
        if (maxy < displayPoint.y + rectangle.height) {
            maxy = displayPoint.y + rectangle.height;
        }
        if ((shotData = screenCapturer.makeScreenShotData(display, minx, miny, maxx - minx, maxy - miny, null, !onError)) != null) {
            INodeBuilder node = ReportManager.getCurrentReportNode();
            Screenshot img = ReportFactory.eINSTANCE.createScreenshot();
            img.setKind(ScreenshotKind.PNG);
            img.setData(shotData);
            img.setMessage(finalMessage);
            ReportHelper.addSnapshotWithData((INodeBuilder)node, (EObject)img);
        }
    }
}

