/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.verifications.tree.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.rcptt.core.VerificationProcessor;
import org.eclipse.rcptt.core.ecl.core.model.CreateWidgetVerificationParam;
import org.eclipse.rcptt.core.scenario.Verification;
import org.eclipse.rcptt.ecl.runtime.IProcess;
import org.eclipse.rcptt.internal.core.RcpttPlugin;
import org.eclipse.rcptt.tesla.core.ui.Image;
import org.eclipse.rcptt.tesla.core.utils.WidgetModels;
import org.eclipse.rcptt.tesla.ecl.impl.TeslaBridge;
import org.eclipse.rcptt.tesla.internal.ui.player.SWTUIElement;
import org.eclipse.rcptt.verifications.runtime.ErrorList;
import org.eclipse.rcptt.verifications.status.StatusFactory;
import org.eclipse.rcptt.verifications.status.TreeItemStyleVerificationError;
import org.eclipse.rcptt.verifications.status.TreeItemVerificationError;
import org.eclipse.rcptt.verifications.status.VerificationStatusData;
import org.eclipse.rcptt.verifications.tree.CaptureTreeVerificationData;
import org.eclipse.rcptt.verifications.tree.Cell;
import org.eclipse.rcptt.verifications.tree.Column;
import org.eclipse.rcptt.verifications.tree.ModelTreeNodeAdapter;
import org.eclipse.rcptt.verifications.tree.Row;
import org.eclipse.rcptt.verifications.tree.Tree;
import org.eclipse.rcptt.verifications.tree.TreeComparison;
import org.eclipse.rcptt.verifications.tree.TreeFactory;
import org.eclipse.rcptt.verifications.tree.TreeNode;
import org.eclipse.rcptt.verifications.tree.TreeVerificationUtils;
import org.eclipse.rcptt.verifications.tree.VerifyStyleType;
import org.eclipse.rcptt.verifications.tree.VerifyTreeData;
import org.eclipse.rcptt.verifications.tree.impl.TreeVerificationModeller;
import org.eclipse.rcptt.verifications.tree.impl.WidgetTreeNodeAdapter;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Widget;

public class TreeVerificationProcessor
extends VerificationProcessor {
    public Object start(Verification verification, IProcess process) throws CoreException {
        return new Date();
    }

    public void finish(Verification verification, Object data, IProcess process) throws CoreException {
        final VerifyTreeData treeVerification = (VerifyTreeData)verification;
        SWTUIElement swtuiElement = TeslaBridge.resolveSWTUIElement((String)treeVerification.getSelector(), (IProcess)process);
        final Widget widget = swtuiElement.widget;
        final ErrorList errors = new ErrorList();
        final Throwable[] error = new Throwable[1];
        widget.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    Tree expectedTree = treeVerification.getTree();
                    Tree actualTree = TreeVerificationModeller.getTreeData(widget, false);
                    TreeVerificationProcessor.this.compareTrees(widget, errors, expectedTree, actualTree, treeVerification.isAllowUncapturedChildren(), treeVerification.isAllowExtraColumns(), treeVerification.isAllowMissingColumns(), treeVerification.isVerifyIcons(), treeVerification.getVerifyStyle());
                }
                catch (Throwable e) {
                    error[0] = e;
                }
            }
        });
        if (error[0] != null) {
            throw new CoreException(RcpttPlugin.createStatus((Throwable)error[0]));
        }
        errors.throwIfAny(String.format("Tree widget verification '%s' failed:", verification.getName()), ((Object)((Object)this)).getClass().getPackage().getName(), verification.getId());
    }

    private void compareTrees(final Widget widget, ErrorList errors, final Tree expectedTree, Tree actualTree, final boolean allowUncapturedChildren, boolean allowExtra, boolean allowMissing, final boolean verifyIcons, final VerifyStyleType verifyStyle) {
        if (expectedTree == null) {
            errors.add("Expected tree is undefined", new Object[0]);
            return;
        }
        final EList expectingColumns = expectedTree.getColumns();
        EList actualColumns = actualTree.getColumns();
        final int[] mappedInds = expectingColumns.size() > 0 ? new int[expectingColumns.size()] : new int[1];
        boolean[] mappedActualCols = new boolean[actualColumns.size()];
        boolean correctMapping = true;
        int i = 0;
        while (i < expectingColumns.size()) {
            boolean mapped = false;
            int j = 0;
            while (j < actualColumns.size()) {
                if (!mappedActualCols[j] && ((Column)expectingColumns.get(i)).getName().equals(((Column)actualColumns.get(j)).getName()) && this.isEqualStrings(((Column)expectingColumns.get(i)).getTooltip(), ((Column)actualColumns.get(i)).getTooltip())) {
                    mappedInds[i] = j;
                    mappedActualCols[j] = true;
                    mapped = true;
                    break;
                }
                ++j;
            }
            if (!mapped) {
                if (allowMissing) {
                    mappedInds[i] = -1;
                } else {
                    correctMapping = false;
                    errors.add("Expected column \"%s\" %s was not found in actual columns list ", new Object[]{((Column)expectingColumns.get(i)).getName(), ((Column)expectingColumns.get(i)).getTooltip() == null ? "" : String.format("with tooltip", expectingColumns.get(i))});
                }
            }
            ++i;
        }
        i = 0;
        while (i < mappedActualCols.length) {
            if (!mappedActualCols[i] && !allowExtra) {
                correctMapping = false;
                errors.add("Column \"%s\" %s is undefined in expected columns list", new Object[]{((Column)actualColumns.get(i)).getName(), ((Column)actualColumns.get(i)).getTooltip() == null ? "" : String.format("with tooltip", actualColumns.get(i))});
            }
            ++i;
        }
        if (correctMapping) {
            if (verifyIcons) {
                i = 0;
                while (i < expectingColumns.size()) {
                    String expImgName = TreeVerificationUtils.getDecoratedImagePath((Image)((Column)expectingColumns.get(i)).getImage());
                    String actImgName = TreeVerificationUtils.getDecoratedImagePath((Image)((Column)expectingColumns.get(mappedInds[i])).getImage());
                    if (expImgName == null && actImgName != null || expImgName != null && !expImgName.equals(actImgName)) {
                        errors.add("Expected %s for column \"%s\" but was %s", new Object[]{expImgName == null ? "no icon" : String.format("icon \"%s\"", expImgName), ((Column)expectingColumns.get(i)).getName(), actImgName == null ? "no icon" : String.format("\"%s\"", actImgName)});
                    }
                    ++i;
                }
            }
            TreeComparison<Row> comparison = new TreeComparison<Row>(false){

                public List<TreeItemVerificationError> compare(Row row1, Row row2) {
                    ArrayList<TreeItemVerificationError> rv = new ArrayList<TreeItemVerificationError>();
                    boolean equal = TreeVerificationProcessor.this.compareRows(rv, row1, row2, widget.getDisplay(), verifyStyle, verifyIcons, (List)expectingColumns, mappedInds);
                    Assert.isTrue((equal == rv.isEmpty() ? 1 : 0) != 0);
                    return rv;
                }

                public boolean isChildrenVerificationRequired(Row expectedChild) {
                    return !allowUncapturedChildren || !expectedChild.getChildren().isEmpty();
                }

                public String getName(Row payload) {
                    if (payload == null) {
                        return "";
                    }
                    return TreeVerificationProcessor.getNonBlankItemText(expectedTree, payload);
                }
            };
            List treeResults = comparison.assertNode((TreeNode)new ModelTreeNodeAdapter(expectedTree), (TreeNode)new WidgetTreeNodeAdapter(widget));
            for (TreeItemVerificationError treeItemVerificationError : treeResults) {
                errors.add((VerificationStatusData)treeItemVerificationError);
            }
        }
    }

    private static String getNonBlankItemText(Tree tree, Row item) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < item.getValues().size()) {
            if (!((Cell)item.getValues().get(i)).getData().getText().equals("")) {
                sb.append(((Cell)item.getValues().get(i)).getData().getText());
                if (i == 0) break;
                sb.append(String.format("(column \"%s\")", ((Column)tree.getColumns().get(i)).getName()));
                break;
            }
            ++i;
        }
        return sb.toString();
    }

    private boolean isEqualStrings(String left, String right) {
        return !(left == null && right != null || left != null && !left.equals(right));
    }

    private boolean compareRows(List<TreeItemVerificationError> errors, Row expectedRow, Row actualRow, Display display, VerifyStyleType verifyStyle, boolean verifyIcons, List<Column> columns, int[] mappedInds) {
        TreeItemVerificationError error;
        boolean equal = true;
        if (expectedRow == actualRow) {
            return true;
        }
        if (expectedRow == null || actualRow == null) {
            error = StatusFactory.eINSTANCE.createTreeItemVerificationError();
            error.setMessage("Row undefined");
            errors.add(error);
        }
        if (expectedRow.isChecked() != actualRow.isChecked()) {
            equal = false;
            error = StatusFactory.eINSTANCE.createTreeItemVerificationError();
            error.setMessage(String.format("Expected to be %s, but actual row is %s", expectedRow.isChecked() ? "checked" : "unchecked", actualRow.isChecked() ? "checked" : "unchecked"));
            errors.add(error);
        }
        int j = 0;
        while (j < mappedInds.length) {
            if (mappedInds[j] != -1) {
                WidgetModels.StyleDiff diff;
                String actImg;
                String expImg;
                Cell expVal = (Cell)expectedRow.getValues().get(j);
                Cell actVal = (Cell)actualRow.getValues().get(mappedInds[j]);
                if (verifyIcons && !this.isEqualStrings(expImg = TreeVerificationUtils.getDecoratedImagePath((Image)expVal.getData().getImage()), actImg = TreeVerificationUtils.getDecoratedImagePath((Image)actVal.getData().getImage()))) {
                    equal = false;
                    TreeItemVerificationError error2 = StatusFactory.eINSTANCE.createTreeItemVerificationError();
                    error2.setMessage(String.format("Expected %s, but was %s", expImg == null ? "no icon" : String.format("icon \"%s\"", expImg), actImg == null ? "no icon" : String.format("\"%s\"", actImg)));
                    if (columns.size() > j) {
                        error2.setColumn(columns.get(j).getName());
                    }
                    errors.add(error2);
                }
                String expText = expVal.getData().getText();
                String actText = actVal.getData().getText();
                EList expectedStyles = expVal.getStyle();
                EList actualStyles = actVal.getStyle();
                if (verifyStyle == VerifyStyleType.IGNORE_STYLED_TEXT) {
                    expText = WidgetModels.getTextWithoutStyle((Iterable)expectedStyles, (String)expText);
                    actText = WidgetModels.getTextWithoutStyle((Iterable)actualStyles, (String)actText);
                }
                if (!expText.equals(actText)) {
                    equal = false;
                    TreeItemVerificationError error3 = StatusFactory.eINSTANCE.createTreeItemVerificationError();
                    error3.setMessage(String.format("Expected \"%s\", but was \"%s\"", expVal.getData().getText(), actVal.getData().getText()));
                    if (columns.size() > j) {
                        error3.setColumn(columns.get(j).getName());
                    }
                    errors.add(error3);
                } else if (verifyStyle == VerifyStyleType.ALL && (diff = WidgetModels.getDiff((int)0, (int)expText.length(), (Iterable)expectedStyles, (Iterable)actualStyles)) != null) {
                    equal = false;
                    TreeItemStyleVerificationError error4 = StatusFactory.eINSTANCE.createTreeItemStyleVerificationError();
                    error4.setMessage(String.format("Different text style from position %d.", diff.at));
                    if (columns.size() > j) {
                        error4.setColumn(columns.get(j).getName());
                    }
                    error4.setExpectedStyle(diff.expected);
                    error4.setActualStyle(diff.actual);
                    errors.add((TreeItemVerificationError)error4);
                }
            }
            ++j;
        }
        return equal;
    }

    public Verification create(EObject param, IProcess process) throws CoreException {
        final CreateWidgetVerificationParam p = (CreateWidgetVerificationParam)param;
        SWTUIElement swtuiElement = TeslaBridge.resolveSWTUIElement((String)p.getSelector(), (IProcess)process);
        final Widget widget = swtuiElement.widget;
        final CaptureTreeVerificationData result = TreeFactory.eINSTANCE.createCaptureTreeVerificationData();
        widget.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                result.getImages().clear();
                result.getImages().putAll(TreeVerificationModeller.extractImages(widget));
                result.setSelector(p.getSelector());
                result.setTree(TreeVerificationModeller.getTreeData(widget, true));
            }
        });
        return result;
    }
}

