/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.plugin;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.filebuffers.IDocumentSetupParticipant;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.internal.core.text.AbstractEditingModel;
import org.eclipse.pde.internal.core.text.IDocumentKey;
import org.eclipse.pde.internal.core.text.bundle.BundleModel;
import org.eclipse.pde.internal.core.text.bundle.ManifestHeader;
import org.eclipse.pde.internal.core.text.bundle.PDEManifestElement;
import org.eclipse.pde.internal.core.text.bundle.PackageFriend;
import org.eclipse.pde.internal.core.util.PropertiesUtil;
import org.eclipse.pde.internal.ui.editor.JarEntryEditorInput;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.pde.internal.ui.editor.context.ManifestDocumentSetupParticipant;
import org.eclipse.pde.internal.ui.editor.context.UTF8InputContext;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IURIEditorInput;

public class BundleInputContext
extends UTF8InputContext {
    public static final String CONTEXT_ID = "bundle-context";
    private HashMap<IDocumentKey, TextEdit> fOperationTable = new HashMap();

    public BundleInputContext(PDEFormEditor editor, IEditorInput input, boolean primary) {
        super(editor, input, primary);
        this.create();
    }

    @Override
    protected IBaseModel createModel(IEditorInput input) throws CoreException {
        BundleModel model = null;
        boolean isReconciling = input instanceof IFileEditorInput;
        IDocument document = this.getDocumentProvider().getDocument((Object)input);
        model = new BundleModel(document, isReconciling);
        if (input instanceof IFileEditorInput) {
            IFile file = ((IFileEditorInput)input).getFile();
            model.setUnderlyingResource((IResource)file);
            model.setCharset(file.getCharset());
        } else if (input instanceof IURIEditorInput) {
            IFileStore store = EFS.getStore((URI)((IURIEditorInput)input).getURI());
            model.setInstallLocation(store.getParent().getParent().toString());
            model.setCharset(this.getDefaultCharset());
        } else if (input instanceof JarEntryEditorInput) {
            File file = ((JarEntryEditorInput)input).getAdapter(File.class);
            model.setInstallLocation(file.toString());
            model.setCharset(this.getDefaultCharset());
        } else {
            model.setCharset(this.getDefaultCharset());
        }
        model.load();
        return model;
    }

    @Override
    public String getId() {
        return CONTEXT_ID;
    }

    @Override
    protected void addTextEditOperation(ArrayList<TextEdit> ops, IModelChangedEvent event) {
        Object[] objects = event.getChangedObjects();
        if (objects != null) {
            int i = 0;
            while (i < objects.length) {
                Object object = objects[i];
                if (object instanceof PDEManifestElement) {
                    object = ((PDEManifestElement)object).getHeader();
                } else if (object instanceof PackageFriend) {
                    object = ((PackageFriend)object).getHeader();
                }
                if (object instanceof ManifestHeader) {
                    String value;
                    ManifestHeader header = (ManifestHeader)object;
                    TextEdit op = this.fOperationTable.get(header);
                    if (op != null) {
                        this.fOperationTable.remove(header);
                        ops.remove(op);
                    }
                    if ((value = header.getValue()) == null || value.trim().length() == 0) {
                        this.deleteKey((IDocumentKey)header, ops);
                    } else {
                        this.modifyKey((IDocumentKey)header, ops);
                    }
                }
                ++i;
            }
        }
    }

    protected TextEdit[] getMoveOperations() {
        return new TextEdit[0];
    }

    private void insertKey(IDocumentKey key, ArrayList<TextEdit> ops) {
        IDocument doc = this.getDocumentProvider().getDocument((Object)this.getInput());
        InsertEdit op = new InsertEdit(PropertiesUtil.getInsertOffset((IDocument)doc), key.write());
        this.fOperationTable.put(key, (TextEdit)op);
        ops.add((TextEdit)op);
    }

    private void deleteKey(IDocumentKey key, ArrayList<TextEdit> ops) {
        if (key.getOffset() > 0) {
            DeleteEdit op = new DeleteEdit(key.getOffset(), key.getLength());
            this.fOperationTable.put(key, (TextEdit)op);
            ops.add((TextEdit)op);
        }
    }

    private void modifyKey(IDocumentKey key, ArrayList<TextEdit> ops) {
        if (key.getOffset() == -1) {
            this.insertKey(key, ops);
        } else {
            ReplaceEdit op = new ReplaceEdit(key.getOffset(), key.getLength(), key.write());
            this.fOperationTable.put(key, (TextEdit)op);
            ops.add((TextEdit)op);
        }
    }

    @Override
    public void doRevert() {
        this.fEditOperations.clear();
        this.fOperationTable.clear();
        AbstractEditingModel model = (AbstractEditingModel)this.getModel();
        model.reconciled(model.getDocument());
    }

    @Override
    protected String getPartitionName() {
        return "___bundle_partition";
    }

    @Override
    protected IDocumentSetupParticipant getDocumentSetupParticipant() {
        return new ManifestDocumentSetupParticipant();
    }
}

