/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.databinding.property.value;

import java.util.Map;
import java.util.Set;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.map.ComputedObservableMap;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.property.INativePropertyListener;
import org.eclipse.core.databinding.property.IProperty;
import org.eclipse.core.databinding.property.IPropertyObservable;
import org.eclipse.core.databinding.property.ISimplePropertyListener;
import org.eclipse.core.databinding.property.SimplePropertyEvent;
import org.eclipse.core.databinding.property.value.SimpleValueProperty;
import org.eclipse.core.internal.databinding.identity.IdentityMap;
import org.eclipse.core.internal.databinding.identity.IdentitySet;
import org.eclipse.core.internal.databinding.property.Util;

public class SetSimpleValueObservableMap
extends ComputedObservableMap
implements IPropertyObservable {
    private SimpleValueProperty detailProperty;
    private INativePropertyListener listener;
    private Map cachedValues;
    private Set staleKeys;
    private boolean updating;

    public SetSimpleValueObservableMap(IObservableSet keySet, SimpleValueProperty valueProperty) {
        super(keySet, valueProperty.getValueType());
        this.detailProperty = valueProperty;
    }

    protected void firstListenerAdded() {
        if (this.listener == null) {
            this.listener = this.detailProperty.adaptListener(new ISimplePropertyListener(){

                @Override
                public void handleEvent(final SimplePropertyEvent event) {
                    if (!SetSimpleValueObservableMap.this.isDisposed() && !SetSimpleValueObservableMap.this.updating) {
                        SetSimpleValueObservableMap.this.getRealm().exec(new Runnable(){

                            @Override
                            public void run() {
                                if (event.type == SimplePropertyEvent.CHANGE) {
                                    SetSimpleValueObservableMap.this.notifyIfChanged(event.getSource());
                                } else if (event.type == SimplePropertyEvent.STALE) {
                                    boolean wasStale = !SetSimpleValueObservableMap.this.staleKeys.isEmpty();
                                    SetSimpleValueObservableMap.this.staleKeys.add(event.getSource());
                                    if (!wasStale) {
                                        SetSimpleValueObservableMap.this.fireStale();
                                    }
                                }
                            }
                        });
                    }
                }
            });
        }
        this.cachedValues = new IdentityMap();
        this.staleKeys = new IdentitySet();
        super.firstListenerAdded();
    }

    protected void lastListenerRemoved() {
        super.lastListenerRemoved();
        this.cachedValues.clear();
        this.cachedValues = null;
        this.staleKeys.clear();
        this.staleKeys = null;
    }

    protected void hookListener(Object addedKey) {
        if (this.cachedValues != null) {
            this.cachedValues.put(addedKey, this.detailProperty.getValue(addedKey));
            if (this.listener != null) {
                this.listener.addTo(addedKey);
            }
        }
    }

    protected void unhookListener(Object removedKey) {
        if (this.cachedValues != null) {
            if (this.listener != null) {
                this.listener.removeFrom(removedKey);
            }
            this.cachedValues.remove(removedKey);
            this.staleKeys.remove(removedKey);
        }
    }

    protected Object doGet(Object key) {
        return this.detailProperty.getValue(key);
    }

    protected Object doPut(Object key, Object value) {
        Object oldValue = this.detailProperty.getValue(key);
        this.updating = true;
        try {
            this.detailProperty.setValue(key, value);
        }
        finally {
            this.updating = false;
        }
        this.notifyIfChanged(key);
        return oldValue;
    }

    private void notifyIfChanged(Object key) {
        Object newValue;
        Object oldValue;
        if (this.cachedValues != null && (!Util.equals(oldValue = this.cachedValues.get(key), newValue = this.detailProperty.getValue(key)) || this.staleKeys.contains(key))) {
            this.cachedValues.put(key, newValue);
            this.staleKeys.remove(key);
            this.fireMapChange(Diffs.createMapDiffSingleChange((Object)key, oldValue, (Object)newValue));
        }
    }

    public Object getObserved() {
        return this.keySet();
    }

    @Override
    public IProperty getProperty() {
        return this.detailProperty;
    }

    public boolean isStale() {
        return super.isStale() || this.staleKeys != null && !this.staleKeys.isEmpty();
    }

    public synchronized void dispose() {
        if (this.cachedValues != null) {
            this.cachedValues.clear();
            this.cachedValues = null;
        }
        this.listener = null;
        this.detailProperty = null;
        this.cachedValues = null;
        this.staleKeys = null;
        super.dispose();
    }
}

