/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.op;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.egit.core.internal.CoreText;
import org.eclipse.egit.core.internal.job.RuleUtil;
import org.eclipse.egit.core.internal.util.ProjectUtil;
import org.eclipse.egit.core.op.IEGitOperation;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.RebaseCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.errors.IllegalTodoFileModification;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.RebaseTodoLine;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.team.core.TeamException;

public class RewordCommitOperation
implements IEGitOperation {
    private Repository repository;
    private RevCommit commit;
    private String newMessage;

    public RewordCommitOperation(Repository repository, RevCommit commit, String newMessage) {
        if (commit.getParentCount() != 1) {
            throw new UnsupportedOperationException("commit is expected to have exactly one parent");
        }
        this.repository = repository;
        this.commit = commit;
        this.newMessage = newMessage;
    }

    @Override
    public void execute(IProgressMonitor m) throws CoreException {
        IProgressMonitor monitor = m != null ? m : new NullProgressMonitor();
        IWorkspaceRunnable action = new IWorkspaceRunnable(){

            public void run(IProgressMonitor pm) throws CoreException {
                pm.beginTask("", 2);
                pm.subTask(MessageFormat.format(CoreText.RewordCommitOperation_rewording, RewordCommitOperation.this.commit.name()));
                RebaseCommand.InteractiveHandler handler = new RebaseCommand.InteractiveHandler(){

                    public void prepareSteps(List<RebaseTodoLine> steps) {
                        for (RebaseTodoLine step : steps) {
                            if (step.getCommit().prefixCompare((AnyObjectId)RewordCommitOperation.this.commit) != 0) continue;
                            try {
                                step.setAction(RebaseTodoLine.Action.REWORD);
                            }
                            catch (IllegalTodoFileModification illegalTodoFileModification) {}
                        }
                    }

                    public String modifyCommitMessage(String oldMessage) {
                        return RewordCommitOperation.this.newMessage;
                    }
                };
                try {
                    Git git = new Git(RewordCommitOperation.this.repository);
                    git.rebase().setUpstream(RewordCommitOperation.this.commit.getParent(0)).runInteractively(handler).setOperation(RebaseCommand.Operation.BEGIN).call();
                }
                catch (GitAPIException e) {
                    throw new TeamException(e.getLocalizedMessage(), e.getCause());
                }
                pm.worked(1);
                ProjectUtil.refreshValidProjects(ProjectUtil.getValidOpenProjects(RewordCommitOperation.this.repository), (IProgressMonitor)new SubProgressMonitor(pm, 1));
                pm.done();
            }
        };
        ResourcesPlugin.getWorkspace().run(action, this.getSchedulingRule(), 1, monitor);
    }

    @Override
    public ISchedulingRule getSchedulingRule() {
        return RuleUtil.getRule(this.repository);
    }
}

