/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.core.refactoring;

import java.util.LinkedList;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.ContentStamp;
import org.eclipse.ltk.core.refactoring.NullChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.internal.core.refactoring.BufferValidationState;
import org.eclipse.ltk.internal.core.refactoring.Changes;
import org.eclipse.ltk.internal.core.refactoring.ContentStamps;
import org.eclipse.ltk.internal.core.refactoring.RefactoringCorePlugin;
import org.eclipse.text.edits.UndoEdit;

public class MultiStateUndoChange
extends Change {
    private ContentStamp fContentStampToRestore;
    private boolean fDirty;
    private IFile fFile;
    private String fName;
    private int fSaveMode;
    private UndoEdit[] fUndos;
    private BufferValidationState fValidationState;

    public MultiStateUndoChange(String name, IFile file, UndoEdit[] undos, ContentStamp stamp, int saveMode) {
        Assert.isNotNull((Object)name);
        Assert.isNotNull((Object)file);
        Assert.isNotNull((Object)undos);
        this.fName = name;
        this.fFile = file;
        this.fUndos = undos;
        this.fContentStampToRestore = stamp;
        this.fSaveMode = saveMode;
    }

    protected Change createUndoChange(UndoEdit[] edits, ContentStamp stampToRestore) throws CoreException {
        return new MultiStateUndoChange(this.getName(), this.fFile, edits, stampToRestore, this.fSaveMode);
    }

    public void dispose() {
        if (this.fValidationState != null) {
            this.fValidationState.dispose();
        }
    }

    public final Object[] getAffectedObjects() {
        Object modifiedElement = this.getModifiedElement();
        if (modifiedElement == null) {
            return null;
        }
        return new Object[]{modifiedElement};
    }

    public final Object getModifiedElement() {
        return this.fFile;
    }

    public final String getName() {
        return this.fName;
    }

    public final int getSaveMode() {
        return this.fSaveMode;
    }

    public void initializeValidationData(IProgressMonitor pm) {
        if (pm == null) {
            pm = new NullProgressMonitor();
        }
        pm.beginTask("", 1);
        try {
            this.fValidationState = BufferValidationState.create(this.fFile);
        }
        finally {
            pm.done();
        }
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException {
        if (pm == null) {
            pm = new NullProgressMonitor();
        }
        pm.beginTask("", 1);
        try {
            if (this.fValidationState == null) {
                throw new CoreException((IStatus)new Status(4, RefactoringCorePlugin.getPluginId(), "MultiStateUndoChange has not been initialialized"));
            }
            ITextFileBuffer buffer = FileBuffers.getTextFileBufferManager().getTextFileBuffer(this.fFile.getFullPath(), LocationKind.IFILE);
            this.fDirty = buffer != null && buffer.isDirty();
            RefactoringStatus refactoringStatus = this.fValidationState.isValid(this.needsSaving(), true);
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    public final boolean needsSaving() {
        return (this.fSaveMode & 2) != 0 || !this.fDirty && (this.fSaveMode & 1) != 0;
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        if (this.fValidationState == null || this.fValidationState.isValid(this.needsSaving(), false).hasFatalError()) {
            return new NullChange();
        }
        if (pm == null) {
            pm = new NullProgressMonitor();
        }
        ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
        pm.beginTask("", 2);
        ITextFileBuffer buffer = null;
        try {
            manager.connect(this.fFile.getFullPath(), LocationKind.IFILE, (IProgressMonitor)new SubProgressMonitor(pm, 1));
            buffer = manager.getTextFileBuffer(this.fFile.getFullPath(), LocationKind.IFILE);
            IDocument document = buffer.getDocument();
            ContentStamp currentStamp = ContentStamps.get(this.fFile, document);
            LinkedList<UndoEdit> list = new LinkedList<UndoEdit>();
            int index = 0;
            while (index < this.fUndos.length) {
                UndoEdit edit = this.fUndos[index];
                UndoEdit redo = edit.apply(document, 1);
                list.addFirst(redo);
                ++index;
            }
            boolean success = ContentStamps.set(document, this.fContentStampToRestore);
            if (this.needsSaving()) {
                buffer.commit(pm, false);
                if (!success) {
                    ContentStamps.set(this.fFile, this.fContentStampToRestore);
                }
            }
            Change change = this.createUndoChange(list.toArray(new UndoEdit[list.size()]), currentStamp);
            return change;
        }
        catch (BadLocationException e) {
            throw Changes.asCoreException(e);
        }
        finally {
            if (buffer != null) {
                manager.disconnect(this.fFile.getFullPath(), LocationKind.IFILE, (IProgressMonitor)new SubProgressMonitor(pm, 1));
            }
        }
    }
}

