/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.team.core.synchronize.SyncInfoSet;
import org.eclipse.team.internal.ui.Policy;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.synchronize.ISynchronizeModelProvider;
import org.eclipse.team.internal.ui.synchronize.ISynchronizeModelProviderDescriptor;
import org.eclipse.team.internal.ui.synchronize.SynchronizeModelProvider;
import org.eclipse.team.internal.ui.synchronize.TreeViewerAdvisor;
import org.eclipse.team.ui.synchronize.ISynchronizeModelElement;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.SynchronizePageActionGroup;
import org.eclipse.ui.IActionBars;

public abstract class SynchronizeModelManager
extends SynchronizePageActionGroup {
    private static final String P_LAST_PROVIDER = "org.eclipse.team.ui.P_LAST_MODELPROVIDER";
    private ISynchronizeModelProvider modelProvider;
    private List toggleModelProviderActions;
    private ISynchronizePageConfiguration configuration;
    private TreeViewerAdvisor advisor;

    public SynchronizeModelManager(ISynchronizePageConfiguration configuration) {
        Assert.isNotNull((Object)configuration, (String)"configuration cannot be null");
        this.configuration = configuration;
        configuration.addActionContribution(this);
    }

    public void setViewerAdvisor(TreeViewerAdvisor advisor) {
        this.advisor = advisor;
    }

    protected abstract ISynchronizeModelProviderDescriptor[] getSupportedModelProviders();

    protected abstract ISynchronizeModelProvider createModelProvider(String var1);

    public ISynchronizeModelProvider getActiveModelProvider() {
        return this.modelProvider;
    }

    protected String getDefaultProviderId() {
        String defaultLayout = TeamUIPlugin.getPlugin().getPreferenceStore().getString("org.eclipse.team.ui.default_layout");
        if (defaultLayout.equals("org.eclipse.team.ui.tree_layout")) {
            return "org.eclipse.team.ui.modelprovider_hierarchical";
        }
        if (defaultLayout.equals("org.eclipse.team.ui.flay_layout")) {
            return "org.eclipse.team.ui.modelprovider_flat";
        }
        return "org.eclipse.team.ui.modelprovider_compressedfolders";
    }

    protected String getSelectedProviderId() {
        ISynchronizeModelProvider provider = this.getActiveModelProvider();
        if (provider != null) {
            return provider.getDescriptor().getId();
        }
        return this.getDefaultProviderId();
    }

    protected void setInput(String id, IProgressMonitor monitor) {
        if (this.modelProvider != null) {
            this.modelProvider.saveState();
            this.modelProvider.dispose();
        }
        this.modelProvider = this.createModelProvider(id);
        this.saveProviderSettings(id);
        this.modelProvider.prepareInput(monitor);
        this.setInput();
    }

    protected void saveProviderSettings(String id) {
        IDialogSettings pageSettings = this.getConfiguration().getSite().getPageSettings();
        if (pageSettings != null) {
            pageSettings.put(P_LAST_PROVIDER, id);
        }
    }

    protected void setInput() {
        this.configuration.setProperty("org.eclipse.team.ui.P_MODEL", this.modelProvider.getModelRoot());
        if (this.advisor != null) {
            this.advisor.setInput(this.modelProvider);
        }
    }

    public ISynchronizeModelElement getModelRoot() {
        if (this.modelProvider != null && this.modelProvider instanceof SynchronizeModelProvider) {
            ((SynchronizeModelProvider)this.modelProvider).waitUntilDone(new IProgressMonitor(){

                public void beginTask(String name, int totalWork) {
                }

                public void done() {
                }

                public void internalWorked(double work) {
                }

                public boolean isCanceled() {
                    return false;
                }

                public void setCanceled(boolean value) {
                }

                public void setTaskName(String name) {
                }

                public void subTask(String name) {
                }

                public void worked(int work) {
                    while (Display.getCurrent().readAndDispatch()) {
                    }
                }
            });
            return this.modelProvider.getModelRoot();
        }
        return null;
    }

    public void initialize(ISynchronizePageConfiguration configuration) {
        super.initialize(configuration);
        ISynchronizeModelProviderDescriptor[] providers = this.getSupportedModelProviders();
        if (providers.length > 1) {
            this.toggleModelProviderActions = new ArrayList();
            int i = 0;
            while (i < providers.length) {
                ISynchronizeModelProviderDescriptor provider = providers[i];
                this.toggleModelProviderActions.add(new ToggleModelProviderAction(provider));
                ++i;
            }
        }
        if (this.modelProvider == null) {
            String defaultProviderId = this.getDefaultProviderId();
            IDialogSettings pageSettings = configuration.getSite().getPageSettings();
            if (pageSettings != null && pageSettings.get(P_LAST_PROVIDER) != null) {
                defaultProviderId = pageSettings.get(P_LAST_PROVIDER);
            }
            this.setInput(defaultProviderId, null);
        } else {
            this.setInput();
        }
    }

    public void fillActionBars(IActionBars actionBars) {
        if (this.toggleModelProviderActions == null) {
            return;
        }
        IToolBarManager toolbar = actionBars.getToolBarManager();
        IMenuManager menu = actionBars.getMenuManager();
        IContributionItem group = this.findGroup((IContributionManager)menu, "layout");
        if (menu != null && group != null) {
            MenuManager layout = new MenuManager(Utils.getString("action.layout.label", Policy.getActionBundle()));
            menu.appendToGroup(group.getId(), (IContributionItem)layout);
            this.appendToMenu(null, (IContributionManager)layout);
        } else if (toolbar != null && (group = this.findGroup((IContributionManager)toolbar, "layout")) != null) {
            this.appendToMenu(group.getId(), (IContributionManager)toolbar);
        }
    }

    private void appendToMenu(String groupId, IContributionManager menu) {
        Iterator iter = this.toggleModelProviderActions.iterator();
        while (iter.hasNext()) {
            if (groupId == null) {
                menu.add((IAction)((Action)iter.next()));
                continue;
            }
            menu.appendToGroup(groupId, (IAction)((Action)iter.next()));
        }
    }

    public void dispose() {
        if (this.modelProvider != null) {
            this.modelProvider.dispose();
        }
        super.dispose();
    }

    public ISynchronizePageConfiguration getConfiguration() {
        return this.configuration;
    }

    protected SyncInfoSet getSyncInfoSet() {
        return (SyncInfoSet)this.getConfiguration().getProperty("org.eclipse.team.ui.P_SYNC_INFO_SET");
    }

    private class ToggleModelProviderAction
    extends Action
    implements IPropertyChangeListener {
        private ISynchronizeModelProviderDescriptor descriptor;

        protected ToggleModelProviderAction(ISynchronizeModelProviderDescriptor descriptor) {
            super(descriptor.getName(), 8);
            this.setImageDescriptor(descriptor.getImageDescriptor());
            this.setToolTipText(descriptor.getName());
            this.descriptor = descriptor;
            this.update();
            SynchronizeModelManager.this.configuration.addPropertyChangeListener(this);
        }

        public void run() {
            if (!SynchronizeModelManager.this.getSelectedProviderId().equals(this.descriptor.getId())) {
                SynchronizeModelManager.this.setInput(this.descriptor.getId(), null);
            }
        }

        public void update() {
            this.setChecked(SynchronizeModelManager.this.getSelectedProviderId().equals(this.descriptor.getId()));
        }

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals("org.eclipse.team.ui.P_MODEL")) {
                this.update();
            }
        }
    }
}

