/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.commons;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.databinding.EMFObservables;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.rcptt.core.model.IElementChangedListener;
import org.eclipse.rcptt.core.model.IQ7Element;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.model.IQ7Project;
import org.eclipse.rcptt.core.model.ITestCase;
import org.eclipse.rcptt.core.model.ITestSuite;
import org.eclipse.rcptt.core.model.ModelException;
import org.eclipse.rcptt.core.model.Q7ElementChangedEvent;
import org.eclipse.rcptt.core.model.search.AllProjectScope;
import org.eclipse.rcptt.core.model.search.ISearchScope;
import org.eclipse.rcptt.core.model.search.Q7SearchCore;
import org.eclipse.rcptt.core.scenario.ScenarioFactory;
import org.eclipse.rcptt.core.scenario.ScenarioPackage;
import org.eclipse.rcptt.core.scenario.TestSuite;
import org.eclipse.rcptt.core.scenario.TestSuiteItem;
import org.eclipse.rcptt.core.tags.Tag;
import org.eclipse.rcptt.core.workspace.Q7Utils;
import org.eclipse.rcptt.core.workspace.RcpttCore;
import org.eclipse.rcptt.internal.core.model.OneProjectScope;
import org.eclipse.rcptt.internal.core.model.ReferencedProjectScope;
import org.eclipse.rcptt.internal.ui.Messages;
import org.eclipse.rcptt.internal.ui.Q7UIPlugin;
import org.eclipse.rcptt.ui.actions.SelectionAction;
import org.eclipse.rcptt.ui.commons.ArrayTransfer;
import org.eclipse.rcptt.ui.commons.ClipboardUtils;
import org.eclipse.rcptt.ui.commons.IContentNamer;
import org.eclipse.rcptt.ui.commons.ISelectionActionsHandler;
import org.eclipse.rcptt.ui.editors.NamedElementLabelProvider;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.ResourceTransfer;

public class TestSuiteTableViewer
extends TableViewer
implements IContentNamer,
ISelectionActionsHandler {
    private static TestSuiteItemTransfer TRANSFER = null;
    private static TestSuiteItem[] EMPTY = new TestSuiteItem[0];
    private final ITestSuite testSuiteModel;
    private final TestSuite testSuite;
    private final DataBindingContext dbc = new DataBindingContext();
    private final IObservableValue testSuiteObservable;
    private SelectionAction.RemoveAction removeAction;
    private SelectionAction.CutAction cutAction;
    private SelectionAction.CopyAction copyAction;
    private SelectionAction.PasteAction pasteAction;
    private final IElementChangedListener workspaceMonitorListener = new IElementChangedListener(){

        public void elementChanged(Q7ElementChangedEvent event) {
            if (TestSuiteTableViewer.this.getControl() == null || TestSuiteTableViewer.this.getControl().isDisposed()) {
                return;
            }
            boolean needRefresh = false;
            try {
                TestSuiteItem[] displayingItems = TestSuiteTableViewer.this.testSuiteModel.getItems();
                IQ7NamedElement[] iQ7NamedElementArray = event.getDelta().getNamedElements();
                int n = iQ7NamedElementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IQ7NamedElement element = iQ7NamedElementArray[n2];
                    String elementID = Q7SearchCore.findIDByDocument((IQ7Element)element);
                    if (elementID != null) {
                        TestSuiteItem[] testSuiteItemArray = displayingItems;
                        int n3 = displayingItems.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            TestSuiteItem item = testSuiteItemArray[n4];
                            if (item.getNamedElementId().equals(elementID)) {
                                needRefresh = true;
                                break;
                            }
                            ++n4;
                        }
                    }
                    ++n2;
                }
            }
            catch (ModelException modelException) {
                needRefresh = true;
            }
            if (needRefresh) {
                Q7UIPlugin.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!TestSuiteTableViewer.this.getControl().isDisposed()) {
                            TestSuiteTableViewer.this.refresh();
                        }
                    }
                });
            }
        }
    };

    public TestSuiteTableViewer(Composite parent, ITestSuite testSuiteModel, TestSuite testSuite) {
        super(parent, 67586);
        this.testSuiteModel = testSuiteModel;
        this.testSuite = testSuite;
        GridData tableGridData = new GridData(1808);
        tableGridData.widthHint = 1;
        tableGridData.heightHint = 200;
        this.getTable().setLayoutData((Object)tableGridData);
        this.getTable().setLinesVisible(true);
        this.getTable().setHeaderVisible(true);
        this.createTableColumns();
        this.setContentProvider((IContentProvider)new TableContentProvider());
        this.testSuiteObservable = EMFObservables.observeValue((EObject)this.testSuite, (EStructuralFeature)ScenarioPackage.Literals.TEST_SUITE__ITEMS);
        this.dbc.bindValue(ViewersObservables.observeInput((Viewer)this), this.testSuiteObservable);
        this.initializeInternalDrapAndDrop();
        this.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                TestSuiteTableViewer.this.doOpen();
            }
        });
        this.addKeyListeners();
        MenuManager popupMenuManager = new MenuManager();
        IMenuListener listener = new IMenuListener(){

            public void menuAboutToShow(IMenuManager mng) {
                TestSuiteTableViewer.this.fillContextMenu(mng);
            }
        };
        popupMenuManager.addMenuListener(listener);
        popupMenuManager.setRemoveAllWhenShown(true);
        Menu menu = popupMenuManager.createContextMenu(this.getControl());
        this.getControl().setMenu(menu);
        RcpttCore.addElementChangedListener((IElementChangedListener)this.workspaceMonitorListener);
        this.getControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                RcpttCore.removeElementChangedListener((IElementChangedListener)TestSuiteTableViewer.this.workspaceMonitorListener);
            }
        });
    }

    private void addKeyListeners() {
        this.getControl().addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if ('\u007f' == e.character && e.stateMask == 0) {
                    if (!TestSuiteTableViewer.this.getSelection().isEmpty()) {
                        TestSuiteTableViewer.this.handleRemove();
                        e.doit = false;
                    }
                } else if ('\u0018' == e.character) {
                    if (!TestSuiteTableViewer.this.getSelection().isEmpty()) {
                        TestSuiteTableViewer.this.cut();
                        e.doit = false;
                    }
                } else if ('\u0003' == e.character) {
                    if (!TestSuiteTableViewer.this.getSelection().isEmpty()) {
                        TestSuiteTableViewer.this.copy();
                        e.doit = false;
                    }
                } else if ('\u0016' == e.character && TestSuiteTableViewer.this.canPaste()) {
                    TestSuiteTableViewer.this.paste();
                    e.doit = false;
                }
            }
        });
    }

    protected void fillContextMenu(IMenuManager manager) {
        this.removeAction = new SelectionAction.RemoveAction(this);
        this.cutAction = new SelectionAction.CutAction(this);
        this.copyAction = new SelectionAction.CopyAction(this);
        this.pasteAction = new SelectionAction.PasteAction(this);
        this.removeAction.update();
        this.cutAction.update();
        this.copyAction.update();
        this.pasteAction.update();
        manager.add((IAction)this.removeAction);
        manager.add((IAction)this.cutAction);
        manager.add((IAction)this.copyAction);
        manager.add((IAction)this.pasteAction);
    }

    public IObservableValue getTestSuiteObservable() {
        return this.testSuiteObservable;
    }

    private void createTableColumns() {
        final TableViewerColumn columnTestCase = new TableViewerColumn((TableViewer)this, 0);
        columnTestCase.getColumn().setText(Messages.ScenariosLaunchTab_ColumnTestCaseText);
        IQ7Project project = this.testSuiteModel.getQ7Project();
        NamedElementLabelProvider testCaseLabelProvider = new NamedElementLabelProvider(project);
        columnTestCase.setLabelProvider((CellLabelProvider)testCaseLabelProvider);
        final TableViewerColumn columnLocation = new TableViewerColumn((TableViewer)this, 0);
        columnLocation.getColumn().setText(Messages.ScenariosLaunchTab_ColumnLocationText);
        columnLocation.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return TestSuiteTableViewer.this.getPathName((TestSuiteItem)element);
            }
        });
        this.getTable().addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                int width = TestSuiteTableViewer.this.getTable().getClientArea().width;
                int testCaseColWidth = columnTestCase.getColumn().getWidth();
                int locationColWidth = columnLocation.getColumn().getWidth();
                double ratio = 0.5;
                if (testCaseColWidth != 0 && locationColWidth != 0) {
                    ratio = (double)testCaseColWidth / (double)(testCaseColWidth + locationColWidth);
                }
                columnTestCase.getColumn().setWidth((int)((double)width * ratio));
                columnLocation.getColumn().setWidth((int)((double)width * (1.0 - ratio)));
            }
        });
    }

    private String getPathName(TestSuiteItem item) {
        IQ7NamedElement q7NamedElement = Q7SearchCore.getTestSuiteItemElement((TestSuiteItem)item, (ISearchScope)this.getSearchScope());
        if (q7NamedElement != null) {
            String folders = q7NamedElement.getResource().getProjectRelativePath().removeLastSegments(1).toString();
            if (folders.length() > 0) {
                folders = "/" + folders;
            }
            return String.valueOf(q7NamedElement.getResource().getProject().getName()) + folders;
        }
        return "";
    }

    private ISearchScope getSearchScope() {
        IQ7Project testSuiteProject = this.testSuiteModel.getQ7Project();
        ReferencedProjectScope scope = testSuiteProject != null ? new ReferencedProjectScope(testSuiteProject) : new AllProjectScope();
        return scope;
    }

    public void reorderSourceList() {
        int i = 0;
        while (i < this.getTable().getItemCount()) {
            this.testSuite.getItems().move(i, (Object)((TestSuiteItem)this.getElementAt(i)));
            ++i;
        }
    }

    private void doOpen() {
        IStructuredSelection iss = (IStructuredSelection)this.getSelection();
        Object item = iss.getFirstElement();
        IQ7NamedElement element = Q7SearchCore.getTestSuiteItemElement((TestSuiteItem)((TestSuiteItem)item), (ISearchScope)this.getSearchScope());
        if (element instanceof IQ7NamedElement) {
            IQ7NamedElement q7Element = element;
            IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            if (activePage != null) {
                try {
                    IDE.openEditor((IWorkbenchPage)activePage, (IFile)((IFile)q7Element.getResource()));
                }
                catch (PartInitException e) {
                    Q7UIPlugin.log(e);
                }
            }
        }
    }

    protected void initializeInternalDrapAndDrop() {
        int ops = 3;
        Transfer[] transferTypes = new Transfer[]{this.getContentTransfer()};
        this.addDragSupport(ops, transferTypes, (DragSourceListener)new ContentDragListener((StructuredViewer)this));
        transferTypes = this.getDropTransferTypes();
        this.addDropSupport(ops, transferTypes, (DropTargetListener)new ContentTableDropListener((StructuredViewer)this));
    }

    protected Transfer[] getDropTransferTypes() {
        return new Transfer[]{this.getContentTransfer(), ResourceTransfer.getInstance()};
    }

    protected Transfer getContentTransfer() {
        if (TRANSFER == null) {
            TRANSFER = new TestSuiteItemTransfer();
        }
        return TRANSFER;
    }

    protected boolean doPerformDrop(Object data, Object currentTarget, int currentLocation) {
        if (data instanceof IResource[]) {
            IResource[] resources = (IResource[])data;
            int targetPosition = this.testSuite.getItems().size() - 1;
            if (currentTarget != null) {
                targetPosition = this.testSuite.getItems().indexOf(currentTarget);
            }
            if (currentLocation == 2 || currentLocation == 4) {
                ++targetPosition;
            }
            IResource[] iResourceArray = resources;
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                if (resource instanceof IFile) {
                    IQ7NamedElement element = this.getNamedElementByResource(resource);
                    if (this.isValidToAdd((IQ7Element)element)) {
                        this.addItem(element, targetPosition);
                        ++targetPosition;
                    }
                } else if (resource instanceof IContainer) {
                    this.addFolder((IContainer)resource, targetPosition);
                }
                ++n2;
            }
            return true;
        }
        return this.doPerformInternalDrop(data, currentTarget, currentLocation);
    }

    protected boolean doPerformInternalDrop(Object data, Object currentTarget, int currentLocation) {
        List<TestSuiteItem> toDrop = this.convertStringsToItems(data);
        for (TestSuiteItem toDropObject : toDrop) {
            if (!toDropObject.equals(currentTarget)) continue;
            return false;
        }
        EList content = this.testSuite.getItems();
        int targetPosition = content.size() - 1;
        if (currentTarget != null) {
            targetPosition = content.indexOf(currentTarget);
        }
        int result = 0;
        EList list = this.testSuite.getItems();
        int i = 0;
        while (i < toDrop.size()) {
            block8: {
                TestSuiteItem toDropObject = toDrop.get(i);
                for (TestSuiteItem testSuiteItem : list) {
                    if (!testSuiteItem.getNamedElementId().equals(toDropObject.getNamedElementId())) {
                        continue;
                    }
                    break block8;
                }
                if (currentLocation == 2 || currentLocation == 4) {
                    ++targetPosition;
                }
                if (targetPosition == -1) {
                    this.testSuite.getItems().add((Object)toDropObject);
                } else {
                    this.testSuite.getItems().add(targetPosition, (Object)toDropObject);
                }
                ++result;
            }
            ++i;
        }
        return result > 0;
    }

    private List<TestSuiteItem> convertStringsToItems(Object data) {
        ArrayList<TestSuiteItem> result = new ArrayList<TestSuiteItem>();
        Object[] objectArray = (Object[])data;
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object itemDesc = objectArray[n2];
            if (itemDesc instanceof String && ((String)itemDesc).lastIndexOf(59) != -1) {
                String itemDescStr = (String)itemDesc;
                String suiteId = itemDescStr.substring(0, itemDescStr.lastIndexOf(59));
                int idx = Integer.parseInt(itemDescStr.substring(itemDescStr.lastIndexOf(59) + 1));
                if (this.testSuite.getId().equals(suiteId)) {
                    result.add((TestSuiteItem)this.testSuite.getItems().get(idx));
                } else {
                    IQ7NamedElement[] elements = Q7SearchCore.findById((String)suiteId, (ISearchScope)this.getSearchScope(), (IProgressMonitor)new NullProgressMonitor());
                    if (elements.length == 1 && elements[0] instanceof ITestSuite) {
                        try {
                            TestSuite sourceSuite = (TestSuite)((ITestSuite)elements[0]).getModifiedNamedElement();
                            if (!this.testSuite.getId().equals(((TestSuiteItem)sourceSuite.getItems().get(idx)).getNamedElementId())) {
                                result.add((TestSuiteItem)EcoreUtil.copy((EObject)((TestSuiteItem)sourceSuite.getItems().get(idx))));
                            }
                        }
                        catch (ModelException e) {
                            Q7UIPlugin.log(e);
                        }
                    }
                }
            }
            ++n2;
        }
        return result;
    }

    protected boolean doValidateDrop(Object target, int operation, TransferData transferType, int currentLocation) {
        if (ResourceTransfer.getInstance().isSupportedType(transferType)) {
            IResource[] resources;
            IResource[] iResourceArray = resources = this.getSelectedResources();
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                if (resource instanceof IContainer) {
                    return true;
                }
                IQ7NamedElement element = this.getNamedElementByResource(resource);
                if (this.isValidToAdd((IQ7Element)element)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
        return this.getContentTransfer().isSupportedType(transferType);
    }

    protected boolean isValidToAdd(IQ7Element element) {
        if (!this.testSuiteModel.equals(element) && (element instanceof ITestSuite || element instanceof ITestCase)) {
            EList list = this.testSuite.getItems();
            for (TestSuiteItem testSuiteItem : list) {
                try {
                    if (!testSuiteItem.getNamedElementId().equals(((IQ7NamedElement)element).getID())) continue;
                    return false;
                }
                catch (ModelException e) {
                    Q7UIPlugin.log(e);
                }
            }
            return true;
        }
        return false;
    }

    public void addItem(IQ7NamedElement q7NamedElement) {
        this.addItem(q7NamedElement, -1);
    }

    public void addItems(List<IQ7NamedElement> items) {
        for (IQ7NamedElement item : items) {
            this.addItem(item);
        }
    }

    public void addTags(List<Tag> tags) {
        for (Tag tag : tags) {
            EList refs = tag.getRefs();
            for (IQ7NamedElement e : refs) {
                this.addItem(e);
            }
            EList childs = tag.getTags();
            if (childs.size() <= 0) continue;
            this.addTags((List<Tag>)childs);
        }
    }

    public void addItem(IQ7NamedElement q7NamedElement, int position) {
        if (this.testSuiteModel.equals(q7NamedElement)) {
            return;
        }
        try {
            String id = q7NamedElement.getID();
            EList items = this.testSuite.getItems();
            for (TestSuiteItem testSuiteItem : items) {
                if (!testSuiteItem.getNamedElementId().equals(id)) continue;
                return;
            }
            TestSuiteItem testItem = ScenarioFactory.eINSTANCE.createTestSuiteItem();
            testItem.setNamedElementId(id);
            testItem.setNamedElemetName(q7NamedElement.getElementName());
            if (q7NamedElement instanceof ITestCase) {
                testItem.setKind("test");
            } else if (q7NamedElement instanceof ITestSuite) {
                testItem.setKind("suite");
            }
            IPath path = this.testSuiteModel.getPath().removeLastSegments(1);
            IPath iPath = q7NamedElement.getPath();
            IPath relativeTo = iPath.makeRelativeTo(path);
            testItem.setPath(relativeTo.toString());
            if (position == -1) {
                this.testSuite.getItems().add((Object)testItem);
            } else {
                this.testSuite.getItems().add(position, (Object)testItem);
            }
        }
        catch (ModelException e) {
            Q7UIPlugin.log(e);
            return;
        }
    }

    public void addFolder(IContainer container) {
        this.addFolder(container, -1);
    }

    public void addFolder(IContainer container, int position) {
        if (container != null) {
            IPath fullPath = container.getFullPath();
            IQ7NamedElement[] allElements = Q7SearchCore.findAllElements((ISearchScope)new OneProjectScope(RcpttCore.create((IProject)container.getProject())));
            int i = 0;
            while (i < allElements.length) {
                IQ7NamedElement el = allElements[i];
                if ((el instanceof ITestCase || el instanceof ITestSuite) && !el.equals(this.testSuiteModel) && fullPath.isPrefixOf(el.getPath())) {
                    this.addItem(el, position);
                }
                ++i;
            }
        }
    }

    public void removeAll() {
        this.testSuite.getItems().clear();
    }

    public void moveUp() {
        this.resetTableSort();
        Table table = this.getTable();
        int[] indices = table.getSelectionIndices();
        int[] newSelection = new int[indices.length];
        int i = 0;
        while (i < indices.length) {
            int index = indices[i];
            if (index > 0) {
                this.swapElements(index, index - 1);
                newSelection[i] = index - 1;
            } else if (index == 0) {
                newSelection[i] = 0;
            }
            ++i;
        }
        table.setSelection(newSelection);
    }

    public void moveDown() {
        this.resetTableSort();
        Table table = this.getTable();
        int[] indices = table.getSelectionIndices();
        if (indices.length < 1) {
            return;
        }
        int[] newSelection = new int[indices.length];
        int max = table.getItemCount() - 1;
        int i = indices.length - 1;
        while (i >= 0) {
            int index = indices[i];
            if (index < max) {
                this.swapElements(index, index + 1);
                newSelection[i] = index + 1;
            } else if (index == max) {
                newSelection[i] = max;
            }
            --i;
        }
        table.setSelection(newSelection);
    }

    @Override
    public boolean canRemove() {
        return !this.getSelection().isEmpty();
    }

    @Override
    public boolean canCut() {
        return !this.getSelection().isEmpty();
    }

    @Override
    public boolean canCopy() {
        return !this.getSelection().isEmpty();
    }

    @Override
    public boolean canPaste() {
        return this.canAdd(ClipboardUtils.getClipboardContents(this.getContentTransfer())) || this.canAdd(ClipboardUtils.getClipboardContents((Transfer)ResourceTransfer.getInstance()));
    }

    @Override
    public void handleRemove() {
        IStructuredSelection selection = (IStructuredSelection)this.getSelection();
        List selectedElements = selection.toList();
        this.testSuite.getItems().removeAll((Collection)selectedElements);
    }

    @Override
    public void cut() {
        this.copy();
        this.handleRemove();
    }

    @Override
    public void copy() {
        IStructuredSelection selection = (IStructuredSelection)this.getSelection();
        ClipboardUtils.setClipboardContents(this.serializeSelection(selection), this.getContentTransfer(), this);
    }

    @Override
    public void paste() {
        this.doAdd(ClipboardUtils.getClipboardContents(this.getContentTransfer()));
        this.doAdd(ClipboardUtils.getClipboardContents((Transfer)ResourceTransfer.getInstance()));
    }

    protected boolean canAdd(Object[] objects) {
        if (objects == null || objects.length == 0) {
            return false;
        }
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            IQ7Element file;
            Object obj = objectArray[n2];
            if (!(obj instanceof IResource && this.isValidToAdd(file = RcpttCore.create((IResource)((IResource)obj))) || String.class.isInstance(obj))) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    protected void doAdd(Object[] objects) {
        if (objects == null) {
            return;
        }
        for (TestSuiteItem item : this.deserializeItems(objects)) {
            this.testSuite.getItems().add((Object)((TestSuiteItem)EcoreUtil.copy((EObject)item)));
        }
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            IQ7Element file;
            Object obj = objectArray[n2];
            if (obj instanceof IResource && (file = RcpttCore.create((IResource)((IResource)obj))).exists() && this.isValidToAdd(file) && file instanceof IQ7NamedElement) {
                this.addItem((IQ7NamedElement)file);
            }
            ++n2;
        }
    }

    private void resetTableSort() {
        this.getTable().setSortColumn(null);
        this.getTable().setSortDirection(0);
        this.setSorter(null);
    }

    private void swapElements(int a, int b) {
        TestSuiteItem aItem = (TestSuiteItem)this.testSuite.getItems().get(a);
        TestSuiteItem bItem = (TestSuiteItem)this.testSuite.getItems().get(b);
        this.testSuite.getItems().move(a, (Object)bItem);
        this.testSuite.getItems().move(b, (Object)aItem);
    }

    private IResource[] getSelectedResources() {
        ISelection selection = LocalSelectionTransfer.getTransfer().getSelection();
        if (selection instanceof IStructuredSelection) {
            return this.getSelectedResources((IStructuredSelection)selection);
        }
        return new IResource[0];
    }

    private IResource[] getSelectedResources(IStructuredSelection selection) {
        ArrayList<IResource> selectedResources = new ArrayList<IResource>();
        for (Object o : selection) {
            IAdaptable a;
            IResource r;
            if (o instanceof IResource) {
                selectedResources.add((IResource)o);
                continue;
            }
            if (!(o instanceof IAdaptable) || (r = (IResource)(a = (IAdaptable)o).getAdapter(IResource.class)) == null) continue;
            selectedResources.add(r);
        }
        return selectedResources.toArray(new IResource[selectedResources.size()]);
    }

    private IQ7NamedElement getNamedElementByResource(IResource resource) {
        IWorkspace workspace;
        IFile file;
        if (resource.getType() == 1 && (file = (workspace = ResourcesPlugin.getWorkspace()).getRoot().getFile(resource.getFullPath())) != null && file.exists()) {
            return (IQ7NamedElement)RcpttCore.create((IResource)file);
        }
        return null;
    }

    private String[] convertSelectionToStrings(IStructuredSelection selection) {
        ArrayList<String> selectedElements = new ArrayList<String>();
        for (Object element : selection) {
            if (!(element instanceof TestSuiteItem)) continue;
            int idx = this.testSuite.getItems().indexOf(element);
            selectedElements.add(String.valueOf(this.testSuite.getId()) + ";" + idx);
        }
        return selectedElements.toArray(new String[selectedElements.size()]);
    }

    private String[] serializeSelection(IStructuredSelection selection) {
        ArrayList<String> selectedElements = new ArrayList<String>();
        for (Object element : selection) {
            if (!(element instanceof TestSuiteItem)) continue;
            try {
                selectedElements.add(Q7Utils.serializeToString((EObject)((TestSuiteItem)element)));
            }
            catch (IOException e) {
                Q7UIPlugin.log(e);
            }
        }
        return selectedElements.toArray(new String[selectedElements.size()]);
    }

    private List<TestSuiteItem> deserializeItems(Object data) {
        ArrayList<TestSuiteItem> result = new ArrayList<TestSuiteItem>();
        if (data instanceof Object[]) {
            Object[] objectArray = (Object[])data;
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                if (object instanceof String) {
                    try {
                        result.add((TestSuiteItem)Q7Utils.deserializeFromstring((String)((String)object)));
                    }
                    catch (IOException e) {
                        Q7UIPlugin.log(e);
                    }
                }
                ++n2;
            }
        }
        return result;
    }

    public Object[] getTableSelection() {
        IStructuredSelection selection = (IStructuredSelection)this.getSelection();
        return selection.toArray();
    }

    @Override
    public String getContentName(Object content) {
        return content.toString();
    }

    public List<TestSuiteItem> getTestcases() {
        ArrayList<TestSuiteItem> result = new ArrayList<TestSuiteItem>();
        result.addAll((Collection<TestSuiteItem>)this.testSuite.getItems());
        return result;
    }

    public void updateItems() {
        for (TestSuiteItem item : this.testSuite.getItems()) {
            try {
                IQ7NamedElement[] element = this.testSuiteModel.getQ7Project().findNamedElement(item.getNamedElementId());
                if (element == null || element.length <= 0) continue;
                String ename = element[0].getElementName();
                item.setNamedElemetName(ename);
                if (element[0] instanceof ITestCase) {
                    item.setKind("test");
                } else if (element[0] instanceof ITestSuite) {
                    item.setKind("suite");
                }
                IPath path = this.testSuiteModel.getPath().removeLastSegments(1);
                IPath iPath = element[0].getPath();
                IPath relativeTo = iPath.makeRelativeTo(path);
                item.setPath(relativeTo.toString());
            }
            catch (ModelException e) {
                e.printStackTrace();
            }
        }
    }

    private class ContentDragListener
    extends DragSourceAdapter {
        private final StructuredViewer structuredViewer;

        public ContentDragListener(StructuredViewer structuredViewer) {
            this.structuredViewer = structuredViewer;
        }

        public void dragStart(DragSourceEvent event) {
            IStructuredSelection selection = (IStructuredSelection)this.structuredViewer.getSelection();
            event.doit = !selection.isEmpty();
        }

        public void dragSetData(DragSourceEvent event) {
            IStructuredSelection selection = (IStructuredSelection)this.structuredViewer.getSelection();
            String[] objects = TestSuiteTableViewer.this.convertSelectionToStrings(selection);
            Transfer transfer = TestSuiteTableViewer.this.getContentTransfer();
            if (transfer.isSupportedType(event.dataType)) {
                event.data = objects;
            }
        }
    }

    private class ContentTableDropListener
    extends ViewerDropAdapter {
        public ContentTableDropListener(StructuredViewer structuredViewer) {
            super((Viewer)structuredViewer);
        }

        public boolean performDrop(Object data) {
            return TestSuiteTableViewer.this.doPerformDrop(data, this.getCurrentTarget(), this.getCurrentLocation());
        }

        public boolean validateDrop(Object target, int operation, TransferData transferType) {
            return TestSuiteTableViewer.this.doValidateDrop(target, operation, transferType, this.getCurrentLocation());
        }
    }

    private class TableContentProvider
    implements IStructuredContentProvider {
        private TableContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof List) {
                return ((List)inputElement).toArray();
            }
            return EMPTY;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class TestSuiteItemTransfer
    extends ArrayTransfer {
        private final String TYPE_NAME = "org.eclipse.rcptt.core.scenario.TestSuiteItem";
        private final int TYPE_ID = TestSuiteItemTransfer.registerType((String)"org.eclipse.rcptt.core.scenario.TestSuiteItem");

        private TestSuiteItemTransfer() {
        }

        protected int[] getTypeIds() {
            return new int[]{this.TYPE_ID};
        }

        protected String[] getTypeNames() {
            return new String[]{"org.eclipse.rcptt.core.scenario.TestSuiteItem"};
        }
    }
}

