/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.jetty.interaction;

import java.util.List;
import org.eclipse.passage.lic.api.ServiceInvocationResult;
import org.eclipse.passage.lic.api.restrictions.ExaminationCertificate;
import org.eclipse.passage.lic.base.diagnostic.RequirementsCoverageExplained;
import org.eclipse.passage.lic.equinox.EquinoxPassageLicenseCoverage;
import org.eclipse.passage.lic.internal.jetty.interaction.Command;
import org.eclipse.passage.lic.internal.jetty.interaction.Scope;

final class LicenseStatus
extends Command {
    public LicenseStatus() {
        super((Scope)new Scope.Self(), (List<String>)new LicStatus().get());
    }

    public void licstatus() {
        ServiceInvocationResult response = new EquinoxPassageLicenseCoverage().assess();
        if (response.data().isPresent()) {
            this.reportCertificate((ExaminationCertificate)response.data().get());
        }
        this.reportDiagnostic(response.diagnostic());
    }

    private void reportCertificate(ExaminationCertificate certificate) {
        System.out.printf("\n%s\n", new RequirementsCoverageExplained(certificate).get());
    }

    @Override
    protected List<String> commands() {
        return new LicStatus().get();
    }

    @Override
    public String usage() {
        return "Examine and report license coverage for the product";
    }

    private static final class LicStatus
    extends Command.Name {
        protected LicStatus() {
            super("licstatus");
        }
    }
}

