/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.dashboard.ui.panel;

import java.util.Collections;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.passage.lic.features.model.meta.FeaturesPackage;
import org.eclipse.passage.lic.internal.e4.core.commands.ExecuteCommand;
import org.eclipse.passage.lic.jface.resource.LicensingImages;
import org.eclipse.passage.lic.licenses.model.meta.LicensesPackage;
import org.eclipse.passage.lic.products.model.meta.ProductsPackage;
import org.eclipse.passage.lic.users.model.meta.UsersPackage;
import org.eclipse.passage.loc.dashboard.ui.DashboardUi;
import org.eclipse.passage.loc.dashboard.ui.panel.DashboardPanelAdvisor;
import org.eclipse.passage.loc.dashboard.ui.panel.DashboardPanelBlock;
import org.eclipse.passage.loc.internal.dashboard.ui.i18n.DashboardUiMessages;
import org.eclipse.passage.loc.internal.features.FeatureRegistry;
import org.eclipse.passage.loc.internal.licenses.LicenseRegistry;
import org.eclipse.passage.loc.internal.products.ProductRegistry;
import org.eclipse.passage.loc.internal.users.UserRegistry;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;

public class DefaultDashboardPanelAdvisor
implements DashboardPanelAdvisor {
    private IEclipseContext eclipseContext;
    private DashboardPanelBlock featureSets;
    private DashboardPanelBlock features;
    private DashboardPanelBlock featureVersions;
    private DashboardPanelBlock productLines;
    private DashboardPanelBlock products;
    private DashboardPanelBlock productVersions;
    private DashboardPanelBlock productVersionFeatures;
    private DashboardPanelBlock userOrigins;
    private DashboardPanelBlock users;
    private DashboardPanelBlock licensePlans;

    @Override
    public void init(IEclipseContext context) {
        this.eclipseContext = context;
    }

    @Override
    public void createHeaderInfo(Composite parent) {
        Label label = new Label(parent, 0);
        label.setLayoutData((Object)GridDataFactory.fillDefaults().align(0x1000000, 128).indent(0, 10).grab(true, false).create());
        label.setFont(JFaceResources.getBannerFont());
        label.setText(DashboardUiMessages.DefaultDashboardPanelAdvisor_overview);
    }

    @Override
    public void createFeatureInfo(Composite parent, FeatureRegistry featureRegistry) {
        Group group = new Group(parent, 0);
        group.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        group.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(4).create());
        group.setText(DashboardUiMessages.DefaultDashboardPanelAdvisor_feature_group);
        this.createLinks(group, "features");
        this.featureSets = this.createFeatureSetBlock((Composite)group);
        this.features = this.createFeatureBlock((Composite)group);
        this.featureVersions = this.createFeatureVersionBlock((Composite)group);
        this.updateFeatureInfo(featureRegistry);
    }

    protected DashboardPanelBlock createFeatureSetBlock(Composite parent) {
        String domain = "features";
        EClass eClass = FeaturesPackage.eINSTANCE.getFeatureSet();
        String label = DashboardUiMessages.DefaultDashboardPanelAdvisor_feature_set_title;
        String info = DashboardUiMessages.DefaultDashboardPanelAdvisor_feature_set_info;
        String warning = DashboardUiMessages.DefaultDashboardPanelAdvisor_feature_set_warning;
        String show = DashboardUiMessages.DefaultDashboardPanelAdvisor_feature_set_show;
        return this.createBlock(parent, domain, eClass, label, info, warning, show);
    }

    protected DashboardPanelBlock createFeatureBlock(Composite parent) {
        String domain = "features";
        EClass eClass = FeaturesPackage.eINSTANCE.getFeature();
        String label = DashboardUiMessages.DefaultDashboardPanelAdvisor_feature_title;
        String info = DashboardUiMessages.DefaultDashboardPanelAdvisor_feature_info;
        String warning = DashboardUiMessages.DefaultDashboardPanelAdvisor_feature_warning;
        String show = DashboardUiMessages.DefaultDashboardPanelAdvisor_feature_show;
        return this.createBlock(parent, domain, eClass, label, info, warning, show);
    }

    protected DashboardPanelBlock createFeatureVersionBlock(Composite parent) {
        String domain = "features";
        String label = DashboardUiMessages.DefaultDashboardPanelAdvisor_feature_version_title;
        EClass eClass = FeaturesPackage.eINSTANCE.getFeatureVersion();
        String info = DashboardUiMessages.DefaultDashboardPanelAdvisor_feature_version_info;
        String warning = DashboardUiMessages.DefaultDashboardPanelAdvisor_feature_version_warning;
        String show = DashboardUiMessages.DefaultDashboardPanelAdvisor_feature_version_show;
        return this.createBlock(parent, domain, eClass, label, info, warning, show);
    }

    @Override
    public void updateFeatureInfo(FeatureRegistry featureRegistry) {
        this.featureSets.update(featureRegistry.getFeatureSets());
        this.features.update(featureRegistry.getFeatures());
        this.featureVersions.update(featureRegistry.getFeatureVersions());
    }

    @Override
    public void createProductInfo(Composite parent, ProductRegistry productRegistry) {
        Group group = new Group(parent, 0);
        group.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        group.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(4).create());
        group.setText(DashboardUiMessages.DefaultDashboardPanelAdvisor_product_group);
        this.createLinks(group, "products");
        this.productLines = this.createProductLineBlock((Composite)group);
        this.products = this.createProductBlock((Composite)group);
        this.productVersions = this.createProductVersionBlock((Composite)group);
        this.productVersionFeatures = this.createProductVersionFeatureBlock((Composite)group);
        this.updateProductInfo(productRegistry);
    }

    protected DashboardPanelBlock createProductLineBlock(Composite parent) {
        String domain = "products";
        EClass eClass = ProductsPackage.eINSTANCE.getProductLine();
        String label = DashboardUiMessages.DefaultDashboardPanelAdvisor_product_line_title;
        String info = DashboardUiMessages.DefaultDashboardPanelAdvisor_product_line_info;
        String warning = DashboardUiMessages.DefaultDashboardPanelAdvisor_product_line_warning;
        String show = DashboardUiMessages.DefaultDashboardPanelAdvisor_product_line_show;
        return this.createBlock(parent, domain, eClass, label, info, warning, show);
    }

    protected DashboardPanelBlock createProductBlock(Composite parent) {
        String domain = "products";
        EClass eClass = ProductsPackage.eINSTANCE.getProduct();
        String label = DashboardUiMessages.DefaultDashboardPanelAdvisor_product_title;
        String info = DashboardUiMessages.DefaultDashboardPanelAdvisor_product_info;
        String warning = DashboardUiMessages.DefaultDashboardPanelAdvisor_product_warning;
        String show = DashboardUiMessages.DefaultDashboardPanelAdvisor_product_show;
        return this.createBlock(parent, domain, eClass, label, info, warning, show);
    }

    protected DashboardPanelBlock createProductVersionBlock(Composite parent) {
        String domain = "products";
        EClass eClass = ProductsPackage.eINSTANCE.getProductVersion();
        String label = DashboardUiMessages.DefaultDashboardPanelAdvisor_product_version_title;
        String info = DashboardUiMessages.DefaultDashboardPanelAdvisor_product_version_info;
        String warning = DashboardUiMessages.DefaultDashboardPanelAdvisor_product_version_warning;
        String show = DashboardUiMessages.DefaultDashboardPanelAdvisor_product_version_show;
        return this.createBlock(parent, domain, eClass, label, info, warning, show);
    }

    protected DashboardPanelBlock createProductVersionFeatureBlock(Composite parent) {
        String domain = "products";
        String label = DashboardUiMessages.DefaultDashboardPanelAdvisor_product_feature_title;
        EClass eClass = ProductsPackage.eINSTANCE.getProductVersionFeature();
        String info = DashboardUiMessages.DefaultDashboardPanelAdvisor_product_feature_info;
        String warning = DashboardUiMessages.DefaultDashboardPanelAdvisor_product_feature_warning;
        String show = DashboardUiMessages.DefaultDashboardPanelAdvisor_product_feature_show;
        return this.createBlock(parent, domain, eClass, label, info, warning, show);
    }

    @Override
    public void updateProductInfo(ProductRegistry productRegistry) {
        this.productLines.update(productRegistry.getProductLines());
        this.products.update(productRegistry.getProducts());
        this.productVersions.update(productRegistry.getProductVersions());
        this.productVersionFeatures.update(productRegistry.getProductVersionFeatures());
    }

    @Override
    public void createUserInfo(Composite parent, UserRegistry userRegistry) {
        Group group = new Group(parent, 0);
        group.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        group.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(4).create());
        group.setText(DashboardUiMessages.DefaultDashboardPanelAdvisor_user_group);
        this.createLinks(group, "users");
        this.userOrigins = this.createUserOriginBlock((Composite)group);
        this.users = this.createUserBlock((Composite)group);
        this.updateUserInfo(userRegistry);
    }

    protected DashboardPanelBlock createUserOriginBlock(Composite parent) {
        String domain = "users";
        EClass eClass = UsersPackage.eINSTANCE.getUserOrigin();
        String label = DashboardUiMessages.DefaultDashboardPanelAdvisor_user_origin_title;
        String info = DashboardUiMessages.DefaultDashboardPanelAdvisor_user_origin_info;
        String warning = DashboardUiMessages.DefaultDashboardPanelAdvisor_user_origin_warning;
        String show = DashboardUiMessages.DefaultDashboardPanelAdvisor_user_origin_show;
        return this.createBlock(parent, domain, eClass, label, info, warning, show);
    }

    protected DashboardPanelBlock createUserBlock(Composite parent) {
        String domain = "users";
        EClass eClass = UsersPackage.eINSTANCE.getUser();
        String label = DashboardUiMessages.DefaultDashboardPanelAdvisor_user_title;
        String info = DashboardUiMessages.DefaultDashboardPanelAdvisor_user_info;
        String warning = DashboardUiMessages.DefaultDashboardPanelAdvisor_user_warning;
        String show = DashboardUiMessages.DefaultDashboardPanelAdvisor_user_show;
        return this.createBlock(parent, domain, eClass, label, info, warning, show);
    }

    @Override
    public void updateUserInfo(UserRegistry userRegistry) {
        this.userOrigins.update(userRegistry.getUserOrigins());
        this.users.update(userRegistry.getUsers());
    }

    @Override
    public void createLicenseInfo(Composite parent, LicenseRegistry licenseRegistry) {
        Group group = new Group(parent, 0);
        group.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        group.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(4).create());
        group.setText(DashboardUiMessages.DefaultDashboardPanelAdvisor_license_group);
        this.createLinks(group, "licenses");
        this.licensePlans = this.createLicensePlanBlock((Composite)group);
        this.updateLicenseInfo(licenseRegistry);
    }

    protected DashboardPanelBlock createLicensePlanBlock(Composite parent) {
        String domain = "licenses";
        String label = DashboardUiMessages.DefaultDashboardPanelAdvisor_license_plan_title;
        EClass eClass = LicensesPackage.eINSTANCE.getLicensePlan();
        String info = DashboardUiMessages.DefaultDashboardPanelAdvisor_license_plan_info;
        String warning = DashboardUiMessages.DefaultDashboardPanelAdvisor_license_plan_warning;
        String show = DashboardUiMessages.DefaultDashboardPanelAdvisor_license_plan_show;
        return this.createBlock(parent, domain, eClass, label, info, warning, show);
    }

    protected DashboardPanelBlock createBlock(Composite parent, final String domain, EClass eClass, String label, String info, String warning, String show) {
        DashboardPanelBlock block = new DashboardPanelBlock();
        Image image = this.getImage(eClass);
        block.createControl(parent, label, image);
        block.setInfo(info);
        block.setWarning(warning);
        final String classifier = eClass.getName();
        block.configureShow(show, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DefaultDashboardPanelAdvisor.this.executeShowCommand(domain, classifier);
            }
        });
        return block;
    }

    @Override
    public void updateLicenseInfo(LicenseRegistry licenseRegistry) {
        this.licensePlans.update(licenseRegistry.getLicensePlans());
    }

    @Override
    public void createFooterInfo(Composite parent) {
        GridDataFactory gdf = GridDataFactory.fillDefaults().align(0x1000000, 128).indent(0, 10).grab(true, false);
        this.appendSummary(parent, gdf);
        this.appendIssueLicenseButton(parent, gdf, DashboardUiMessages.DefaultDashboardPanelAdvisor_btn_issue_personal_text, DashboardUiMessages.DefaultDashboardPanelAdvisor_btn_issue_personal_description, this::executeIssueLicenseCommand);
        this.appendIssueLicenseButton(parent, gdf, DashboardUiMessages.DefaultDashboardPanelAdvisor_btn_issue_floating_text, DashboardUiMessages.DefaultDashboardPanelAdvisor_btn_issue_floating_description, this::executeIssueFloatingLicenseCommand);
    }

    private void appendSummary(Composite parent, GridDataFactory gdf) {
        Label summary = new Label(parent, 0);
        summary.setLayoutData((Object)gdf.create());
        summary.setText(DashboardUiMessages.DefaultDashboardPanelAdvisor_summary);
    }

    private void appendIssueLicenseButton(Composite parent, GridDataFactory gdf, String text, String tooltip, Runnable issuing) {
        Button issue = new Button(parent, 8);
        issue.setImage(LicensingImages.getImage((String)LicensesPackage.eINSTANCE.getPersonalLicensePack().getName()));
        issue.setLayoutData((Object)gdf.create());
        issue.setText(text);
        issue.setToolTipText(tooltip);
        issue.addSelectionListener(SelectionListener.widgetSelectedAdapter(c -> issuing.run()));
    }

    protected void executeIssueLicenseCommand() {
        new ExecuteCommand("org.eclipse.passage.loc.dashboard.ui.command.issue.license", this.eclipseContext).apply(Collections.emptyMap());
    }

    protected void executeIssueFloatingLicenseCommand() {
        new ExecuteCommand("org.eclipse.passage.loc.dashboard.ui.command.issue.floatinglicense", this.eclipseContext).apply(Collections.emptyMap());
    }

    protected void createLinks(Group group, final String domain) {
        Link create = new Link((Composite)group, 0);
        create.setText(DashboardUiMessages.DefaultDashboardPanelAdvisor_create_link);
        create.setLayoutData((Object)GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).span(2, 1).create());
        create.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DefaultDashboardPanelAdvisor.this.executeCreateCommand(domain);
            }
        });
        Link open = new Link((Composite)group, 0);
        open.setText(DashboardUiMessages.DefaultDashboardPanelAdvisor_load_link);
        open.setLayoutData((Object)GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).span(2, 1).create());
        open.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DefaultDashboardPanelAdvisor.this.executeLoadCommand(domain);
            }
        });
    }

    protected void executeCreateCommand(String domain) {
        DashboardUi.executeCreateCommand(this.eclipseContext, domain);
    }

    protected void executeLoadCommand(String domain) {
        DashboardUi.executeLoadCommand(this.eclipseContext, domain);
    }

    protected void executeShowCommand(String domain, String classifier) {
        DashboardUi.executeShowCommand(this.eclipseContext, domain, classifier);
    }

    protected Image getImage(EClass eClass) {
        return LicensingImages.getImage((String)eClass.getName());
    }

    @Override
    public void dispose(IEclipseContext context) {
        this.eclipseContext = null;
    }
}

